--Copyright Melons 2022, ask permission before use.


-- Ultimate AI Functions Start
difficulty = Map.LobbyOption("difficulty")

function setDifficulty() 

	toxicAdjustment =1

	if toxic_enabled == 1
	then 
		toxicAdjustment = 3
	end


	if difficulty == "noob" then
		difficultyHandicap = 0.6
		maxLimit = (6*HandicapAdjustment)*toxicAdjustment
		mcvLimit = (12*HandicapAdjustment)*toxicAdjustment
	elseif difficulty == "easy" then
		difficultyHandicap = 0.8
		maxLimit = (10*HandicapAdjustment)*toxicAdjustment
		mcvLimit = (14*HandicapAdjustment)*toxicAdjustment
	elseif difficulty == "normal" then
		difficultyHandicap = 1
		maxLimit = (14*HandicapAdjustment)*toxicAdjustment
		mcvLimit = (18*HandicapAdjustment)*toxicAdjustment
	elseif difficulty == "extreme" then
		difficultyHandicap = 1.2
		maxLimit = (20*HandicapAdjustment)*toxicAdjustment
		mcvLimit = (30*HandicapAdjustment)*toxicAdjustment
	else
		difficultyHandicap = 1.5
		maxLimit = 99
		mcvLimit = 99
	end
end


function theBots()
    return Player.GetPlayers(function(player)
        return player.IsBot == true;
    end);
end

function theUltimateBots()
    return Player.GetPlayers(function(player)
        return player.IsBot == true and player.HasPrerequisites({"ultimateaienabled"});
    end);
end

function theHumans()
    return Player.GetPlayers(function(player)
        return player.IsBot == false and player.IsNonCombatant == false;
    end);
end

function thePlayers()
    return Player.GetPlayers(function(player)
        return player.IsNonCombatant == false;
    end);
end

function thePlayersAndCreeps()
    return Player.GetPlayers(function(player)
        return true
    end);
end


--Random Testing
function getActorsAround(actorselected,actorsToFind, distance)
	actorList = Map.ActorsInCircle(actorselected.CenterPosition, WDist.FromCells(distance), function(a)
		return a.Type == actorsToFind
	end)

	return actorList
end

function getClosetActor(actorselected,actorsToFind)
	actorList = Map.ActorsInCircle(actorselected.CenterPosition, WDist.FromCells(50), function(a)
		return a.Type == actorsToFind
	end)

	return actorList[1]
end

function getAllActors(a)

	theActors = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
		return actor.Type == a
	end)

	return theActors

end

function getAllCreeps()

	targets = Utils.Where(Creeps.GetActors(), function(actor)
		return
			actor.Type == "powr" or actor.Type == "silo"
	end)
	return targets

end

----START OF AI REINFORCEMENTS ---

function createNewMcv(quantity)
	if quantity == nil then
		quantity = 1
	end
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		for z, thePlayer in ipairs(AIPlayers) do
			Actor.Create("mcv", true, { Owner = thePlayer, Location = thePlayer.HomeLocation + CVec.New(0, 3) });
		end
		quantity = quantity -1
		if quantity > 0 then
			createNewMcv(quantity)
		end
	end)
end



function createRandomInfantryPerBuilding(quantity)
	if quantity == nil then
		quantity = 1
	end
	
	countLimit = 0

			for z, thePlayer in ipairs(AIPlayers) do
				theProducers = thePlayer.GetActorsByTypes({ "barr", "tent" });
				
				Utils.Do(theProducers, function(theUnits)
					if countLimit < maxLimit then
						if (difficulty == "easy" or difficulty == "noob") then
							toProduceTanks = { "e1", "e1", "e1",  "e1", "e1", "e1", "e3"  }
						else
							toProduceTanks = { "e1", "e1", "e1", "e3"  }
						end
						randomUnit = Utils.RandomInteger(1,#toProduceTanks+1)
						randomTank =  toProduceTanks[randomUnit];
						-- Media.DisplayMessage("hello1", "Mission", HSLColor.Red)
						theTank = Actor.Create(randomTank, true, { Owner = thePlayer, Location = theUnits.Location + CVec.New(0, 2) });
						theTank.Move(theUnits.RallyPoint)
						countLimit = countLimit+1
					end
				end)
				quantity = quantity -1
			end
			if quantity > 0 then
				--Media.DisplayMessage("hello2", "Mission", HSLColor.Red)
				createRandomInfantryPerBuilding(quantity)
			end
end




function createRandomTankPerBuilding(quantity)
	if quantity == nil then
		quantity = 1
	end

	countLimit = 0

			for z, thePlayer in ipairs(AIPlayers) do
				theProducers = thePlayer.GetActorsByTypes({ "weap" });

				Utils.Do(theProducers, function(theUnits)
					if countLimit < maxLimit then
						if (difficulty == "easy" or difficulty == "noob") then
							toProduceTanks = { "jeep", "apc", "1tnk", "ftrk", "jeep", "apc", "1tnk", "ftrk", "jeep", "apc", "1tnk", "ftrk", "4tnk", "ctnk", "v2rl", "2tnk", "2tnk", "1tnk", "3tnk", "mrj", "2tnk", "arty", "mgg", "mrj", "v2rl", "2tnk", "arty", "3tnk", "2tnk", "stnk", "dtrk" }
						elseif (difficulty == "normal") then
							toProduceTanks = { "apc", "apc", "1tnk", "1tnk", "ftrk", "4tnk", "3tnk", "3tnk", "ctnk", "v2rl", "2tnk", "2tnk", "2tnk", "1tnk", "3tnk", "2tnk", "arty", "mgg", "mrj", "v2rl", "2tnk", "arty", "3tnk", "mrj", "stnk", "dtrk"}
						else
							toProduceTanks = { "apc", "1tnk", "ftrk", "4tnk", "4tnk", "ctnk", "v2rl", "2tnk", "2tnk", "1tnk", "3tnk", "mrj", "2tnk", "arty", "mgg", "mrj", "v2rl", "2tnk", "arty", "3tnk", "mrj", "stnk", "dtrk"}
						end
						randomUnit = Utils.RandomInteger(1,#toProduceTanks+1)
						randomTank =  toProduceTanks[randomUnit];
						-- Media.DisplayMessage("hello1", "Mission", HSLColor.Red)
						theTank = Actor.Create(randomTank, true, { Owner = thePlayer, Location = theUnits.Location + CVec.New(0, 2) });
						theTank.Move(theUnits.RallyPoint)
						countLimit = countLimit+1
					end
				end)
				quantity = quantity -1

			end
			if quantity > 0 then
				--Media.DisplayMessage("hello2", "Mission", HSLColor.Red)
				createRandomTankPerBuilding(quantity)
			end
end




function spawnUnits(spawnUnitType, spawnUnitOwner, spawnUnitLocation)
	theActor = Actor.Create(spawnUnitType, true, { Owner = spawnUnitOwner, Location =  spawnUnitLocation});

	if spawnUnitType ~= "mcv" then
		if spawnUnitType == "qtnk" or spawnUnitType == "mgg" or spawnUnitType == "mrj" or spawnUnitType == "thf" then
			--theActor.Move(CaptureMiddle.Location)
		else
			--theActor.AttackMove(CaptureMiddle.Location)
		end
	end
	
end

function sendRepeatWave(unitsTier,quantity,repeatTime)
	
	if repeatTime == nil then
		repeatTime = 120
	end

	sendAttackWave(unitsTier,quantity)

			--Set Next Wave
			Trigger.AfterDelay(DateTime.Seconds(repeatTime), function()
				sendRepeatWave(unitsTier,quantity,repeatTime)
			end)
end

local function joinTypes(...)
	local out = {}
	for i = 1, select("#", ...) do
		local t = select(i, ...)
		if t then for _, v in ipairs(t) do table.insert(out, v) end end
	end
	return out
end

function orderAllUnitsToAssault()
	-- prefer high-value structures
	local assaultTargets = { "mcv","fact","dome","weap","barr","tent","proc","apwr","powr","afld","hpad","spen","syrd","silo" }

	-- combat-ish pools (keeps engineers out, but includes spy/thf so we can handle them specially)
	local unitTypes = joinTypes(
		tier0infantry, tier1infantry, tier2infantry, tier3infantry,
		tier1Tanks, tier2Tanks, tier3Tanks, tier4Tanks
	)

	for _, p in ipairs(AIPlayers) do
		local units = p.GetActorsByTypes(unitTypes)
		Utils.Do(units, function(u)
			-- Special-cases first: SPY and THIEF infiltrate, not attack-move
			if u.Type == "spy" then
				local t = findClosestTargetAi(u, { "powr","apwr","dome" })
				if t then
					u.Stop()
					u.DisguiseAsType("e1", t.EffectiveOwner)
					u.Move(t.Location)
					u.Infiltrate(t)
				end
				return
			elseif u.Type == "thf" then
				local t = findClosestTargetAi(u, { "proc" })
				if t then
					u.Stop()
					u.Move(t.Location)
					u.Infiltrate(t)
				end
				return
			end

			-- Everyone else: attack-move if supported, otherwise just move
			local t = findClosestTargetAi(u, assaultTargets)
			if t then
				u.Stop()
				if u.HasProperty and u.HasProperty("AttackMove") then
					u.AttackMove(t.Location)
				else
					u.Move(t.Location)
				end
			elseif #HumanPlayers > 0 then
				-- Fallback if no target found
				if u.HasProperty and u.HasProperty("AttackMove") then
					u.AttackMove(HumanPlayers[1].HomeLocation)
				else
					u.Move(HumanPlayers[1].HomeLocation)
				end
			end
		end)
	end
end

-- === SCALING HELPERS (define BEFORE finalAssault) ===

function avgCost(types)
	if not types or #types == 0 then return 0 end
	local sum = 0
	for _, t in ipairs(types) do
		local c = Actor.Cost(t) or 0   -- cost from Valued trait; nil -> 0
		sum = sum + c
	end
	return sum / #types
end

function playerArmyValue(p)
	local total = 0
	local attackers = p.GetGroundAttackers()  -- current ground combat units
	Utils.Do(attackers, function(u)
		total = total + (Actor.Cost(u.Type) or 0)
	end)
	return total
end

function enemiesArmyValue()
	local total = 0
	for _, hp in ipairs(HumanPlayers) do
		total = total + playerArmyValue(hp)
	end
	return total
end


function finalAssault()
	Media.DisplayMessage("FINAL ASSAULT — all forces attack!", "Mission", HSLColor.Red)

	-- Base sizing as your current *minimum* (same numbers as before)
	local scaleFloor = math.max(1, HandicapAdjustment) * difficultyHandicap * ((toxic_enabled == 1) and 1.2 or 1.0)

	local infBase, t2Base, t3Base, t4Base
	if difficulty == "noob" then
		infBase, t2Base, t3Base, t4Base = 80, 20, 8, 2
	elseif difficulty == "easy" then
		infBase, t2Base, t3Base, t4Base = 120, 30, 12, 4
	elseif difficulty == "normal" then
		infBase, t2Base, t3Base, t4Base = 160, 40, 16, 6
	else -- extreme/insane
		infBase, t2Base, t3Base, t4Base = 220, 60, 24, 10
	end

	local infWaves = math.floor(infBase * scaleFloor)
	local t2Waves  = math.floor(t2Base * scaleFloor)
	local t3Waves  = math.floor(t3Base * scaleFloor)
	local t4Waves  = math.floor(t4Base * scaleFloor)

	-- --- SCALING: grow up to enemy army value -----------------------------
	-- Compute expected *cost* of the baseline wave we are about to send.
	local expectedBaseline =
		  infWaves *           avgCost(tier1infantry)
		+ math.floor(infWaves * 0.15) * avgCost(tier2infantry)
		+ t2Waves *            avgCost(tier2Tanks)
		+ t3Waves *            avgCost(tier3Tanks)
		+ t4Waves *            avgCost(tier4Tanks)

	-- Current enemy combat value (humans only, ground attackers).
	local enemyValue = enemiesArmyValue()

	-- Scale so the *expected* spawn value ≈ enemy army value,
	-- but never below your baseline (i.e., current behavior).
	local mult = 1
	if expectedBaseline > 0 and enemyValue > expectedBaseline then
		mult = enemyValue / expectedBaseline
	end

	-- Optional safety cap to avoid pathological spawns (uncomment if needed)
	-- local maxMultiplier = 3.0
	-- if mult > maxMultiplier then mult = maxMultiplier end

	infWaves = math.floor(infWaves * mult)
	t2Waves  = math.floor(t2Waves  * mult)
	t3Waves  = math.floor(t3Waves  * mult)
	t4Waves  = math.floor(t4Waves  * mult)
	-- ----------------------------------------------------------------------

	-- Big mixed push: infantry + mid/heavy armor + a dash of elite
	sendAttackWave(tier1infantry, infWaves)
	sendAttackWave(tier2infantry, math.floor(infWaves * 0.15))
	sendAttackWave(tier2Tanks,   t2Waves)
	sendAttackWave(tier3Tanks,   t3Waves)
	sendAttackWave(tier4Tanks,   t4Waves)

	-- Then throw EVERYTHING at the enemy
	orderAllUnitsToAssault()
end


-- Average rules cost for a list of actor type strings.
local function avgCost(types)
	if not types or #types == 0 then return 0 end
	local sum = 0
	for _, t in ipairs(types) do
		sum = sum + Actor.Cost(t)   -- from Valued trait
	end
	return sum / #types
end

-- Sum the current value of a player's army (ground attackers only).
local function playerArmyValue(p)
	local total = 0
	local attackers = p.GetGroundAttackers()   -- live ground combat units
	Utils.Do(attackers, function(u)
		total = total + Actor.Cost(u.Type)
	end)
	return total
end

-- Total value for all human opponents.
local function enemiesArmyValue()
	local total = 0
	for _, hp in ipairs(HumanPlayers) do
		total = total + playerArmyValue(hp)
	end
	return total
end


function sendAttackWave(unitsTier, quantity)

	if repeatWave == nil then
		local repeatWave = 0
	end
	if unitsTier == nil then
		unitsTier = tier1Tanks
	end

	--bug for ai production
		for z, thePlayer in ipairs(AIPlayers) do

			if #thePlayer.GetActors() > 1 then

				if (unitsTier == tierMcv) then
					if (countMcvs(thePlayer) >= mcvLimit) then
						return
					end
				end

				if quantity == nil or quantity == 0 then
					quantityToProduce = 7
				else
					quantityToProduce = quantity
				end

				currentSpawn = thePlayer.HomeLocation + CVec.New(-5,-5)

				while quantityToProduce > 0 do
					randomUnit = Utils.RandomInteger(1,#unitsTier+1)
					--Media.DisplayMessage("".. randomUnit, "Mission", HSLColor.Red)

					spawnUnits(unitsTier[randomUnit],thePlayer, currentSpawn)

					quantityToProduce = quantityToProduce -1

					if currentSpawn == spawnPoint1 then
						currentSpawn = spawnPoint2
					elseif  currentSpawn == spawnPoint2 then
						currentSpawn = spawnPoint3
					elseif  currentSpawn == spawnPoint3 then
						currentSpawn = spawnPoint4
					elseif  currentSpawn == spawnPoint4 then
						currentSpawn = spawnPoint1
					end
				end
			end
		end

end


function createHarv()
	if quantity == nil then
		quantity = 1
	end
	if toxic_enabled then
		Trigger.AfterDelay(DateTime.Seconds(10), function()
			for z, thePlayer in ipairs(AIPlayers) do
				if thePlayer.Cash < 2500 then
					Actor.Create("harv", true, { Owner = thePlayer, Location = thePlayer.HomeLocation + CVec.New(0, 2) });
				end
			end
			createHarv()
		end)
	else
		Trigger.AfterDelay(DateTime.Seconds(25), function()
			for z, thePlayer in ipairs(AIPlayers) do
				if thePlayer.Cash < 1500 then
					Actor.Create("harv", true, { Owner = thePlayer, Location = thePlayer.HomeLocation + CVec.New(0, 2) });
				end
			end
			createHarv()
		end)

	end
end

function createEngineers(quantity)--
	if quantity == nil then
		quantity = 1
	end

				sendAttackWave(tierEngineers,#theHumans())
				sendAttackWave(tierThief,#theHumans())
				
				if (difficulty ~= "easy" and difficulty ~= "noob" and difficulty ~= "normal") then
					sendAttackWave(tierSpy,#theHumans())
				end

			Trigger.AfterDelay(DateTime.Seconds(5), function()
				sendEngineers()
				if (difficulty ~= "easy" and difficulty ~= "noob") then
				end
			end)
			if quantity > 0 then
				Trigger.AfterDelay(DateTime.Seconds(60), function()
					--Media.DisplayMessage("hello2", "Mission", HSLColor.Red)
					createEngineers(quantity)
					sendThief()
					sendSpy()
				end)
			end
end

--send engineers to cap middle
function sendThief()
	
	for z, thePlayer in ipairs(AIPlayers) do
        local theUnits = thePlayer.GetActorsByType("thf");

		actorToTarget = { "proc"}

		if #theUnits > 0 then
			Utils.Do(theUnits, function(unit)
				unitToTarget = findClosestTargetAi(unit,actorToTarget)

				if unitToTarget ~= nil then
					--Media.DisplayMessage("hello5", "Mission", HSLColor.Red)
					unit.Stop()
					unit.Move(unitToTarget.Location)
					unit.Infiltrate(unitToTarget)
				end
			end)
		end
	end
end

--send engineers to cap middle
function sendSpy()
	
	for z, thePlayer in ipairs(AIPlayers) do
        local theUnits = thePlayer.GetActorsByType("spy");

		actorToTarget = { "powr", "apwr", "dome" }

		if #theUnits > 0 then
			Utils.Do(theUnits, function(unit)
				unitToTarget = findClosestTargetAi(unit,actorToTarget)
	
				if unitToTarget ~= nil then
					--Media.DisplayMessage("hello5", "Mission", HSLColor.Red)
					unit.Stop()
					unit.DisguiseAsType("e1",unitToTarget.EffectiveOwner)
					unit.Move(unitToTarget.Location)
					unit.Infiltrate(unitToTarget)
				end
			end)
		end
	end
end

function findClosestTargetAi(searchActor, actorTypes)
     closestActor = nil
     distnceCloset = 250000;
    
    
    for rr, enemyPlayer in ipairs(HumanPlayers) do
        if enemyPlayer ~= searchActor.EffectiveOwner then
            if enemyPlayer.Team ~= searchActor.EffectiveOwner.Team or enemyPlayer.Team == 0 or searchActor.EffectiveOwner.Team == 0 then
                local actors = enemyPlayer.GetActorsByTypes(actorTypes);
                for rr, actor in ipairs(actors) do
                     theDistance = actor.Location - searchActor.Location;
                     distanceMath = math.sqrt((theDistance.X * theDistance.X) + (theDistance.Y * theDistance.Y));
                    if distanceMath <= distnceCloset then
                        distnceCloset = distanceMath;
                        closestActor = actor;
                    end
                end
            end
        end
    end
    return closestActor;
end


--send engineers to cap middle
function sendEngineers()
	for z, thePlayer in ipairs(AIPlayers) do
        local engineers = thePlayer.GetActorsByType("e6");
		Utils.Do(engineers, function(unit)

			if (comcentre1 ~= nil and comcentre1 ~= '') then
				-- Media.DisplayMessage( "comcentre1 does exists", "Mission", HSLColor.Red)
				if comcentre1.Owner ~= unit.Owner and comcentre1.EffectiveOwner.Team  ~= unit.EffectiveOwner.Team then
					unit.Stop()
					unit.Move(comcentre1.Location)
					unit.Capture(comcentre1)
				else

					if (comcentre2 ~= nil and comcentre2 ~= '') then
						-- Media.DisplayMessage( "comcentre1 does exists", "Mission", HSLColor.Red)
						if comcentre2.Owner ~= unit.Owner and comcentre2.EffectiveOwner.Team  ~= unit.EffectiveOwner.Team then
							unit.Stop()
							unit.Move(comcentre2.Location)
							unit.Capture(comcentre2)
						end
					else
						if (comcentre3 ~= nil and comcentre3 ~= '') then
							-- Media.DisplayMessage( "comcentre3 does exists", "Mission", HSLColor.Red)
							if comcentre3.Owner ~= unit.Owner and comcentre3.EffectiveOwner.Team  ~= unit.EffectiveOwner.Team then
								unit.Stop()
								unit.Move(comcentre3.Location)
								unit.Capture(comcentre3)
							end
						end
					end

				end
			end


		end)
		
	end
end

function aiCash()

	if toxic_enabled then
		Trigger.AfterDelay(DateTime.Seconds(10), function()
			for z, thePlayer in ipairs(AIPlayers) do
				if thePlayer.Cash < 4000 then
					thePlayer.Cash =  thePlayer.Cash +2000
				end
			end
			aiCash()
		end)
	else
		Trigger.AfterDelay(DateTime.Seconds(20), function()
			for z, thePlayer in ipairs(AIPlayers) do
				if thePlayer.Cash < 4000 then
					thePlayer.Cash =  thePlayer.Cash +500
				end
			end
			aiCash()
		end)
	end
	
end



--Tanks every 60s
function continuousProductionTanks()

	if (difficulty == "noob") then
		continuousDelay = 90/ToxicHandicap
	elseif (difficulty == "easy") then
		continuousDelay = 74/ToxicHandicap
	elseif (difficulty == "normal") then
		continuousDelay = 65/ToxicHandicap
	else
		continuousDelay = 45/ToxicHandicap
	end

	createRandomTankPerBuilding((4*HandicapAdjustment))
	Trigger.AfterDelay(DateTime.Seconds(continuousDelay), continuousProductionTanks)
end

--Infantry every 15s
function continuousProductionInfantry()

	if (difficulty == "noob" ) then
		continuousDelay = 30/ToxicHandicap
	elseif (difficulty == "easy") then
		continuousDelay = 25/ToxicHandicap
	elseif (difficulty == "normal") then
		continuousDelay = 20/ToxicHandicap
	else
		continuousDelay = 15/ToxicHandicap
	end

	createRandomInfantryPerBuilding((4*HandicapAdjustment))
	Trigger.AfterDelay(DateTime.Seconds(continuousDelay), continuousProductionInfantry)
end

function continuousProduction()
	continuousProductionTanks()
	continuousProductionInfantry()
end

function countMcvs(isPlayer)
	mcvCount = countbuildings("mcv", isPlayer)
	factCount = countbuildings("fact", isPlayer)
	totalMcvs = mcvCount + factCount
	return totalMcvs
end


-- Ultimate AI Functions End

a = 500 --nuke timer
NuclearStrikes = Map.LobbyOption("NuclearStrikes")
--check option selected
if (NuclearStrikes ~= "entry_1") then
	if (NuclearStrikes == "entry_2") then
		a = 5
	else
		if (NuclearStrikes == "entry_3") then
			a = 8
		else
			if (NuclearStrikes == "entry_4") then
				a = 12
			else
				a = 15
			end
		end
	end
end


function getActorsAround(actorselected,actorsToFind, distance)
	actorList = Map.ActorsInCircle(actorselected.CenterPosition, WDist.FromCells(distance), function(a)
		return a.Type == actorsToFind
	end)

	return actorList
end


--messaging system
function readmessages() 
					
	messagescount = tablelength(messages)
	
	resetmessagestimer = messagescount*3+1

	if messagescount > 0 then
		for i = tablelength(messages),1,-1 
		do 
			Trigger.AfterDelay(DateTime.Seconds(i*3), function()
				Media.DisplayMessage (messages[i], "Mission", HSLColor.Red)
			end)
		end
	else
		Media.DisplayMessage ("No Messages to Display", "Mission", HSLColor.Red)
	end

	Trigger.AfterDelay(DateTime.Seconds(resetmessagestimer), function()
		messages = {}
	end)

end



--message loop
function readmessagesloop() 
					
	if loopcounter < 6 then
			
		messagescount = tablelength(messagesloop)
		
		resetmessagestimer = messagescount*3+1

		if messagescount > 0 then
			for i = tablelength(messagesloop),1,-1 
			do 
				Trigger.AfterDelay(DateTime.Seconds(i*3), function()
					Media.DisplayMessage (messagesloop[i], "Mission", HSLColor.Red)
				end)
			end
		else
			--Media.DisplayMessage ("No Loop Messages to Display", "Mission", HSLColor.Red)
		end


		Trigger.AfterDelay(5000, readmessagesloop)
		loopcounter = loopcounter +1
	end

end

function setupRefs()

	facts = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
		return actor.Type == "fact" or actor.Type == "mcv"
	end)


	Utils.Do(facts, function(a)
		
			-- Media.DisplayMessage (""..a.Owner.Name, "Mission", HSLColor.Red)
		if a.Owner ~= castlePlayer then
			actorOwner = a.Owner
			--Media.DisplayMessage (""..actorOwner.Name, "Mission", HSLColor.Red)

			toCapture = {}
			toCapture = { "silo","powr"}

			Utils.Do(toCapture, function(z)
				actorsToCapture = getActorsAround(a,z,15)
					
				Utils.Do(actorsToCapture, function(b)
					b.Owner = actorOwner
				end)
			end)
		end
	end)

	--Create Refs
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		powrs = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
			return 
			actor.Type == "silo"
		end)

		Utils.Do(powrs, function(a)

			actorOwner = a.Owner
			originalLocation = a.Location
			newLocation = originalLocation + CVec.New(0,1)

			if actorOwner.InternalName ~= "Creeps" then
				Actor.Create("proc", true, { Owner = actorOwner, Location = newLocation})
			end

			
			 --Media.DisplayMessage (""..actorOwner.InternalName, "Mission", HSLColor.Red)
			-- Media.DisplayMessage(""..newLocation, "Mission", HSLColor.Red)
		end)

	end)


	Trigger.AfterDelay(DateTime.Seconds(2), function()
		creepActors = getAllCreeps()
		removeactors(creepActors)
		--Media.DisplayMessage(""..#creepActors, "Mission", HSLColor.Red)

	end)

end


	function getAllCreeps()

		targets = Utils.Where(Creeps.GetActors(), function(actor)
			return
				actor.Type == "powr" or actor.Type == "silo"
		end)
		return targets

	end

	--Remove Boxes in Table
	function removeactors(a)
		Utils.Do(a, function(unit)
			unit.Destroy()
		end)
		return 
	end


rules = function()
		if (Cappoints ~= "entry_off") then
			if (Cappoints == "entry_1") then
				table.insert(messages, "OBJECTIVE: Capture the Communications Centre with an engineer and hold for timer amount")
				-- Media.DisplayMessage ("OBJECTIVE: Capture the Communications Centre with an engineer and hold for timer amount  ", "Mission", HSLColor.Red)
			else
				table.insert(messages, "OBJECTIVE: Capture all the Communications Centres with an engineer and hold for timer amount")
				-- Media.DisplayMessage ("OBJECTIVE: Capture all the Communications Centres with an engineer and hold for timer amount  ", "Mission", HSLColor.Red)
			end
		end
		if (NuclearStrikes ~= "entry_1") then
			--Beaconmiddle()
			if (Cappoints ~= "entry_off") then
					table.insert(messages, "WARNING: Nuclear strike mode enabled, middle area will be nuked every 5-15 minutes")
					-- Media.DisplayMessage ("WARNING: Nuclear strike mode enabled, middle area will be nuked every 5-15 minutes", "Mission", HSLColor.Red)
				
			else
				table.insert(messages, "WARNING: Nuclear strike mode enabled, middle area will be nuked every 5-15 minutes")
				-- Media.DisplayMessage ("WARNING: Nuclear strike mode enabled, middle area will be nuked every 5-15 minutes", "Mission", HSLColor.Red)
			end
			--Trigger.AfterDelay(DateTime.Seconds(5), function()
			--	nukemid() 
      	 	--end)
		end
end


--[[]prepandfire = function()
	if (Nuker.HasProperty("ActivateNukePower")) then
		Media.DisplayMessage ("WARNING: Abomb preparing to launch in the middle", "Mission", HSLColor.Red)
		Media.PlaySpeechNotification(USSR, "AbombPrepping")
		Trigger.AfterDelay(DateTime.Seconds(30), function()
			nukemid()
		end)
	end
end]]

--[[]
delayedlaunch = function()
	Trigger.AfterDelay(DateTime.Minutes(a), function()
		prepandfire()
	end)
end]]

--[[]nukemid = function()
			Media.PlaySpeechNotification(USSR, "AbombLaunchDetected")
--Middle Area


Nuker.ActivateNukePower(CPos.New(42,64))
Nuker.ActivateNukePower(CPos.New(58,64))
Nuker.ActivateNukePower(CPos.New(50,64)) 
Nuker.ActivateNukePower(CPos.New(50,70))
Nuker.ActivateNukePower(CPos.New(50,57))
Nuker.ActivateNukePower(CPos.New(14,64)) -- Left
Nuker.ActivateNukePower(CPos.New(83,64)) -- Right 

			Nuker.ActivateNukePower(CPos.New(57,55))
			Nuker.ActivateNukePower(CPos.New(65,55))
			Nuker.ActivateNukePower(CPos.New(73,55))
			Nuker.ActivateNukePower(CPos.New(57,73))
			Nuker.ActivateNukePower(CPos.New(65,73))
			Nuker.ActivateNukePower(CPos.New(73,73))
			Nuker.ActivateNukePower(CPos.New(48,60))
			Nuker.ActivateNukePower(CPos.New(48,68))
			Nuker.ActivateNukePower(CPos.New(80,60))
			Nuker.ActivateNukePower(CPos.New(80,68))
			Nuker.ActivateNukePower(CPos.New(12,64)) -- Left
			Nuker.ActivateNukePower(CPos.New(115,64)) -- Right 
			
			--delayedparabombs()
			delayedlaunch()
end]]
--[[]
delayedtroopers = function()
	Trigger.AfterDelay(DateTime.Seconds(25), function()
	--	Media.DisplayMessage ("Troops incoming", "Mission", HSLColor.Red)
	ShockDrop.TargetParatroopers(SHOCKER1.CenterPosition, Angle.New(300))
	ShockDrop2.TargetParatroopers(SHOCKER2.CenterPosition, Angle.New(300))
--	ShockDrop3.TargetParatroopers(SHOCKER3.CenterPosition, Angle.New(800))
--	ShockDrop4.TargetParatroopers(SHOCKER4.CenterPosition, Angle.New(800))
	end)
end
]]



function tablelength(T)
	local count = 0
	for _ in pairs(T) do count = count + 1 end
	return count
end


function toxicPlayersCheck()
    return Player.GetPlayers(function(player)
        return true
    end);
end

function setToxic()
	toxiccheck = 1
	Utils.Do(toxicPlayersCheck(), function(thesePlayers)
		if toxiccheck == 1 then
			if thesePlayers.HasPrerequisites({"toxic_enabled"}) 
			then
				toxic_enabled = 1
				-- Media.DisplayMessage ("Toxic Enabled", "Mission", HSLColor.Red)
				toxiccheck = 2
				UserInterface.SetMissionText("TOXIC MODE ENABLED", HSLColor.Red)
			end
		end
	end)
end


WorldLoaded = function()
	
Neutral = Player.GetPlayer("Neutral") 
Creeps = Player.GetPlayer("Creeps") 
Cappoints = Map.LobbyOption("Cappoints")
NuclearStrikes = Map.LobbyOption("NuclearStrikes")
toxic_enabled = 0
enablechecking = 0
bioenabled = 0
playersingame = {"Multi0","Multi1","Multi2","Multi3","Multi4","Multi5","Multi6","Multi7"} -- Table of Potential Players
actorstoupdate = {"fact","weap","tent","barr","hpad","afld","afld.ukraine","kenn","spen","syrd"}
playersingamecount = tablelength(playersingame) 
actorstoupdatecount = tablelength(actorstoupdate) 
--Media.DisplayMessage ("Total Players is " .. playersingame2, "Mission", HSLColor.Red)
activeplayers = {}    -- Table for Active Players
activeplayername = {}    -- Table for Active Players
z = 1

messages = {}
messagesloop = {}
setToxic()

----START OF AI SETUP CODE After setToxic() ---
	
AllPlayersIncludingCreeps = thePlayersAndCreeps();
AllPlayers = thePlayers();
AIPlayers = theUltimateBots();
UltimateBotsCount = #theUltimateBots();
AllBots = theBots();
HumanPlayers = theHumans();
HandicapAdjustment = #theHumans()/4
HumansCount = #theHumans()
ToxicHandicap = 1
		
tierEngineers = { "e6", "e6", "e6", "e6"}
tierThief = { "thf", "thf", "thf", "thf"}
tierSpy = { "spy", "spy", "spy", "spy"}
tier1Tanks = { "jeep", "apc", "1tnk", "ftrk"}
tier2Tanks = { "v2rl", "2tnk", "arty", "mgg", "mrj", "ttnk"}
tier3Tanks = { "3tnk", "mrj", "ctnk", "stnk" }
tier4Tanks = { "4tnk", "3tnk", "mrj", "dtrk", "ctnk", "stnk" }
tier0infantry = {"e1"}
tier1infantry = { "e1", "medi", "dog", "e1", "e2", "e3", "e3r1", "e4", "mech", "gnrl", "shok" }
tier2infantry = { "spy", "thf" }
tier3infantry = { "e7", "sniper"}
tierMcv = { "mcv"}

if toxic_enabled == 1 	then 
	ToxicHandicap = HandicapAdjustment*4
end
----END OF AI SETUP CODE After setToxic() ---




for i = playersingamecount,1,-1 
do 
	playername = playersingame[i]
	if (Player.GetPlayer(playername) ~= nil) then
		playerinfo = Player.GetPlayer(playername)
		activeplayers[z] = Player.GetPlayer(playername)
		z = z + 1
		i = i + 1
	end
end

--activeplayerscount = tablelength(activeplayers) --Table of players currently in the game
activeplayerscount = function()
	return tablelength(activeplayers)
end
--Media.DisplayMessage ("Active Players  " .. activeplayerscount(), "Mission", HSLColor.Red) --display total of players

--[[Beaconmiddle = function()
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.PlaySoundNotification(USSR, "Beacon")
			for i = activeplayerscount(),1,-1 
			do 
				playeractive = activeplayers[i]
				playername = playeractive.InternalName
				Beacon.New(playeractive, spymiddle.CenterPosition, 500)
				Radar.Ping(playeractive, spymiddle.CenterPosition, HSLColor.Aqua, 500)
			end
	end)
end
	

Spawnspyplanemiddle = function()
			for i = activeplayerscount(),1,-1 
			do 
				playeractive = activeplayers[i]
				playername = playeractive.InternalName
				spyplanemiddle1 = Actor.Create(unittocreatespyplane2, true, { Owner = playeractive, Location = spymiddle.Location})
				spyplanemiddle1.Destroy()
			end
end

Spawnspyplanetemp = function()
			for i = activeplayerscount(),1,-1 
			do 
				playeractive = activeplayers[i]
				playername = playeractive.InternalName
				spyplanemiddle2 = Actor.Create(unittocreatespyplane1, true, { Owner = playeractive, Location = spymiddle.Location})
				tempspyplane1 = Actor.Create(unittocreatespyplane1, true, { Owner = playeractive, Location = ComLeft.Location})
				tempspyplane2 = Actor.Create(unittocreatespyplane1, true, { Owner = playeractive, Location = ComRight.Location})
				tempspyplane3 = Actor.Create(unittocreatespyplane1, true, { Owner = playeractive, Location = BioDown.Location})
				tempspyplane4 = Actor.Create(unittocreatespyplane1, true, { Owner = playeractive, Location = BioUp.Location})
				spyplanemiddle2.Destroy()
				tempspyplane1.Destroy()
				tempspyplane2.Destroy()
				tempspyplane3.Destroy()
				tempspyplane4.Destroy()
			end
end
]]
	--Nuker = Actor.Create("nuker", false, { Owner = Creeps })
	--ShockDrop = Actor.Create("shockdrop", false, { Owner = Creeps })
	--ShockDrop2 = Actor.Create("shockdrop", false, { Owner = Creeps })
	--ShockDrop3 = Actor.Create("shockdrop", false, { Owner = Creeps })
	--ShockDrop4 = Actor.Create("shockdrop", false, { Owner = Creeps })

--Spawn Units

--unittocreate = "miss"
--unittocreate2 = "gmine"
--unittocreate3 = "POWR"
--unittocreatebio = "bio"
--unittocreatetree1 = "tc05"
--unittocreatetree2 = "t05"
--unittocreatespyplane1 = "camera.spyplane"
--unittocreatespyplane2 = "camera.spyplane2"
--createwarriorant = "warriorant"
--createfireant = "fireant"
--creategiantant = "ant"
--Createtreehusk1 = "tc01.husk"
--Createtreehusk2 = "t08.husk"

--[[
-- 1 x Middle 
Spawncom1 = function()
	comcentre1 = Actor.Create(unittocreate, true, { Owner = Neutral, Location = ComMiddle.Location})
	--combotmid = Actor.Create(unittocreate, true, { Owner = Neutral, Location = ComMiddleBottom.Location})
end

-- Sides
Spawncom2 = function() 
	comcentre1 = Actor.Create(unittocreate, true, { Owner = Neutral, Location = ComLeft.Location})
	comcentre2 = Actor.Create(unittocreate, true, { Owner = Neutral, Location = ComRight.Location})
end

-- 1 x Middle + Sides
Spawncom3 = function() 
	comcentre1 = Actor.Create(unittocreate, true, { Owner = Neutral, Location = ComLeft.Location})
	comcentre2 = Actor.Create(unittocreate, true, { Owner = Neutral, Location = ComMiddle.Location})
	comcentre3 = Actor.Create(unittocreate, true, { Owner = Neutral, Location = ComRight.Location})
end

--trees for middle
Spawntrees = function()
	--tree1 = Actor.Create(Createtreehusk1, true, { Owner = Neutral, Location = tc05left.Location})
	--tree2 = Actor.Create(Createtreehusk2, true, { Owner = Neutral, Location = tc05right.Location})
	--tree3 = Actor.Create(unittocreatetree2, true, { Owner = Neutral, Location = tc02middle.Location})

	trees = {}
	for i = 4,1,-1 
	do 
		TreeName = "Tree" .. i
		TreeActor = Map.NamedActor(TreeName)
			if i < 3 then
				trees[i] = Actor.Create(unittocreatetree1, true, { Owner = Neutral, Location = TreeActor.Location})
			else
				trees[i] = Actor.Create(unittocreatetree2, true, { Owner = Neutral, Location = TreeActor.Location})
			end
		--Media.DisplayMessage (minename, "Mission", HSLColor.Red)
	end


end

--Bio Labs for middle
Biolabs = function()
	biolab1 = Actor.Create(unittocreatebio, true, { Owner = Neutral, Location = BioUp.Location})
	biolab2 = Actor.Create(unittocreatebio, true, { Owner = Neutral, Location = BioDown.Location})
	table.insert(messages, "WARNING: Bio Labs Enabled")
		-- Media.DisplayMessage ("WARNING: Bio Labs Enabled", "Mission", HSLColor.Red)
end

Spawnmines = function()
	extramine = {}
	actornames = {}  
	zerocount = 0
	for i = 143,116,-1 
	do 
		minename = "Tmine" .. i
		actornames[zerocount] = "Tmine" .. i
		zerocount = zerocount+1
	end
	
	actornamescount = tablelength(actornames) 
	
	for i = actornamescount,1,-1 
	do 
		actorname = actornames[i]
		if (actorname ~= nil) then
			minename2 = Map.NamedActor(actorname)
			-- Media.DisplayMessage (actorname .. "", "Mission", HSLColor.Red)
			extramine[i] = Actor.Create(unittocreate2, true, { Owner = Neutral, Location = minename2.Location})
		end
		i = i + 1
	end
end

Spawnants = function()
	extramine = {}
	for i = 56,20,-1 
	do 
		antname = "Ant1" .. i
		antactor = Map.NamedActor(antname)
		--Media.DisplayMessage (antname, "Mission", HSLColor.Red)
		if i < 35 then
			if i < 30 then
				extramine[i] = Actor.Create(createwarriorant, true, { Owner = Creeps, Stance = AttackAnything, Location = antactor.Location})
			else
				extramine[i] = Actor.Create(creategiantant, true, { Owner = Creeps, Stance = AttackAnything, Location = antactor.Location})
			end
		else
			extramine[i] = Actor.Create(createfireant, true, { Owner = Creeps, Stance = AttackAnything, Location = antactor.Location})
		end
		--Media.DisplayMessage (minename, "Mission", HSLColor.Red)
	end

	table.insert(messages, "Ants have escaped from the Bio Labs!")
	-- Media.DisplayMessage ("Ants have escaped from the Bio Labs!", "Mission", HSLColor.Red)
end

if activeplayers[1].HasPrerequisites({"bio_enabled"}) 
then
	bioenabled = 1
	Biolabs()
	Spawnspyplanetemp()
	if (NuclearStrikes == "entry_1") then
		Spawnants()
	end
end


if (Cappoints == "entry_off") then
	Spawntrees()
	Spawnspyplanetemp()
else
	if (Cappoints == "entry_1") then -- Middle
		Spawncom1()
		Spawnspyplanemiddle()
		Spawnspyplanetemp()
	end
	
	if (Cappoints == "entry_2") then --  Sides
		Spawncom2()
		Spawntrees()
		Spawnspyplanetemp()
	end
	
	if (Cappoints == "entry_3") then --  Middle + Sides
		Spawncom3()
		Spawnspyplanemiddle()
		Spawnspyplanetemp()
		--Spawntrees()
	end
end
]]

--count buildings

countbuildings = function(buildingtype, theplayer)
	local sams = theplayer.GetActorsByType(buildingtype)
	return #sams
end


checkbuildings = function()

	for i = activeplayerscount(),1,-1 
	do 
		playeractive = activeplayers[i]
		playername = playeractive.InternalName
		
		for y = actorstoupdatecount,1,-1 
		do 
			buildingtype = actorstoupdate[y]
			--Media.DisplayMessage (playername, "Mission", HSLColor.Red)
			factorycount = countbuildings(buildingtype, playeractive)
			--factorycount = 11
			conditonname = buildingtype .. factorycount

			if (factorycount > 1) then
				if (factorycount < 8) then
					playeractive.GrantCondition(conditonname,1)
				else
					if (factorycount <= 9) then
						conditonname = buildingtype .. "8"
						playeractive.GrantCondition(conditonname,1)
					else
						if (factorycount <= 12) then
							conditonname = buildingtype .. "10"
							playeractive.GrantCondition(conditonname,1)
						else
							if (factorycount <= 15) then
								conditonname = buildingtype .. "13"
								playeractive.GrantCondition(conditonname,1)
							else
								if (factorycount <= 16) then
									conditonname = buildingtype .. "17"
									playeractive.GrantCondition(conditonname,1)
								else
									if (factorycount <= 24) then
										conditonname = buildingtype .. "21"
										playeractive.GrantCondition(conditonname,1)
									else
										conditonname = buildingtype .. "25"
										playeractive.GrantCondition(conditonname,1)
									end
								end
							end
						end
					end
				end
			end
			--Media.DisplayMessage ("Granted!" .. playername, "Mission", HSLColor.Red)
			--Media.DisplayMessage (" Condition Name2 :  " .. conditonname, "Mission", HSLColor.Red)
		end
	end
end

--toxicrules = Player.HasPrerequisites("toxic_enabled")
--toxicrules = Map.LobbyOption("toxicrules")

if toxic_enabled == 1
then 
		table.insert(messages, "Toxic Rules Enabled. 25 buildings of each for max speed")
		-- Media.DisplayMessage ("Toxic Rules Enabled. 25 buildings of each for max speed", "Mission", HSLColor.Red)
	enablechecking = 1
	--Spawnmines()
else
		table.insert(messages, "Standard Rules apply for maximum build speed (4 War/7 other buildings)")
		-- Media.DisplayMessage ("Standard Rules apply for maximum build speed (4 War/7 other buildings)", "Mission", HSLColor.Red)
end

--[[]if (NuclearStrikes ~= "entry_1") then
	delayedtroopers()
	if bioenabled == 1 then
		Trigger.AfterDelay(DateTime.Seconds(30), function()
			Spawnants()
		end)
	end
else
	if (Cappoints ~= "entry_off") then
		delayedtroopers()
	end
end]]


--end war fact check
rules()
	

	----START OF AI REFINFORCEMENT CODE ---
-- Media.DisplayMessage ("Ultimate Bots  " .. UltimateBotsCount, "Mission", HSLColor.Red) --display total of players
	if UltimateBotsCount > 0 then

			-- MCVs on repeat
			Trigger.AfterDelay(DateTime.Seconds(30), function()

				if (difficulty == "noob" ) then
					timerDelay = 70
				elseif (difficulty == "easy") then
					timerDelay = 50
				elseif (difficulty == "normal") then
					timerDelay = 40
				else
					timerDelay = 30
				end
		
				sendRepeatWave(tierMcv,1,timerDelay/HandicapAdjustment)
			end) 
		
			--One off attacks
			Trigger.AfterDelay(DateTime.Seconds(110), function()
				Media.DisplayMessage( "Enemy Troops Inbound", "Mission", HSLColor.Red)
				if (difficulty == "noob") then
					sendAttackWave(tier0infantry,(15*HandicapAdjustment)*difficultyHandicap)
				elseif (difficulty == "easy") then
					sendAttackWave(tier0infantry,(20*HandicapAdjustment)*difficultyHandicap)
				elseif (difficulty == "normal") then
					sendAttackWave(tier0infantry,(30*HandicapAdjustment)*difficultyHandicap)
				else
					sendAttackWave(tier0infantry,(50*HandicapAdjustment)*difficultyHandicap)
				end
			end)
		
		
			Trigger.AfterDelay(DateTime.Seconds(220), function()
				Media.DisplayMessage( "Enemy Troops Inbound", "Mission", HSLColor.Red)
				if (difficulty == "noob") then
					sendAttackWave(tier0infantry,(10*HandicapAdjustment)*difficultyHandicap)
				elseif (difficulty == "easy") then
					sendAttackWave(tier0infantry,(15*HandicapAdjustment)*difficultyHandicap)
				elseif (difficulty == "normal") then
					sendAttackWave(tier0infantry,(20*HandicapAdjustment)*difficultyHandicap)
				else
					sendAttackWave(tier0infantry,(25*HandicapAdjustment)*difficultyHandicap)
				end
			end)
		
			Trigger.AfterDelay(DateTime.Seconds(330), function()
				Media.DisplayMessage( "Enemy Troops Inbound", "Mission", HSLColor.Red)
				if (difficulty == "easy" or difficulty == "noob") then
					sendAttackWave(tier0infantry,(60*HandicapAdjustment)*difficultyHandicap)
					sendAttackWave(tier1Tanks,(8*HandicapAdjustment)*difficultyHandicap)
				elseif (difficulty == "normal") then
					sendAttackWave(tier0infantry,(60*HandicapAdjustment)*difficultyHandicap)
					sendAttackWave(tier1Tanks,(8*HandicapAdjustment)*difficultyHandicap)
				else
					sendAttackWave(tier1infantry,(60*HandicapAdjustment)*difficultyHandicap)
					sendAttackWave(tier2Tanks,(8*HandicapAdjustment)*difficultyHandicap)
				end
			end)
		
			Trigger.AfterDelay(DateTime.Seconds(420), function()
				--Start of Tank Waves
				Media.DisplayMessage( "Enemy Tanks Inbound", "Mission", HSLColor.Red)
		
				if (difficulty == "easy" or difficulty == "noob") then
					--Infantry
					sendAttackWave(tier1infantry,(80*HandicapAdjustment)*difficultyHandicap)
					sendAttackWave(tier1Tanks,(8*HandicapAdjustment)*difficultyHandicap)
					sendAttackWave(tier2Tanks,(8*HandicapAdjustment)*difficultyHandicap)
				elseif (difficulty == "normal") then
					--Infantry
					sendAttackWave(tier1infantry,(90*HandicapAdjustment)*difficultyHandicap)
					sendAttackWave(tier1Tanks,(8*HandicapAdjustment)*difficultyHandicap)
					sendAttackWave(tier2Tanks,(8*HandicapAdjustment)*difficultyHandicap)
				else
					--Infantry
					sendAttackWave(tier1infantry,(100*HandicapAdjustment)*difficultyHandicap)
					sendAttackWave(tier2Tanks,(10*HandicapAdjustment)*difficultyHandicap)
					sendAttackWave(tier3Tanks,(10*HandicapAdjustment)*difficultyHandicap)
				end
				-- sendAttackWave(tier4Tanks,2*HandicapAdjustment)*difficultyHandicap)
			end)
		
			Trigger.AfterDelay(DateTime.Seconds(540), function()
		
				Media.DisplayMessage( "Enemy Tanks Inbound", "Mission", HSLColor.Red)
		
				if (difficulty == "easy" or difficulty == "noob") then
					--Infantry
					sendAttackWave(tier1infantry,(100*HandicapAdjustment)*difficultyHandicap)
					sendAttackWave(tier2infantry,(4*HandicapAdjustment)*difficultyHandicap)
					--Tanks
					sendAttackWave(tier1Tanks,(6*HandicapAdjustment)*difficultyHandicap)
					sendAttackWave(tier2Tanks,(6*HandicapAdjustment)*difficultyHandicap)
					sendAttackWave(tier3Tanks,(4*HandicapAdjustment)*difficultyHandicap)
					--sendAttackWave(tier4Tanks,(2*HandicapAdjustment)*difficultyHandicap)
				elseif (difficulty == "normal") then
					--Infantry
					sendAttackWave(tier1infantry,(100*HandicapAdjustment)*difficultyHandicap)
					sendAttackWave(tier2infantry,(4*HandicapAdjustment)*difficultyHandicap)
					--Tanks
					sendAttackWave(tier1Tanks,(8*HandicapAdjustment)*difficultyHandicap)
					sendAttackWave(tier2Tanks,(8*HandicapAdjustment)*difficultyHandicap)
					sendAttackWave(tier3Tanks,(6*HandicapAdjustment)*difficultyHandicap)
					--sendAttackWave(tier4Tanks,(2*HandicapAdjustment)*difficultyHandicap)
				else
					--Infantry
					sendAttackWave(tier1infantry,(120*HandicapAdjustment)*difficultyHandicap)
					sendAttackWave(tier2infantry,(8*HandicapAdjustment)*difficultyHandicap)
					--Tanks
					sendAttackWave(tier1Tanks,(10*HandicapAdjustment)*difficultyHandicap)
					sendAttackWave(tier2Tanks,(8*HandicapAdjustment)*difficultyHandicap)
					sendAttackWave(tier3Tanks,(6*HandicapAdjustment)*difficultyHandicap)
					sendAttackWave(tier4Tanks,(4*HandicapAdjustment)*difficultyHandicap)
				end
				
			end)
		
		
		
			Trigger.AfterDelay(DateTime.Seconds(2), function()
				aiCash() -- Stream of cash for AI
				createHarv() -- If ran out of money then create Harvester
				createEngineers()
			end)
		
		
		
			if (difficulty == "noob") then
				continuousCountdown = 720
			elseif (difficulty == "easy" ) then
				continuousCountdown = 600
			elseif (difficulty == "normal") then
				continuousCountdown = 600
			else
				continuousCountdown = 480
			end
		
				Trigger.AfterDelay(DateTime.Seconds(continuousCountdown), function()
					Media.DisplayMessage( "WARNING: Ultimate AI has ramped up production!", "Mission", HSLColor.Red)
					continuousProduction()
				end)
		
			setDifficulty()

			Trigger.AfterDelay(DateTime.Seconds(1200), function()
				finalAssault()
			end)
	end
		----END OF AI REFINFORCEMENT CODE ---
		
		Trigger.AfterDelay(DateTime.Seconds(2), function()
			setupRefs()


		end)
		
--read the messages
readmessages()

loopcounter = 1
Trigger.AfterDelay(5000, readmessagesloop)


if UltimateBotsCount > 0 then
	Trigger.AfterDelay(DateTime.Seconds(2), function()
		AdjustmentLevel = difficultyHandicap*HandicapAdjustment*toxicAdjustment
		Media.DisplayMessage( "AI Difficulty Level "..AdjustmentLevel.." (Adjusted For Players/Difficulty)", "Mission", HSLColor.Red)
	end)
end

end


Tick = function()
	if enablechecking > 0 then
		checkbuildings()
	end
end

