AllyBottom = { { "fact", -4, -1 }, { "fact", -4, -5 }, { "fact", -4, -9 }, { "fact", -1, -5 }, { "fact", -1, -9 }, { "apwr", -7, 0 }, { "apwr", -7, -4 }, { "apwr", -7, -8 }, { "apwr", -7, -12 }, { "apwr", 2, 0 }, { "apwr", 2, -4 }, { "apwr", 2, -8 }, { "weap", 5, 0 }, { "weap", 5, -3 }, { "weap", 5, -6 }, { "weap", -10, 0 }, { "weap", -10, -3 }, { "weap", -10, -6 }, { "weap", -10, -9 }, { "dome", -9, -12 }, { "weap", 5, -9 }, { "dome", 5, -12 }, { "apwr", 2, -12 }, { "fact", -1, -13 }, { "fact", -4, -13 }, { "fix", -4, -16 }, { "fix", -1, -16 }, { "gmine", -9, 8 }, { "gmine", -9, 11 }, { "gmine", -6, 8 }, { "gmine", -6, 11 }, { "gmine", -3, 8 }, { "gmine", -3, 11 }, { "gmine", 0, 8 }, { "gmine", 0, 11 }, { "gmine", 3, 8 }, { "gmine", 3, 11 }, { "gmine", 6, 8 }, { "gmine", 6, 11 }, { "gmine", -9, 14 }, { "gmine", -6, 14 }, { "gmine", -3, 14 }, { "gmine", 0, 14 }, { "gmine", 3, 14 }, { "gmine", 6, 14 }, { "gmine", -12, 8 }, { "gmine", -12, 11 }, { "gmine", -12, 14 }, { "gmine", 9, 8 }, { "gmine", 9, 11 }, { "gmine", 9, 14 }, { "proc", -10, 3 }, { "proc", -5, 3 }, { "proc", 0, 3 }, { "proc", 5, 3 }, { "harv", -12, 9 }, { "harv", -9, 9 }, { "harv", -6, 9 }, { "harv", -3, 9 }, { "harv", 0, 9 }, { "harv", 3, 9 }, { "harv", 6, 9 }, { "harv", 9, 9 }, { "tent", 8, 0 }, { "tent", 8, -3 }, { "tent", 8, -6 }, { "tent", 8, -9 }, { "tent", -12, 0 }, { "tent", -12, -3 }, { "tent", -12, -6 }, { "tent", -12, -9 }, { "hpad", 10, 0 }, { "hpad", 10, -3 }, { "hpad", 10, -6 }, { "hpad", 10, -9 }, { "hpad", -14, 0 }, { "hpad", -14, -3 }, { "hpad", -14, -6 }, { "hpad", -14, -9 }, { "atek", 7, -12 }, { "atek", -11, -12 }, }

SovietBottom = { { "fact", -4, -1 }, { "fact", -4, -5 }, { "fact", -4, -9 }, { "fact", -1, -5 }, { "fact", -1, -9 }, { "apwr", -7, 0 }, { "apwr", -7, -4 }, { "apwr", -7, -8 }, { "apwr", -7, -12 }, { "apwr", 2, 0 }, { "apwr", 2, -4 }, { "apwr", 2, -8 }, { "weap", 5, 0 }, { "weap", 5, -3 }, { "weap", 5, -6 }, { "weap", -10, 0 }, { "weap", -10, -3 }, { "weap", -10, -6 }, { "weap", -10, -9 }, { "dome", -9, -12 }, { "weap", 5, -9 }, { "dome", 5, -12 }, { "apwr", 2, -12 }, { "fact", -1, -13 }, { "fact", -4, -13 }, { "fix", -4, -16 }, { "fix", -1, -16 }, { "gmine", -9, 8 }, { "gmine", -9, 11 }, { "gmine", -6, 8 }, { "gmine", -6, 11 }, { "gmine", -3, 8 }, { "gmine", -3, 11 }, { "gmine", 0, 8 }, { "gmine", 0, 11 }, { "gmine", 3, 8 }, { "gmine", 3, 11 }, { "gmine", 6, 8 }, { "gmine", 6, 11 }, { "gmine", -9, 14 }, { "gmine", -6, 14 }, { "gmine", -3, 14 }, { "gmine", 0, 14 }, { "gmine", 3, 14 }, { "gmine", 6, 14 }, { "gmine", -12, 8 }, { "gmine", -12, 11 }, { "gmine", -12, 14 }, { "gmine", 9, 8 }, { "gmine", 9, 11 }, { "gmine", 9, 14 }, { "afld", 10, 0 }, { "afld", 10, -3 }, { "afld", 10, -6 }, { "afld", 10, -9 }, { "afld", -15, -9 }, { "afld", -15, -6 }, { "afld", -15, -3 }, { "afld", -15, 0 }, { "barr", 8, -9 }, { "barr", 8, -6 }, { "barr", 8, -3 }, { "barr", 8, 0 }, { "barr", -12, 0 }, { "barr", -12, -3 }, { "barr", -12, -6 }, { "barr", -12, -9 }, { "stek", 7, -12 }, { "stek", -12, -12 }, { "proc", -10, 3 }, { "proc", -5, 3 }, { "proc", 0, 3 }, { "proc", 5, 3 }, { "harv", -12, 9 }, { "harv", -9, 9 }, { "harv", -6, 9 }, { "harv", -3, 9 }, { "harv", 0, 9 }, { "harv", 3, 9 }, { "harv", 6, 9 }, { "harv", 9, 9 }, }

AllyTop = { { "fact", -4, -1 }, { "fact", -4, 3 }, { "fact", -1, 3 }, { "fact", -4, 7 }, { "fact", -1, 7 }, { "fact", -1, 11 }, { "fact", -4, 11 }, { "apwr", -7, 0 }, { "apwr", -7, 4 }, { "apwr", -7, 8 }, { "apwr", -7, 12 }, { "apwr", 2, 12 }, { "apwr", 2, 8 }, { "apwr", 2, 4 }, { "apwr", 2, 0 }, { "weap", -10, -1 }, { "weap", -10, 2 }, { "weap", -10, 5 }, { "weap", -10, 8 }, { "weap", 5, -1 }, { "weap", 5, 2 }, { "weap", 5, 5 }, { "weap", 5, 8 }, { "dome", 5, 11 }, { "dome", -9, 11 }, { "atek", 7, 11 }, { "atek", -11, 11 }, { "tent", 8, -1 }, { "tent", 8, 2 }, { "tent", 8, 5 }, { "tent", 8, 8 }, { "tent", -12, -1 }, { "tent", -12, 2 }, { "tent", -12, 5 }, { "tent", -12, 8 }, { "hpad", 10, -1 }, { "hpad", 10, 2 }, { "hpad", 10, 5 }, { "hpad", 10, 8 }, { "hpad", -14, -1 }, { "hpad", -14, 2 }, { "hpad", -14, 5 }, { "hpad", -14, 8 }, { "proc", 5, -5 }, { "proc", 0, -5 }, { "gmine", 9, -13 }, { "gmine", 9, -10 }, { "gmine", 9, -7 }, { "gmine", 6, -7 }, { "gmine", 6, -10 }, { "gmine", 6, -13 }, { "gmine", 3, -13 }, { "gmine", 3, -10 }, { "gmine", 3, -7 }, { "gmine", 0, -7 }, { "gmine", 0, -10 }, { "gmine", 0, -13 }, { "gmine", -3, -13 }, { "gmine", -3, -10 }, { "gmine", -3, -7 }, { "gmine", -6, -7 }, { "gmine", -6, -10 }, { "gmine", -6, -13 }, { "gmine", -9, -13 }, { "gmine", -9, -10 }, { "gmine", -9, -7 }, { "gmine", -12, -7 }, { "gmine", -12, -10 }, { "gmine", -12, -13 }, { "proc", -10, -5 }, { "proc", -5, -5 }, { "fix", -1, 15 }, { "fix", -4, 15 }, { "harv", -12, -8 }, { "harv", -9, -8 }, { "harv", -6, -8 }, { "harv", -3, -8 }, { "harv", 0, -8 }, { "harv", 3, -8 }, { "harv", 6, -8 }, { "harv", 9, -8 }, }

SovietTop = { { "fact", -4, -1 }, { "fact", -4, 3 }, { "fact", -1, 3 }, { "fact", -4, 7 }, { "fact", -1, 7 }, { "fact", -1, 11 }, { "fact", -4, 11 }, { "apwr", -7, 0 }, { "apwr", -7, 4 }, { "apwr", -7, 8 }, { "apwr", -7, 12 }, { "apwr", 2, 12 }, { "apwr", 2, 8 }, { "apwr", 2, 4 }, { "apwr", 2, 0 }, { "weap", -10, -1 }, { "weap", -10, 2 }, { "weap", -10, 5 }, { "weap", -10, 8 }, { "weap", 5, -1 }, { "weap", 5, 2 }, { "weap", 5, 5 }, { "weap", 5, 8 }, { "dome", 5, 11 }, { "dome", -9, 11 }, { "gmine", 9, -13 }, { "gmine", 6, -13 }, { "gmine", 3, -13 }, { "gmine", 0, -13 }, { "gmine", -3, -13 }, { "gmine", -6, -13 }, { "gmine", -9, -13 }, { "gmine", -12, -13 }, { "fix", -1, 15 }, { "fix", -4, 15 }, { "harv", 3, -8 }, { "harv", 6, -8 }, { "harv", 9, -8 }, { "proc", 5, -5 }, { "proc", 0, -5 }, { "proc", -5, -5 }, { "proc", -10, -5 }, { "harv", 0, -8 }, { "harv", -3, -8 }, { "harv", -6, -8 }, { "harv", -9, -8 }, { "harv", -12, -8 }, { "gmine", -12, -10 }, { "gmine", -9, -10 }, { "gmine", -6, -10 }, { "gmine", -3, -10 }, { "gmine", 0, -10 }, { "gmine", 3, -10 }, { "gmine", 6, -10 }, { "gmine", 9, -10 }, { "gmine", 9, -7 }, { "gmine", 6, -7 }, { "gmine", 3, -7 }, { "gmine", 0, -7 }, { "gmine", -3, -7 }, { "gmine", -6, -7 }, { "gmine", -9, -7 }, { "gmine", -12, -7 }, { "afld", 10, -1 }, { "afld", 10, 2 }, { "afld", 10, 5 }, { "afld", 10, 8 }, { "afld", -15, 8 }, { "afld", -15, 5 }, { "afld", -15, 2 }, { "afld", -15, -1 }, { "barr", 8, 8 }, { "barr", 8, 5 }, { "barr", 8, 2 }, { "barr", 8, -1 }, { "barr", -12, -1 }, { "barr", -12, 2 }, { "barr", -12, 5 }, { "barr", -12, 8 }, { "stek", 7, 11 }, { "stek", -12, 11 }, }

PlayerStructures = {
    england = { AllyTop, AllyBottom },
    france = { AllyTop, AllyBottom },
    germany = { AllyTop, AllyBottom },
    russia = { SovietTop, SovietBottom },
    ukraine = { SovietTop, SovietBottom },
}

Players = { "Multi0", "Multi1", "Multi2", "Multi3", "Multi4", "Multi5", "Multi6", "Multi7" }

local function PutStructuresTemplate(player, structures)
    for _, s in ipairs(structures) do
        --Media.DisplayMessage(tostring(s))
        local struct = s[1]
        local X = s[2] + player.HomeLocation.X
        local Y = s[3] + player.HomeLocation.Y
        --Media.DisplayMessage(struct .. X .. "@" .. Y)
        Actor.Create(struct, true, { Owner = player, Location = CPos.New(X, Y), Faction = player.Faction })
    end
end

local function PutStructures()
    for idx, player_name in ipairs(Players) do
        local player = Player.GetPlayer(player_name)
        if player ~= nil then
            local isTop = (player.Spawn <= 4)
            Media.DisplayMessage(tostring(player) .. tostring(isTop))
            --if player.Faction ==
            if isTop then
                PutStructuresTemplate(player, PlayerStructures[player.Faction][1])
            else
                PutStructuresTemplate(player, PlayerStructures[player.Faction][2])
            end
        end
    end
end

WorldLoaded = function()
    PutStructures()
end
