function getActorsAround(actorselected,actorsToFind, distance)
    actorList = Map.ActorsInCircle(actorselected.CenterPosition, WDist.FromCells(distance), function(a)
        return a.Type == actorsToFind
    end)
    return actorList
end


function setupRefs()

    facts = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
        return actor.Type == "fact" or actor.Type == "mcv"
    end)


    Utils.Do(facts, function(a)
        
            -- Media.DisplayMessage (""..a.Owner.Name, "Mission", HSLColor.Red)
        if a.Owner ~= castlePlayer then
            actorOwner = a.Owner
            --Media.DisplayMessage (""..actorOwner.Name, "Mission", HSLColor.Red)

            toCapture = {}
            toCapture = { "silo","powr","oilb","apwr"}

            Utils.Do(toCapture, function(z)
                actorsToCapture = getActorsAround(a,z,11)
                    
                Utils.Do(actorsToCapture, function(b)
                    b.Owner = actorOwner
                end)
            end)
        end
    end)

    --Create Refs
    Trigger.AfterDelay(DateTime.Seconds(1), function()
        powrs = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
            return 
            actor.Type == "silo"
        end)

        Utils.Do(powrs, function(a)

            actorOwner = a.Owner
            originalLocation = a.Location
            newLocation = originalLocation + CVec.New(0,1)

            --if actorOwner.InternalName ~= "Creeps" then
            if actorOwner.InternalName ~= "Neutral" then
                Actor.Create("proc", true, { Owner = actorOwner, Location = newLocation})
            end
            
             --Media.DisplayMessage (""..actorOwner.InternalName, "Mission", HSLColor.Red)
            -- Media.DisplayMessage(""..newLocation, "Mission", HSLColor.Red)
        end)

    end)


    Trigger.AfterDelay(DateTime.Seconds(5), function()
        --neutralActors = getAllNeutral()
        --removeactors(neutralActors)

        creepActors = getAllCreeps()
        removeactors(creepActors)
        --Media.DisplayMessage(""..#creepActors, "Mission", HSLColor.Red)
    end)
end

function getAllCreeps()
    targets = Utils.Where(Creeps.GetActors(), function(actor)
        return
            actor.Type == "powr" or actor.Type == "silo" or actor.Type == "oilb" or actor.Type == "apwr" or actor.Type == "harv" or actor.Type == "proc"
    end)
    return targets
end

function getAllNeutral()
    targets = Utils.Where(Neutral.GetActors(), function(actor)
        return
            actor.Type == "powr" or actor.Type == "silo" or actor.Type == "oilb" or actor.Type == "apwr"
    end)
    return targets
end

--Remove Boxes in Table
function removeactors(a)
    Utils.Do(a, function(unit)
        unit.Destroy()
    end)
    return 
end

WorldLoaded = function()
    Creeps = Player.GetPlayer("Creeps") 
    Neutral = Player.GetPlayer("Neutral") 
    Trigger.AfterDelay(DateTime.Seconds(2), function()
        setupRefs()
    end)

    --local init_teleport
    --local TeleportNameIn
    --local TeleportActorIn
    --local TeleportNameOut
    --local TeleportActorOut
    --local Tile
    --local AreaSize
    --local Tile
    --local TeleportActorDiffX
    --local TeleportActorDiffY
    actor_speed = {}
    actor_speed["1tnk"]             = 8
    actor_speed["2tnk"]             = 10
    actor_speed["3tnk"]             = 12
    actor_speed["4tnk"]             = 16
    actor_speed["ant"]              = 4
    actor_speed["apc"]              = 6
    actor_speed["arty"]             = 8
    actor_speed["ctnk"]             = 8
    actor_speed["dog"]              = 3
    actor_speed["dtrk"]             = 6
    actor_speed["e1"]               = 2
    actor_speed["e2"]               = 3
    actor_speed["e3"]               = 3
    actor_speed["e3r1"]             = 3
    actor_speed["e4"]               = 3
    actor_speed["e6"]               = 3
    actor_speed["e7"]               = 3
    actor_speed["fireant"]          = 4
    actor_speed["ftrk"]             = 6
    actor_speed["gnrl"]             = 3
    actor_speed["harv"]             = 10
    actor_speed["jeep"]             = 6
    actor_speed["mcv"]              = 20
    actor_speed["mech"]             = 3
    actor_speed["medi"]             = 3
    actor_speed["mgg"]              = 6
    actor_speed["mrj"]              = 6
    actor_speed["shok"]             = 3
    actor_speed["sniper"]           = 3
    actor_speed["spy"]              = 3
    actor_speed["stnk"]             = 8
    actor_speed["thf"]              = 3
    actor_speed["ttnk"]             = 8
    actor_speed["v2rl"]             = 8
    actor_speed["warriorant"]       = 4
    actor_speed["zombie"]           = 5
    m_speed=8
    flits_teleport=function(a,m_Teleport,count,speed,m_teleported)
        local m_speed=speed
        local m_count=count
        local m_actor=a
        local m_actorId=tostring(m_actor)
        local m_TeleportNumber=m_Teleport
        --m_teleported=teleported[m_TeleportNumber]
        --Media.DisplayMessage("Count: "..m_count.." Actor: "..m_actorId,"Mission",HSLColor.Blue);
        Trigger.AfterDelay(DateTime.Seconds(0),function()
            if not m_actor.IsDead then
                m_actorId=tostring(m_actor)
                if m_teleported[m_actorId]~=nil then
                    m_teleported[m_actorId] = m_teleported[m_actorId] - 1
                    --Media.DisplayMessage("m_teleported["..m_actorId.."]="..m_teleported[m_actorId],"Mission",HSLColor.Blue);
                    resetter[m_TeleportNumber] = 10
                    if m_teleported[m_actorId] >= 0 then
                        flits_teleport(m_actor,m_TeleportNumber,0, m_speed, m_teleported)
                        return 
                    end
                    --Media.DisplayMessage("Deleting: "..m_actorId.." from list.","Mission",HSLColor.Blue);
                else
                    Media.DisplayMessage("Not in list: "..m_actorId,"Mission",HSLColor.Blue);
                    return
                end
                --if m_teleported[m_actorId]~=nil then
                --    m_teleported[m_actorId] = nil
                --    --Media.DisplayMessage("Deleting: "..m_actorId.." from list.","Mission",HSLColor.Blue);
                --else
                --    Media.DisplayMessage("Not in list: "..m_actorId,"Mission",HSLColor.Blue);
                --    return
                --end
                --Media.DisplayMessage("Teleporting: "..m_actor.Type.."  ID: "..m_actorId,"Mission",HSLColor.Blue);
                X=m_actor.CenterPosition.X/Tile
                Y=m_actor.CenterPosition.Y/Tile
                --Media.DisplayMessage("Teleporting: "..m_actor.Type.."  from: "..X..","..Y,"Mission",HSLColor.Blue);

                TeleportActorIn     =Teleports_ActorsIn[m_TeleportNumber]           
                TeleportActorIn_BR  =Teleports_ActorsIn_BR[m_TeleportNumber]     
                TeleportActorOut    =Teleports_ActorsOut[m_TeleportNumber]
                TeleportActorDiffX  =Teleports_ActorsDiffX[m_TeleportNumber]
                TeleportActorDiffY  =Teleports_ActorsDiffY[m_TeleportNumber]
                Teleport_SizeX      =Teleports_SizeX[m_TeleportNumber]
                Teleport_SizeY      =Teleports_SizeY[m_TeleportNumber]

                --Next_m_TeleportNumber = (m_TeleportNumber) % 4 + 1
                --NEXT_X = Teleports_ActorsIn[Next_m_TeleportNumber].CenterPosition.X/Tile
                --NEXT_Y = Teleports_ActorsIn[Next_m_TeleportNumber].CenterPosition.Y/Tile
                if m_actor.IsIdle then
                    --Media.DisplayMessage("Actor Idle","Mission",HSLColor.Blue);
                    --if (X>=TeleportActorIn.CenterPosition.X/Tile-2.5 and X<=TeleportActorIn.CenterPosition.X/Tile+2.5 and Y>=TeleportActorIn.CenterPosition.Y/Tile-2.5 and Y<=TeleportActorIn.CenterPosition.Y/Tile+2.5) then
                    if TeleportActorDiffX > 0 then
                        dir_X = 1
                    elseif TeleportActorDiffX < 0 then
                        dir_X = -1
                    else 
                        dir_X = 0
                    end    
                    if REVERSED_ON == 1 then  
                        if m_TeleportNumber == 7 or m_TeleportNumber == 8 then 
                            dir_X = 0
                        else
                            dir_X = -dir_X
                        end
                    end

                    --if TeleportActorDiffY > 0 then
                    --    dir_Y = 1
                    --elseif TeleportActorDiffY < 0 then
                    --    dir_Y = -1
                    --else 
                    --    dir_Y = 0
                    --end    
                    dir_Y = 0
                    Xm = X
                    Ym = Y
                    Xm = X+dir_X
                    Ym = Y+dir_Y
                    --Xm = X+TeleportActorDiffX
                    --Ym = Y+TeleportActorDiffY
                    if (not (m_TeleportNumber == 7 or m_TeleportNumber == 8) and 
                        X>=TeleportActorIn.CenterPosition.X/Tile - 1.5 and
                        X<=TeleportActorIn_BR.CenterPosition.X/Tile + 1.5 and
                        Y>=TeleportActorIn.CenterPosition.Y/Tile + 0.5 and
                        Y<=TeleportActorIn_BR.CenterPosition.Y/Tile - 0.5) then

                        NewP=CPos.New(Xm,Ym)
                        m_actor.Teleport(NewP)
                        m_teleported[m_actorId]=m_speed
                        --Media.DisplayMessage("Teleporting "..m_TeleportNumber..": "..m_actor.Type.."  ID: "..m_actorId,"Mission",HSLColor.Blue);

                        flits_teleport(m_actor,m_TeleportNumber,0, m_speed, m_teleported)

                    else
                        if m_actor.HasProperty("Move") then
                            if (dir_X==1) then
                                m_angle=math.rad((Utils.RandomInteger(0,180)+Utils.RandomInteger(0,180))/2)
                            else
                                m_angle=math.rad((Utils.RandomInteger(180,360)+Utils.RandomInteger(180,360))/2)
                            end
                            r=(Utils.RandomInteger(4,12)+Utils.RandomInteger(4,12)+Utils.RandomInteger(4,12))/3
                            XX=Xm + math.sin(m_angle)*r
                            YY=Ym + math.cos(m_angle)*r

                            --YY=Y
                            --XX=Xm + TeleportActorDiffX
                            NewP=CPos.New(XX,YY)
                            m_actor.Move(NewP)
                            --Media.DisplayMessage("Moving "..m_TeleportNumber..": "..m_actor.Type.."  ID: "..m_actorId,"Mission",HSLColor.Blue);
                        end

                        if m_teleported[m_actorId]~=nil then
                            m_teleported[m_actorId]=nil
                        end
                    end
                else
                    --if (X>=TeleportActorIn.CenterPosition.X/Tile-2.5 and X<=TeleportActorIn.CenterPosition.X/Tile+2.5 and Y>=TeleportActorIn.CenterPosition.Y/Tile-2.5 and Y<=TeleportActorIn.CenterPosition.Y/Tile+2.5) then
                    if (X>=TeleportActorIn.CenterPosition.X/Tile - 0.5 and X<=TeleportActorIn_BR.CenterPosition.X/Tile + 0.5 and Y>=TeleportActorIn.CenterPosition.Y/Tile - 0.5 and Y<=TeleportActorIn_BR.CenterPosition.Y/Tile + 0.5) then
                        NewP=CPos.New(X+TeleportActorDiffX,Y+TeleportActorDiffY)
                        --Media.DisplayMessage("Actor Moving and in box","Mission",HSLColor.Blue);
                        --if REVERSED_ON == 0 and not (m_TeleportNumber == 7 or m_TeleportNumber == 8) then 
                        if not (m_TeleportNumber == 7 or m_TeleportNumber == 8) then 
                            m_actor.Stop()
                            m_teleported[m_actorId]=m_speed
                            flits_teleport(m_actor,m_TeleportNumber,0, m_speed, m_teleported)
                        end
                    else
                        --Media.DisplayMessage("Actor Moving and NOT in box","Mission",HSLColor.Blue);
                        if m_teleported[m_actorId] ~= nil then
                            m_teleported[m_actorId]=nil
                        end
                    end
                end
            else
                m_actorId=tostring(m_actor)
                --Media.DisplayMessage("Actor ID: "..m_actorId.." is Dead","Mission",HSLColor.Blue);
                --Media.DisplayMessage("Teleporting: "..m_actor.Type.."  ID: "..m_actorId,"Mission",HSLColor.Blue);
                if m_teleported[m_actorId]~=nil then
                    m_teleported[m_actorId]=nil
                end
            end
        end)
    end

    resetter = {}
    teleported={}
    teleported[1]={}
    teleported[2]={}
    teleported[3]={}
    teleported[4]={}
    teleported[5]={}
    teleported[6]={}
    teleported[7]={}
    teleported[8]={}
    Teleports_ActorsIn={}
    Teleports_ActorsIn_BR={}
    Teleports_ActorsOut={}
    Teleports_ActorsDiffX={}
    Teleports_ActorsDiffY={}
    Teleports_SizeX={}
    Teleports_SizeY={}
    TeleportCount={}
    number_time={}
    Tile=WDist.FromCells(1).Length
    AreaSize=WVec.New(Tile*2.5,Tile*2.5,0)
    AreaHalfSize=WVec.New(Tile*0.5,-Tile*0.25,0) --EEKS
    --AreaHalfSize=WVec.New(Tile*0.5,Tile*0.5,0)
    check_teleport=function(TeleportNumber)
        --Media.DisplayMessage("Checking teleports.","Mission",HSLColor.Green)

        if not init_teleport then
            init_teleport=1
            for i=1,8,1 do

                number_time[i]=5
                Oke = 1
                Media.DisplayMessage("Init teleport: "..i,"Mission",HSLColor.Green)

                TeleportNameIn="ActorTeleportIn_TL_"..i
                TeleportActorIn=Map.NamedActor(TeleportNameIn)

                TeleportNameIn="ActorTeleportIn_BR_"..i
                TeleportActorIn_BR=Map.NamedActor(TeleportNameIn)

                TeleportNameOut="ActorTeleportOut_TL_"..i
                TeleportActorOut=Map.NamedActor(TeleportNameOut)

                if TeleportActorIn~=nil and TeleportActorOut~=nil and TeleportActorIn_BR~=nil then
                    
                    x_i  = TeleportActorIn.CenterPosition.X/Tile        - 0.5
                    y_i  = TeleportActorIn.CenterPosition.Y/Tile        - 0.5
                    x_BR = TeleportActorIn_BR.CenterPosition.X/Tile+1   + 0.5
                    y_BR = TeleportActorIn_BR.CenterPosition.Y/Tile+1   + 0.5
                    x_o  = TeleportActorOut.CenterPosition.X/Tile       - 0.5
                    y_o  = TeleportActorOut.CenterPosition.Y/Tile       - 0.5

                    Teleports_ActorsDiffX[i]=x_o-x_i
                    Teleports_ActorsDiffY[i]=y_o-y_i

                    Teleports_SizeX[i]=x_BR-x_i
                    Teleports_SizeY[i]=y_BR-y_i

                    --TeleportActorDiffY=TeleportActorOut.CenterPosition.Y/Tile-TeleportActorIn.CenterPosition.Y/Tile

                    Teleports_ActorsIn[i] = TeleportActorIn
                    Teleports_ActorsIn_BR[i] = TeleportActorIn_BR
                    Teleports_ActorsOut[i] = TeleportActorOut

                    --Media.DisplayMessage("Teleport in/out location "..i..": "..x_i..","..y_i.." / "..x_o..","..y_o.." OK!","Mission",HSLColor.Blue);
                    TeleportCount[i]=0
                    resetter[i] = 10
                    if Oke == 1 then
                        --Teleported[i]={}
                        Trigger.AfterDelay(DateTime.Seconds(4+i),function()
                            check_teleport(i)
                        end)
                    --else
                    --    return
                    end
                    --return
                else
                    if TeleportActorIn == nil then
                        Media.DisplayMessage("Teleport in TL location:  TeleportActorIn_TL_"..i..": NOT OK! AAARGHHHHH!!!!","Mission",HSLColor.Blue);
                    elseif TeleportActorOut == nil then
                        Media.DisplayMessage("Teleport out location: TeleportActorOut_TL_"..i..": NOT OK! AAARGHHHHH!!!!","Mission",HSLColor.Blue);
                    elseif TeleportActorIn_BR == nil then
                        Media.DisplayMessage("Teleport in BR location: TeleportActorIn_BR_"..i..": NOT OK! AAARGHHHHH!!!!","Mission",HSLColor.Blue);
                    end
                    Oke = 0
                    --return
                end

            end
            return
        end

        if TeleportNumber == nil then 
            Media.DisplayMessage("TeleportNumber == nil","Mission",HSLColor.Blue);
        --else
            --Media.DisplayMessage("Checking TeleportNumber: "..TeleportNumber,"Mission",HSLColor.Blue);
        end 

        --facts=Map.ActorsInBox(Teleports_ActorsIn[TeleportNumber].CenterPosition-AreaSize,Teleports_ActorsIn[TeleportNumber].CenterPosition+AreaSize,function(actor)
        --facts=Map.ActorsInBox(Teleports_ActorsIn[TeleportNumber].CenterPosition - AreaHalfSize,Teleports_ActorsIn_BR[TeleportNumber].CenterPosition + AreaHalfSize,function(actor)



        number=0
        count=0
        local actorId=""
        local m_teleported=teleported[TeleportNumber]

        facts=Map.ActorsInBox(Teleports_ActorsIn[TeleportNumber].CenterPosition - AreaHalfSize,Teleports_ActorsIn_BR[TeleportNumber].CenterPosition + AreaHalfSize,function(actor)
            return  m_teleported[tostring(actor)]==nil and
                    actor.HasProperty("Move") and
                    actor.Type~="waypoint" and
                    actor.Type~="badr" and actor.CenterPosition.Z == 0
                    --and actor.Type~="badr.bomber" and actor.Type~="mig" and actor.Type~="yak" and 
                    --actor.Type~="heli" and actor.Type~="mh60" and actor.Type~="mh60" and  
                    --actor.Type~="chinook" and actor.Type~="hind" and actor.Type~="tran" and
                    --actor.Type~="u2" and actor.Type~="longbow" and actor.Type~="u2" --
        end)
        --Utils.Do(facts,function(actor)
        --    Media.DisplayMessage("actor.Type: "..actor.Type,"Mission",HSLColor.Blue);
        --end)


        Utils.Do(facts,function(actor)
            --if (actor.CenterPosition.Z ~= 0) then 
            --    Media.DisplayMessage("actor.Type: "..actor.Type.." actor.CenterPosition.Z = "..actor.CenterPosition.Z,"Mission",HSLColor.Blue);
            --    return
            --end
            number=number+1
            if not (m_TeleportNumber == 7 or m_TeleportNumber == 8) and number==1 and number_time[TeleportNumber]==4 then
                Media.PlaySound("chrotnk1.aud")
            end
            --if number==1 and number_time[TeleportNumber]==4 then
            --    Media.DisplayMessage("Teleporter "..TeleportNumber..": Activity Detected...","Mission",HSLColor.Blue);
            --end
            actorId=tostring(actor)
            --if actor_speed[actor.Type] ~= nil then
            --end
            a_s = math.abs(Teleports_ActorsDiffX[TeleportNumber]) - 1
            --Media.DisplayMessage("Count: "..number.." Actor: "..actorId.."  speed = "..a_s,"Mission",HSLColor.Blue);
            if actor.IsIdle then
                if m_teleported[actorId]==nil then
                    count=count+1
                    --Media.DisplayMessage("Count: "..number.." Actor: "..actorId.." is idle.","Mission",HSLColor.Blue);

                    resetter[TeleportNumber] = 10
                    m_teleported[actorId]=a_s
                    --if not (m_TeleportNumber == 7 or m_TeleportNumber == 8) and count==1 then                     
                    --    Media.PlaySound("chrotnk1.aud")
                    --end
                    flits_teleport(actor,TeleportNumber,1, a_s, teleported[TeleportNumber])
                end
            else
                if m_teleported[actorId]==nil then
                    count=count+1
                    --Media.DisplayMessage("Count: "..number.." Actor: "..actorId.." is NOT idle.","Mission",HSLColor.Blue);

                    resetter[TeleportNumber] = 10
                    m_teleported[actorId]=a_s
                    --if not (m_TeleportNumber == 7 or m_TeleportNumber == 8) and count==1 then                     
                    --    Media.PlaySound("chrotnk1.aud")
                    --end
                    flits_teleport(actor,TeleportNumber,1, a_s, teleported[TeleportNumber])
                end
            end
        end)

        --TeleportCount[TeleportNumber]=tablelength(m_teleported)
        --if (TeleportCount[TeleportNumber]>0) then
        if (resetter[TeleportNumber]>0) then
            --if not number_time[TeleportNumber]==4 then
            --    --Media.DisplayMessage("Teleporter: "..TeleportNumber.."  Active: "..resetter[TeleportNumber],"Mission",HSLColor.Blue);
            --    --Media.DisplayMessage("Teleporter "..TeleportNumber.."  Active","Mission",HSLColor.Blue);
            --end
            --Media.DisplayMessage("TeleportCount: "..TeleportCount[TeleportNumber],"Mission",HSLColor.Blue);

            --Utils.Do(teleported,function(MyId)
            --    Media.DisplayMessage("Teleporting list: ID: "..MyId,"Mission",HSLColor.Blue);
            --end)

            number_time[TeleportNumber]=0.2
            resetter[TeleportNumber] = resetter[TeleportNumber] - 1

            --Media.DisplayMessage("Teleporter: "..TeleportNumber.."  Resetter: "..resetter[TeleportNumber],"Mission",HSLColor.Blue);

            if (resetter[TeleportNumber] <= 0) then
                --m_TeleportCount = TeleportCount[TeleportNumber]

                --if not number_time[TeleportNumber]==4 then
                --    Media.DisplayMessage("Teleporter1: "..TeleportNumber.."  Slow on: resetter: "..resetter[TeleportNumber].."  number_time: "..number_time[TeleportNumber],"Mission",HSLColor.Blue);
                    --Media.DisplayMessage("Teleporter "..TeleportNumber.."  Slow on","Mission",HSLColor.Blue);
                --end
                --TeleportCount[TeleportNumber]=0
                --m_teleported={}
                teleported[TeleportNumber]={}

                --number_time[TeleportNumber]=4
                --resetter[TeleportNumber] = 10
            end
        else
            --if number_time[TeleportNumber]~=5 then
            --    Media.DisplayMessage("Teleporter "..TeleportNumber.." Rest...","Mission",HSLColor.Blue);
            --end
            --if not number_time[TeleportNumber]==4 then
            --    Media.DisplayMessage("Teleporter2: "..TeleportNumber.."  Slow on: resetter: "..resetter[TeleportNumber].."  number_time: "..number_time[TeleportNumber],"Mission",HSLColor.Blue);
            --end
            number_time[TeleportNumber]=4
        end


        Trigger.AfterDelay(DateTime.Seconds(number_time[TeleportNumber]),function()
            check_teleport(TeleportNumber)
        end)

    end

    
    REVERSE=function(in_time)
        Media.DisplayMessage("Reversing direction in "..in_time.." seconds.","Mission",HSLColor.Yellow);
        Trigger.AfterDelay(DateTime.Seconds(in_time-30),function()
            Media.DisplayMessage("Reversing direction in 30 seconds.","Mission",HSLColor.Yellow);
            Trigger.AfterDelay(DateTime.Seconds(25),function()
                Media.DisplayMessage("Reversing direction in 5 seconds.","Mission",HSLColor.Yellow);
                Trigger.AfterDelay(DateTime.Seconds(5),function()
                    Media.DisplayMessage("Reversing direction for 45 seconds.","Mission",HSLColor.Yellow);
                    REVERSE_DIRECTION()
                end)
            end)
        end)
    end

    REVERSE_DIRECTION=function()
        if REVERSED_ON == 0 then
            REVERSED_ON=1
            Trigger.AfterDelay(DateTime.Seconds(40),function()
                Media.DisplayMessage("Returning normal direction in 5 seconds.","Mission",HSLColor.Yellow);
                Trigger.AfterDelay(DateTime.Seconds(5),function()
                    REVERSE_DIRECTION()
                end)
            end)
        else 
            Media.DisplayMessage("Returning normal direction.","Mission",HSLColor.Yellow);
            REVERSED_ON=0
            Trigger.AfterDelay(DateTime.Seconds(210),function()
                REVERSE(90)
            end)
        end
    end

    Trigger.AfterDelay(DateTime.Seconds(1),function()
        check_teleport()
    end)

    REVERSED_ON=0
    REVERSE(300)
end


Tick = function()
end

