--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

MCVReinforcements = { "amcv" }
InfantryReinforcements = { "n1", "n1", "n1" }
VehicleReinforcements = { "hmmv" }
NodPatrol = { "n1", "n1" }
GDIBaseBuildings = { "pyle", "afac", "nuke" }

SendNodPatrol = function()
	Reinforcements.Reinforce(Nod, NodPatrol, { nod0.Location, nod1.Location }, 15, function(soldier)
		soldier.AttackMove(nod2.Location)
		soldier.AttackMove(nod3.Location)
		IdleHunt(soldier)
	end)
end

Reinforce = function(units)
	local ReinArrivalPath = { lstStart.Location, lstEnd.Location }
	local ReinExitPath = { lstStart.Location }
	Media.PlaySpeechNotification(GDI, "Reinforce")
	DoNavalTransportDrop(DummyGuy, ReinArrivalPath, ReinExitPath, "lst.init", units, function(a)
		--a.Move(lstEnd.Location)
	end)
	--ReinforceWithLandingCraft(GDI, units, lstStart.Location, lstEnd.Location, reinforcementsTarget.Location)
end

ReinforceMCV = function()
	local ReinArrivalPath = { lstStart.Location + CVec.New(2, 0), lstEnd.Location + CVec.New(2, 0) }
	local ReinExitPath = { lstStart.Location + CVec.New(2, 0) }
	Media.PlaySpeechNotification(GDI, "Reinforce")
	DoNavalTransportDropCustom(DummyGuy, ReinArrivalPath, ReinExitPath, "lst.init", MCVReinforcements, function(a)end)
	--ReinforceWithLandingCraft(GDI, units, lstStart.Location, lstEnd.Location, reinforcementsTarget.Location)
end

DoNavalTransportDropCustom = function(player, entryPath, exitPath, transportType, units, unitFunc)
	local initialtransport = Reinforcements.ReinforceWithTransport(player, transportType, units, entryPath, exitPath)
	local cargo = initialtransport[2]
	local carrier = initialtransport[1]
	carrier.UnloadPassenger()
	Utils.Do(MCVPlayers,function(PID)
		local ExtraMCV = Actor.Create("amcv", false, { Owner = PID })
		carrier.LoadPassenger(ExtraMCV)
		Trigger.OnAddedToWorld(ExtraMCV, function(self)
			self.Move(mcvTarget.Location)
		end)
	end)
end

WorldLoaded = function()
	GDI = Player.GetPlayer("GDI")
	Nod = Player.GetPlayer("Nod")
	
	DummyGuy = Player.GetPlayer("DummyGuy")
	coopInfo =
	{
		FMVExtra = "intro2.vqa",
		FMVBriefing = "gdi1.vqa",
		FMVOpening = "landing.vqa",
		Mainplayer = GDI,
		MainEnemies = {Nod},
		Dummyplayer = DummyGuy
	}
	
	ORAMod = "ca"
	SplitOwnerBlacklist = {"pt2"}
	CoopInit25(coopInfo)
	
	Utils.Do(CoopPlayers,function(PID)
		PID.Cash = 5000
	end)
	BoatManager()
	InitObjectives(GDI)

	SecureAreaObjective = GDI.AddPrimaryObjective("Eliminate all Nod forces in the area.")
	BeachheadObjective = GDI.AddSecondaryObjective("Establish a beachhead.")

	--[[DoNavalTransportDrop(GDI, lstStart.Location + CVec.New(2, 0), lstEnd.Location + CVec.New(2, 0), "lst.init", MCVReinforcements, function(a)
		a.Move(mcvTarget.Location)
	end)]]
	--ReinforceWithLandingCraft(GDI, MCVReinforcements, lstStart.Location + CVec.New(2, 0), lstEnd.Location + CVec.New(2, 0), mcvTarget.Location)
	ReinforceMCV()
	Reinforce(InfantryReinforcements)

	SendNodPatrol()

	Trigger.AfterDelay(DateTime.Seconds(10), function() Reinforce(InfantryReinforcements) end)
	Trigger.AfterDelay(DateTime.Seconds(60), function() Reinforce(VehicleReinforcements) end)
end

BoatManager = function()
	--Gunboat.Patrol({BoatPatrol1.Location,BoatPatrol2.Location},true,0) --Patrol does work, but the Boat Stops to attack, so I try to mimic the original uninterrupted Movement
	Gunboat.Move(BoatPatrol1.Location)
	Trigger.OnDamaged(Gunboat,function(self, attacker) --This keeps the boat alive, despite the balance differences
		if attacker.Owner == Nod then
			Gunboat.Health = Gunboat.MaxHealth
		end
	end)
	Trigger.OnEnteredFootprint({BoatPatrol1.Location}, function(a, id)
		if a == Gunboat then
			a.Move(BoatPatrol2.Location)
		end
	end)
	Trigger.OnEnteredFootprint({BoatPatrol2.Location}, function(a, id)
		if a == Gunboat then
			a.Move(BoatPatrol1.Location)
		end
	end)
end
Tick = function()
	if Nod.HasNoRequiredUnits() then
		GDI.MarkCompletedObjective(SecureAreaObjective)
	end

	if DateTime.GameTime > DateTime.Seconds(5) and CoopTeamHasNoRequiredUnits() then
		GDI.MarkFailedObjective(BeachheadObjective)
		GDI.MarkFailedObjective(SecureAreaObjective)
	end

	if DateTime.GameTime % DateTime.Seconds(1) == 0 and not GDI.IsObjectiveCompleted(BeachheadObjective) and CheckForBase(GDI, GDIBaseBuildings) then
		GDI.MarkCompletedObjective(BeachheadObjective)
	end
end

CheckForBase = function(player, buildingTypes)
	local OverallCount = 0

	Utils.Do(buildingTypes, function(name)
		local count = 0
		Utils.Do(CoopPlayers,function(PID)
			if #PID.GetActorsByType(name) > 0 then
				count = count + 1
			end
		end)
		if count > 0 then
			OverallCount = OverallCount + 1
		end
	end)

	return OverallCount == #buildingTypes
end