Firstplantblown = false
Enteredbunker = false

if Difficulty == "easy" then
	BlowupMin = 60*5
	BlowupMax = 60*7
end
if Difficulty == "normal" then
	BlowupMin = 60*2
	BlowupMax = 60*5
end
if Difficulty == "hard" then
	BlowupMin = 60*1
	BlowupMax = 60*2
end

BlowUpPower = function()
	if #Plants > 0 then	
		RNG = Utils.RandomInteger(1, #Plants)
		if Firstplantblown == false then
			RNG = Utils.RandomInteger(1, 4)
			Firstplantblown = true
		end
		if Plants[RNG].IsInWorld == true then
			Media.PlaySound("present.aud")
			Beacon.New(USSR,Plants[RNG].CenterPosition,20,true)
			Plants[RNG].Kill()
		end
		if Plants[RNG].IsInWorld == false then
			table.remove(Plants, RNG)
			BlowUpPower()
		end
	end
end

BlowUpDefences = function()
	if #Defences > 0 then	
		RNG = Utils.RandomInteger(1, #Defences)
		if Defences[RNG].IsInWorld == true then
			Media.PlaySound("present.aud")
			Beacon.New(USSR,Defences[RNG].CenterPosition,20,true)
			Defences[RNG].Kill()
		end
		if Defences[RNG].IsInWorld == false then
			table.remove(Defences, RNG)
			BlowUpDefences()
		end
	end
end

BlowUpRandom = function()
	if Saboteur.IsDead == false then
		if #Randombuilding > 0 then	
			RNG = Utils.RandomInteger(1, #Randombuilding)
			if Randombuilding[RNG].IsInWorld == true then
				Media.PlaySound("present.aud")
				Beacon.New(USSR,Randombuilding[RNG].CenterPosition,20,true)
				Randombuilding[RNG].Kill()
				if Randombuilding[RNG].Type == "proc" and Difficulty ~= "hard" then
					for i, UID in ipairs(Randombuilding) do
						if UID.Type == "proc" then
							table.remove(Randombuilding, i)
						end
					end
				end
				Randomtime = Utils.RandomInteger(BlowupMin, BlowupMax)
				Trigger.AfterDelay(DateTime.Seconds(Randomtime), function()
					BlowUpRandom()
				end)
			end
			if Randombuilding[RNG].IsInWorld == false then
				table.remove(Randombuilding, RNG)
				BlowUpRandom()
			end
		end
	end
end

Introsequence = function ()
	Plants = USSR.GetActorsByTypes({"apwr"})
	Defences = USSR.GetActorsByTypes({"tsla","ftur","sam"})
	Randombuilding = USSR.GetActorsByTypes({"tsla","ftur","sam","apwr","silo","proc","fix"})
	camera1 = Actor.Create("camera", true, { Owner = USSR, Location = waypoint0.Location })
	Saboteur.Move(waypoint1.Location)
	Trigger.AfterDelay(DateTime.Seconds(3), function()
		Media.PlaySound("present.aud")
	end)
	Trigger.OnKilled(BridgeBarrel1, function()
		Utils.Do(Player.GetPlayer("Neutral").GetActorsByType("bridge1"), function(actor)	
			actor.Kill()
		end)
	end)
	Trigger.OnEnteredProximityTrigger(waypoint1.CenterPosition, WDist.FromCells(1), function(actor, id)
		if Difficulty == "normal" then
			Utils.Do(USSR.GetActorsByTypes({"dome"}),function()
				table.insert(Randombuilding, UID)
			end)
		end
		if Difficulty == "hard" then
			Utils.Do(USSR.GetActorsByTypes({"dome","barr","barr","kenn","weap","spen"}),function()
				table.insert(Randombuilding, UID)
			end)
		end
		if actor.Type==Saboteur.Type then
			Trigger.RemoveProximityTrigger(id)
			if BridgeBarrel1.IsDead == false then
				BridgeBarrel1.Health = 0
			end
			
			Trigger.AfterDelay(DateTime.Seconds(1), function()
				if Actor153.IsInWorld == true then
					Actor153.Kill()
				end
				Conyards = USSR.GetActorsByTypes({"mcv","fact"})
				for i,UID in pairs (Conyards) do
					UID.Kill()
				end
			end)
			Trigger.AfterDelay(DateTime.Seconds(3), function()
				if Saboteur.IsDead == false then
					Saboteur.Move(waypoint3.Location)
					Trigger.AfterDelay(DateTime.Seconds(1), function()
					camera1.Destroy()
					end)
				end
			end)
		end
	end)
	Trigger.OnEnteredProximityTrigger(waypoint3.CenterPosition, WDist.FromCells(2), function(actor, id)
		if actor.Type==Saboteur.Type then
			Trigger.RemoveProximityTrigger(id)
			flare2 = Actor.Create("flare", true, { Owner = BadGuy, Location = waypoint15.Location })
			--camera2 = Actor.Create("camera", true, { Owner = USSR, Location = Landerexit.Location })
			--camera3 = Actor.Create("camera", true, { Owner = USSR, Location = waypoint9.Location })
			--camera4 = Actor.Create("camera", true, { Owner = USSR, Location = waypoint11.Location })
			--camera5 = Actor.Create("camera", true, { Owner = USSR, Location = waypoint21.Location })
			Trigger.AfterDelay(DateTime.Seconds(2), function()
				if Saboteur.IsDead == false then
					BlowUpPower()
				end
			end)
			Trigger.AfterDelay(DateTime.Seconds(60), function()
				BlowUpDefences()
			end)
		end
	end)
	Trigger.OnEnteredProximityTrigger(waypoint3.CenterPosition, WDist.FromCells(20), function(actor, id)
		if IsOwnedByCoopPlayer(actor) and actor.Type ~= "flare" and actor.Type ~= "camera" and Saboteur.IsDead == false and Lander.IsDead == false then
			flare2.Destroy()
			Trigger.RemoveProximityTrigger(id)
			Lander.Move(waypoint4.Location)
			Saboteur.EnterTransport(Lander)
		end
	end)
	Trigger.OnPassengerEntered(Lander, function(Lander, Cargo)
		Lander.Move(Landerexit.Location)
		Trigger.OnEnteredProximityTrigger(Landerexit.CenterPosition, WDist.FromCells(1), function(actor, id)
			if actor == Lander then
				Trigger.RemoveProximityTrigger(id)
				Lander.IsInWorld = false
				Lander.Teleport(waypoint9.Location)
				Lander.IsInWorld = true
				Lander.UnloadPassengers(waypoint11.Location,5)
				--Lander.Move(waypoint11.Location)
			end
		end)
	end)
	Trigger.OnPassengerExited(Lander, function(Lander, Cargo)
		flare3 = Actor.Create("flare", true, { Owner = BadGuy, Location = waypoint94.Location })
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Saboteur.Move(waypoint25.Location)
			Landed = true
		end)
	end)
	Trigger.OnEnteredProximityTrigger(waypoint25.CenterPosition, WDist.FromCells(25), function(actor, id)
		if IsOwnedByCoopPlayer(actor) and actor.Type ~= "flare" and actor.Type ~= "camera" and Saboteur.IsDead == false then
			Northeastreached = true
			Trigger.RemoveProximityTrigger(id)
		end
	end)
	Trigger.OnEnteredProximityTrigger(waypoint23.CenterPosition, WDist.FromCells(2), function(actor, id)
		if actor.Type==Saboteur.Type then
			Trigger.RemoveProximityTrigger(id)
			flare4 = Actor.Create("flare", true, { Owner = BadGuy, Location = waypoint22.Location })
		end
	end)
	Trigger.OnPassengerEntered(Techcen, function(TC, Cargo)
		if Cargo.Type==Saboteur.Type then
			Enteredbunker = true
			Media.PlaySpeechNotification(All, "ObjectiveNotMet")
			USSR.MarkFailedObjective(KillSaboBeforeHide)
		end
	end)
end

WorldLoaded = function()
	USSR = Player.GetPlayer("USSR")
	Greece = Player.GetPlayer("Greece")
	GoodGuy = Player.GetPlayer("GoodGuy")
	Sabo = Player.GetPlayer("Sabo")
	Spain = Player.GetPlayer("Spain")
	Neutral = Player.GetPlayer("Neutral")
	BadGuy = Player.GetPlayer("BadGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	
	coopInfo =
	{
		Mainplayer = USSR,
		MainEnemies = {GoodGuy, Greece},
		Dummyplayer = BadGuy
	}
	
	CoopInit25(coopInfo)
	
	--Override Sharing options
	BaseShared = true
	TechShared = true
	MoneyShareOverride = 100
	GiveRadar()
	
	Greece.Cash = 1000
	GoodGuy.Cash = 1000
	
	ForCom.Owner = BadGuy

	Mimicfixes = {}
	Teammoney = USSR.Cash
	for i, PID in pairs (CoopPlayers) do
		PID.Cash = Teammoney/#CoopPlayers
	end
	
	Camera.Position = DefaultCameraPosition.CenterPosition

	InitObjectives(USSR)
	
	Sabosurvive = AddPrimaryObjective(Sabo, "survive")
	ProtectComcen = AddPrimaryObjective(USSR, "protect-command-center")
	DefeatAllies = AddPrimaryObjective(USSR, "defeat-allied-forces")
	KillSaboteur = AddPrimaryObjective(USSR, "Eliminate the Saboteur.")
	KillSaboBeforeBlow = AddSecondaryObjective(USSR, "Kill him before all Bombs detonate.")
	KillSaboBeforeHide = AddSecondaryObjective(USSR, "Prevent him from hiding.")
	
	Trigger.OnKilled(Saboteur, function()
		Media.PlaySpeechNotification(All, "ObjectiveMet")
		USSR.MarkCompletedObjective(KillSaboteur)
		if #Randombuilding > 0 then
			USSR.MarkCompletedObjective(KillSaboBeforeBlow)
		end
		if #Randombuilding == 0 then
			USSR.MarkFailedObjective(KillSaboBeforeBlow)
		end
		if Enteredbunker == false then
			USSR.MarkCompletedObjective(KillSaboBeforeHide)
		end
	end)
	
	Trigger.OnKilled(ForCom, function()
		Media.PlaySpeechNotification(All, "ObjectiveNotMet")
		USSR.MarkFailedObjective(ProtectComcen)
	end)
	Introsequence()
	Randomtime = Utils.RandomInteger(BlowupMin, BlowupMax)
	Trigger.AfterDelay(DateTime.Seconds(Randomtime), function()
		BlowUpRandom()
	end)
end

Tick = function()
	if Landed == true and Northeastreached == true and Saboteur.IsDead == false then
		Landed = false
		flare3.Destroy()
		if Techcen.IsDead == false then
			Saboteur.EnterTransport(Techcen)
		else
			Saboteur.Move(waypoint22.Location)
		end
	end
	if Greece.HasNoRequiredUnits() and GoodGuy.HasNoRequiredUnits() and Sabo.HasNoRequiredUnits() and not USSR.IsObjectiveCompleted(ProtectComcen) and USSR.IsObjectiveCompleted(KillSaboteur) then
		Media.PlaySpeechNotification(All, "ObjectiveMet")
		USSR.MarkCompletedObjective(DefeatAllies)
		USSR.MarkCompletedObjective(ProtectComcen)
	end
	Utils.Do(CoopPlayers,function(PID)
		if PID ~= USSR then
			local ownedRefs = #PID.GetActorsByType("proc")
			if ownedRefs == 0 then
				Utils.Do(PID.GetActorsByType("harv"),function(UID)
					UID.Owner = USSR
				end)
			end
		end
	end)
end

GiveRadar = function()
	if not USSRdome.IsDead and USSRdome.Owner == USSR and USSR.PowerState ~= "Critical" then
		Utils.Do(CoopPlayers, function(PID)
			if PID ~= USSR and #PID.GetActorsByType("proxydome") == 0 then
				Actor.Create("proxydome", true, { Owner = PID, Location = CPos.New(0, 0) })
			end
		end)
	else
		Utils.Do(CoopPlayers, function(PID)
			Utils.Do(PID.GetActorsByType("proxydome"), function(UID)
				UID.Destroy()
			end)
		end)
	end
	Trigger.AfterDelay(5, function()
		GiveRadar()
	end)
end