--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]
OpeningAttack = { StartV2, StartTeam1, StartTeam2, StartTeam3 }
MCVTeam = { "mcv", "2tnk", "2tnk" }

Setup = function()
	Utils.Do(USSR.GetGroundAttackers(), function(unit)
		Trigger.OnDamaged(unit, function() IdleHunt(unit) end)
	end)

	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.PlaySpeechNotification(All, "ReinforcementsArrived")
		Reinforcements.Reinforce(GoodGuy, { "jeep", "jeep" }, { AlliedReinforcementPoint.Location, DefaultCameraPosition.Location })
		Utils.Do(OpeningAttack, function(a)
			if not a.IsDead then
				a.AttackMove(DefaultCameraPosition.Location)
			end
		end)
	end)

	Trigger.AfterDelay(DateTime.Seconds(10), function()
		Reinforcements.Reinforce(GoodGuy, { "spy", "e1", "e1", "e1", "e3", "e3", "e3" }, { AlliedReinforcementPoint.Location, DefaultCameraPosition.Location })
	end)

	Trigger.AfterDelay(DateTime.Seconds(15), function()
		Reinforcements.Reinforce(GoodGuy, MCVTeam, { AlliedReinforcementPoint.Location, DefaultCameraPosition.Location })
	end)

	Trigger.OnKilled(MoneyBarrel, function()
		Actor.Create("moneycrate", true, { Owner = Allies, Location = MoneyBarrel.Location })
	end)
end

Tick = function()
	USSR.Cash = 50000
	BadGuy.Cash = 50000

	if DateTime.GameTime > DateTime.Seconds(5) and CoopTeamHasNoRequiredUnits() then
		USSR.MarkCompletedObjective(SovietObj)
	end

	if USSR.HasNoRequiredUnits() and BadGuy.HasNoRequiredUnits() then
		Allies.MarkCompletedObjective(DestroyAll)
	end
	
	Utils.Do(GoodGuy.GetActorsByType("mcv"), function(UID)
		local CurrentPlayer = CoopPlayers[MCVCount]
		UID.Owner = CurrentPlayer
		MCVCount = MCVCount + 1
		if MCVCount > #CoopPlayers then
			MCVCount = 1
		end
	end)
end

WorldLoaded = function()
	Allies = Player.GetPlayer("Allies")
	USSR = Player.GetPlayer("USSR")
	BadGuy = Player.GetPlayer("BadGuy")
	GoodGuy = Player.GetPlayer("GoodGuy")
	
	coopInfo =
	{
		Mainplayer = Allies,
		MainEnemies = {USSR, BadGuy},
		Dummyplayer = Player.GetPlayer("GoodGuy")
	}
	
	CoopInit25(coopInfo)
	
	MCVCount = 2
	if #CoopPlayers == 1 then
		MCVCount = 1
	end
	
	Utils.Do(MCVPlayers, function(PID)
		if PID ~= CoopPlayers[1] and PID ~= CoopPlayers[2] then
			table.insert(MCVTeam, 1, "mcv")
		end
	end)

	InitObjectives(Allies)

	SovietObj = AddPrimaryObjective(USSR, "")
	DestroyAll = AddPrimaryObjective(Allies, "destroy-soviet-units-infrastructure")

	Camera.Position = DefaultCameraPosition.CenterPosition
	PowerProxy = Actor.Create("paratroopers", false, { Owner = BadGuy })
	Setup()
	ActivateAI()
end
