--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]
Jeeps = { Jeep1, Jeep2 }
StarterMCVs = {}
JeepWaypoints = { JeepWaypoint1.Location, JeepWaypoint2.Location }
OreAttackers = { OreAttack1, OreAttack2, OreAttack3, OreAttack4, OreAttack5, OreAttack6, OreAttack7, OreAttack8 }
RadarSites = { Radar1, Radar2, Radar3, Radar4 }
StartAttack = { StartAttack1, StartAttack2, StartAttack3, StartAttack4, StartAttack5 }
ChronoDemolitionTrigger = { CPos.New(35,96), CPos.New(36,96), CPos.New(37,96), CPos.New(37,97), CPos.New(38,97), CPos.New(39,97) }
OreAttackTrigger = { CPos.New(105,67), CPos.New(106,67), CPos.New(107,67), CPos.New(108,67), CPos.New(109,67), CPos.New(110,67) }

Start = function()
	Reinforcements.Reinforce(BadGuy, StarterMCVs, { MCVEntry.Location, DefaultCameraPosition.Location }, 5)

	Utils.Do(Jeeps, function(jeep)
		jeep.Patrol(JeepWaypoints, true, 125)
	end)

	Utils.Do(StartAttack, function(a)
		IdleHunt(a)
	end)

	ChronoCam = Actor.Create("camera", true, { Owner = USSR, Location = Chronosphere.Location})
end

MissionTriggers = function()
	Trigger.OnAllKilledOrCaptured(RadarSites, function()
		for _, PID in ipairs(CoopPlayers) do
			PID.MarkCompletedObjective(TakeDownRadar)
		end
		ChronoshiftAlliedUnits()
	end)

	Trigger.OnCapture(Chronosphere, function()
		if not USSR.IsObjectiveCompleted(TakeDownRadar) then
			Media.DisplayMessage(UserInterface.GetFluentMessage("chrono-trap-triggered"), UserInterface.GetFluentMessage("headquarters"))
			Chronosphere.Kill()
		else
			for _, PID in ipairs(MCVPlayers) do
				PID.MarkCompletedObjective(CaptureChronosphere)
			end
		end
	end)

	Trigger.OnKilled(Chronosphere, function()
		for _, PID in ipairs(MCVPlayers) do
			PID.MarkFailedObjective(CaptureChronosphere)
		end
	end)

	local chronoTriggered
	Trigger.OnEnteredFootprint(ChronoDemolitionTrigger, function(actor, id)
		for _, PID in ipairs(MCVPlayers) do
		if actor.Owner == PID and not chronoTriggered and not USSR.IsObjectiveCompleted(TakeDownRadar) then
			Trigger.RemoveFootprintTrigger(id)
			chronoTriggered = true
			Media.DisplayMessage(UserInterface.GetFluentMessage("chrono-trap-triggered"), UserInterface.GetFluentMessage("headquarters"))
			Chronosphere.Kill()
		end
		end
	end)

	Trigger.OnEnteredProximityTrigger(ChinookLZ.CenterPosition, WDist.FromCells(5), function(actor, id)
		for _, PID in ipairs(MCVPlayers) do
		if actor.Owner == PID and actor.Type == "harv" then
			Trigger.RemoveProximityTrigger(id)
			SendChinook()
		end
		end
	end)

	local oreAttackTriggered
	Trigger.OnEnteredFootprint(OreAttackTrigger, function(actor, id)
		for _, PID in ipairs(MCVPlayers) do
		if actor.Owner == PID and not oreAttackTriggered then
			Trigger.RemoveFootprintTrigger(id)
			oreAttackTriggered = true

			Utils.Do(OreAttackers, function(a)
				if not a.IsDead then
					IdleHunt(a)
				end
			end)
		end
		end
	end)
end

ChronoshiftAlliedUnits = function()
	if Chronosphere.IsDead then
		return
	end

	local cells = Utils.ExpandFootprint({ ChronoshiftPoint.Location }, false)
	local units = { }
	for i = 1, #cells do
		local unit = Actor.Create("2tnk", true, { Owner = Greece, Facing = Angle.North })
		units[unit] = cells[i]
		IdleHunt(unit)
	end
	Chronosphere.Chronoshift(units)
end

Tick = function()
	Greece.Cash = 20000
	
	if DateTime.GameTime > DateTime.Seconds(10) then
		Lostcount = 0
		for _, PID in ipairs(CoopPlayers) do
			if PID.HasNoRequiredUnits() then
				Lostcount = Lostcount + 1
			end
		end
		
		if Lostcount >= #CoopPlayers then
			Greece.MarkCompletedObjective(AlliesObjective)
		end
	end
	
	for _, UID in ipairs(Dummyplayer.GetActorsByType("mcv")) do
		CurrentPlayer = CoopPlayers[MCVCount]
		UID.Owner = CurrentPlayer
		MCVCount = MCVCount + 1
		if MCVCount > #CoopPlayers then
			MCVCount = 1
		end
	end
end

WorldLoaded = function()
	USSR = Player.GetPlayer("USSR")
	Greece = Player.GetPlayer("Greece")
	GoodGuy = Player.GetPlayer("GoodGuy")
	
	--Mission specific Information for the Coop Base Script
	FMVBriefing = "soviet13.vqa"
	FMVOpening = "mtnkfact.vqa"
	Enemyplayer = Greece
	Enemyplayer2 = GoodGuy
	Mainplayer = USSR
	Dummyplayer = Player.GetPlayer("BadGuy")
	--
	
	CoopInit()
	
	MCVCount = 1
	for _, PID in ipairs(MCVPlayers) do
		table.insert(StarterMCVs, "mcv")
	end
	
	InitObjectives(USSR)

	AlliesObjective = AddPrimaryObjective(Greece, "")
	TakeDownRadar = AddPrimaryObjective(USSR, "destroy-allied-radar-sites")
	CaptureChronosphere = AddPrimaryObjective(USSR, "capture-the-chronosphere")

	Camera.Position = DefaultCameraPosition.CenterPosition
	Start()
	MissionTriggers()
	ActivateAI()
	GreeceWarFactory.RallyPoint = WarFactoryRally.Location
	if Difficulty == "hard" then
		V2A.Destroy()
		V2B.Destroy()
	end
end
