HarkonnenBase = { HarkonnenOutpost, HarkonnenRefinery, HarkonnenHeavyFact, HarkonnenTurret1, HarkonnenTurret2, HarkonnenBarracks, HarkonnenSilo1, HarkonnenSilo2, HarkonnenWindTrap1, HarkonnenWindTrap2, HarkonnenWindTrap3, HarkonnenWindTrap4, HarkonnenWindTrap5 }
SmugglerBase = { STurret1, STurret2 }

HarkonnenReinforcements =
{
	easy =
	{
		{ "combat_tank_h", "light_inf", "light_inf", "light_inf", "trooper" },
		{ "light_inf", "light_inf", "light_inf_level4", "light_inf_level2", "trooper" },
		{ "trike", "light_inf", "light_inf", "light_inf_level2", "trooper" },
		{ "combat_tank_h", "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper" },
		{ "combat_tank_h", "light_inf", "light_inf", "trooper" }
	},

	normal =
	{
		{ "combat_tank_h", "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper" },
		{ "light_inf", "light_inf", "light_inf_level4", "light_inf_level2", "trooper", "trooper"  },
		{ "combat_tank_h", "light_inf", "light_inf", "trooper", "trooper", "trooper" },
		{ "combat_tank_h", "light_inf", "sardaukar", "light_inf", "trooper", "trooper" },
		{ "trike", "light_inf", "light_inf", "light_inf_level2", "light_inf_level2", "light_inf_level4", "trooper" },
		{ "combat_tank_h", "combat_tank_h", "trike", "combat_tank_h", "light_inf", "trooper", "trooper" },
	},

	hard =
	{
		{ "combat_tank_h", "trike", "light_inf", "light_inf", "light_inf_level4", "trooper", "trooper" },
		{ "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper" },
		{ "combat_tank_h", "combat_tank_h", "light_inf", "light_inf", "light_inf_level2", "light_inf_level2", "light_inf_level4", "trooper", "trooper" },
		{ "combat_tank_h", "light_inf", "sardaukar", "light_inf", "trooper", "trooper" },
		{ "combat_tank_h", "combat_tank_h", "light_inf", "light_inf", "trooper", "trooper", "light_inf_level4", "light_inf_level2", "light_inf_level2" },
		{ "combat_tank_h", "combat_tank_h", "light_inf", "light_inf", "sardaukar", "trooper", "trooper", "sardaukar", "sardaukar" },
		{ "combat_tank_h", "combat_tank_h", "combat_tank_h", "combat_tank_h", "sardaukar", "sardaukar", "sardaukar" },
		{ "light_inf", "light_inf", "light_inf_level1", "trooper_level1", "trooper", "trooper", "sardaukar", "sardaukar", "sardaukar" },
		{ "light_inf", "light_inf_level1", "light_inf", "light_inf", "light_inf_level1", "combat_tank_h", "sardaukar", "sardaukar", "sardaukar" },
		{ "light_inf_level1", "light_inf_level1", "light_inf_level1", "light_inf_level1", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar" },
	}
}

HarkonnenAttackDelay =
{
	easy = DateTime.Minutes(5),
	normal = DateTime.Minutes(4),
	hard = DateTime.Minutes(3)
}

HarkonnenAttackWaves =
{
	easy = 5,
	normal = 6,
	hard = 10
}

InitialHarkonnenReinforcements = { "light_inf", "light_inf", "light_inf", "light_inf", "trooper", "trooper", "combat_tank_h" }

HarkonnenPaths =
{
	{ HarkonnenEntry1.Location, HarkonnenRally3.Location },
	{ HarkonnenEntry2.Location, HarkonnenRally4.Location },
	{ HarkonnenEntry3.Location, HarkonnenRally2.Location },
	{ HarkonnenEntry4.Location, HarkonnenRally1.Location },
}

AtreidesReinforcements =
{
	{ "trike", "trike", "quad" },
	{ "light_inf", "light_inf", "light_inf", "light_inf", "engineer", "trooper", "trooper" }
}
AtreidesPath = { AtreidesEntry.Location, AtreidesRally.Location }

Messages =
{
	"The-Fremens-have-not-enough-troops",
	"Reinforce-the-Fremens-bastion-on-the-northeast"
}

FremenInterval =
{
	easy = { DateTime.Minutes(1) + DateTime.Seconds(30), DateTime.Minutes(2) },
	normal = { DateTime.Minutes(2) + DateTime.Seconds(20), DateTime.Minutes(2) + DateTime.Seconds(40) },
	hard = { DateTime.Minutes(3) + DateTime.Seconds(40), DateTime.Minutes(4) }
}

IntegrityLevel =
{
	easy = 25,
	normal = 50,
	hard = 75
}

FremenProduction = function()
	if Sietch.IsDead then
		return
	end

	local delay = Utils.RandomInteger(FremenInterval[Difficulty][1], FremenInterval[Difficulty][2] + 1)
	Fremen.Build({ "nsfremen" }, function()
		Trigger.AfterDelay(delay, FremenProduction)
	end)
end

AttackNotifier = 0
Tick = function()
	if Atreides.HasNoRequiredUnits() then
		Harkonnen.MarkCompletedObjective(KillAtreides)
	end

	if Harkonnen.HasNoRequiredUnits() and not Atreides.IsObjectiveCompleted(KillHarkonnen) then
		Media.DisplayMessage(UserInterface.GetFluentMessage("harkonnen-annihilated"), Mentat)
		Atreides.MarkCompletedObjective(KillHarkonnen)
		Atreides.MarkCompletedObjective(ProtectFremen)
		Atreides.MarkCompletedObjective(KeepIntegrity)
	end

	if DateTime.GameTime % DateTime.Seconds(10) == 0 and LastHarvesterEaten[Harkonnen] then
		local units = Harkonnen.GetActorsByType("harvester")

		if #units > 0 then
			LastHarvesterEaten[Harkonnen] = false
			ProtectHarvester(units[1], Harkonnen, AttackGroupSize[Difficulty])
		end
	end

	if not Sietch.IsDead then
		AttackNotifier = AttackNotifier - 1
		local integrity = math.floor((Sietch.Health * 100) / Sietch.MaxHealth)
		SiegeIntegrity = UserInterface.GetFluentMessage("sietch-integrity", { ["integrity"] = integrity })
		UserInterface.SetMissionText(SiegeIntegrity, Atreides.Color)

		if integrity < IntegrityLevel[Difficulty] then
			Atreides.MarkFailedObjective(KeepIntegrity)
		end
	end
end

WorldLoaded = function()
	Harkonnen = Player.GetPlayer("Harkonnen")
	Fremen = Player.GetPlayer("Fremen")
	Atreides = Player.GetPlayer("Atreides")
	Smuggler = Player.GetPlayer("Smuggler")

	InitObjectives(Atreides)
	KillAtreides = AddPrimaryObjective(Harkonnen, "")
	ProtectFremen = AddPrimaryObjective(Atreides, "protect-fremen-sietch")
	KillHarkonnen = AddPrimaryObjective(Atreides, "destroy-harkonnen")
	local keepSietchIntact = UserInterface.GetFluentMessage("keep-sietch-intact", { ["integrity"] = IntegrityLevel[Difficulty] })
	KeepIntegrity = AddPrimaryObjective(Atreides, keepSietchIntact)

	Camera.Position = AConyard.CenterPosition

	Trigger.AfterDelay(DateTime.Minutes(4) + DateTime.Seconds(10), function()
		Media.DisplayMessage(Messages[1], Mentat)
	end)

	Trigger.AfterDelay(DateTime.Minutes(5) + DateTime.Seconds(10), function()
		Media.DisplayMessage(Messages[2], Mentat)
	end)

	Trigger.AfterDelay(DateTime.Seconds(2), function()
		Beacon.New(Atreides, Sietch.CenterPosition + WVec.New(0, 1024, 0))
		Media.DisplayMessage(UserInterface.GetFluentMessage("fremen-sietch-southeast"), Mentat)
	end)

	Trigger.OnAllKilledOrCaptured(HarkonnenBase, function()
		Utils.Do(Harkonnen.GetGroundAttackers(), IdleHunt)
	end)

	Trigger.OnKilled(Sietch, function()
		Actor.Create("invisibleBlocker", true, { Owner = Fremen, Location = CPos.New(62, 59) })
		UserInterface.SetMissionText(UserInterface.GetFluentMessage("sietch-destroyed"), Atreides.Color)
		Atreides.MarkFailedObjective(ProtectFremen)
	end)
	Trigger.OnDamaged(Sietch, function()
		if AttackNotifier <= 0 then
			AttackNotifier = DateTime.Seconds(10)
			Beacon.New(Atreides, Sietch.CenterPosition + WVec.New(0, 1024, 0), DateTime.Seconds(7))
			Media.DisplayMessage(UserInterface.GetFluentMessage("fremen-sietch-under-attack"), Mentat)

			local defenders = Fremen.GetGroundAttackers()
			if #defenders > 0 then
				Utils.Do(defenders, function(unit)
					unit.Guard(Sietch)
				end)
			end
		end
	end)

	local path = function() return Utils.Random(HarkonnenPaths) end
	local waveCondition = function() return Atreides.IsObjectiveCompleted(KillHarkonnen) end
	local huntFunction = function(unit)
		unit.AttackMove(HarkonnenAttackLocation)
		IdleHunt(unit)
	end
	
	Trigger.AfterDelay(DateTime.Minutes(2) + DateTime.Seconds(40), function()
		Media.PlaySpeechNotification(Atreides, "Reinforce")
		Reinforcements.Reinforce(Atreides, AtreidesReinforcements[1], AtreidesPath)
	end)
	Trigger.AfterDelay(DateTime.Minutes(5) + DateTime.Seconds(10), function()
		Media.PlaySpeechNotification(Atreides, "Reinforce")
		Reinforcements.Reinforce(Atreides, AtreidesReinforcements[2], AtreidesPath)
	end)

	Trigger.OnEnteredProximityTrigger(HarkonnenRally1.CenterPosition, WDist.New(6 * 1024), function(a, id)
		if a.Owner == Atreides then
			Trigger.RemoveProximityTrigger(id)
			local units = Reinforcements.Reinforce(Harkonnen, { "light_inf", "combat_tank_h", "trike" }, HarkonnenPaths[3])
			Utils.Do(units, IdleHunt)
		end
	end)

	Trigger.OnExitedProximityTrigger(Sietch.CenterPosition, WDist.New(10.5 * 1024), function(a, id)
		if a.Owner == Fremen and not a.IsDead then
			a.AttackMove(FremenRally.Location)
			Trigger.OnIdle(a, function()
				if a.Location.X < 54 or a.Location.Y < 54 then
					a.AttackMove(FremenRally.Location)
				end
			end)
		end
	end)
end
