HarkonnenBase = { HConyard, HPower1, HPower2, HBarracks }
MercenariesBase = { MPower, MLightFactory }

HarkonnenReinforcements =
{
	easy =
	{
		{ "light_inf", "trooper" },
		{ "light_inf", "trooper" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "trooper" }
	},

	normal =
	{
		{ "light_inf", "light_inf_level1" },
		{ "light_inf", "light_inf_level1" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1" },
		{ "light_inf", "light_inf", "trooper" },
		{ "light_inf", "light_inf", "light_inf" },
		{ "light_inf", "light_inf_level1" }
	},

	hard =
	{
		{ "light_inf_level1", "light_inf_level1" },
		{ "light_inf", "light_inf_level1" },
		{ "light_inf", "light_inf_level1" },
		{ "light_inf", "light_inf", "light_inf", "light_inf_level1", "light_inf_level1", "light_inf_level4" },
		{ "light_inf", "light_inf", "trooper_level1" },
		{ "light_inf_level1", "light_inf_level1", "trooper_level1" },
		{ "light_inf", "light_inf", "light_inf_level1" },
		{ "light_inf", "light_inf_level1" },
		{ "light_inf_level1", "light_inf_level1" }
	}
}

HarkonnenAttackPaths =
{
	{ HarkonnenEntry1.Location, HarkonnenRally1.Location },
	{ HarkonnenEntry1.Location, HarkonnenRally3.Location },
	{ HarkonnenEntry2.Location, HarkonnenRally2.Location },
	{ HarkonnenEntry2.Location, HarkonnenRally4.Location }
}

HarkonnenAttackDelay =
{
	easy = DateTime.Minutes(4),
	normal = DateTime.Minutes(3) + DateTime.Seconds(10),
	hard = DateTime.Minutes(2) + DateTime.Seconds(20)
}

HarkonnenAttackWaves =
{
	easy = 4,
	normal = 8,
	hard = 12
}

Tick = function()
	if Atreides.HasNoRequiredUnits() then
		Harkonnen.MarkCompletedObjective(KillAtreides)
	end

	if Harkonnen.HasNoRequiredUnits() and not Atreides.IsObjectiveCompleted(KillHarkonnen) then
		Media.DisplayMessage(UserInterface.GetFluentMessage("harkonnen-annihilated"), Mentat)
		Atreides.MarkCompletedObjective(KillHarkonnen)
	end
end

WorldLoaded = function()
	Harkonnen = Player.GetPlayer("Harkonnen")
	Atreides = Player.GetPlayer("Atreides")
	Mercenaries = Player.GetPlayer("Mercenaries")

	InitObjectives(Atreides)
	KillAtreides = AddPrimaryObjective(Harkonnen, "")
	KillHarkonnen = AddPrimaryObjective(Atreides, "destroy-harkonnen-forces")

	Camera.Position = AConyard.CenterPosition

	Trigger.AfterDelay(DateTime.Minutes(2) + DateTime.Seconds(40), function()
		Media.DisplayMessage(Messages[5], Mentat)
	end)

	Trigger.OnAllKilled(HarkonnenBase, function()
		Utils.Do(Harkonnen.GetGroundAttackers(), IdleHunt)
	end)

	local path = function() return Utils.Random(HarkonnenAttackPaths) end
	SendCarryallReinforcements(Harkonnen, 2, HarkonnenAttackWaves[Difficulty], HarkonnenAttackDelay[Difficulty], path, HarkonnenReinforcements[Difficulty])
	SendCarryallReinforcements(Mercenaries, 1, MercenariesAttackWaves[Difficulty], MercenariesAttackDelay[Difficulty], path, MercenariesReinforcements[Difficulty])
	Trigger.AfterDelay(0, ActivateAI)

	Actor.Create("upgrade.barracks", true, { Owner = Mercenaries })
	Actor.Create("upgrade.barracks", true, { Owner = Harkonnen })
end

	Trigger.AfterDelay(DateTime.Seconds(25), function()
		Media.PlaySpeechNotification(Atreides, "Reinforce")
		Reinforcements.Reinforce(Atreides, AtreidesReinforcements, AtreidesEntryPath)
end)

MercenariesReinforcements =
{
	easy =
	{
		{ "raider" },
		{ "raider", "raider" },
		{ "light_inf", "light_inf", "trooper" }
	},

	normal =
	{
		{ "raider", "raider" },
		{ "raider", "raider", "raider" },
		{ "raider", "raider", "light_inf", "trooper" },
		{ "light_inf", "light_inf", "trooper", "trooper", "light_inf_level4" },
	},

	hard =
	{
		{ "raider", "raider", "raider" },
		{ "raider", "raider", "raider", "raider"  },
		{ "light_inf_level1", "light_inf", "light_inf", "trooper", "trooper", "light_inf_level4" },
		{ "light_inf_level1", "light_inf_level1", "trooper", "raider", "raider" }
	}
}

MercenariesAttackPaths =
{
	{ MercenariesEntry1.Location, MercenariesRally1.Location },
	{ MercenariesEntry1.Location, MercenariesRally2.Location }
}

MercenariesAttackDelay =
{
	easy = DateTime.Minutes(5),
	normal = DateTime.Minutes(4) + DateTime.Seconds(20),
	hard = DateTime.Minutes(3) + DateTime.Seconds(40)
}

MercenariesAttackWaves =
{
	easy = 2,
	normal = 4,
	hard = 7
}

AtreidesReinforcements = { "light_inf", "light_inf","light_inf", "light_inf", "trooper", "trooper", "engineer"  }
AtreidesEntryPath = { AtreidesEntry1.Location, AtreidesRally1.Location }

Messages =
{
	UserInterface.GetFluentMessage("build-concrete"),
	UserInterface.GetFluentMessage("build-windtrap"),
	UserInterface.GetFluentMessage("build-refinery"),
	UserInterface.GetFluentMessage("build-silo"),
	UserInterface.GetFluentMessage("Capture-the-enemy-light-factory")
}

