--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

OrdosMainBase = { OPower1, OPower2, OPower3, OPower4, OPower5, OPower6, OPower7, OPower8, OPower9, OPower10, ORefinery1, ORefinery2, OBarracks1, OLightFactory1, OLightFactory2, OHeavyFactory, OLightFactory3, OBarracks2, OHighTechFactory1, ORepairPad}

OrdosSmallBase = { OStarport }

SmugglersBase = { SPower1, SPower2, SConyard, SBarracks, STurret1}
OrdosReinforcements =
{
	easy =
	{
		{ "light_inf", "light_inf", "trooper", "trooper" },
		{ "combat_tank_o", "combat_tank_o"},
		{ "light_inf", "light_inf", "light_inf", "trooper", "trooper", "trooper" },
		{ "light_inf", "light_inf", "trooper", "trooper" },
		{ "combat_tank_o", "combat_tank_o"},
		{ "light_inf", "light_inf", "light_inf", "trooper", "trooper", "trooper" },
		{ "combat_tank_o", "combat_tank_o"}
	},

	normal =
	{
		{ "light_inf", "light_inf", "light_inf", "trooper", "trooper", "trooper" },
		{ "combat_tank_o", "combat_tank_o", "missile_tank" },
		{ "light_inf", "light_inf", "light_inf", "light_inf", "trooper", "trooper", "trooper", "trooper" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "trooper", "trooper" },
		{ "combat_tank_o", "combat_tank_o", "missile_tank" },
		{ "light_inf", "light_inf", "light_inf", "light_inf", "trooper", "trooper", "trooper", "trooper" },
		{ "combat_tank_o", "combat_tank_o", "missile_tank" },
		{ "light_inf", "light_inf", "light_inf", "light_inf", "trooper", "trooper", "trooper", "trooper" }
	},
	hard =
	{
		{ "light_inf", "light_inf", "light_inf", "trooper", "trooper", "trooper", "light_inf", "trooper" },
		{ "combat_tank_o", "combat_tank_o", "combat_tank_o", "missile_tank" },
		{ "light_inf", "light_inf", "light_inf", "light_inf", "trooper", "trooper", "trooper", "trooper", "light_inf", "trooper" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "trooper", "trooper", "light_inf", "trooper" },
		{ "combat_tank_o", "combat_tank_o", "combat_tank_o", "missile_tank" },
		{ "light_inf", "light_inf", "light_inf", "light_inf", "trooper", "trooper", "trooper", "trooper", "light_inf", "trooper" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "trooper", "trooper", "light_inf", "trooper" },
		{ "combat_tank_o", "combat_tank_o", "combat_tank_o", "missile_tank" },
		{ "light_inf", "light_inf", "light_inf", "light_inf", "trooper", "trooper", "trooper", "trooper", "light_inf", "trooper" }
	}
}

OrdosStarportReinforcements =
{
	easy = {  "combat_tank_o", "combat_tank_o" },
	normal = { "missile_tank", "combat_tank_o", "combat_tank_o" },
	hard = { "missile_tank", "missile_tank", "combat_tank_o", "combat_tank_o", "combat_tank_o" }
}

OrdosReinforcementsDelay =
{
	easy = DateTime.Minutes(3),
	normal = DateTime.Minutes(2) + DateTime.Seconds(20),
	hard = DateTime.Minutes(1)
}

OrodsStarportDelay =
{
	easy = DateTime.Minutes(7),
	normal = DateTime.Minutes(6),
	hard = DateTime.Minutes(5)
}

OrdosAttackWaves =
{
	easy = 7,
	normal = 8,
	hard = 9
}

InitialReinforcementsSquads =
{
	{ "trooper", "trooper", "quad", "quad", "light_inf", "raider" },
	{ "light_inf", "light_inf", "light_inf", "light_inf", "trooper", "trooper", "trooper", "trooper" },
	{"combat_tank_h", "combat_tank_h"}
}

OrdosReinforcementsPaths =
{
	{ Map.ClosestEdgeCell(OrdosReinforcementsPoint1.Location), OrdosReinforcementsPoint1.Location },
	{ Map.ClosestEdgeCell(OrdosReinforcementsPoint2.Location), OrdosReinforcementsPoint2.Location },
	{ Map.ClosestEdgeCell(OrdosReinforcemetsPoint3.Location), OrdosReinforcemetsPoint3.Location }
}

InitialPaths =
{
	{ Map.ClosestEdgeCell(OrdosUnitSpawn.Location), OrdosUnitSpawn.Location },
	{ Map.ClosestEdgeCell(SmugglerUnitSpawn.Location), SmugglerUnitSpawn.Location },
	{ Map.ClosestEdgeCell(OrdosSmallUnitSpawn.Location), OrdosSmallUnitSpawn.Location }
}

AtreidesReinforcements =
{
	easy = { "combat_tank_a", "combat_tank_a", "combat_tank_a", "missile_tank", "combat_tank_a", "missile_tank","missile_tank" },
	normal = { "combat_tank_a", "combat_tank_a", "combat_tank_a", "missile_tank", "missile_tank" },
	hard = { "combat_tank_a", "combat_tank_a", "missile_tank" }
}

AtreidesReinforcementsPatchs = { Map.ClosestEdgeCell(AreidesReinfocementsPoint.Location), AreidesReinfocementsPoint.Location
}
SendStarportReinforcements = function()
	Trigger.AfterDelay(OrodsStarportDelay[Difficulty], function()
		if OStarport.IsDead or OStarport.Owner ~= OrdosSmall then
			return
		end

		local units = Reinforcements.ReinforceWithTransport(OrdosSmall, "frigate", OrdosStarportReinforcements[Difficulty], { Map.ClosestEdgeCell(OStarport.Location), OStarport.Location + CVec.New(1, 1) }, { Map.ClosestEdgeCell(OStarport.Location) })[2]
		Utils.Do(units, function(unit)
			unit.AttackMove(AttackLocation)
			IdleHunt(unit)
		end)

		SendStarportReinforcements()
	end)
end
InitStarportReinforcements = function (delay, squad)
	Trigger.AfterDelay(delay, function()
		if OStarport.IsDead or OStarport.Owner ~= OrdosSmall then
			return
		end

		local units = Reinforcements.ReinforceWithTransport(OrdosSmall, "frigate", squad, { Map.ClosestEdgeCell(OStarport.Location), OStarport.Location + CVec.New(1, 1) }, { Map.ClosestEdgeCell(OStarport.Location) })[2]
		Utils.Do(units, function(unit)
			unit.AttackMove(AttackLocation)
			IdleHunt(unit)
		end)
	end)
end
SendAtreidesReinforcements = function(delay)
	Trigger.AfterDelay(delay, function()
		Reinforcements.ReinforceWithTransport(Atreides, "carryall.reinforce", AtreidesReinforcements[Difficulty], AtreidesReinforcementsPatchs, { AtreidesReinforcementsPatchs[1] })
		Trigger.AfterDelay(DateTime.Seconds(5), function()
			Media.PlaySpeechNotification(Atreides, "Reinforce")
		end)
	end)
end

Tick = function()

	if Atreides.HasNoRequiredUnits() then
		Ordos.MarkCompletedObjective(KillAtreides1)
		OrdosSmall.MarkCompletedObjective(KillAtreides2)
	end

	if Ordos.HasNoRequiredUnits() and OrdosSmall.HasNoRequiredUnits() and not OrdosKilled then
		Media.DisplayMessage(UserInterface.GetFluentMessage("ordos-annihilated"), Mentat)
		OrdosKilled = true
		Atreides.MarkCompletedObjective(KillOrdos)
	end

	if Smugglers.HasNoRequiredUnits() then
		Media.DisplayMessage(UserInterface.GetFluentMessage("smugglers-annihilated"), Mentat)
	end

	if DateTime.GameTime % DateTime.Seconds(10) == 0 and LastHarvesterEaten[Ordos] then
		local units = Ordos.GetActorsByType("harvester")

		if #units > 0 then
			LastHarvesterEaten[Ordos] = false
			ProtectHarvester(units[1], Ordos, AttackGroupSize[Difficulty])
		end
	end


end

WorldLoaded = function()

	Ordos = Player.GetPlayer("Ordos")
	Smugglers = Player.GetPlayer("Smugglers")
	OrdosSmall = Player.GetPlayer("OrdosSmall")
	Atreides = Player.GetPlayer("Atreides")
	Ordos.Cash = 12000
	OrdosSmall.Cash = 5000
	Smugglers.Cash = 3000
	InitObjectives(Atreides)
	KillOrdos = AddPrimaryObjective(Atreides, UserInterface.GetFluentMessage("destroy-ordos"))
	KillAtreides1 = AddPrimaryObjective(Ordos, "")
	KillAtreides2 = AddPrimaryObjective(OrdosSmall, "")

	Camera.Position = AMCV.CenterPosition
	AttackLocation = AMCV.Location

	Trigger.OnAllKilledOrCaptured(OrdosMainBase, function()
		Utils.Do(Ordos.GetGroundAttackers(), IdleHunt)
	end)

	Trigger.OnAllKilledOrCaptured(SmugglersBase, function()
		Utils.Do(Smugglers.GetGroundAttackers(), IdleHunt)
	end)

	Trigger.OnAllKilledOrCaptured(OrdosSmallBase, function()
		Utils.Do(OrdosSmall.GetGroundAttackers(), IdleHunt)
	end)

	local path = function() return Utils.Random(OrdosReinforcementsPaths) end
	local waveCondition = function() return OrdosKilled end
	local huntFunction = function(unit)
		unit.AttackMove(AttackLocation)
		IdleHunt(unit)
	end
	SendCarryallReinforcements(Ordos, 0, OrdosAttackWaves[Difficulty], OrdosReinforcementsDelay[Difficulty], path, OrdosReinforcements[Difficulty], waveCondition, huntFunction)

	SendStarportReinforcements()

	Actor.Create("upgrade.barracks", true, { Owner = Ordos })
	Actor.Create("upgrade.light", true, { Owner = Ordos })
	Actor.Create("upgrade.heavy", true, { Owner = Ordos })
	Actor.Create("upgrade.barracks", true, { Owner = Smugglers })
	Trigger.AfterDelay(0, ActivateAI)

	SendAtreidesReinforcements(DateTime.Minutes(6), AtreidesReinforcements[Difficulty])

end

function AICrushLogic(unit, bot)
	if unit.IsDead then
		return
	end
	if Utils.RandomInteger(0,100) >= CrushChance[Difficulty] then
		Trigger.AfterDelay(200, function ()
			AICrushLogic(unit, bot)
		end)
		return
	end
	local actors = Map.ActorsInCircle(unit.CenterPosition, WDist.FromCells(5), function (a)
		return
		a.IsDead == false and
		a.IsInWorld == true and
		a.Owner.IsAlliedWith(bot) == false
	end)
	local targets = Utils.Where(actors, function(a)
		return
		a.Type == "light_inf" or
		a.Type == "trooper" or
		a.Type == "engineer" and
		Map.TerrainType(a.Location) ~= "Rough"
	end)
	if targets[1] ~= nil then
		unit.Stop()
		unit.Move(Utils.Random(targets).Location)
		Trigger.AfterDelay(55, function ()
			AICrushLogic(unit, bot)
		end)
		IdleHunt(unit)
	else
		Trigger.AfterDelay(200, function ()
			AICrushLogic(unit, bot)
		end)
	end
end