--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

EarlyGameStage = DateTime.Minutes(5)
InitialProductionDelay = {
	OrdosMain =
	{
		easy = DateTime.Seconds(0),
		normal = DateTime.Seconds(0),
		hard = DateTime.Seconds(0)
	},
	Smugglers =
	{
		easy = DateTime.Seconds(0),
		normal = DateTime.Seconds(60),
		hard = DateTime.Seconds(30)
	},
}
AttackGroupSize =
{
	easy = 6,
	normal = 8,
	hard = 10
}

EarlyAttackDelays =
{
	easy = { DateTime.Seconds(7), DateTime.Seconds(10) },
	normal = { DateTime.Seconds(4), DateTime.Seconds(6) },
	hard = { DateTime.Seconds(3), DateTime.Seconds(5) }
}
LateAttackDelays =
{
	easy = { DateTime.Seconds(4), DateTime.Seconds(7) },
	normal = { DateTime.Seconds(2), DateTime.Seconds(5) },
	hard = { DateTime.Seconds(1), DateTime.Seconds(3) }
}

OrdosInfantryTypes = { "light_inf", "light_inf", "trooper", "trooper", "trooper" }
OrdosVehicleTypes = { "raider", "raider", "quad" }
OrdosTankTypes = { "combat_tank_o", "combat_tank_o", "siege_tank" }


ActivateAI = function()
	IdlingUnits[Ordos] = Reinforcements.Reinforce(Ordos, InitialReinforcementsSquads[1], InitialPaths[1])

	IdlingUnits[Smugglers] = Reinforcements.Reinforce(Smugglers, InitialReinforcementsSquads[2], InitialPaths[2])
	IdlingUnits[OrdosSmall] = Reinforcements.Reinforce(OrdosSmall, InitialReinforcementsSquads[3], InitialPaths[3])

	DefendAndRepairBase(Ordos, OrdosMainBase, 0.75, AttackGroupSize[Difficulty])
	DefendAndRepairBase(Smugglers, SmugglersBase, 0.75, AttackGroupSize[Difficulty])
	DefendAndRepairBase(OrdosSmall, OrdosSmallBase, 0.75, AttackGroupSize[Difficulty])

	local delay = function()
		if EarlyGameStage >= DateTime.GameTime then
			return Utils.RandomInteger(EarlyAttackDelays[Difficulty][1], EarlyAttackDelays[Difficulty][2] + 1)
		else
			return Utils.RandomInteger(LateAttackDelays[Difficulty][1], LateAttackDelays[Difficulty][2] + 1)
		end
	end
	local infantryToBuild = function() return { Utils.Random(OrdosInfantryTypes) } end
	local vehilcesToBuild = function() return { Utils.Random(OrdosVehicleTypes) } end
	local tanksToBuild = function() return { Utils.Random(OrdosTankTypes) } end
	local attackThresholdSize = AttackGroupSize[Difficulty] * 2.5
	Trigger.AfterDelay(InitialProductionDelay["OrdosMain"][Difficulty], function()
		ProduceUnits(Ordos, OBarracks1, delay, infantryToBuild, AttackGroupSize[Difficulty], attackThresholdSize)
		ProduceUnits(Ordos, OBarracks2, delay, infantryToBuild, AttackGroupSize[Difficulty], attackThresholdSize)
		ProduceUnits(Ordos, OLightFactory1, delay, vehilcesToBuild, AttackGroupSize[Difficulty], attackThresholdSize)
		ProduceUnits(Ordos, OLightFactory2, delay, vehilcesToBuild, AttackGroupSize[Difficulty], attackThresholdSize)
		ProduceUnits(Ordos, OLightFactory3, delay, vehilcesToBuild, AttackGroupSize[Difficulty], attackThresholdSize)
		ProduceUnits(Ordos, OHeavyFactory, delay, tanksToBuild, AttackGroupSize[Difficulty], attackThresholdSize)
	end)
	Trigger.AfterDelay(InitialProductionDelay["Smugglers"][Difficulty], function()
		ProduceUnits(Smugglers, SBarracks, delay, infantryToBuild, AttackGroupSize[Difficulty], attackThresholdSize)
	end)
	Trigger.OnProduction(OHeavyFactory, function (producer, produced)
		if produced.Type == "combat_tank_o" and producer.Owner.IsBot then
			AICrushLogic(produced, producer.Owner)
		end
	end)

end

function AICrushLogic(unit, bot)
	if unit.IsDead then
		return
	end
	if Utils.RandomInteger(0,100) >= CrushChance[Difficulty] then
		Trigger.AfterDelay(200, function ()
			AICrushLogic(unit, bot)
		end)
		return
	end
	local actors = Map.ActorsInCircle(unit.CenterPosition, WDist.FromCells(5), function (a)
		return
		a.IsDead == false and
		a.IsInWorld == true and
		a.Owner.IsAlliedWith(bot) == false
	end)
	local targets = Utils.Where(actors, function(a)
		return
		a.Type == "light_inf" or
		a.Type == "trooper" or
		a.Type == "engineer" and
		Map.TerrainType(a.Location) ~= "Rough"
	end)
	if targets[1] ~= nil then
		unit.Stop()
		unit.Move(Utils.Random(targets).Location)
		Trigger.AfterDelay(55, function ()
			AICrushLogic(unit, bot)
		end)
		IdleHunt(unit)
	else
		Trigger.AfterDelay(200, function ()
			AICrushLogic(unit, bot)
		end)
	end
end