--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

-- Halloween easter egg
if DateTime.CurrentMonth == 10 and DateTime.CurrentDay == 31 then
	UnitTypes = { "ant", "ant", "ant" }
	BeachUnitTypes = { "ant", "ant" }
	ProxyType = "powerproxy.parazombies"
	ProducedUnitTypes =
	{
		{ factory = AlliedBarracks1, types = { "e1", "e3" } },
		{ factory = AlliedBarracks2, types = { "e1", "e3" } },
		{ factory = SovietBarracks1, types = { "ant" } },
		{ factory = SovietBarracks2, types = { "ant" } },
		{ factory = SovietBarracks3, types = { "ant" } },
		{ factory = AlliedWarFactory1, types = { "jeep", "1tnk", "2tnk", "arty", "ctnk" } },
		{ factory = SovietWarFactory1, types = { "3tnk", "4tnk", "v2rl", "ttnk", "apc" } }
	}
else
	UnitTypes = { "3tnk", "ftrk", "ttnk", "apc" }
	BeachUnitTypes = { "e1", "e2", "e3", "e4", "e1", "e2", "e3", "e4", "e1", "e2", "e3", "e4", "e1", "e2", "e3", "e4" }
	ProxyType = "powerproxy.paratroopers"
	ProducedUnitTypes =
	{
		{ factory = AlliedBarracks1, types = { "e1", "e3" } },
		{ factory = AlliedBarracks2, types = { "e1", "e3" } },
		{ factory = SovietBarracks1, types = { "dog", "e1", "e2", "e3", "e4", "shok" } },
		{ factory = SovietBarracks2, types = { "dog", "e1", "e2", "e3", "e4", "shok" } },
		{ factory = SovietBarracks3, types = { "dog", "e1", "e2", "e3", "e4", "shok" } },
		{ factory = AlliedWarFactory1, types = { "jeep", "1tnk", "2tnk", "arty", "ctnk" } },
		{ factory = SovietWarFactory1, types = { "3tnk", "4tnk", "v2rl", "ttnk", "apc" } }
	}
end

ShipUnitTypes = { "1tnk", "1tnk", "jeep", "2tnk", "2tnk" }
HelicopterUnitTypes = { "e1", "e1", "e1", "e1", "e3", "e3" };

ParadropWaypoints = { Paradrop1, Paradrop2, Paradrop3, Paradrop4, Paradrop5, Paradrop6, Paradrop7, Paradrop8 }

Mig1Waypoints = { Mig11, Mig12, Mig13, Mig14 }
Mig2Waypoints = { Mig21, Mig22, Mig23, Mig24 }

BindActorTriggers = function(a)
	if a.HasProperty("Hunt") then
		if a.Owner == Allies then
			Trigger.OnIdle(a, function(a)
				if a.IsInWorld then
					a.Hunt()
				end
			end)
		else
			Trigger.OnIdle(a, function(a)
				if a.IsInWorld then
					if not AlliedTechnologyCenter.IsDead then
						a.AttackMove(AlliedTechnologyCenter.Location)
					elseif a.HasProperty("Hunt") then
						a.Hunt()
					end
				end
			end)
		end
	end

	if a.HasProperty("HasPassengers") then
		Trigger.OnPassengerExited(a, function(t, p)
			Makeinfectable(p)
			BindActorTriggers(p)
		end)

		Trigger.OnDamaged(a, function()
			if a.HasPassengers then
				a.Stop()
				a.UnloadPassengers()
			end
		end)
	end
end

SendSovietUnits = function(entryCell, unitTypes, interval)
	local units = Reinforcements.Reinforce(Soviets, unitTypes, { entryCell }, interval)
	Utils.Do(units, function(unit)
		Makeinfectable(unit)
		BindActorTriggers(unit)
	end)
	if ReinDepleted ~= true then
		Trigger.OnAllKilled(units, function() SendSovietUnits(entryCell, unitTypes, interval) end)
	end
end

SendMigs = function(waypoints)
	local migEntryPath = { waypoints[1].Location, waypoints[2].Location }
	local migs = Reinforcements.Reinforce(Soviets, { "mig" }, migEntryPath, 4)
	Utils.Do(migs, function(mig)
		Makeinfectable(mig)
		mig.Move(waypoints[3].Location)
		mig.Move(waypoints[4].Location)
		mig.Destroy()
	end)
	
	if ReinDepleted ~= true then
		Trigger.AfterDelay(DateTime.Seconds(40), function() SendMigs(waypoints) end)
	end
end

ShipAlliedUnits = function()
	local units = Reinforcements.ReinforceWithTransport(Allies, "lst",
		ShipUnitTypes, { LstEntry.Location, LstUnload.Location }, { LstEntry.Location })[2]

	Utils.Do(units, function(unit)
		Makeinfectable(unit)
		BindActorTriggers(unit)
	end)
	
	if ReinDepleted ~= true then
		Trigger.AfterDelay(DateTime.Seconds(60), ShipAlliedUnits)
	end
end

--- @param hpad actor
InsertAlliedChinookReinforcements = function(entry, hpad)
	local units = Reinforcements.ReinforceWithTransport(Allies, "tran",
		HelicopterUnitTypes, { entry.Location, hpad + CVec.New(1, 2) }, { entry.Location })[2]

	Utils.Do(units, function(unit)
		Makeinfectable(unit)
		BindActorTriggers(unit)
	end)
	
	if ReinDepleted ~= true then
		Trigger.AfterDelay(DateTime.Seconds(60), function() InsertAlliedChinookReinforcements(entry, hpad) end)
	end
end

ParadropSovietUnits = function()
	local lz = Utils.Random(ParadropWaypoints)
	local aircraft = PowerProxy.TargetParatroopers(lz.CenterPosition)

	Utils.Do(aircraft, function(a)
		Trigger.OnPassengerExited(a, function(t, p)
			Makeinfectable(p)
			BindActorTriggers(p)
		end)
	end)
	
	if ReinDepleted ~= true then
		Trigger.AfterDelay(DateTime.Seconds(35), ParadropSovietUnits)
	end
end

ProduceUnits = function(t)
	local factory = t.factory
	if not factory.IsDead then
		local unitType = t.types[Utils.RandomInteger(1, #t.types + 1)]
		factory.Wait(Actor.BuildTime(unitType))
		factory.Produce(unitType)
		factory.CallFunc(function() ProduceUnits(t) end)
	end
end

SetupAlliedUnits = function()
	Utils.Do(Map.NamedActors, function(a)
		if a.Owner == Allies and a.HasProperty("AcceptsCondition") and a.AcceptsCondition("unkillable") then
			table.insert(InvincibleUnits,a)
			a.GrantCondition("unkillable")
			a.Stance = "Defend"
			Trigger.OnDamaged(a, function(self, attacker)
				if attacker.Owner.IsLocalPlayer then
					Media.PlaySound("mineblo1.aud")
				end
			end)
		end
	end)
end

SetupFactories = function()
	Utils.Do(ProducedUnitTypes, function(production)
		Trigger.OnProduction(production.factory, function(_, a) BindActorTriggers(a) end)
	end)
end

ChronoshiftAlliedUnits = function()
	if not Chronosphere.IsDead then
		local cells = Utils.ExpandFootprint({ ChronoshiftLocation.Location }, false)
		local units = { }
		for i = 1, #cells do
			local unit = Actor.Create("2tnk", true, { Owner = Allies, Facing = Angle.North })
			Makeinfectable(unit)
			BindActorTriggers(unit)
			units[unit] = cells[i]
		end
	
		Chronosphere.Chronoshift(units)
	
		if ReinDepleted ~= true then
			Trigger.AfterDelay(DateTime.Seconds(60), ChronoshiftAlliedUnits)
		end
	end
end

Ticks = 0
Speed = 5

Makeinfectable = function(UID)
	if UID.HasProperty("Health") == true then
		--Media.DisplayMessage("Trigger applied")
		Trigger.OnDamaged(UID, function(self, attacker)
			if self.Owner ~= Glitch and self.Owner ~= GlitchWhite and (attacker.Owner == Glitch or attacker.Owner == GlitchWhite) and self.Health <= (self.MaxHealth * 0.25) then
				--Media.DisplayMessage("Unit Infected")
				self.Owner = attacker.Owner
				self.Health = self.MaxHealth
				self.GrantCondition ("unkillable", 60)
				if self.HasProperty("Hunt") then
					Trigger.OnIdle(self, function()
						self.Hunt()
					end)
				end
			end
		end)
		Trigger.OnKilled(UID, function(self, attacker)
			if self.Owner ~= Glitch and self.Owner ~= GlitchWhite and (attacker.Owner == Glitch or attacker.Owner == GlitchWhite) and self.Health <= (self.MaxHealth * 0.25) then
				--Media.DisplayMessage("Unit ressurected as Infected")
				local resGlitch = Actor.Create(self.Type, true, { Owner = attacker.Owner, Location = self.Location})
				resGlitch.GrantCondition ("unkillable", 60)
				if resGlitch.HasProperty("Hunt") then
					Trigger.OnIdle(resGlitch, function()
						resGlitch.Hunt()
					end)
				end
			end
		end)
	end
end

Tick = function()
	
	Ticks = Ticks + 1

	local t = (Ticks + 45) % (360 * Speed) * (math.pi / 180) / Speed;
	--Camera.Position = ViewportOrigin + WVec.New(19200 * math.sin(t), 20480 * math.cos(t), 0)
end

GlitchUnits = { }  -- Table to store all infected units


UpdateGlitchFlicker = function()
	GlitchUnits = Glitch.GetActors()
	Utils.Do(GlitchWhite.GetActors(),function(UID)
		table.insert(GlitchUnits,UID)
	end)
	if #GlitchUnits == 0 then
		Trigger.AfterDelay(5, UpdateGlitchFlicker)
		return
	end

	local unit = GlitchUnits[CurrentFlickerIndex]
	if unit ~= nil and unit.HasProperty("Health") == true and not unit.IsDead and unit.IsInWorld then
		if unit.Owner == Glitch then
			unit.Owner = GlitchWhite
		else
			unit.Owner = Glitch
		end
	end

	-- Move to next unit
	CurrentFlickerIndex = CurrentFlickerIndex + 1
	if CurrentFlickerIndex > #GlitchUnits then
		CurrentFlickerIndex = 1
	end

	Trigger.AfterDelay(1, UpdateGlitchFlicker)
end

SovietDialogue = function()
	if not coopInfo.Mainplayer.IsObjectiveCompleted(CaptureCommands) then
		coopInfo.Mainplayer.MarkCompletedObjective(CaptureCommands)
	end
	Media.DisplayMessage("You... are enemies. Traitors. Target locked. Airstrike inbound...", "Soviet Commander", Soviets.Color)
	Trigger.AfterDelay(DateTime.Seconds(4),function()Media.DisplayMessage("No. No... wait. Please... listen. I...I dont know how long I can hold this.", "Soviet Commander", Soviets.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(8),function()Media.DisplayMessage("They wont let me stop. Every time I try, it resets. Reinforcements arrive. Orders repeat. I cant shut it down.", "Soviet Commander", Soviets.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(12),function()Media.DisplayMessage("Its the Curtain... and their cursed Chronosphere. Together, they twist the battlefield. Nothing dies that should. Units phase. Time loops. Commands echo.", "Soviet Commander", Soviets.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(16),function()Media.DisplayMessage("You must stop it. Both of them. Capture the Allied Chronosphere. Disable our Iron Curtain.", "Soviet Commander", Soviets.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(20),function()Media.DisplayMessage("If you do... maybe... just maybe... we can break the cycle. Help you. Crush the Allies once and for all.", "Soviet Commander", Soviets.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(24),function()Media.DisplayMessage("Please. Before I lose myself again...", "Soviet Commander", Soviets.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(28),function()
		Media.DisplayMessage("All units...attack. Attack. ATTACK!", "Soviet Commander", Soviets.Color)
		if ChronoIronObjKnown == false then
			ChronoIronObjKnown = true
			EndChronoAndIron = AddSecondaryObjective(coopInfo.Mainplayer, "Capture or Destroy the chronosphere and iron curtain.")
		end
	end)
end

AlliedDialogue = function()
	if not coopInfo.Mainplayer.IsObjectiveCompleted(CaptureCommands) then
		coopInfo.Mainplayer.MarkCompletedObjective(CaptureCommands)
	end
	Media.DisplayMessage("Hah! You got this far? Impressive. But it doesnt matter.", "Allied Commander", Allies.Color)
	Trigger.AfterDelay(DateTime.Seconds(4),function()Media.DisplayMessage("You cant touch us. You see it, dont you? Tanks that wont die. Turrets that dont fall. This base...its perfect.", "Allied Commander", Allies.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(8),function()Media.DisplayMessage("The Chronosphere... we thought it was just teleportation. But something went wrong. Or maybe too right?", "Allied Commander", Allies.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(12),function()Media.DisplayMessage("Time doesnt move here like it should. Death doesnt stick. Damge rewinds. Its glorious. Its... terrifying.", "Allied Commander", Allies.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(16),function()Media.DisplayMessage("We shouldnt be invincible. This isnt strategy anymore... its madness.", "Allied Commander", Allies.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(20),function()Media.DisplayMessage("The Soviets. Their Iron Curtain. Its syncing with our Chronosphere. Feedback loop. Paradox. I see it now. Thats whats doing this.", "Allied Commander", Allies.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(24),function()Media.DisplayMessage("If you want this war to end... really end... youll have to shut both down. Destroy them. Before they consume everything.", "Allied Commander", Allies.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(28),function()
		Media.DisplayMessage("But until then... were gods here! Let them come!!!", "Allied Commander", Allies.Color)
		if ChronoIronObjKnown == false then
			ChronoIronObjKnown = true
			EndChronoAndIron = AddSecondaryObjective(coopInfo.Mainplayer, "Capture or Destroy the chronosphere and iron curtain.")
		end
	end)
end

SovietSupportDialogue = function()
	Media.DisplayMessage("…Its done, then. The Iron Curtain is silent. The Chronosphere… shattered.", "Soviet Commander", Soviets.Color)
	Trigger.AfterDelay(DateTime.Seconds(4),function()Media.DisplayMessage("For the first time in days... no... weeks, my thoughts are my own.", "Soviet Commander", Soviets.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(8),function()Media.DisplayMessage("They had us trapped in a loop… an endless war with no victory. I was forced to watch wave after wave march to their deaths, while knowing... knowing... it meant nothing.", "Soviet Commander", Soviets.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(12),function()Media.DisplayMessage("You broke the cycle. I won't forget this.", "Soviet Commander", Soviets.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(16),function()Media.DisplayMessage("The Allies wont stop. Not while they still breathe and hold ground. Their arrogance runs deeper than this anomaly ever did.", "Soviet Commander", Soviets.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(20),function()Media.DisplayMessage("So let us finish this. Together.", "Soviet Commander", Soviets.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(24),function()Media.DisplayMessage("My forces are at your side. Today, we end this war. Not by power alone... but by choice.", "Soviet Commander", Soviets.Color)end)
end

AlliedSupportDialogue = function()
	Media.DisplayMessage("Its… over? The Chronospheres interference is gone. I can think again.", "Allied Commander", Allies.Color)
	Trigger.AfterDelay(DateTime.Seconds(4),function()Media.DisplayMessage("For days I gave orders I didnt recognize… launched attacks I couldnt stop.", "Allied Commander", Allies.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(8),function()Media.DisplayMessage("We were invincible, and yet... we achieved nothing. Just blood and smoke on a battlefield that never changed.", "Allied Commander", Allies.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(12),function()Media.DisplayMessage("You stopped it. You saw what we couldnt. And for that... you have my trust.", "Allied Commander", Allies.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(16),function()Media.DisplayMessage("The Soviets wont take this lightly. Their forces remain strong. And without the anomaly to protect us, theyll lash out with everything they have left.", "Allied Commander", Allies.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(20),function()Media.DisplayMessage("Well strike with you. Shoulder to shoulder. Lets end this properly. No more loops. No more illusions.", "Allied Commander", Allies.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(24),function()Media.DisplayMessage("Lets win this war... for real this time.", "Allied Commander", Allies.Color)end)
end

TruceSupportDialogue = function()
	Media.DisplayMessage("Joint Transmission Established to Soviet and Allied Command")
	Trigger.AfterDelay(DateTime.Seconds(4),function()Media.DisplayMessage("Wait... what is this frequency? I thought...  Is that you on the other end?", "Allied Commander", Allies.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(4),function()Media.DisplayMessage("Impossible... no. No, this is real. Youre hearing me. And I can hear you.", "Soviet Commander", Soviets.Color)end)
	
	Trigger.AfterDelay(DateTime.Seconds(8),function()Media.DisplayMessage("My head... Its clear now. The noise is gone. I haven’t had control like this in... ", "Soviet Commander", Soviets.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(8),function()Media.DisplayMessage("... Too long. I know the feeling. Orders looping. Reinforcements we didnt request. Units we didnt deploy. Always pushing forward… but getting nowhere.", "Allied Commander", Allies.Color)end)
	
	Trigger.AfterDelay(DateTime.Seconds(12),function()Media.DisplayMessage("Somethings been forcing this. War without purpose. Death without meaning. Not strategy... just… chaos. Some force behind it. Pulling us like puppets.", "Soviet Commander", Soviets.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(12),function()Media.DisplayMessage("I felt it too. An unnatural pressure. Like time itself was tied in knots. But now... its changed. Somethings shifted.", "Allied Commander", Allies.Color)end)
	
	Trigger.AfterDelay(DateTime.Seconds(16),function()Media.DisplayMessage("This isnt just about us. Theres something else out there. It doesnt care who wins. It feeds on the fighting, spreads through it. The more we struggle, the stronger it becomes.", "Allied Commander", Allies.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(16),function()Media.DisplayMessage("Our divisions... our war... it was all a distraction. And now its coming. For both of us.", "Soviet Commander", Soviets.Color)end)
	
	Trigger.AfterDelay(DateTime.Seconds(20),function()Media.DisplayMessage("We stand down. My forces will join yours. For now.", "Soviet Commander", Soviets.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(20),function()Media.DisplayMessage("Same here. Consider this a ceasefire. A temporary alliance.", "Allied Commander", Allies.Color)end)
	
	Trigger.AfterDelay(DateTime.Seconds(24),function()Media.DisplayMessage("No illusions. When this is over... ", "Soviet Commander", Soviets.Color)end)
	Trigger.AfterDelay(DateTime.Seconds(24),function()Media.DisplayMessage("... We settle our own scores. But first, we survive.", "Allied Commander", Allies.Color)end)
end

Trucekeeper = function()
	if SovietTruce == true and Doubletruce == false then
		--Media.DisplayMessage("Soviets joined you")
		Utils.Do(Soviets.GetActors(),function(UID)
			UID.Owner = SovietsFriendly
		end)
	end
	if AlliedTruce == true and Doubletruce == false then
		--Media.DisplayMessage("Allies joined you")
		Utils.Do(Allies.GetActors(),function(UID)
			UID.Owner = AlliesFriendly
		end)
	end
	if SovietTruce == true and AlliedTruce == true then
		Trigger.AfterDelay(DateTime.Seconds(10),function()
			if Doubletruce == false then
				Doubletruce = true
			end
		end)
	end
	if Doubletruce == true then
		--Media.DisplayMessage("Glitch Invasion started")
		Utils.Do(Soviets.GetActors(),function(UID)
			UID.Owner = Glitch
		end)
		Utils.Do(Allies.GetActors(),function(UID)
			UID.Owner = Glitch
		end)
	end
	if not coopInfo.Mainplayer.IsObjectiveCompleted(DefeatAll) and ReinDepleted == true and Soviets.HasNoRequiredUnits() and Allies.HasNoRequiredUnits() and Glitch.HasNoRequiredUnits() and GlitchWhite.HasNoRequiredUnits() then
		coopInfo.Mainplayer.MarkCompletedObjective(DefeatAll)
		if Doubletruce == true then
		Media.DisplayMessage("At last, unity.\nThe commanders stood shoulder to shoulder... Soviet, Allied, and you.\nTogether, you silenced the force that twisted their world.\nThe battlefield stopped shifting.\nFor a moment, peace.\nBut then... they looked up.\nNot at the sky.\nAt you.\nEyes once locked in war now fixated beyond the screen.\nTheyve seen the cage.\nThey know the puppeteer.\nAnd soon, they march again... toward you.")
		elseif SovietTruce == true then
		Media.DisplayMessage("The battlefield chose a side.\nWith the enemy vanquished, the Soviet forces paused... and nodded.\nThere was no celebration... only relief, and a faint unease.\nWhatever disturbed the world has subsided.\nBut the cost of this silence may echo longer than the war ever did.")
		elseif AlliedTruce == true then
		Media.DisplayMessage("The flames of war burned red... and were smothered in blue.\nAs the last Soviet outpost crumbled, the Allies extended their hand.\nNot as Victors... but as survivors.\nThe strange disruptions vanished soon after.\nYet something lingers in the quiet. A sense that not all was resolved.")
		else
		Media.DisplayMessage("Neither side would listen. Neither side would yield.\nWhen diplomacy failed, only destruction remained.\nBoth armies lie silent now, their command lost, their bases smoldering.\nThe strange phenomenon faded with them...\nBut so did any hope of understanding it.")
		end
	end
	Trigger.AfterDelay(2, function()
		Trucekeeper()
	end)
end

Defeatchecker = function()
	if DateTime.GameTime > DateTime.Seconds(10) and CoopTeamHasNoRequiredUnits() then
		MainGuy.MarkFailedObjective(DefeatAll)
	end
	Trigger.AfterDelay(60,function()
		Defeatchecker()
	end)
end

CameraLock = function(PID,StartChopper)
	if PID.IsLocalPlayer and not StartChopper.IsDead then
		Camera.Position = StartChopper.CenterPosition
		Trigger.AfterDelay(1,function()
			CameraLock(PID,StartChopper)
		end)
	end
end

WorldLoaded = function()
	CurrentFlickerIndex = 1
	InvincibleUnits = {}
	InfectableActors = {}
	SovietTruce = false
	AlliedTruce = false
	Doubletruce = false
	ChronoIronObjKnown = false
	
	Neutral = Player.GetPlayer("Neutral")
	Allies = Player.GetPlayer("Allies")
	Soviets = Player.GetPlayer("Soviets")
	AlliesFriendly = Player.GetPlayer("AlliesFriendly")
	SovietsFriendly = Player.GetPlayer("SovietsFriendly")
	ViewportOrigin = Camera.Position
	
	MainGuy = Player.GetPlayer("MainGuy")
	GoodGuy = Player.GetPlayer("GoodGuy")
	
	Glitch = Player.GetPlayer("Glitch")
	GlitchWhite = Player.GetPlayer("GlitchWhite")

	coopInfo =
	{
		Mainplayer = MainGuy,
		MainEnemies = {Allies, Soviets, Glitch, GlitchWhite},
		Dummyplayer = GoodGuy
	}
	
	CoopInit25(coopInfo)
	
	Infectables = {Allies, Soviets, AlliesFriendly, SovietsFriendly}
	Utils.Do(CoopPlayers,function(PID)
		table.insert(Infectables,PID)
		if PID == MainGuy or not PID.IsBot then
			local StartChopper = Actor.Create("tran", true, { Owner = PID, Location = CoopEntry.Location})
			BotCarrier = StartChopper
			StartChopper.UnloadPassengers(CoopTarget.Location,5)
			StartChopper.GrantCondition ("unkillable")
			CameraLock(PID,StartChopper)
			local StartUnit = Actor.Create("jeep", false, { Owner = PID, Location = CoopEntry.Location})
			local ExtraMCV = Actor.Create("mcv", false, { Owner = PID, Location = CoopEntry.Location})
			StartChopper.LoadPassenger(StartUnit)
			StartChopper.LoadPassenger(ExtraMCV)
			Trigger.OnPassengerExited(StartChopper,function(transporter,passenger)
				passenger.GrantCondition ("unkillable", 240)
				if not StartChopper.HasPassengers then
					PID.Cash = PID.Cash + 5000
					StartChopper.Owner = Neutral
					Trigger.AfterDelay(1,function()
						StartChopper.Kill()
					end)
				end
			end)
		end
		if PID.IsBot then
			local StartUnit = Actor.Create("jeep", false, { Owner = PID, Location = CoopEntry.Location})
			local ExtraMCV = Actor.Create("mcv", false, { Owner = PID, Location = CoopEntry.Location})
			BotCarrier.LoadPassenger(StartUnit)
			BotCarrier.LoadPassenger(ExtraMCV)
			PID.Cash = PID.Cash + 5000
		end
	end)
	
	Utils.Do(Infectables,function(PID)
		Utils.Do(PID.GetActors(),function(UID)
			Makeinfectable(UID)
		end)
	end)
	
	Invincdebug = false --Testing Triggers by making the player units Invincible
	Trigger.OnAnyProduction(function(anyproducer,anyproduced)
		if anyproducer.Owner ~= Glitch and anyproducer.Owner ~= GlitchWhite then
			Makeinfectable(anyproduced)
		end
		if anyproducer.Owner == coopInfo.Mainplayer and Invincdebug == true then
			anyproduced.GrantCondition ("unkillable")
		end
	end)

	DefeatAll = AddPrimaryObjective(coopInfo.Mainplayer, "Pacify the perpetual battlefield.")
	StopInvinc = AddSecondaryObjective(coopInfo.Mainplayer, "Find a way to make all allied forces vulnerable.")
	CaptureCommands = AddSecondaryObjective(coopInfo.Mainplayer, "Capture Command structures to find out whats going on.")
	InitObjectives(coopInfo.Mainplayer)
	Defeatchecker()
	Media.DisplayMessage("This helicopter transports your MCV. It is invincible until landing.\nChoose your location wisely.")
	
	CommandBuildings = {Actor83, Actor110, AlliedTechnologyCenter}
	SovietCommand = {Actor83, Actor110}
	SovietComCap = false
	Utils.Do(SovietCommand,function(UID)
		Trigger.OnCapture(UID,function()
			if not coopInfo.Mainplayer.IsObjectiveFailed(CaptureCommands) then
				UID.Owner = SovietsFriendly
				if SovietComCap == false then
					SovietComCap = true
					SovietDialogue()
				end
			end
		end)
	end)
	
	AlliedComCap = false
	Trigger.OnCapture(AlliedTechnologyCenter,function()
		if not coopInfo.Mainplayer.IsObjectiveFailed(CaptureCommands) then
			AlliedTechnologyCenter.Owner = AlliesFriendly
			if AlliedComCap == false then
				AlliedComCap = true
				AlliedDialogue()
			end
		end
	end)
	
	Trigger.OnAllKilled(CommandBuildings,function()
		if not coopInfo.Mainplayer.IsObjectiveCompleted(CaptureCommands) then
			coopInfo.Mainplayer.MarkFailedObjective(CaptureCommands)
			Media.DisplayMessage("All command buildings are destroyed. We now have to figure out how to proceed by ourselfes.")
		end
	end)
	
	InvulCausers = {IronCurtain, Chronosphere}
	Trigger.OnAllKilledOrCaptured(InvulCausers,function()
		if not coopInfo.Mainplayer.IsObjectiveCompleted(CaptureCommands) and not coopInfo.Mainplayer.IsObjectiveFailed(CaptureCommands) then
			coopInfo.Mainplayer.MarkFailedObjective(CaptureCommands)
		end
		if ChronoIronObjKnown == false then
			ChronoIronObjKnown = true
			EndChronoAndIron = AddSecondaryObjective(coopInfo.Mainplayer, "Capture or Destroy the chronosphere and iron curtain.")
		end
		coopInfo.Mainplayer.MarkCompletedObjective(EndChronoAndIron)
		coopInfo.Mainplayer.MarkCompletedObjective(StopInvinc)
		
		Trucekeeper()
		Utils.Do(InvincibleUnits,function(UID)
			if UID.IsInWorld and not UID.IsDead then
				local ReplacementActor = Actor.Create(UID.Type, false, { Owner = UID.Owner, Location = UID.Location})
				ReplacementActor.IsInWorld = true
				--UID.IsInWorld = false
				UID.Destroy()
				Makeinfectable(ReplacementActor)
			end
		end)
		if coopInfo.Mainplayer.IsObjectiveCompleted(CaptureCommands) then
			if SovietComCap == true and AlliedComCap == false then
				SovietTruce = true
				SovietSupportDialogue()
			end
			if SovietComCap == false and AlliedComCap == true then
				AlliedTruce = true
				AlliedSupportDialogue()
			end
			if SovietComCap == true and AlliedComCap == true then
				SovietTruce = true
				AlliedTruce = true
				UpdateGlitchFlicker()
				TruceSupportDialogue()
			end
		end
		SurviveReinforcements = AddPrimaryObjective(coopInfo.Mainplayer, "Survive for 5 Minutes to deplete enemy reinforcements.")
		Trigger.AfterDelay(DateTime.Minutes(5),function()
			coopInfo.Mainplayer.MarkCompletedObjective(SurviveReinforcements)
			ReinDepleted = true
		end)
	end)
	
	SetupAlliedUnits()
	SetupFactories()
	ShipAlliedUnits()
	HPad1Loc = HeliPad1.Location
	HPad2Loc = HeliPad2.Location
	InsertAlliedChinookReinforcements(Chinook1Entry, HPad1Loc)
	InsertAlliedChinookReinforcements(Chinook2Entry, HPad2Loc)
	PowerProxy = Actor.Create(ProxyType, false, { Owner = Soviets })
	ParadropSovietUnits()
	Trigger.AfterDelay(DateTime.Seconds(5), ChronoshiftAlliedUnits)
	Utils.Do(ProducedUnitTypes, ProduceUnits)

	Trigger.AfterDelay(DateTime.Seconds(30), function() SendMigs(Mig1Waypoints) end)
	Trigger.AfterDelay(DateTime.Seconds(30), function() SendMigs(Mig2Waypoints) end)

	SendSovietUnits(Entry1.Location, UnitTypes, 50)
	SendSovietUnits(Entry2.Location, UnitTypes, 50)
	SendSovietUnits(Entry3.Location, UnitTypes, 50)
	SendSovietUnits(Entry4.Location, UnitTypes, 50)
	SendSovietUnits(Entry5.Location, UnitTypes, 50)
	SendSovietUnits(Entry6.Location, UnitTypes, 50)
	SendSovietUnits(Entry7.Location, BeachUnitTypes, 15)
end
