--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

SamSites = { Sam1, Sam2, Sam3, Sam4 }
Sam4Guards = { Sam4Guard0, Sam4Guard1, Sam4Guard2, Sam4Guard3, Sam4Guard4, HiddenBuggy }
NodInfantrySquad = { "e1", "e1", "e1", "e1", "e1" }
NodAttackRoutes = { { AttackWaypoint }, { AttackWaypoint }, { AttackRallypoint1, AttackRallypoint2, AttackWaypoint } }
InfantryReinforcements = { "e1", "e1", "e1", "e1", "e1", "e2", "e2", "e2", "e2", "e2" }
JeepReinforcements = { "jeep", "jeep", "jeep" }
MCVReinforcements = { }

AttackPlayer = function()
	if NodBarracks.IsDead or IsOwnedByCoopPlayer(NodBarracks) then
		return
	end

	local after = function(team)
		local count = 1
		local route = Utils.Random(NodAttackRoutes)
		Utils.Do(team, function(actor)
			Trigger.OnIdle(actor, function()
				if actor.Location == route[count].Location then
					if not count == #route then
						count = count + 1
					else
						Trigger.ClearAll(actor)
						Trigger.AfterDelay(0, function()
							Trigger.OnIdle(actor, actor.Hunt)
						end)
					end
				else
					actor.AttackMove(route[count].Location)
				end
			end)
		end)
		Trigger.OnAllKilled(team, function() Trigger.AfterDelay(DateTime.Seconds(15), AttackPlayer) end)
	end

	NodBarracks.Build(NodInfantrySquad, after)
end

SendReinforcements = function()
	Reinforcements.Reinforce(GoodGuy, JeepReinforcements, { VehicleStart.Location, VehicleStop.Location })
	Reinforcements.Reinforce(GoodGuy, InfantryReinforcements, { InfantryStart.Location, InfantryStop.Location }, 5)
	Trigger.AfterDelay(DateTime.Seconds(3), function()
		Reinforcements.Reinforce(GoodGuy, MCVReinforcements, { VehicleStart.Location, MCVwaypoint.Location })
		InitialUnitsArrived = true
	end)
	Media.PlaySpeechNotification(All, "Reinforce")
end

WorldLoaded = function()
	GDI = Player.GetPlayer("GDI")
	Nod = Player.GetPlayer("Nod")

	GoodGuy = Player.GetPlayer("GoodGuy")

	coopInfo =
	{
		FMVBriefing = "gdi3.vqa",
		FMVOpening = "samdie.vqa",
		Mainplayer = GDI,
		MainEnemies = {Nod},
		Dummyplayer = GoodGuy
	}
	
	ORAMod = "td"
	
	CoopInit25(coopInfo)
	
	Utils.Do(MCVPlayers,function(PID)
		table.insert(MCVReinforcements, "mcv")
	end)
	
	InitObjectives(GDI)

	DestroyNod = AddPrimaryObjective(GDI, "eliminate-nod")
	local airSupportObjective = AddSecondaryObjective(GDI, "destroy-sams")

	Trigger.OnAllKilled(SamSites, function()
		GDI.MarkCompletedObjective(airSupportObjective)
		Actor.Create("airstrike.proxy", true, { Owner = GDI })
	end)

	RepairNamedActors(Nod, 0.25)

	Trigger.OnDamaged(Sam4, function()
		Utils.Do(Sam4Guards, IdleHunt)
	end)

	SendReinforcements()

	Camera.Position = MCVwaypoint.CenterPosition

	Trigger.AfterDelay(DateTime.Seconds(15), AttackPlayer)
end

Tick = function()
	
	if #coopInfo.Dummyplayer.GetActorsByType("mcv") > 0 and #MCVPlayers > 1 then
		AssignToCoopPlayers(coopInfo.Dummyplayer.GetActorsByType("mcv"))
	elseif #coopInfo.Dummyplayer.GetActorsByType("mcv") > 0 and #MCVPlayers == 1 then
		coopInfo.Dummyplayer.GetActorsByType("mcv")[1].Owner = GDI
	end
	
	if InitialUnitsArrived then
		if DateTime.GameTime > DateTime.Seconds(5) and CoopTeamHasNoRequiredUnits() then
			GDI.MarkFailedObjective(DestroyNod)
		end

		if Nod.HasNoRequiredUnits() then
			GDI.MarkCompletedObjective(DestroyNod)
		end
	end
end
