function getAllCreeps()
	targets = Utils.Where(Creeps.GetActors(), function(actor)
		return actor.Type == "powr" or actor.Type == "silo" or actor.Type == "apwr" or actor.Type == "oilb"
	end)
	return targets

end

function getAllNeutral()
	targets = Utils.Where(Neutral.GetActors(), function(actor)
		return actor.Type == "powr" or actor.Type == "silo" or actor.Type == "apwr" or actor.Type == "oilb"
	end)
	return targets

end

function removeactors(a)
	Utils.Do(a, function(unit)
		unit.Destroy()
	end)
	return 
end

function getActorsAround(actorselected,actorsToFind, distance)
	actorList = Map.ActorsInCircle(actorselected.CenterPosition, WDist.FromCells(distance), function(a)
		return a.Type == actorsToFind
	end)
	return actorList
end

function setupRefs()
	facts = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
		return actor.Type == "fact" or actor.Type == "mcv"
	end)
	Utils.Do(facts, function(a)
		if a.Owner ~= castlePlayer then
			actorOwner = a.Owner
			toCapture = {}
			toCapture = { "silo", "powr", "apwr", "dtrk", "oilb" }
			Utils.Do(toCapture, function(z)
				actorsToCapture = getActorsAround(a,z,19)
				Utils.Do(actorsToCapture, function(b)
					b.Owner = actorOwner
				end)
			end)
		end
	end)

	Trigger.AfterDelay(DateTime.Seconds(2), function()
		powrs = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
			return 
			actor.Type == "silo"
		end)
		Utils.Do(powrs, function(a)
			actorOwner = a.Owner
			originalLocation = a.Location
			newLocation = originalLocation + CVec.New(0,1)
			if actorOwner.InternalName ~= "Neutral" then
				Actor.Create("proc", true, { Owner = actorOwner, Location = newLocation})
			end
		end)
	end)
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		creepActors = getAllCreeps()
		removeactors(creepActors)
--		neutralActors = getAllNeutral()
--		removeactors(neutralActors)
	end)
end

WorldLoaded = function()
	Creeps = Player.GetPlayer("Creeps")
	Neutral = Player.GetPlayer("Neutral")
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		setupRefs()
	end)
end


-- Ticks for checkbulidings

Tick = function()
end

