--[[
   Copyright 2007-2022 The OpenRA Developers (see AUTHORS)
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

AttackDirection = Map.LobbyOption("adir")
EnemyType = Map.LobbyOption("monsters")


PatrolWaypoints = { Entry2, Entry4, Entry6, Entry8 }
ParadropWaypoints = { Paradrop1, Paradrop2, Paradrop3, Paradrop4 }
SpawnPoints = { Spawn1, Spawn2, Spawn3, Spawn4 }
Snipers = { Sniper1, Sniper2, Sniper3, Sniper4, Sniper5, Sniper6, Sniper7, Sniper8, Sniper9, Sniper10, Sniper11, Sniper12 }

Walls =
{
	{ WallTopRight1, WallTopRight2, WallTopRight3, WallTopRight4, WallTopRight5, WallTopRight6, WallTopRight7, WallTopRight8, WallTopRight9 },
	{ WallTopLeft1, WallTopLeft2, WallTopLeft3, WallTopLeft4, WallTopLeft5, WallTopLeft6, WallTopLeft7, WallTopLeft8, WallTopLeft9 },
	{ WallBottomLeft1, WallBottomLeft2, WallBottomLeft3, WallBottomLeft4, WallBottomLeft5, WallBottomLeft6, WallBottomLeft7, WallBottomLeft8, WallBottomLeft9 },
	{ WallBottomRight1, WallBottomRight2, WallBottomRight3, WallBottomRight4, WallBottomRight5, WallBottomRight6, WallBottomRight7, WallBottomRight8, WallBottomRight9 }
}

if AttackDirection == "all" then
	SovietEntryPoints = { Entry1, Entry2, Entry3, Entry4, Entry5, Entry6, Entry7, Entry8 }
elseif AttackDirection == "north" then
	SovietEntryPoints = { Entry1, Entry2, Entry3 }
elseif AttackDirection == "east" then
	SovietEntryPoints = { Entry3, Entry4, Entry5 }
elseif AttackDirection == "south" then
	SovietEntryPoints = { Entry5, Entry6, Entry7 }
elseif AttackDirection == "west" then
	SovietEntryPoints = { Entry7, Entry8, Entry1 }
end

-- "pvice" "bspi" "reve" "imp" "pinky" "manc" "mechwarrior" "exciter" "tripod"

if Difficulty == "veryeasy" then
	ParaChance = 20
	if EnemyType == "normal" then
		Patrol = { "e1", "e2", "e1", "e1", "e4", "e4", "e1", "e2", "e4" }
		Infantry = { "e4","e4", "e1", "e1", "e2", "e1" }
		Vehicles = { "arty", "ftrk", "apc" }
		Tank = { "3tnk", "3tnk" }
		LongRange = { "v2rl" }
		Boss = { "4tnk" }
		Swarm = { "shok", "shok", "shok", "ttnk", "ttnk" }
	elseif EnemyType == "monsters" then
		Patrol = { "pvice", "bspi", "pvice", "bspi", "ufo" }
		Infantry = { "bspi", "pvice", "pvice", "pvice" }
		Vehicles = { "reve", "reve" }
		Tank = { "imp" }
		LongRange = { "pinky" }
		Boss = { "manc" }
		Swarm = { "mechwarrior", "bspi", "bspi", "pvice", "pvice", "pvice", "pvice"  }
	elseif EnemyType == "mixed" then
		Patrol = { "pvice", "e2", "e1", "e4", "bspi" }
		Infantry = { "e4", "pvice", "e1", "bspi", "e2" }
		Vehicles = { "reve", "arty", "ftrk" }
		Tank = { "3tnk", "imp" }
		LongRange = { "pinky" }
		Boss = { "4tnk" }
		Swarm = { "mechwarrior", "ttnk", "ttnk", "ufo", "ufo" }
	elseif EnemyType == "bosses" then
		Patrol = { "imp", "bspi" }
		Infantry = { "reve" }
		Vehicles = { "apc", "ftrk" }
		Tank = { "3tnk" }
		LongRange = { "arty" }
		Boss = { "exciter" }
		Swarm = { "mechwarrior" }
	end
elseif Difficulty == "easy" then
	ParaChance = 25
	if EnemyType == "normal" then
		Patrol = { "e1", "e2", "e1", "e1", "e4", "e4", "e1", "e2", "e4", "e1" }
		Infantry = { "e4","e4", "e1", "e1", "e2", "e1", "e1" }
		Vehicles = { "arty", "ftrk", "ftrk", "apc", "apc" }
		Tank = { "3tnk", "3tnk" }
		LongRange = { "v2rl" }
		Boss = { "4tnk" }
		Swarm = { "shok", "shok", "shok", "shok", "shok", "ttnk", "ttnk", "ttnk" }
	elseif EnemyType == "monsters" then
		Patrol = { "pvice", "bspi", "pvice", "bspi", "pvice", "bspi", "ufo" }
		Infantry = { "bspi", "pvice", "pvice", "pvice" }
		Vehicles = { "reve", "reve", "reve" }
		Tank = { "imp", "imp" }
		LongRange = { "pinky", "pinky" }
		Boss = { "manc" }
		Swarm = { "mechwarrior", "bspi", "bspi", "bspi", "pvice", "pvice", "pvice", "pvice", "pvice"  }
	elseif EnemyType == "mixed" then
		Patrol = { "pvice", "e2", "pvice", "e1", "e4", "bspi", "ufo" }
		Infantry = { "e4", "pvice", "e1", "bspi", "pvice", "e2" }
		Vehicles = { "reve", "arty", "ftrk", "apc" }
		Tank = { "3tnk", "imp" }
		LongRange = { "v2rl", "pinky" }
		Boss = { "4tnk" }
		Swarm = { "mechwarrior", "ttnk", "ttnk", "ttnk", "ttnk", "ufo", "ufo", "ufo" }
	elseif EnemyType == "bosses" then
		Patrol = { "2tnk", "bspi" }
		Infantry = { "pinky" }
		Vehicles = { "apc", "ftrk" }
		Tank = { "3tnk", "mechwarrior" }
		LongRange = { "v2rl" }
		Boss = { "manc", "4tnk" }
		Swarm = { "exciter" }
	end
elseif Difficulty == "normal" then
	ParaChance = 30
	if EnemyType == "normal" then
		Patrol = { "e1", "e2", "e1", "e1", "e4", "e4", "e1", "e2", "e4", "e1", "e2", "e1" }
		Infantry = { "e4","e4", "e1", "e1", "e2", "e1", "e1" }
		Vehicles = { "arty", "arty", "ftrk", "ftrk", "apc", "apc" }
		Tank = { "3tnk", "3tnk", "3tnk" }
		LongRange = { "v2rl", "v2rl" }
		Boss = { "4tnk" }
		Swarm = { "shok", "shok", "shok", "shok", "shok", "shok", "shok", "ttnk", "ttnk", "ttnk", "ttnk", "ttnk" }
	elseif EnemyType == "monsters" then
		Patrol = { "pvice", "bspi", "pvice", "bspi", "pvice", "bspi" }
		Infantry = { "bspi", "pvice", "pvice", "bspi", "pvice", "pvice", "ufo" }
		Vehicles = { "reve", "reve", "reve", "reve", "reve" }
		Tank = { "imp", "imp", "imp" }
		LongRange = { "pinky", "pinky", "pinky" }
		Boss = { "manc", "mechwarrior" }
		Swarm = { "mechwarrior", "bspi", "bspi", "bspi", "bspi", "bspi", "pvice", "pvice", "pvice", "pvice", "pvice", "pvice", "pvice"  }
	elseif EnemyType == "mixed" then
		Patrol = { "pvice", "e2", "pvice", "e1", "e4", "bspi", "bspi" }
		Infantry = { "e4", "pvice", "e1", "bspi", "pvice", "e2", "ufo" }
		Vehicles = { "reve", "arty", "ftrk", "reve", "apc" }
		Tank = { "3tnk", "3tnk", "imp" }
		LongRange = { "v2rl", "pinky", "pinky" }
		Boss = { "4tnk", "manc" }
		Swarm = { "mechwarrior", "ttnk", "ttnk", "ttnk", "ttnk", "ttnk", "ufo", "ufo", "ufo", "ufo" }
	elseif EnemyType == "bosses" then
		Patrol = { "mechwarrior", "reve", "ufo" }
		Infantry = { "pinky", "imp" }
		Vehicles = { "apc", "ftrk" }
		Tank = { "3tnk" }
		LongRange = { "arty", "v2rl" }
		Boss = { "exciter", "manc" }
		Swarm = { "4tnk" }
	end
elseif Difficulty == "hard" then
	ParaChance = 35
	if EnemyType == "normal" then
		Patrol = { "e1", "e2", "e1", "e1", "e4", "e4", "e1", "e2", "e4", "e1", "e2", "e1", "e1", "e4" }
		Infantry = { "e4","e4", "e1", "e1", "e2", "e1", "e1" }
		Vehicles = { "arty", "arty", "arty", "ftrk", "ftrk", "ftrk", "apc", "apc", "apc" }
		Tank = { "3tnk", "3tnk", "3tnk", "3tnk" }
		LongRange = { "v2rl", "v2rl", "v2rl" }
		Boss = { "4tnk", "4tnk" }
		Swarm = { "shok", "shok", "shok", "shok", "shok", "shok", "shok", "ttnk", "shok", "ttnk", "ttnk", "ttnk", "ttnk", "ttnk" }
	elseif EnemyType == "monsters" then
		Patrol = { "pvice", "bspi", "pvice", "bspi", "pvice", "bspi", "ufo" }
		Infantry = { "bspi", "pvice", "pvice", "bspi", "pvice", "pvice", "pvice", "bspi", "ufo" }
		Vehicles = { "reve", "reve", "reve", "reve", "reve", "reve" }
		Tank = { "imp", "imp", "imp", "imp" }
		LongRange = { "pinky", "pinky", "pinky", "pinky" }
		Boss = { "manc", "exciter" }
		Swarm = { "mechwarrior", "mechwarrior", "bspi", "bspi", "bspi", "bspi", "bspi", "bspi", "bspi", "pvice", "pvice", "pvice", "pvice", "pvice", "pvice", "pvice", "pvice", "pvice", "pvice"  }
	elseif EnemyType == "mixed" then
		Patrol = { "pvice", "e2", "pvice", "e1", "pvice", "e4", "bspi", "bspi" }
		Infantry = { "e4", "pvice", "e1", "bspi", "pvice", "e2", "bspi", "e1", "ufo" }
		Vehicles = { "reve", "arty", "ftrk", "reve", "apc", "reve" }
		Tank = { "3tnk", "3tnk", "imp", "imp" }
		LongRange = { "v2rl", "pinky", "v2rl", "pinky" }
		Boss = { "4tnk", "manc", "exciter" }
		Swarm = { "mechwarrior", "mechwarrior", "ttnk", "ttnk", "ttnk", "ttnk", "ttnk", "ufo", "ufo", "ufo", "ufo", "ufo" }
	elseif EnemyType == "bosses" then
		Patrol = { "bspi", "imp", "ufo" }
		Infantry = { "mechwarrior", "pinky", "reve" }
		Vehicles = { "bspi", "ftrk", "apc" }
		Tank = { "3tnk", "3tnk" }
		LongRange = { "arty", "v2rl" }
		Boss = { "manc", "tripod" }
		Swarm = { "exciter", "4tnk", "ufo" }
	end
else
	ParaChance = 40
	if EnemyType == "normal" then
		Patrol = { "e1", "e2", "e1", "e1", "e4", "e4", "e1", "e2", "e4", "e1", "e2", "e1", "e1", "e4", "e4", "e1", "e2", "e4" }
		Infantry = { "e4", "e1", "e1", "e2", "e1", "e2", "e1", "e1" }
		Vehicles = { "arty", "arty", "arty", "arty", "ftrk", "ftrk", "ftrk", "apc", "apc", "apc" }
		Tank = { "3tnk", "3tnk", "3tnk", "3tnk" }
		LongRange = { "v2rl", "v2rl", "v2rl", "v2rl" }
		Boss = { "4tnk", "4tnk", "4tnk" }
		Swarm = { "shok", "shok", "shok", "shok", "shok", "shok", "shok", "shok", "shok", "ttnk", "ttnk", "ttnk", "ttnk", "ttnk" }
	elseif EnemyType == "monsters" then
		Patrol = { "pvice", "bspi", "pvice", "bspi", "pvice", "bspi" }
		Infantry = { "bspi", "pvice", "pvice", "bspi", "pvice", "pvice", "pvice", "bspi", "ufo", "ufo" }
		Vehicles = { "reve", "reve", "reve", "reve", "reve", "reve" }
		Tank = { "imp", "imp", "imp", "imp", "imp" }
		LongRange = { "pinky", "pinky", "pinky", "pinky", "pinky" }
		Boss = { "manc", "exciter", "exciter" }
		Swarm = { "mechwarrior", "mechwarrior", "bspi", "bspi", "bspi", "bspi", "bspi", "bspi", "bspi", "bspi", "bspi", "bspi", "pvice", "pvice", "pvice", "pvice", "pvice", "pvice", "pvice", "pvice", "pvice", "pvice"  }
	elseif EnemyType == "mixed" then
		Patrol = { "pvice", "e2", "pvice", "e1", "pvice", "e4", "bspi", "bspi" }
		Infantry = { "e4", "pvice", "e1", "bspi", "pvice", "e2", "bspi", "e1", "ufo", "ufo" }
		Vehicles = { "reve", "arty", "ftrk", "reve", "apc", "reve" }
		Tank = { "3tnk", "3tnk", "imp", "imp" }
		LongRange = { "v2rl", "pinky", "v2rl", "pinky" }
		Boss = { "4tnk", "manc", "4tnk", "exciter" }
		Swarm = { "mechwarrior", "mechwarrior", "ttnk", "ttnk", "ttnk", "ttnk", "ttnk", "ttnk", "ufo", "ufo", "ufo", "ufo", "ufo", "ufo", "ufo", "ufo" }
	elseif EnemyType == "bosses" then
		Patrol = { "bspi", "reve", "apc", "ufo" }
		Infantry = { "mechwarrior", "pinky", "imp" }
		Vehicles = { "pinky", "ftrk", "apc" }
		Tank = { "3tnk", "3tnk", "3tnk" }
		LongRange = { "arty", "v2rl", "v2rl" }
		Boss = { "pinky", "manc", "tripod" }
		Swarm = { "exciter", "4tnk", "ufo" }
	end
end

Wave = 0
Waves =
{
	{ delay = 500, units = { Infantry } },
	{ delay = 500, units = { Patrol, Patrol } },
	{ delay = 700, units = { Infantry, Infantry, Vehicles }, },
	{ delay = 1500, units = { Infantry, Infantry, Infantry, Infantry } },
	{ delay = 1500, units = { Infantry, Infantry, Patrol, Vehicles } },
	{ delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Tank, Vehicles } },
	{ delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Tank, Tank, Swarm } },
	{ delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry, LongRange } },
	{ delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry, Infantry, LongRange, Tank, LongRange } },
	{ delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry, Infantry, Infantry, LongRange, LongRange, Tank, Tank, Vehicles } },
	{ delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry, Infantry, Infantry, Infantry, Boss, Swarm } }
}

-- Now do some adjustments to the waves
if Difficulty == "tough" or Difficulty == "endless" then
	Waves[8] = { delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry }, ironUnits = { LongRange } }
	Waves[9] = { delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry, Infantry, Infantry, LongRange, LongRange, Vehicles, Tank }, ironUnits = { Tank } }
	Waves[11] = { delay = 1500, units = { Vehicles, Infantry, Patrol, Patrol, Patrol, Infantry, LongRange, Tank, Boss, Infantry, Infantry, Patrol } }
end

IdleHunt = function(actor)
	Trigger.OnIdle(actor, function(a)
		if a.IsInWorld then
			a.Hunt()
		end
	end)
end

SendUnits = function(entryCell, unitTypes, targetCell, extraData)
	Reinforcements.Reinforce(soviets, unitTypes, { entryCell }, 40, function(a)
		if not a.HasProperty("AttackMove") then
			Trigger.OnIdle(a, function(a)
				a.Move(targetCell)
			end)
			return
		end

		a.AttackMove(targetCell)
		Trigger.OnIdle(a, function(a)
			a.Hunt()
		end)

		if extraData == "IronCurtain" then
			a.GrantCondition("invulnerability", DateTime.Seconds(25))
		end
	end)
end

SendWave = function()
	Wave = Wave + 1
	local wave = Waves[Wave]
	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(SovietEntryPoints).Location
			local target = Utils.Random(SpawnPoints).Location

			SendUnits(entry, units, target)
		end)

		if wave.ironUnits then
			Utils.Do(wave.ironUnits, function(units)
				local entry = Utils.Random(SovietEntryPoints).Location
				local target = Utils.Random(SpawnPoints).Location

				SendUnits(entry, units, target, "IronCurtain")
			end)
		end

		Utils.Do(players, function(player)
			Media.PlaySpeechNotification(player, "EnemyUnitsApproaching")
		end)

		if (Wave < #Waves) then
			if Utils.RandomInteger(1, 100) < ParaChance then
					local aircraft = ParaProxy.TargetParatroopers(Utils.Random(ParadropWaypoints).CenterPosition)
					Utils.Do(aircraft, function(a)
						Trigger.OnPassengerExited(a, function(t, p)
							IdleHunt(p)
						end)
					end)
				local delay = Utils.RandomInteger(DateTime.Seconds(15), DateTime.Seconds(25))
				Trigger.AfterDelay(delay, SendWave)
			else
				SendWave()
			end
		else
			if Difficulty == "endless" then
				Wave = 0
				IncreaseDifficulty()
				SendWave()
				return
			end

			Trigger.AfterDelay(DateTime.Minutes(1), SovietsRetreating)
			Media.DisplayMessage("You almost survived the onslaught! Last wave incoming.")
		end
	end)
end

SovietsRetreating = function()
	Utils.Do(Snipers, function(a)
		if not a.IsDead and a.Owner == soviets then
			a.Destroy()
		end
	end)
	Trigger.AfterDelay(DateTime.Seconds(5), function() -- Sometimes the game doesnt end because one of the snipers is not removed, so i added this
		Sniper = soviets.GetActorsByType("sniper")
		for p,snip in pairs(Sniper) do
			snip.Destroy()
		end
	end)
end

MonstersOn = function()
	Utils.Do(Snipers, function(a)
		if not a.IsDead and a.Owner == soviets then
			a.GrantCondition("noattack", 0)
		end
	end)
end

IncreaseDifficulty = function()
	local additions = { Infantry, Patrol, Vehicles, Tank, LongRange, Boss, Swarm }
	Utils.Do(Waves, function(wave)
		wave.units[#wave.units + 1] = Utils.Random(additions)
	end)
end

Tick = function()
	UserInterface.SetMissionText("Wave: " .. Wave .. "", HSLColor.White)
end

SetupWallOwners = function()
	Utils.Do(players, function(player)
		Utils.Do(Walls[player.Spawn], function(wall)
			wall.Owner = player
		end)
	end)
end

CheckOilPositions = function()
	if Player1 ~= nil then
		OilDerrick1 = Player1.GetActorsByType("oilb")
		for p,oil in pairs(OilDerrick1) do
			P1OilPosition = oil.CenterPosition
		end
	end
	if Player2 ~= nil then
		OilDerrick2 = Player2.GetActorsByType("oilb")
		for p,oil in pairs(OilDerrick2) do
			P2OilPosition = oil.CenterPosition
		end
	end
	if Player3 ~= nil then
		OilDerrick3 = Player3.GetActorsByType("oilb")
		for p,oil in pairs(OilDerrick3) do
			P3OilPosition = oil.CenterPosition
		end
	end
	if Player4 ~= nil then
		OilDerrick4 = Player4.GetActorsByType("oilb")
		for p,oil in pairs(OilDerrick4) do
			P4OilPosition = oil.CenterPosition
		end
	end
end
MoneyCompensatorP1 = function()
	if Player1.Cash > 6500 then
		if Player2 ~= nil and Player2.Cash < 1000 then
			Player1.Cash = Player1.Cash - 500
			Player2.Cash = Player2.Cash + 500
			Media.FloatingText("-500 $", P1OilPosition, 40, HSLColor.Red)
			Media.FloatingText("+500 $", P2OilPosition, 40, HSLColor.LawnGreen)
		end
		Trigger.AfterDelay(100, function()
			if Player3 ~= nil and Player3.Cash < 1000 then
				Player1.Cash = Player1.Cash - 500
				Player3.Cash = Player3.Cash + 500
				Media.FloatingText("-500 $", P1OilPosition, 40, HSLColor.Red)
				Media.FloatingText("+500 $", P3OilPosition, 40, HSLColor.LawnGreen)
			end
		end)
		Trigger.AfterDelay(200, function()
			if Player4 ~= nil and Player4.Cash < 1000 then
				Player1.Cash = Player1.Cash - 500
				Player4.Cash = Player4.Cash + 500
				Media.FloatingText("-500 $", P1OilPosition, 40, HSLColor.Red)
				Media.FloatingText("+500 $", P4OilPosition, 40, HSLColor.LawnGreen)
			end
		end)
	end
	Trigger.AfterDelay(Utils.RandomInteger(321, 789), MoneyCompensatorP1)
end
MoneyCompensatorP2 = function()
	if Player2.Cash > 6500 then
		if Player3 ~= nil and Player3.Cash < 1000 then
			Player2.Cash = Player2.Cash - 500
			Player3.Cash = Player3.Cash + 500
			Media.FloatingText("-500 $", P2OilPosition, 40, HSLColor.Red)
			Media.FloatingText("+500 $", P3OilPosition, 40, HSLColor.LawnGreen)
		end
		Trigger.AfterDelay(100, function()
			if Player4 ~= nil and Player4.Cash < 1000 then
				Player2.Cash = Player2.Cash - 500
				Player4.Cash = Player4.Cash + 500
				Media.FloatingText("-500 $", P2OilPosition, 40, HSLColor.Red)
				Media.FloatingText("+500 $", P4OilPosition, 40, HSLColor.LawnGreen)
			end
		end)
		Trigger.AfterDelay(200, function()
			if Player1 ~= nil and Player1.Cash < 1000 then
				Player2.Cash = Player2.Cash - 500
				Player1.Cash = Player1.Cash + 500
				Media.FloatingText("-500 $", P2OilPosition, 40, HSLColor.Red)
				Media.FloatingText("+500 $", P1OilPosition, 40, HSLColor.LawnGreen)
			end
		end)
	end
	Trigger.AfterDelay(Utils.RandomInteger(321, 789), MoneyCompensatorP2)
end
MoneyCompensatorP3 = function()
	if Player3.Cash > 6500 then
		if Player4 ~= nil and Player4.Cash < 1000 then
			Player3.Cash = Player3.Cash - 500
			Player4.Cash = Player4.Cash + 500
			Media.FloatingText("-500 $", P3OilPosition, 40, HSLColor.Red)
			Media.FloatingText("+500 $", P4OilPosition, 40, HSLColor.LawnGreen)
		end
		Trigger.AfterDelay(100, function()
			if Player1 ~= nil and Player1.Cash < 1000 then
				Player3.Cash = Player3.Cash - 500
				Player1.Cash = Player1.Cash + 500
				Media.FloatingText("-500 $", P3OilPosition, 40, HSLColor.Red)
				Media.FloatingText("+500 $", P1OilPosition, 40, HSLColor.LawnGreen)
			end
		end)
		Trigger.AfterDelay(200, function()
			if Player2 ~= nil and Player2.Cash < 1000 then
				Player3.Cash = Player3.Cash - 500
				Player2.Cash = Player2.Cash + 500
				Media.FloatingText("-500 $", P3OilPosition, 40, HSLColor.Red)
				Media.FloatingText("+500 $", P2OilPosition, 40, HSLColor.LawnGreen)
			end
		end)
	end
	Trigger.AfterDelay(Utils.RandomInteger(321, 789), MoneyCompensatorP3)
end
MoneyCompensatorP4 = function()
	if Player4.Cash > 6500 then
		if Player1 ~= nil and Player1.Cash < 1000 then
			Player4.Cash = Player4.Cash - 500
			Player1.Cash = Player1.Cash + 500
			Media.FloatingText("-500 $", P4OilPosition, 40, HSLColor.Red)
			Media.FloatingText("+500 $", P1OilPosition, 40, HSLColor.LawnGreen)
		end
		Trigger.AfterDelay(100, function()
			if Player2 ~= nil and Player2.Cash < 1000 then
				Player4.Cash = Player4.Cash - 500
				Player2.Cash = Player2.Cash + 500
				Media.FloatingText("-500 $", P4OilPosition, 40, HSLColor.Red)
				Media.FloatingText("+500 $", P2OilPosition, 40, HSLColor.LawnGreen)
			end
		end)
		Trigger.AfterDelay(200, function()
			if Player3 ~= nil and Player3.Cash < 1000 then
				Player4.Cash = Player4.Cash - 500
				Player3.Cash = Player3.Cash + 500
				Media.FloatingText("-500 $", P4OilPosition, 40, HSLColor.Red)
				Media.FloatingText("+500 $", P3OilPosition, 40, HSLColor.LawnGreen)
			end
		end)
	end
	Trigger.AfterDelay(Utils.RandomInteger(321, 789), MoneyCompensatorP4)
end
WorldLoaded = function()
	soviets = Player.GetPlayer("Soviets")
	players = { }
	for i = 0, 4 do
		local player = Player.GetPlayer("Multi" ..i)
		players[i] = player

		if players[i] and players[i].IsBot then
			ActivateAI(players[i], i)
		end
	end
	Player1 = Player.GetPlayer("Multi0")
	Player2 = Player.GetPlayer("Multi1")
	Player3 = Player.GetPlayer("Multi2")
	Player4 = Player.GetPlayer("Multi3")
	Media.DisplayMessage("Defend Fort Monstar at all costs!")

	SetupWallOwners()

	ParaProxy = Actor.Create("powerproxy.paratroopers", false, { Owner = soviets })
	SendWave()
	if EnemyType == "monsters" or EnemyType == "bosses" then
		Trigger.AfterDelay(DateTime.Seconds(1), MonstersOn)
	end
	CheckOilPositions()
	if Player1 ~= nil then
		MoneyCompensatorP1()
	end
	if Player2 ~= nil then
		MoneyCompensatorP2()
	end
	if Player3 ~= nil then
		MoneyCompensatorP3()
	end
	if Player4 ~= nil then
		MoneyCompensatorP4()
	end
end