CanAttackFromSouth = true
CanAttackFromIsland = true
DifficultySetting = Map.LobbyOption("difficulty")

StrikeForceList = { "warriorant", "warriorant", "warriorant", "warriorant", "warriorant", "fireant", "fireant", "fireant", "fireant" }

AntLists = {
	easy = {
		"fireant", "fireant",
		"scoutant", "scoutant",
		"warriorant", "warriorant", "warriorant",
	},

	normal = {
		"fireant", "fireant", "fireant",
		"scoutant", "scoutant", "scoutant", "scoutant" ,
		"warriorant", "warriorant", "warriorant", "warriorant", "warriorant" 
	},

	hard = {
		"fireant", "fireant", "fireant", "fireant", "fireant",
		"scoutant", "scoutant", "scoutant", "scoutant", "scoutant", 
		"warriorant", "warriorant", "warriorant", "warriorant", "warriorant", "warriorant", "warriorant", "warriorant" 
	}
}

AttackDirection = { "north", "middle", "south" }

Pathing = {
	north = {
		{ waypoint0.Location, waypoint12.Location }, 
		waypoint18.Location
	},

	middle = {
		{ waypoint1.Location, waypoint11.Location },
		waypoint35.Location
	},

	south = {
		{ waypoint2.Location, waypoint95.Location }, 
		waypoint20.Location
	}
}

StartAttack = function()

	--Applying the Production Multiplier for Ant Reinforcements instead
	local multiplier
	local playerCount = GetCoopPlayerCount()

	if Map.LobbyOption("prmp") == "999" then
		multiplier = playerCount - 1
	else
		multiplier = tonumber(Map.LobbyOptionOrDefault("prmp", "0"))
	end
	--Media.DisplayMessage("Enemy Multiplier is at " .. multiplier .. "x")
	--All Ready
	
	local direction = Utils.Random(AttackDirection)
	local shouldLaunchAttack = true

	if direction ~= "south" and not CanAttackFromIsland then
		shouldLaunchAttack = false
	elseif not CanAttackFromSouth then
		shouldLaunchAttack = false
	end

	if shouldLaunchAttack then
		local pathAndPoint = Pathing[direction]
		OGAnts = Reinforcements.Reinforce(PatrolAnts, AntLists[DifficultySetting], pathAndPoint[1], DateTime.Seconds(75/#CoopPlayers), function(ant)
			ant.AttackMove(pathAndPoint[2])
			Trigger.OnIdle(ant, function(actor)
				actor.Hunt()
			end)
		end)
		Utils.Do(OGAnts, function(NewestAnt)
			Trigger.OnAddedToWorld(NewestAnt, function()
				for _ = 1, multiplier do
					local CopyAnt = Actor.Create(NewestAnt.Type, false, { Owner = NewestAnt.Owner, Location = NewestAnt.Location })
					--Media.DisplayMessage("Ant multiplied")
					--Wait a moment before letting the Ants appear, to give the original squad time to move ahead
					Trigger.AfterDelay(120, function()
						CopyAnt.IsInWorld = true
						CopyAnt.Scatter()
					end)
					Trigger.OnIdle(CopyAnt, function()
						if CopyAnt.HasProperty("Hunt") then
							if NewestAnt.IsDead then
								CopyAnt.Hunt()
								return
							end
						end
						if CopyAnt.HasProperty("Guard") then
							CopyAnt.Guard(NewestAnt)
						end
					end)
				end
			end)
		end)
	end
end

StopIslandAttacks = function()
	CanAttackFromIsland = false
end

StopSouthernAttacks = function()
	CanAttackFromSouth = false
end

StartNorthAttack = function()
	if CanAttackFromNorth then
		local attackPath = { waypoint0.Location, waypoint12.Location }
		return SpawnVillageAttack(attackPath, Actor192.Location)
	end
end

StartSouthAttack = function()
	if CanAttackFromSouth then
		local attackPath = { waypoint2.Location, waypoint8.Location }
		return SpawnVillageAttack(attackPath, Church.Location)
	end
end

SpawnVillageAttack  = function(attackPath, attackPoint) 
	return Reinforcements.Reinforce(AttackAnts, StrikeForceList, attackPath, DateTime.Seconds(5), function(ant)
		Trigger.OnIdle(ant, function(actor)
			actor.Hunt()
		end)
	end)

end

InitAntPlayers = function()
	PatrolAnts = Player.GetPlayer("PatrolAnts")
	AttackAnts = Player.GetPlayer("AttackAnts")
end
