--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

--Boolean Vars
baseDiscovered = false
AtEndGame = false

--Basic Vars
TimerColor = Player.GetPlayer("GoodGuy").Color
InsertionHelicopterType = "tran.insertion"
TimerTicks = DateTime.Minutes(18) -- 18 minutes is roughly 30 mins in the original game
Ticks = TimerTicks

--Table Vars
TankPath = { waypoint12.Location, waypoint13.Location }
InsertionPath = { waypoint12.Location, waypoint0.Location }
AlliedBase = { WarFactory, PillBox1, PillBox2, Refinery, PowerPlant1, PowerPlant2, RepairPad, OreSilo, Barracks, RadarDome }
AlliedForces = { "2tnk" , "2tnk", "mcv" }
ChopperTeam = { "e1r1", "e1r1", "e2", "e2", "e1r1" }

SendTanks = function()
	Media.PlaySpeechNotification(All, "ReinforcementsArrived")
	Reinforcements.Reinforce(GoodGuy, AlliedForces, TankPath, DateTime.Seconds(1))
end

SendInsertionHelicopter = function()
	Media.PlaySpeechNotification(All, "AlliedReinforcementsSouth")
	Reinforcements.ReinforceWithTransport(GoodGuy, InsertionHelicopterType, ChopperTeam, InsertionPath, { waypoint4.Location })
end

AlliedForcesHaveArrived = UserInterface.GetFluentMessage("allied-forces-have-arrived")
FinishTimer = function()
	for i = 0, 9, 1 do
		local c = TimerColor
		if i % 2 == 0 then
			c = HSLColor.White
		end
		Trigger.AfterDelay(DateTime.Seconds(i), function() UserInterface.SetMissionText(AlliedForcesHaveArrived, c) end)
	end
	Trigger.AfterDelay(DateTime.Seconds(10), function() UserInterface.SetMissionText("") end)
end

TimerExpired = function()
	Allies.MarkCompletedObjective(SurviveObjective)
end

DiscoveredAlliedBase = function(actor, discoverer)
	if (not baseDiscovered and IsOwnedByCoopPlayer(discoverer)) then
		baseDiscovered = true
		Media.PlaySpeechNotification(All, "ObjectiveReached")
		Utils.Do(AlliedBase, function(building)
			building.Owner = Allies
		end)

		--Need to delay this so we don't fail mission before obj added
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			SurviveObjective = AddPrimaryObjective(Allies, "defend-outpost-until-reinforcements-arrive")
			SetupTimeNotifications()
			Trigger.OnAllRemovedFromWorld(AlliedBase, function()
				Allies.MarkFailedObjective(SurviveObjective)
			end)
			Media.PlaySpeechNotification(All, "TimerStarted")
			Trigger.AfterDelay(DateTime.Seconds(2), function() Allies.MarkCompletedObjective(DiscoverObjective) end)
			Creeps.GetActorsByType("harv")[1].FindResources()
			Creeps.GetActorsByType("harv")[1].Owner = Allies
		end)
	end
end

SetupTimeNotifications = function()
	Trigger.AfterDelay(DateTime.Minutes(8), function()
		Media.PlaySpeechNotification(All, "TenMinutesRemaining")
	end)

	Trigger.AfterDelay(DateTime.Minutes(13), function()
		Media.PlaySpeechNotification(All, "WarningFiveMinutesRemaining")
	end)

	Trigger.AfterDelay(DateTime.Minutes(14), function()
		Media.PlaySpeechNotification(All, "WarningFourMinutesRemaining")
	end)

	Trigger.AfterDelay(DateTime.Minutes(15), function()
		Media.PlaySpeechNotification(All, "WarningThreeMinutesRemaining")
	end)

	Trigger.AfterDelay(DateTime.Minutes(16), function()
		Media.PlaySpeechNotification(All, "WarningTwoMinutesRemaining")
	end)

	Trigger.AfterDelay(DateTime.Minutes(17), function()
		Media.PlaySpeechNotification(All, "WarningOneMinuteRemaining")
	end)

	Trigger.AfterDelay(DateTime.Minutes(17) + DateTime.Seconds(40), function()
		Media.PlaySpeechNotification(All, "AlliedForcesApproaching")
	end)
end

GetTicks = function()
	return Ticks
end

ResourceSharing = function()
	if ResourcePool >= #CoopPlayers then
		Utils.Do(CoopPlayers, function(player)
			player.Cash = player.Cash + 1
		end)
		ResourcePool = ResourcePool - #CoopPlayers
		ResourceSharing()
	end
end

GiveRadar = function()
	if not RadarDome.IsDead and RadarDome.Owner == Allies and Allies.PowerState ~= "Critical" then
		Utils.Do(CoopPlayers, function(PID)
			if PID ~= Allies and #PID.GetActorsByType("proxydome") == 0 then
				Actor.Create("proxydome", true, { Owner = PID, Location = CPos.New(0, 0) })
			end
		end)
	else
		Utils.Do(CoopPlayers, function(PID)
			Utils.Do(PID.GetActorsByType("proxydome"), function(UID)
				UID.Destroy()
			end)
		end)
	end
	Trigger.AfterDelay(5, function()
		GiveRadar()
	end)
end

Tick = function()
	--ResourcePool = ResourcePool + Allies.Resources
	--Allies.Resources = 0
	--ResourceSharing()
	Utils.Do(CoopPlayers, function(player)
		if player ~= Spain then
			Utils.Do(player.GetActorsByType("harv"), function(actor)
				actor.Owner = Allies
			end)
		end
	end)
	
	if SurviveObjective ~= nil then
		if Ticks > 0 then
			if Ticks == DateTime.Minutes(17) then
				StartAntAttack()
			elseif Ticks == DateTime.Minutes(15) then
				SendInsertionHelicopter()
			elseif Ticks == DateTime.Minutes(12) then
				StartAntAttack()
			elseif Ticks == DateTime.Minutes(6) then
				StartAntAttack()
			elseif Ticks == DateTime.Minutes(1) then
				EndAntAttack()
			end

			Ticks = Ticks - 1;
			if (Ticks % DateTime.Seconds(1)) == 0 then
				Timer = UserInterface.GetFluentMessage("reinforcements-arrive-in", { ["time"] = Utils.FormatTime(Ticks) })
				UserInterface.SetMissionText(Timer, TimerColor)
			end
		else
			if not AtEndGame then
				Media.PlaySpeechNotification(All, "SecondObjectiveMet")
				AtEndGame = true
				FinishTimer()
				Camera.Position = waypoint13.CenterPosition
				SendTanks()
				Trigger.AfterDelay(DateTime.Seconds(2), function() TimerExpired() end)
			end
			Ticks = Ticks - 1
		end
	end
end

AddObjectives = function()
	InitObjectives(Allies)

	DiscoverObjective = AddPrimaryObjective(Allies, "find-outpost")

	Utils.Do(AlliedBase, function(actor)
		Trigger.OnEnteredProximityTrigger(actor.CenterPosition, WDist.FromCells(8), function(discoverer, id)
			DiscoveredAlliedBase(actor, discoverer)
		end)
	end)

	Trigger.AfterDelay(DateTime.Seconds(1), function()
		Creeps.GetActorsByType("harv")[1].Stop()
	end)

	Camera.Position = Ranger.CenterPosition
end

WorldLoaded = function()
	Allies = Player.GetPlayer("Spain")
	AntMan = Player.GetPlayer("AntMan")
	Creeps = Player.GetPlayer("Creeps")
	
	ResourcePool = 0
	local coopInfo =
	{
		FMVBriefing = "antintro.vqa",
		Mainplayer = Allies,
		MainEnemies = {AntMan},
		Dummyplayer = Player.GetPlayer("GoodGuy")
	}
	
	CoopInit25(coopInfo)
	
	--Override Sharing options
	BaseShared = true
	TechShared = true
	MoneyShareOverride = 100
	
	
	if #CoopPlayers >= 6 then
		Extraguy = Actor.Create("e1", true, { Owner = CoopPlayers[6], Location = Johnathan.Location})
		Extraguy.Scatter()
	end
	
	GiveRadar()
	
	AddObjectives()
	Trigger.OnKilled(MoneyDerrick, function()
		Actor.Create("moneycrate", true, { Owner = Allies, Location = MoneyDerrick.Location + CVec.New(1,0) })
	end)
	Trigger.OnKilled(MoneyBarrel, function()
		Actor.Create("moneycrate", true, { Owner = Allies, Location = MoneyBarrel.Location})
	end)
end
