--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

if Difficulty == "easy" then
	TanyaType = "e7"
	ReinforceCash = 5000
	HoldAITime = DateTime.Minutes(3)
	SpecialCameras = true
elseif Difficulty == "normal" then
	TanyaType = "e7.noautotarget"
	ReinforceCash = 2250
	HoldAITime = DateTime.Minutes(2)
	SpecialCameras = true
else
	TanyaType = "e7.noautotarget"
	ReinforceCash = 1500
	HoldAITime = DateTime.Minutes(1) + DateTime.Seconds(30)
	SendWaterTransports = true
end

Engicount = 0
SpyType = {}
SpyEntryPath = { SpyEntry.Location, SpyLoadout.Location }
InsertionTransport = "lst.in"
ExtractionTransport = "lst"
TrukPath = { TrukWaypoint1, TrukWaypoint2, TrukWaypoint3, TrukWaypoint4, TrukWaypoint5, TrukWaypoint6 }
ExtractionHeliType = "tran"
InsertionHeliType = "tran.in"
ExtractionPath = { ExtractionEntry.Location, ExtractionLZ.Location }
HeliReinforcements = { "medi", "mech", "mech" }

GreeceReinforcements =
{
	{ types = { "2tnk", "2tnk", "2tnk", "arty", "arty" }, entry = { SpyEntry.Location, SpyLoadout.Location } },
	{ types = { "e3", "e3", "e3", "e6", "e6" }, entry = { SpyEntry.Location, GreeceLoadout1.Location } },
	{ types = { "jeep", "jeep", "e1", "e1", "2tnk" }, entry = { SpyEntry.Location, GreeceLoadout2.Location } }
}

DogPatrol = { Dog1, Dog2 }
PatrolA = { PatrolA1, PatrolA2, PatrolA3, PatrolA4, PatrolA5 }
PatrolB = { PatrolB1, PatrolB2, PatrolB3 }

DogPatrolPath = { DogPatrolRally1.Location, DogPatrolRally2.Location, DogPatrolRally3.Location }
PatrolAPath = { PatrolRally.Location, PatrolARally1.Location, PatrolARally2.Location, PatrolARally3.Location }
PatrolBPath = { PatrolBRally1.Location, PatrolBRally2.Location, PatrolBRally3.Location, PatrolRally.Location }

TanyaVoices = { "tuffguy", "bombit", "laugh", "gotit", "lefty", "keepem" }
SpyVoice = "sking"
SamSites = { Sam1, Sam2, Sam3, Sam4 }

GroupPatrol = function(units, waypoints, delay)
	local i = 1
	local stop = false

	Utils.Do(units, function(unit)
		Trigger.OnIdle(unit, function()
			if stop then
				return
			end

			if unit.Location == waypoints[i] then
				local bool = Utils.All(units, function(actor) return actor.IsIdle end)

				if bool then
					stop = true

					i = i + 1
					if i > #waypoints then
						i = 1
					end

					Trigger.AfterDelay(delay, function() stop = false end)
				end
			else
				unit.AttackMove(waypoints[i])
			end
		end)
	end)
end

Tick = function()

	for _, UID in ipairs(GoodGuy.GetActorsByType("e6")) do
		if Engicount > 0 and #CoopPlayers > 2 then
			UID.IsInWorld = false
		end
		
		if Engicount == 0 and #CoopPlayers > 2 then
			for _, PID in ipairs(CoopPlayers) do
				Extraengineer = Actor.Create(UID.Type, true, { Owner = PID, Location = UID.Location })
				Extraengineer.Scatter()
			end
			UID.IsInWorld = false
			Engicount = Engicount +1
		end
		
		if #CoopPlayers <= 2 then
			CurrentPlayer = CoopPlayers[CoopCurrent]
			UID.Owner = CurrentPlayer
			CoopCurrent = CoopCurrent + 1
			if CoopCurrent > #CoopPlayers then
				CoopCurrent = 1
			end
		end
	end
	
	if FollowTruk and not Truk.IsDead then
		Camera.Position = Truk.CenterPosition
	end

	if USSR.HasNoRequiredUnits() then
		if not Greece.IsObjectiveCompleted(KillAll) and Difficulty == "tough" then
			SendWaterExtraction()
		end
		for _, PID in ipairs(CoopPlayers) do
		PID.MarkCompletedObjective(KillAll)
		end
	end
	
	Lostcount = 0
	for _, PID in ipairs(CoopPlayers) do
		if TeamLanded and PID.HasNoRequiredUnits() then
			Lostcount = Lostcount + 1
		end
	end
	
	if Lostcount >= #CoopPlayers then
		USSR.MarkCompletedObjective(USSRobjective)
	end

	if USSR.Resources >= USSR.ResourceCapacity * 0.75 then
		USSR.Cash = USSR.Cash + USSR.Resources - USSR.ResourceCapacity * 0.25
		USSR.Resources = USSR.ResourceCapacity * 0.25
	end
end

SendReinforcements = function()
	Teamlanded = false
	GreeceReinforcementsArrived = true
	Camera.Position = ReinforceCamera.CenterPosition
	for _, PID in ipairs(CoopPlayers) do
	PID.Cash = Greece.Cash + ReinforceCash
	end

	Utils.Do(GreeceReinforcements, function(reinforcements)
		Reinforcements.ReinforceWithTransport(GoodGuy, InsertionTransport, reinforcements.types, reinforcements.entry, { SpyEntry.Location })
	end)

	Media.PlaySpeechNotification(All, "AlliedReinforcementsArrived")

	ActivateAI()
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		Teamlanded = true
	end)
end

ExtractUnits = function(extractionUnit, pos, after)
	if extractionUnit.IsDead or TanyasSaved == false then
		return
	end

	extractionUnit.Move(pos)
	extractionUnit.Destroy()

	Trigger.OnRemovedFromWorld(extractionUnit, after)
end

SendWaterExtraction = function()
	local flare = Actor.Create("flare", true, { Owner = GoodGuy, Location = SpyEntryPath[2] + CVec.New(2, 0) })
	Trigger.AfterDelay(DateTime.Seconds(5), flare.Destroy)
	Media.PlaySpeechNotification(All, "SignalFlareNorth")
	Camera.Position = flare.CenterPosition

	WaterExtractionTran = Reinforcements.ReinforceWithTransport(GoodGuy, ExtractionTransport, nil, SpyEntryPath)[1]
	ExtractObjective = AddPrimaryObjective(Greece, "extract-transport")

	Trigger.OnKilled(WaterExtractionTran, function() USSR.MarkCompletedObjective(USSRobjective) end)
	WExtractionstarted = false
	Trigger.OnPassengerEntered(WaterExtractionTran, function()
		if WExtractionstarted == false then
			WExtractionstarted = true
			TanyasSaved = true
			for _, PID in ipairs(CoopPlayers) do
				for _, UID in ipairs (PID.GetGroundAttackers()) do
					UID.Health = 0
				end
			end
	--Trigger.OnAllRemovedFromWorld(Greece.GetGroundAttackers(), function()
			ExtractUnits(WaterExtractionTran, SpyEntryPath[1], function()
				for _, PID in ipairs(CoopPlayers) do
					PID.MarkCompletedObjective(ExtractObjective)
					PID.MarkCompletedObjective(TanyaSurviveObjective)
				end
			end)
		end
	end)
end

WarfactoryInfiltrated = function()
	FollowTruk = true
	Truk.GrantCondition("hijacked")

	Truk.Wait(DateTime.Seconds(1))
	Utils.Do(TrukPath, function(waypoint)
		Truk.Move(waypoint.Location)
	end)

	if SpecialCameras then
		Trigger.AfterDelay(DateTime.Seconds(2), function()
			SpyCameraA.Destroy()
			SpyCameraB.Destroy()
		end)
	end
end

MissInfiltrated = function()
	for i = 0, 5, 1 do
		local sound = Utils.Random(TanyaVoices)
		Trigger.AfterDelay(DateTime.Seconds(i), function()
			Media.PlaySoundNotification(All, sound)
		end)
	end
	Prison.Attack(Prison)

	Trigger.AfterDelay(DateTime.Seconds(6), FreeTanya)
end

FreeTanya = function()
	Prison.Stop()
	AllTanyas = {}
	for _, PID in ipairs(CoopPlayers) do
	Tanya = Actor.Create(TanyaType, true, { Owner = PID, Location = Prison.Location + CVec.New(1, 1) })
	table.insert(AllTanyas, Tanya)
		if PID == Greece then
			Tanya.Demolish(Prison)
		end
	Tanya.Move(Tanya.Location + CVec.New(Utils.RandomInteger(-1, 2), 1))
	end

	if TanyaType == "e7.noautotarget" then
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Media.DisplayMessage(UserInterface.GetFluentMessage("tanya-rules-of-engagement"), UserInterface.GetFluentMessage("tanya"))
		end)
	end
	
	TanyasSaved = false
	Trigger.OnAllKilled(AllTanyas, function()
		if TanyasSaved == false then
			USSR.MarkCompletedObjective(USSRobjective)
		end
	end)

	if Difficulty == "tough" then
		KillSams = AddPrimaryObjective(Greece, "destroy-sam-sites-blocker")
		
		for _, PID in ipairs(CoopPlayers) do
		PID.MarkCompletedObjective(RescueTanyaObjective)
		end
		
		TanyaSurviveObjective = AddPrimaryObjective(Greece, "tanya-survive")
		Media.PlaySpeechNotification(All, "TanyaRescued")
	else
		KillSams = AddPrimaryObjective(Greece, "destroy-sam-sites-blocker")

		Media.PlaySpeechNotification(All, "TargetFreed")
	end

	if not SpecialCameras and PrisonCamera and PrisonCamera.IsInWorld then
		PrisonCamera.Destroy()
	end
end

SendSpy = function()
	AllSpies = {}
	SpiesDone = false
	Camera.Position = SpyEntry.CenterPosition
	for _, PID in ipairs(CoopPlayers) do
		table.insert(SpyType, "spy")
	end
	Spy = Reinforcements.ReinforceWithTransport(GoodGuy, InsertionTransport, SpyType, SpyEntryPath, { SpyEntryPath[1] })[2][1]

	if SpecialCameras then
		SpyCameraA = Actor.Create("camera", true, { Owner = Greece, Location = SpyCamera1.Location })
		SpyCameraB = Actor.Create("camera", true, { Owner = Greece, Location = SpyCamera2.Location })
	end

	Trigger.AfterDelay(DateTime.Seconds(5), function()
		for _, PID in ipairs(CoopPlayers) do
			Playerspies = PID.GetActorsByType ("spy")
			table.insert(AllSpies, Playerspies[1])
		end
		
		Trigger.OnAllKilled(AllSpies, function()
			if SpiesDone == false then
				USSR.MarkCompletedObjective(USSRobjective)
			end
		end)
		Media.DisplayMessage(UserInterface.GetFluentMessage("disguise-spy"), UserInterface.GetFluentMessage("spy"))
	end)
end

ActivatePatrols = function()
	GroupPatrol(DogPatrol, DogPatrolPath, DateTime.Seconds(2))

	Trigger.AfterDelay(DateTime.Seconds(3), function()
		GroupPatrol(PatrolA, PatrolAPath, DateTime.Seconds(7))
		GroupPatrol(PatrolB, PatrolBPath, DateTime.Seconds(6))
	end)
end

InitTriggers = function()
	Trigger.OnInfiltrated(Warfactory, function()
		SpiesDone = true
		if Greece.IsObjectiveCompleted(InfiltrateWarfactoryObjective) then
			return
		elseif Truk.IsDead then
			if not Greece.IsObjectiveCompleted(RescueTanyaObjective) then
				USSR.MarkCompletedObjective(USSRobjective)
			end

			return
		end
		
		for _, PID in ipairs(CoopPlayers) do
			for _, UID in ipairs (PID.GetGroundAttackers()) do
				UID.Health = 0
			end
		end
		
		for _, PID in ipairs(CoopPlayers) do
			PID.MarkCompletedObjective(InfiltrateWarfactoryObjective)
		end
		WarfactoryInfiltrated()
	end)
--end

	Trigger.OnKilled(Truk, function()
		if not Greece.IsObjectiveCompleted(InfiltrateWarfactoryObjective) then
			for _, PID in ipairs(CoopPlayers) do
			PID.MarkFailedObjective(InfiltrateWarfactoryObjective)
			end
		elseif FollowTruk then
			USSR.MarkCompletedObjective(USSRobjective)
		end
	end)

	Trigger.OnInfiltrated(Prison, function()
		if SpiesDone == false then
		SpiesDone = true
		for _, PID in ipairs(CoopPlayers) do
			for _, UID in ipairs (PID.GetGroundAttackers()) do
				UID.Health = 0
			end
		end
		
		if Greece.IsObjectiveCompleted(RescueTanyaObjective) then
			return
		end

		if not Greece.IsObjectiveCompleted(InfiltrateWarfactoryObjective) then
			Media.DisplayMessage(UserInterface.GetFluentMessage("skip-heroics"), UserInterface.GetFluentMessage("battlefield-control"))
			for _, PID in ipairs(CoopPlayers) do
			PID.MarkCompletedObjective(InfiltrateWarfactoryObjective)
			end
		end

		if not PrisonCamera then
			if SpecialCameras then
				PrisonCamera = Actor.Create("camera", true, { Owner = Greece, Location = TrukWaypoint5.Location })
			else
				PrisonCamera = Actor.Create("camera.small", true, { Owner = Greece, Location = Prison.Location + CVec.New(1, 1) })
			end
		end

		if SpecialCameras and SpyCameraA and not SpyCameraA.IsDead then
			SpyCameraA.Destroy()
			SpyCameraB.Destroy()
		end
		
		Trigger.AfterDelay(DateTime.Seconds(2), MissInfiltrated)
		end
	end)

	Trigger.OnEnteredFootprint({ TrukWaypoint5.Location }, function(a, id)
		if a == Truk then
			Trigger.RemoveFootprintTrigger(id)
			AllSpies = {}
			Spy = Actor.Create("spy", true, { Owner = Greece, Location = TrukWaypoint5.Location })
			Spy.DisguiseAsType("e1", USSR)
			Spy.Move(SpyWaypoint.Location)
			Spy.Infiltrate(Prison)
			table.insert(AllSpies, Spy)
			SpiesDone = false
			Media.PlaySoundNotification(All, SpyVoice)
			
			Trigger.OnAllKilled(AllSpies, function()
				if SpiesDone == false then
					USSR.MarkCompletedObjective(USSRobjective)
				end
			end)

			FollowTruk = false

			if SpecialCameras then
				PrisonCamera = Actor.Create("camera", true, { Owner = Greece, Location = TrukWaypoint5.Location })
			else
				PrisonCamera = Actor.Create("camera.small", true, { Owner = Greece, Location = Prison.Location + CVec.New(1, 1) })
			end

			--Trigger.OnKilled(Spy, function() USSR.MarkCompletedObjective(USSRobjective) end)
		end
	end)

	Trigger.OnEnteredFootprint({ TrukWaypoint6.Location }, function(a, id)
		if a == Truk then
			Trigger.RemoveFootprintTrigger(id)
			Truk.Stop()
			Truk.Kill()
			ExplosiveBarrel.Kill()
		end
	end)

	if Difficulty ~= "tough" then
		Trigger.OnKilled(Mammoth, function()
			Trigger.AfterDelay(HoldAITime - DateTime.Seconds(45), function() HoldProduction = false end)
			Trigger.AfterDelay(HoldAITime, function() Attacking = true end)
		end)
	end

	Trigger.OnKilled(FlameBarrel, function()
		if not FlameTower.IsDead then
			FlameTower.Kill()
		end
	end)

	Trigger.OnKilled(SamBarrel, function()
		if not Sam1.IsDead then
			Sam1.Kill()
		end
	end)

	Trigger.OnAllKilled(SamSites, function()
		for _, PID in ipairs(CoopPlayers) do
		PID.MarkCompletedObjective(KillSams)
		end

		local flare = Actor.Create("flare", true, { Owner = GoodGuy, Location = ExtractionPath[2] + CVec.New(0, -1) })
		Trigger.AfterDelay(DateTime.Seconds(7), flare.Destroy)
		Media.PlaySpeechNotification(All, "SignalFlare")

		if Difficulty == "tough" then
			Reinforcements.ReinforceWithTransport(GoodGuy, InsertionHeliType, HeliReinforcements, ExtractionPath, { ExtractionPath[1] })
			if not Harvester.IsDead then
				Harvester.FindResources()
			end

		else
			ExtractionHeli = Reinforcements.ReinforceWithTransport(GoodGuy, ExtractionHeliType, nil, ExtractionPath)[1]
			local exitPos = CPos.New(ExtractionPath[1].X, ExtractionPath[2].Y)

			Trigger.OnKilled(ExtractionHeli, function() USSR.MarkCompletedObjective(USSRobjective) end)
			Trigger.OnPassengerEntered(ExtractionHeli, function()
				TanyasSaved = true
				ExtractUnits(ExtractionHeli, exitPos, function()
					Media.PlaySpeechNotification(All, "TanyaRescued")
					Startphase2 = false
					for _, PID in ipairs(CoopPlayers) do
						for _, UID in ipairs (PID.GetGroundAttackers()) do
							UID.Health = 0
						end
						PID.MarkCompletedObjective(RescueTanyaObjective)
					end
					Trigger.AfterDelay(DateTime.Seconds(2), function()
						if Startphase2 == false then
							Startphase2 = true
							SendReinforcements()
						end
					end)

					if PrisonCamera and PrisonCamera.IsInWorld then
						PrisonCamera.Destroy()
					end
				end)
			end)
		end
	end)
end

AddObjectives = function()
	USSRobjective = AddPrimaryObjective(USSR, "")
	RescueTanyaObjective = AddPrimaryObjective(Greece, "rescue-tanya")
	KillAll = AddPrimaryObjective(Greece, "eliminate-soviet-units")
	InfiltrateWarfactoryObjective = AddSecondaryObjective(Greece, "infiltrate-warfactory")
end

WorldLoaded = function()
	Greece = Player.GetPlayer("Greece")
	USSR = Player.GetPlayer("USSR")
	
	FactoryCaptured = false
	SowietFactories = USSR.GetActorsByType("fact")
	for _, UID in ipairs(SowietFactories) do
		Trigger.OnCapture(UID, function(self, captor, oldOwner, newOwner)
			if FactoryCaptured == false then
				FactoryCaptured = true
				for n, PID in ipairs(CoopPlayers) do
					if PID ~= newOwner then
						local ExtraCon = Actor.Create(self.Type, true, { Owner = USSR, Location = self.Location + CVec.New(0, 1) })
						Trigger.AfterDelay(DateTime.Seconds(4), function()
							ExtraCon.Owner = PID
							ExtraCon.Deploy()
						end)
					end
				end
			end
		end)
	end
	
	--Mission specific Information for the Coop Base Script
	FMVBriefing = "ally5.vqa"
	FMVOpening = "tanya1.vqa"
	Enemyplayer = USSR
	--
	
	CoopInit()

	InitObjectives(Greece)
	AddObjectives()
	InitTriggers()
	SendSpy()

	Trigger.AfterDelay(DateTime.Seconds(3), ActivatePatrols)
end
