--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

TruckStops = { TruckStop1, TruckStop2, TruckStop3, TruckStop4, TruckStop5, TruckStop6, TruckStop7, TruckStop8 }
MissionStartAttackUnits = { StartAttack1tnk1, StartAttack1tnk2, StartAttackArty1, StartAttackArty2, StartAttackArty3 }
TruckEscape = { TruckEscape1, TruckEscape2, TruckEscape3, TruckEscape4, TruckEscape5, TruckEscapeWest }
BackupRoute = { TruckEscape2, TruckEscape1, TruckEscapeEast }

MissionStart = function()
	Utils.Do(TruckStops, function(waypoint)
		StolenTruck.Move(waypoint.Location)
	end)

	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Utils.Do(MissionStartAttackUnits, function(actor)
			actor.AttackMove(DefaultCameraPosition.Location)
		end)
	end)

	Trigger.AfterDelay(DateTime.Seconds(45), function()
		Media.DisplayMessage(UserInterface.GetFluentMessage("truck-stopped-near-allied-base"))
	end)

	Trigger.OnKilled(StolenTruck, function()
		for _, PID in ipairs(CoopPlayers) do
			PID.MarkCompletedObjective(DestroyTruck)
			PID.MarkCompletedObjective(DefendCommand)
		end
	end)

	Trigger.OnKilled(CommandCenter, function()
		for _, PID in ipairs(CoopPlayers) do
			PID.MarkFailedObjective(DefendCommand)
		end
	end)
end

Trigger.OnEnteredProximityTrigger(TruckAlarm.CenterPosition, WDist.FromCells(11), function(actor, triggerflee)
	for _, PID in ipairs(CoopPlayers) do
	if actor.Owner == PID and actor.Type ~= "badr" and actor.Type ~= "u2" and actor.Type ~= "camera.spyplane" then
		Trigger.RemoveProximityTrigger(triggerflee)
		Media.DisplayMessage(UserInterface.GetFluentMessage("convoy-truck-escaping"))
		EscapeCamera = Actor.Create("camera", true, { Owner = USSR, Location = TruckAlarm.Location })
		Media.PlaySoundNotification(All, "AlertBleep")
		Utils.Do(TruckEscape, function(waypoint)
			StolenTruck.Move(waypoint.Location)
		end)

		Trigger.AfterDelay(DateTime.Seconds(5), function()
			EscapeCamera.Destroy()
		end)

		Trigger.OnIdle(StolenTruck, function()
			Utils.Do(BackupRoute, function(waypoint)
				StolenTruck.Move(waypoint.Location)
			end)
		end)
	end
	end
end)

Trigger.OnEnteredFootprint(({ TruckEscapeWest.Location } or { TruckEscapeEast.Location }), function(actor, triggerlose)
	if actor.Owner == Greece and actor.Type == "truk" then
		Trigger.RemoveFootprintTrigger(triggerlose)
		actor.Destroy()
		for _, PID in ipairs(CoopPlayers) do
			PID.MarkFailedObjective(DestroyTruck)
		end
	end
end)

Tick = function()
	Greece.Cash = 50000
	Germany.Cash = 50000
end

WorldLoaded = function()
	USSR = Player.GetPlayer("USSR")
	Germany = Player.GetPlayer("Germany")
	Greece = Player.GetPlayer("Greece")
	
	--Mission specific Information for the Coop Base Script
	FMVBriefing = "soviet9.vqa"
	FMVOpening = "movingin.vqa"
	Enemyplayer = Greece
	Enemyplayer2 = Germany
	Mainplayer = USSR
	Dummyplayer = Player.GetPlayer("BadGuy")
	--
	
	CoopInit()
	
	for i, PID in ipairs(MCVPlayers) do
		if PID ~= USSR then
			ExtraMCV = Actor.Create("mcv", true, { Owner = PID, Location = (Actor305.Location) })
			ExtraMCV.Scatter()
		end
	end
	
	InitObjectives(USSR)

	DestroyTruck = AddPrimaryObjective(USSR, "destroy-stolen-convoy-truck")
	DefendCommand = AddPrimaryObjective(USSR, "defend-forward-command-center")

	Camera.Position = DefaultCameraPosition.CenterPosition

	MissionStart()
	ActivateAI()
end
