--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]
AlliedBoatReinforcements = { "dd", "dd" }
TimerTicks = DateTime.Minutes(21)
ObjectiveBuildings = { Chronosphere, AlliedTechCenter }
ScientistTypes = { "chan", "chan", "chan", "chan" }
ScientistDiscoveryFootprint = { CPos.New(28, 83), CPos.New(29, 83) }
ScientistEvacuationFootprint = { CPos.New(29, 60), CPos.New(29, 61), CPos.New(29, 62), CPos.New(29, 63), CPos.New(29, 64), CPos.New(29, 65), CPos.New(29, 66) }
StartingMCVs = {}

InitialAlliedReinforcements = function()
	Trigger.AfterDelay(DateTime.Seconds(2), function()
		Media.PlaySpeechNotification(All, "ReinforcementsArrived")
		Reinforcements.Reinforce(GoodGuy, StartingMCVs, { MCVEntry.Location, MCVStop.Location })
		Reinforcements.Reinforce(GoodGuy, AlliedBoatReinforcements, { DDEntry.Location, DDStop.Location })
	end)
end

CreateScientists = function()
	local scientists = Reinforcements.Reinforce(Greece, ScientistTypes, { ScientistsExit.Location })
	Utils.Do(scientists, function(s)
		s.Move(s.Location + CVec.New(0, 1))
		s.Scatter()
	end)

	local flare = Actor.Create("flare", true, { Owner = GoodGuy, Location = DefaultCameraPosition.Location + CVec.New(-1, 0) })
	Trigger.AfterDelay(DateTime.Seconds(2), function() Media.PlaySpeechNotification(All, "SignalFlareNorth") end)

	Trigger.OnAnyKilled(scientists, function()
		Media.PlaySpeechNotification(All, "ObjectiveNotMet")
		for _, PID in ipairs(CoopPlayers) do
			PID.MarkFailedObjective(EvacuateScientists)
		end
	end)

	-- Add the footprint trigger in a frame end task (delay 0) to avoid crashes
	local left = #scientists
	Trigger.AfterDelay(0, function()
		local changeOwnerTrigger = Trigger.OnEnteredFootprint(ScientistEvacuationFootprint, function(a, id)
			if a.Owner == Greece and a.Type == "chan" then
				a.Owner = Germany
				a.Stop()
				a.Move(MCVEntry.Location)

				-- Constantly try to reach the exit (and thus avoid getting stuck if the path was blocked)
				Trigger.OnIdle(a, function()
					a.Move(MCVEntry.Location)
				end)
			end
		end)

		-- Use a cell trigger to destroy the scientists preventing the player from causing glitchs by blocking the path
		Trigger.OnEnteredFootprint({ MCVEntry.Location }, function(a, id)
			if a.Owner == Germany then
				a.Stop()
				a.Destroy()

				left = left - 1
				if left == 0 then
					Trigger.RemoveFootprintTrigger(id)
					Trigger.RemoveFootprintTrigger(changeOwnerTrigger)
					flare.Destroy()

					if not Greece.IsObjectiveCompleted(EvacuateScientists) and not Greece.IsObjectiveFailed(EvacuateScientists) then
						Media.PlaySpeechNotification(All, "ObjectiveMet")
						for _, PID in ipairs(CoopPlayers) do
							PID.MarkCompletedObjective(EvacuateScientists)
						end
					end
				end
			end
		end)
	end)
end

DefendChronosphereCompleted = function()
	local cells = Utils.ExpandFootprint({ ChronoshiftLocation.Location }, false)
	local units = { }
	for i = 1, #cells do
		local unit = Actor.Create("2tnk", true, { Owner = GoodGuy, Facing = Angle.North })
		units[unit] = cells[i]
	end
	Chronosphere.Chronoshift(units)
	UserInterface.SetMissionText(UserInterface.GetFluentMessage("experiment-successful"), GoodGuy.Color)

	Trigger.AfterDelay(DateTime.Seconds(3), function()
		for _, PID in ipairs(CoopPlayers) do
			PID.MarkCompletedObjective(DefendChronosphere)
			PID.MarkCompletedObjective(KeepBasePowered)
		end
	end)
end

Ticked = TimerTicks
Tick = function()
	USSR.Cash = 5000

	if USSR.HasNoRequiredUnits() then
		for _, PID in ipairs(CoopPlayers) do
			PID.MarkCompletedObjective(DefendChronosphere)
			PID.MarkCompletedObjective(KeepBasePowered)
		end
	end

	Lostcount = 0
	for _, PID in ipairs(CoopPlayers) do
		if DateTime.GameTime > DateTime.Seconds(10) and PID.HasNoRequiredUnits() then
			Lostcount = Lostcount + 1
		end
	end
	
	if Lostcount >= #CoopPlayers then
		USSR.MarkCompletedObjective(BeatAllies)
	end

	if Ticked > 0 then
		if (Ticked % DateTime.Seconds(1)) == 0 then
			Timer = UserInterface.GetFluentMessage("chronosphere-experiment-completes-in", { ["time"] = Utils.FormatTime(Ticked) })
			UserInterface.SetMissionText(Timer, TimerColor)
		end
		Ticked = Ticked - 1
	elseif Ticked == 0 and (Greece.PowerState ~= "Normal") then
		for _, PID in ipairs(CoopPlayers) do
			PID.MarkFailedObjective(KeepBasePowered)
		end
	elseif Ticked == 0 then
		DefendChronosphereCompleted()
		Ticked = Ticked - 1
	end
	
	for _, UID in ipairs(GoodGuy.GetActorsByType("mcv")) do
		CurrentPlayer = CoopPlayers[MCVCount]
		UID.Owner = CurrentPlayer
		MCVCount = MCVCount + 1
		if MCVCount > #CoopPlayers then
			MCVCount = 1
		end
	end
	
	for _, UID in ipairs(GoodGuy.GetActorsByType("mnly")) do
		if SkipFirstPlayer ~= nil and CoopCurrent == 1 and #CoopPlayers > 1 then
			CoopCurrent = CoopCurrent + 1
		end
		CurrentPlayer = CoopPlayers[CoopCurrent]
		UID.Owner = CurrentPlayer
		CoopCurrent = CoopCurrent + 1
		if CoopCurrent > #CoopPlayers then
			CoopCurrent = 1
		end
	end
	
end

WorldLoaded = function()
	Greece = Player.GetPlayer("Greece")
	USSR = Player.GetPlayer("USSR")
	Germany = Player.GetPlayer("Germany")

	--Mission specific Information for the Coop Base Script
	FMVBriefing = "ally8.vqa"
	FMVOpening = "aagun.vqa"
	Enemyplayer = USSR
	SkipFirstPlayer = true
	--
	CoopInit()
	for _, PID in ipairs(MCVPlayers) do
		table.insert(StartingMCVs, "mcv")
	end
	MCVCount = 1

	InitObjectives(Greece)
	DefendChronosphere = AddPrimaryObjective(Greece, "defend-chronosphere-tech-center")
	KeepBasePowered = AddPrimaryObjective(Greece, "chronosphere-needs-power")
	EvacuateScientists = AddSecondaryObjective(Greece, "evacuate-scientists-from-west-island")
	BeatAllies = AddPrimaryObjective(USSR, "")

	Trigger.AfterDelay(DateTime.Minutes(1), function()
		Media.PlaySpeechNotification(All, "TwentyMinutesRemaining")
	end)
	Trigger.AfterDelay(DateTime.Minutes(11), function()
		Media.PlaySpeechNotification(All, "TenMinutesRemaining")
	end)
	Trigger.AfterDelay(DateTime.Minutes(16), function()
		Media.PlaySpeechNotification(All, "WarningFiveMinutesRemaining")
	end)
	Trigger.AfterDelay(DateTime.Minutes(18), function()
		Media.PlaySpeechNotification(All, "WarningThreeMinutesRemaining")
	end)
	Trigger.AfterDelay(DateTime.Minutes(20), function()
		Media.PlaySpeechNotification(All, "WarningOneMinuteRemaining")
	end)

	PowerProxy = Actor.Create("powerproxy.paratroopers", false, { Owner = USSR })

	Camera.Position = DefaultCameraPosition.CenterPosition
	TimerColor = GoodGuy.Color

	Trigger.OnAnyKilled(ObjectiveBuildings, function()
		for _, PID in ipairs(CoopPlayers) do
			PID.MarkFailedObjective(DefendChronosphere)
		end
	end)

	Trigger.OnEnteredFootprint(ScientistDiscoveryFootprint, function(a, id)
		for _, PID in ipairs(CoopPlayers) do
		if a.Owner == PID and not ScientistsTriggered then
			ScientistsTriggered = true
			Trigger.RemoveFootprintTrigger(id)
			CreateScientists()
		end
		end
	end)

	InitialAlliedReinforcements()
	ActivateAI()
end
