function addTriggers()
	for i, passenger in pairs(Map.NamedActors) do
		if (passenger.HasProperty("HasPassengers")) then
			Trigger.OnPassengerEntered(passenger, function(transport, passenger)
				transport.Owner = passenger.Owner
			end)
			Trigger.OnPassengerExited(passenger, function(transport, passenger)
				if (not transport.HasPassengers) then
					transport.Owner = neutralGarrison
				end
			end)
		end
	end
end

function WorldLoaded()
	neutralGarrison = Player.GetPlayer("NeutralGarrison")
	addTriggers()
    rules()
end

rules = function()
    Trigger.AfterDelay(DateTime.Seconds(3), function()
        Media.DisplayMessage ("Soviets: The invasion in the North of Scotland will succeed if we can use our new submersible troop carriers.", "Mission", HSLColor.Red)
        Trigger.AfterDelay(DateTime.Seconds(10), function()
            Media.DisplayMessage ("Allies: We are being invaded! Give all you've got to repel the amphibious assault on our coast. Hold out for 8 minutes to win.", "Mission", HSLColor.Green)
        end)
    end)
end

Tick = function ()

end