--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]
ActiveHeroes = {}
PlayableUnits = {"dog", "e1", "e1r1", "e2", "e3", "e3r1", "e4", "medi", "mech", "shok", "e7"}
PlayableRides = {"jeep","harv","v2rl","1tnk","2tnk","3tnk","4tnk","arty","mgg","mrj","ttnk","ftrk","dtrk","ctnk","yak","mig","heli","hind","mh60","ss","msub","dd","ca","pt"}
PlayableAll = {}
MimicBuildings = {"dome", "fix", "atek", "stek", "powr", "apwr"}
Defensetypes = {"renefenc", "renebrik", "renebag", "silo"}
Activemimics = {}
Localmimics = {}
AllWallBuilders = {}
Payoutmulti = Map.LobbyOption("paymultiplier")

StartRenegade = false

EmptyCheckDone = false
RespawnCheckDone = false
RenegadeCheckDone = false
CheckedDeaths = false
Waittobeseated = false

CenterCamera = function()
    AllyMoney = Ally.Cash + Ally.Resources
    SovietMoney = Soviet.Cash + Soviet.Resources
    Queuenumber = 0
    AlliedWaiters = 0
    SovietWaiters = 0
    for h, Heroes in pairs(ActiveHeroes) do
        if Heroes.Owner.Team == 1 then
            AlliedWaiters = AlliedWaiters + 1
        end
        if Heroes.Owner.Team == 2 then
            SovietWaiters = SovietWaiters + 1
        end
    end
    MoreNeeded = ""

    AllTeamPlayers = #Alliedorder - 1
    LegalUnits = #Ally.GetActorsByTypes(PlayableUnits)
    MoreNeeded = " [Infantry Pool: " .. LegalUnits .. "]"
    if AlliedWaiters < AllTeamPlayers and LegalUnits == 0 then
        MoreNeeded = " [More Infantry needed!]"
    end
    if Ally.IsLocalPlayer == true then
        UserInterface.SetMissionText(
            "[Living Renegades: " .. AlliedWaiters .. "/" .. AllTeamPlayers .. "]" .. MoreNeeded,
            Ally.Color
        )
    end

    AllTeamPlayers = #Sovietorder - 1
    LegalUnits = #Soviet.GetActorsByTypes(PlayableUnits)
    MoreNeeded = " [Infantry Pool: " .. LegalUnits .. "]"
    if SovietWaiters < AllTeamPlayers and LegalUnits == 0 then
        MoreNeeded = " [More Infantry needed!]"
    end
    if Soviet.IsLocalPlayer == true then
        UserInterface.SetMissionText(
            "[Living Renegades: " .. SovietWaiters .. "/" .. AllTeamPlayers .. "]" .. MoreNeeded,
            Soviet.Color
        )
    end
    for i, PID in pairs(Playerorder) do
        if PID.Team == 1 then
            ShownMoney = AllyMoney
        end
        if PID.Team == 2 then
            ShownMoney = SovietMoney
        end
        CurrentCamPlayer = PID
        PlayerUnits = PID.GetActorsByTypes(PlayableAll)
        PlayerInfantry = PID.GetActorsByTypes(PlayableUnits)
        DeleteParatent = PID.GetActorsByType("powerproxy.paratent")
        if DateTime.GameTime % 30 == 0 then
		if #PlayerInfantry > 0 --[[and #DeleteParatent == 0]] then
			ClassChanger(PID)
        end
		end
        if #PlayerInfantry == 0 and #DeleteParatent > 0 then
            DeleteParatent[1].Destroy()
        end
        CurrentParafac = PID.GetActorsByType("powerproxy.parafactory")
        if #PlayerUnits > 0 then
            if #CurrentParafac == 0 then
                ParafactoryCont(PID)
            end
            Ammocounter = ""
            if PlayerUnits[1].HasProperty("AmmoCount") == true then
                Ammocounter =
                    " [Ammo: " ..
                    PlayerUnits[1].AmmoCount("primary") .. "/" .. PlayerUnits[1].MaximumAmmoCount("primary") .. "]"
            end
            if PID.IsLocalPlayer == true then
                UserInterface.SetMissionText(
                    "[Unit Type: " ..
                        PlayerUnits[1].TooltipName ..
                            "] [Health: " ..
                                PlayerUnits[1].Health ..
                                    "/" ..
                                        PlayerUnits[1].MaxHealth ..
                                            "]" .. Ammocounter .. " [CO Money: " .. ShownMoney .. "$]",
                    PID.Color
                )
				if Map.LobbyOption("lockcamera") == "Yes" then
					Camera.Position = PlayerUnits[1].CenterPosition
				end
            end
        end
        if #PlayerUnits == 0 then
            if #CurrentParafac > 0 then
                CurrentParafac[1].Destroy()
            end
            for o, POI in ipairs(Playerorder) do
                if POI.Team == PID.Team then
                    Queuenumber = Queuenumber + 1
                end
                if POI == PID and PID.IsLocalPlayer == true then
                    UserInterface.SetMissionText(
                        "[Your CO has no Infantry left, please wait.]" .. " [CO Money: " .. ShownMoney .. "$]",
                        PID.Color
                    )
                end
            end
        end
    end
end

ClassChanger = function(PID)
    CurrentParatent = PID.GetActorsByType("powerproxy.paratent")
    CurrentTentprovider = PID.GetActorsByType("powerproxy.tentprovider")
    ChangingPlayer = PID
    Barracks = Map.ActorsInCircle(PlayerInfantry[1].CenterPosition, WDist.New(4096), IsValidBarrack)
	BarrackCount = #Barracks
	--Media.DisplayMessage("" .. BarrackCount, "Valid Barracks", PID.Color)
    if #Barracks > 0 and #CurrentParatent == 0 then
        --Media.DisplayMessage("Paratent Created", "Paratent Created", PID.Color)
        Paraprovider = Actor.Create("powerproxy.tentprovider", true, {Location = AlliedSpawn.Location, Owner = PID})
        Paratent = Actor.Create("powerproxy.paratent", true, {Location = AlliedSpawn.Location, Owner = PID})
        Trigger.OnProduction(Paratent,function(Producer, Produced)
                Produced.IsInWorld = false
                local DropDestination = PID.GetActorsByTypes(PlayableUnits)
                Produced.Owner = Producer.Owner
                Produced.Health = Produced.MaxHealth * (DropDestination[1].Health / DropDestination[1].MaxHealth)
                for h, Heroes in pairs(ActiveHeroes) do
                    if DropDestination[1] == Heroes then
                        table.remove(ActiveHeroes, h)
                    end
                end
                table.insert(ActiveHeroes, Produced)
                Produced.GiveLevels(4)
                Produced.Teleport(DropDestination[1].Location)
                Produced.IsInWorld = true
                DropDestination[1].IsInWorld = false
                DropDestination[1].Destroy()
                Trigger.OnKilled(
                    Produced,
                    function(Actor)
                        local Ownerid = Actor.Owner
                        local Ownercolor = Ownerid.Color
                        local Playername = Ownerid.Name
                        if PID.Team == LocalPlayer.Team then
                            Media.DisplayMessage("Waiting for Reincarnation...", Playername .. " has died.", Ownercolor)
                        end
                        for h, Heroes in pairs(ActiveHeroes) do
                            if Actor == Heroes then
                                table.remove(ActiveHeroes, h)
                            end
                        end
                    end
                )
            end
        )
    end
    if #Barracks == 0 --[[and #CurrentParatent > 0]] then
        CurrentParatent = PID.GetActorsByTypes({"powerproxy.paratent", "powerproxy.tentprovider"})
        for t, Tents in pairs(CurrentParatent) do
            Tents.Destroy()
        end
    end
end

TentCleanup = function()
    for i, PID in pairs(Playerorder) do
        CurrentParatent = PID.GetActorsByType("powerproxy.paratent")
        CurrentTentprovider = PID.GetActorsByType("powerproxy.tentprovider")
        if #CurrentParatent < #CurrentTentprovider then
            CurrentTentprovider[1].Destroy()
        end
    end
end

IsValidBarrack = function(actor)
    local GetOwner = actor.Owner
    return GetOwner.Team == ChangingPlayer.Team and actor.Type == "tent" or
        GetOwner.Team == ChangingPlayer.Team and actor.Type == "barr"
end

RenegadeChecker = function(KilledHero)
    local Ownerid = KilledHero.Owner
    local Ownercolor = KilledHero.Color
    local Playername = KilledHero.Name
    Media.DisplayMessage("Reincarnation upcoming...", Playername .. " has died.", Ownercolor)
    for i, FindHero in pairs(ActiveHeroes) do
        if FindHero.Owner == Ownerid then
            table.remove(ActiveHeroes, i)
        end
    end
end
 --

--[[else if Ownerid.IsLocalPlayer == true then
					UserInterface.SetMissionText("Unit Type: " .. Heroes.TooltipName .. " Health: " .. Heroes.Health .. "/" .. Heroes.MaxHealth, Ownercolor)
				end]] GiveBackEmpty = function(
    Transporter)
    Transporter.Stop()
    --		Empties.Health = Empties.Health - 1
    --		if Empties.Type == "jeep" and Empties.Owner == Empty and Empties.IsDead == false then
    Giveback = Actor.Create(Transporter.Type, true, {Location = Transporter.Location, Owner = Greece})
    Giveback.Health = Transporter.Health
    Transporter.Destroy()
    --		end
end

RenegadeUnit = function()
    if RespawnCheckDone == false then
        RespawnCheckDone = true
        for i, PID in pairs(Playerorder) do
            if PID ~= Ally and PID ~= Soviet then
                table.remove(Playerorder, i)
                table.insert(Playerorder, PID)
                CurrentHero = 0
                for h, Heroes in pairs(ActiveHeroes) do
                    if ActiveHeroes[h].Owner == PID then
                        CurrentHero = CurrentHero + 1
                    end
                end
                if StartRenegade == true and CurrentHero == 0 and Waittobeseated == false then
                    Waittobeseated = true
                    if PID.Team == 1 then
                        LegalUnits = Ally.GetActorsByTypes(PlayableUnits)
                    end
                    if PID.Team == 2 then
                        LegalUnits = Soviet.GetActorsByTypes(PlayableUnits)
                    end
                    if #LegalUnits > 0 then
                        --table.remove(Playerorder, i)
                        --table.insert(Playerorder, PID)
                        RNG = Utils.RandomInteger(1, #LegalUnits)
                        LegalUnits[RNG].Owner = PID
                        table.insert(ActiveHeroes, LegalUnits[RNG])
                        LegalUnits[RNG].GiveLevels(4)
                        local Unitname = LegalUnits[RNG].TooltipName
                        local Ownerid = PID
                        local Ownercolor = PID.Color
                        local Playername = PID.Name
                        Beacon.New(PID, LegalUnits[RNG].CenterPosition, 5, true)
                        Trigger.OnKilled(
                            LegalUnits[RNG],
                            function(Actor)
                                local Ownerid = Actor.Owner
                                local Ownercolor = Ownerid.Color
                                local Playername = Ownerid.Name
                                if PID.Team == LocalPlayer.Team then
                                    Media.DisplayMessage(
                                        "Waiting for Reincarnation...",
                                        Playername .. " has died.",
                                        Ownercolor
                                    )
                                end
                                for h, Heroes in pairs(ActiveHeroes) do
                                    if Actor == Heroes then
                                        table.remove(ActiveHeroes, h)
                                    end
                                end
                            end
                        )
                        if PID.Team == LocalPlayer.Team then
                            Media.DisplayMessage("Good Luck!", Playername .. " is now a " .. Unitname, Ownercolor)
                        end
                    end
                    Trigger.AfterDelay(
                        DateTime.Seconds(0.75),
                        function()
                            Waittobeseated = false
                        end
                    )
                end
            end
        end
        Trigger.AfterDelay(
            DateTime.Seconds(0.75),
            function()
                RespawnCheckDone = false
            end
        )
    end
end

ListAllPlayables = function()
    for _, value in ipairs(PlayableUnits) do
        table.insert(PlayableAll, value)
    end
    for _, value in ipairs(PlayableRides) do
        table.insert(PlayableAll, value)
    end
end

GiveTransporters = function()
    if EmptyCheckDone == false then
        EmptyCheckDone = true
        for c, CoP in pairs(CoPlayers) do
            AllTrans = CoP.GetActorsByTypes(PlayableRides)
            for i, Transporter in pairs(AllTrans) do
                if Transporter.HasPassengers == true and Transporter.Owner == CoP then
                    FirstCargo = Transporter.Passengers[1]
                    if FirstCargo.Owner ~= CoP then
                        Transporter.Owner = FirstCargo.Owner
                        if FirstCargo.Owner == Ally then
                            Transporter.UnloadPassenger()
                        end
                        if FirstCargo.Owner == Soviet then
                            Transporter.UnloadPassenger()
                        end
                        if FirstCargo.Owner ~= Ally and FirstCargo.Owner ~= Soviet then
                            Transporter.GiveLevels(4)
                            Trigger.OnPassengerExited(
                                Transporter,
                                function()
                                    Transporter.Owner = Neutral
                                    Transporter.Stop()
                                    EmptyType = Transporter.Type
                                    EmptyLocation = Transporter.Location
                                    EmptyHealth = Transporter.Health
                                    EmptyFacing = Transporter.Facing
                                    if Transporter.HasProperty("AmmoCount") == true then
                                        EmptyAmmo = Transporter.AmmoCount("primary")
                                    end
                                    Transporter.IsInWorld = false
                                    Transporter.Destroy()
                                    Giveback =
                                        Actor.Create(
                                        EmptyType,
                                        true,
                                        {Location = EmptyLocation, Owner = CoP, Facing = EmptyFacing}
                                    )
                                    Giveback.Health = EmptyHealth
                                    if Giveback.HasProperty("AmmoCount") == true then
                                        Giveback.Reload(
                                            "primary",
                                            (Giveback.MaximumAmmoCount("primary") * -1) + EmptyAmmo
                                        )
                                    end
                                end
                            )
                        end
                    end
                end
            end
        end
        Trigger.AfterDelay(
            DateTime.Seconds(0.25),
            function()
                EmptyCheckDone = false
            end
        )
    end
end

MimicBuildingsCheck = function()
    for ib, BID in pairs(MimicBuildings) do
        AllyCOMimics = Ally.GetActorsByType(BID)
        for ico, ACoID in pairs(AllyCOMimics) do
            if ACoID.IsDead == true then
                table.remove(AllyCOMimics, ico)
            end
        end
        SovietCOMimics = Soviet.GetActorsByType(BID)
        for ico, SCoID in pairs(SovietCOMimics) do
            if SCoID.IsDead == true then
                table.remove(SovietCOMimics, ico)
            end
        end
        for ip, PID in pairs(Playerorder) do
            for il, LID in pairs(Localmimics) do
                table.remove(Localmimics, il)
            end
            for ia, AMID in pairs(Activemimics) do
                if AMID.Type == BID and AMID.Owner == PID then
                    table.insert(Localmimics, AMID)
                end
            end

            if PID ~= Ally and PID ~= Soviet and PID.Team == 1 then
                if #Localmimics < #AllyCOMimics then
                    NewMimic = Actor.Create(BID, true, {Location = AllyCOMimics[1].Location, Owner = PID})
                    table.insert(Activemimics, NewMimic)
                    table.insert(Localmimics, NewMimic)
                end

                if #Localmimics > #AllyCOMimics then
                    Localmimics[1].Health = 0
                end
            end
            if PID ~= Ally and PID ~= Soviet and PID.Team == 2 then
                if #Localmimics < #SovietCOMimics then
                    NewMimic = Actor.Create(BID, true, {Location = SovietCOMimics[1].Location, Owner = PID})
                    table.insert(Activemimics, NewMimic)
                    table.insert(Localmimics, NewMimic)
                end

                if #Localmimics > #SovietCOMimics then
                    Localmimics[1].Health = 0
                end
            end
        end
    end
end

BadgerNeutralizer = function()
    for i, PID in pairs(AllPlayers) do
        if PID ~= Ally and PID ~= Soviet then
            Badgers = PID.GetActorsByType("badr")
            for i, UID in pairs(Badgers) do
                if PID.Team == 1 then
                    UID.Owner = EmptyAlly
                end
            end
        end
    end
end

DamageEmpties = function()
    NonVacantVehicles = EmptyAlly.GetActorsByTypes(PlayableAll)
    for i, UID in pairs(NonVacantVehicles) do
        UID.Health = UID.Health - (UID.MaxHealth / 3000)
    end
end

ParafactoryCont = function(PID)
    Parafactory = Actor.Create("powerproxy.parafactory", true, {Location = AlliedSpawn.Location, Owner = PID})
    Trigger.OnProduction(
        Parafactory,
        function(Producer, Produced)
            local DropDestination = PID.GetActorsByTypes(PlayableAll)
            local GetEdge = Map.ClosestEdgeCell(DropDestination[1].Location)
            if PID.Team == 1 then
                Produced.Owner = Ally
            end
            if PID.Team == 2 then
                Produced.Owner = Soviet
            end
            for l, LID in pairs(PlayableRides) do
                if Produced.Type == LID and Produced.Type ~= "harv" then
                    Produced.Owner = EmptyAlly
                end
            end
            Produced.IsInWorld = false
            local DropFlare =
                Actor.Create("flare", true, {Location = DropDestination[1].Location, Owner = Producer.Owner})
            local AirDrop = Actor.Create("badr", true, {Location = GetEdge, Owner = Producer.Owner})
            AirDrop.LoadPassenger(Produced)
            AirDrop.Paradrop(DropFlare.Location)
            Trigger.AfterDelay(
                DateTime.Seconds(10),
                function()
                    DropFlare.Destroy()
                end
            )
        end
    )
end

RenBotController = function()
    for i, PID in pairs(AllPlayers) do
        if PID ~= Ally and PID ~= Soviet and PID.IsBot == true then
            BotUnits = PID.GetActorsByTypes(PlayableUnits)
            for b, BID in pairs(BotUnits) do
                IdleHunt(BID)
            end
        end
    end
end

BuildWalls = function()	
    for i, PID in pairs(AllPlayers) do
		Defensebuildings = PID.GetActorsByTypes(Defensetypes)
		for f, DID in pairs (Defensebuildings) do
			if PID ~= Ally and PID ~= Soviet then
				Defenseowner = DID.Owner
				if Defenseowner.Faction == Ally.Faction then
					DID.Owner = Ally
				end
				if Defenseowner.Faction == Soviet.Faction then
					DID.Owner = Soviet
				end
			end
		end
        if PID ~= Ally and PID ~= Soviet then
			CurrentWallBuilder = ""
			ControlledUnit = PID.GetActorsByTypes(PlayableAll)
            for wb, UID in pairs(AllWallBuilders) do
				if UID.Owner == PID then
					CurrentWallBuilder = UID
					WallBuildNo = wb
				end
			end
			if #ControlledUnit > 0 then
				Wallbuilder = Actor.Create("WallBuilder", true, {Location = ControlledUnit[1].Location, Owner = PID})
				table.insert(AllWallBuilders, Wallbuilder)
			end
            if CurrentWallBuilder ~= "" then
				table.remove(AllWallBuilders, WallBuildNo)
				CurrentWallBuilder.Destroy()
			end
        end
    end
end

MoneySpread = function()
	if Ally.Resources >= (#AlliedPlayers - 1) then
		for i, PID in ipairs(AlliedPlayers) do
			if PID ~= Ally then
				PID.Cash = PID.Cash+(1*Payoutmulti)
				Ally.Resources = Ally.Resources-1
			else
				PID.Cash = PID.Cash+1
				Ally.Resources = Ally.Resources-1
			end
		end
	end
	if Soviet.Resources >= (#SovietPlayers - 1) then
		for i, PID in ipairs(SovietPlayers) do
			if PID ~= Soviet then
				PID.Cash = PID.Cash+(1*Payoutmulti)
				Soviet.Resources = Soviet.Resources-1
			else
				PID.Cash = PID.Cash+1
				Soviet.Resources = Soviet.Resources-1
			end
		end
	end
end

Tick = function()
	if DateTime.GameTime % 15 == 0 then
		MoneySpread()
	end
    TentCleanup()
    RenBotController()
    DamageEmpties()
    --	MimicBuildingsCheck()
    RenegadeUnit()
    GiveTransporters()
    CenterCamera()
	BuildWalls()
    if Ally.HasNoRequiredUnits() and DateTime.GameTime > DateTime.Seconds(5) then
        for i, Def in pairs(AlliedDefeaters) do
            if Def.IsDead == false then
                Def.Kill()
            end
        end
    end
    if Soviet.HasNoRequiredUnits() and DateTime.GameTime > DateTime.Seconds(5) then
        for i, Def in pairs(SovietDefeaters) do
            if Def.IsDead == false then
                Def.Kill()
            end
        end
    end
end

WorldLoaded = function()
    Ally = Player.GetPlayer("Ally")
    EmptyAlly = Player.GetPlayer("EmptyAlly")
    AlliedRen1 = Player.GetPlayer("AlliedRen1")
    AlliedRen2 = Player.GetPlayer("AlliedRen2")
    AlliedRen3 = Player.GetPlayer("AlliedRen3")
    AlliedRen4 = Player.GetPlayer("AlliedRen4")
    AlliedRen5 = Player.GetPlayer("AlliedRen5")
    AlliedRen6 = Player.GetPlayer("AlliedRen6")
    AlliedRen7 = Player.GetPlayer("AlliedRen7")
    AlliedRen8 = Player.GetPlayer("AlliedRen8")
    AlliedRen9 = Player.GetPlayer("AlliedRen9")
    AlliedRen10 = Player.GetPlayer("AlliedRen10")
    AlliedRen11 = Player.GetPlayer("AlliedRen11")
    AlliedRen12 = Player.GetPlayer("AlliedRen12")
    AlliedRen13 = Player.GetPlayer("AlliedRen13")
    AlliedRen14 = Player.GetPlayer("AlliedRen14")
    AlliedRen15 = Player.GetPlayer("AlliedRen15")
    AlliedRen16 = Player.GetPlayer("AlliedRen16")
    Soviet = Player.GetPlayer("Soviet")
    EmptySoviet = Player.GetPlayer("EmptySoviet")
    SovietRen1 = Player.GetPlayer("SovietRen1")
    SovietRen2 = Player.GetPlayer("SovietRen2")
    SovietRen3 = Player.GetPlayer("SovietRen3")
    SovietRen4 = Player.GetPlayer("SovietRen4")
    SovietRen5 = Player.GetPlayer("SovietRen5")
    SovietRen6 = Player.GetPlayer("SovietRen6")
    SovietRen7 = Player.GetPlayer("SovietRen7")
    SovietRen8 = Player.GetPlayer("SovietRen8")
    SovietRen9 = Player.GetPlayer("SovietRen9")
    SovietRen10 = Player.GetPlayer("SovietRen10")
    SovietRen11 = Player.GetPlayer("SovietRen11")
    SovietRen12 = Player.GetPlayer("SovietRen12")
    SovietRen13 = Player.GetPlayer("SovietRen13")
    SovietRen14 = Player.GetPlayer("SovietRen14")
    SovietRen15 = Player.GetPlayer("SovietRen15")
    SovietRen16 = Player.GetPlayer("SovietRen16")
    Neutral = Player.GetPlayer("Neutral")

    CoPlayers = {}
    table.insert(CoPlayers, EmptyAlly)
    table.insert(CoPlayers, EmptySoviet)
    ListAllPlayables()
    AlliedRenDomes = {}
    SovietRenDomes = {}

    AlliedPlayers = {}
    if AlliedRen1 ~= nil then
        table.insert(AlliedPlayers, AlliedRen1)
    end
    if AlliedRen2 ~= nil then
        table.insert(AlliedPlayers, AlliedRen2)
    end
    if AlliedRen3 ~= nil then
        table.insert(AlliedPlayers, AlliedRen3)
    end
    if AlliedRen4 ~= nil then
        table.insert(AlliedPlayers, AlliedRen4)
    end
    if AlliedRen5 ~= nil then
        table.insert(AlliedPlayers, AlliedRen5)
    end
    if AlliedRen6 ~= nil then
        table.insert(AlliedPlayers, AlliedRen6)
    end
    if AlliedRen7 ~= nil then
        table.insert(AlliedPlayers, AlliedRen7)
    end
    if AlliedRen8 ~= nil then
        table.insert(AlliedPlayers, AlliedRen8)
    end
    if AlliedRen9 ~= nil then
        table.insert(AlliedPlayers, AlliedRen9)
    end
    if AlliedRen10 ~= nil then
        table.insert(AlliedPlayers, AlliedRen10)
    end
    if AlliedRen11 ~= nil then
        table.insert(AlliedPlayers, AlliedRen11)
    end
    if AlliedRen12 ~= nil then
        table.insert(AlliedPlayers, AlliedRen12)
    end
    if AlliedRen13 ~= nil then
        table.insert(AlliedPlayers, AlliedRen13)
    end
    if AlliedRen14 ~= nil then
        table.insert(AlliedPlayers, AlliedRen14)
    end
    if AlliedRen15 ~= nil then
        table.insert(AlliedPlayers, AlliedRen15)
    end
    if AlliedRen16 ~= nil then
        table.insert(AlliedPlayers, AlliedRen16)
    end
    table.insert(AlliedPlayers, Ally)
    table.insert(CoPlayers, Ally)

    SovietPlayers = {}
    if SovietRen1 ~= nil then
        table.insert(SovietPlayers, SovietRen1)
    end
    if SovietRen2 ~= nil then
        table.insert(SovietPlayers, SovietRen2)
    end
    if SovietRen3 ~= nil then
        table.insert(SovietPlayers, SovietRen3)
    end
    if SovietRen4 ~= nil then
        table.insert(SovietPlayers, SovietRen4)
    end
    if SovietRen5 ~= nil then
        table.insert(SovietPlayers, SovietRen5)
    end
    if SovietRen6 ~= nil then
        table.insert(SovietPlayers, SovietRen6)
    end
    if SovietRen7 ~= nil then
        table.insert(SovietPlayers, SovietRen7)
    end
    if SovietRen8 ~= nil then
        table.insert(SovietPlayers, SovietRen8)
    end
    if SovietRen9 ~= nil then
        table.insert(SovietPlayers, SovietRen9)
    end
    if SovietRen10 ~= nil then
        table.insert(SovietPlayers, SovietRen10)
    end
    if SovietRen11 ~= nil then
        table.insert(SovietPlayers, SovietRen11)
    end
    if SovietRen12 ~= nil then
        table.insert(SovietPlayers, SovietRen12)
    end
    if SovietRen13 ~= nil then
        table.insert(SovietPlayers, SovietRen13)
    end
    if SovietRen14 ~= nil then
        table.insert(SovietPlayers, SovietRen14)
    end
    if SovietRen15 ~= nil then
        table.insert(SovietPlayers, SovietRen15)
    end
    if SovietRen16 ~= nil then
        table.insert(SovietPlayers, SovietRen16)
    end
    table.insert(SovietPlayers, Soviet)
    table.insert(CoPlayers, Soviet)

    Alliedorder = AlliedPlayers
    Sovietorder = SovietPlayers

    table.remove(Alliedorder, 0)
    table.remove(Sovietorder, 0)

    AllPlayers = {}
    for _, value in ipairs(AlliedPlayers) do
        if value.IsLocalPlayer == true then
            Camera.Position = AlliedSpawn.CenterPosition
        end
        table.insert(AllPlayers, value)
    end
    for _, value in ipairs(SovietPlayers) do
        if value.IsLocalPlayer == true then
            Camera.Position = SovietSpawn.CenterPosition
        end
        table.insert(AllPlayers, value)
    end

    Playerorder = {}
    for _, value in ipairs(Alliedorder) do
        if value ~= Ally then
            value.Cash = (Ally.Cash/10)/(#Alliedorder-1)
            table.insert(Playerorder, value)
        end
    end
    for _, value in ipairs(Sovietorder) do
        if value ~= Soviet then
            value.Cash = (Soviet.Cash/10)/(#Sovietorder-1)
            table.insert(Playerorder, value)
        end
    end

    LocalPlayer = Ally
    for i, PID in pairs(AllPlayers) do
        if PID.IsLocalPlayer == true and PID.IsNonCombatant == false then
            LocalPlayer = PID
        end
    end

    ConstructionVehicleReinforcements = {"mcv"}
    AlliedStart = {AlliedSpawn.Location, AlliedSpawn.Location}
    SovietStart = {SovietSpawn.Location, SovietSpawn.Location}
    if Ally.IsBot == true then
        Actor.Create("fact", true, {Location = AlliedSpawn.Location + CVec.New(0, -2), Owner = Ally})
    else
        Reinforcements.Reinforce(Ally, ConstructionVehicleReinforcements, AlliedStart)
    end
    if Soviet.IsBot == true then
        Actor.Create("fact", true, {Location = SovietSpawn.Location + CVec.New(-1, 1), Owner = Soviet})
    else
        Reinforcements.Reinforce(Soviet, ConstructionVehicleReinforcements, SovietStart)
    end
    Starterunit = "e1"
    AlliedDefeaters = {}
    SovietDefeaters = {}
	Zeropoint = CPos.Zero
    AlliedStartBarracks = Actor.Create("tent", true, {Location = AlliedSpawn.Location + CVec.New(0, 2), Owner = Ally})
    AlliedStartPower = Actor.Create("powr", true, {Location = AlliedSpawn.Location + CVec.New(2, 2), Owner = Ally})
    for i, PID in pairs(AlliedPlayers) do
        if PID ~= Ally then
            AlliedStartUnit = Actor.Create(Starterunit, true, {Location = AlliedSpawn.Location, Owner = Ally})
            AlliedDefeater = Actor.Create("defeater", false, {Location = Zeropoint, Owner = PID})
            table.insert(AlliedDefeaters, AlliedDefeater)
            AlliedStartUnit.Scatter()
        end
    end
    SovietStartBarracks =
        Actor.Create("barr", true, {Location = SovietSpawn.Location + CVec.New(0, -2), Owner = Soviet})
    SovietStartPower = Actor.Create("powr", true, {Location = SovietSpawn.Location + CVec.New(-2, -2), Owner = Soviet})
    for i, PID in pairs(SovietPlayers) do
        if PID ~= Soviet then
            SovietStartUnit = Actor.Create(Starterunit, true, {Location = SovietSpawn.Location, Owner = Soviet})
            SovietDefeater = Actor.Create("defeater", false, {Location = Zeropoint, Owner = PID})
            table.insert(SovietDefeaters, SovietDefeater)
            SovietStartUnit.Scatter()
        end
    end

    --AlliedRen1.Cash = 50000
    --SovietRen1.Cash = 50000

    --	OnlyTec = Map.LobbyOption(alltec)
    for i, PID in pairs(AllPlayers) do
        if PID ~= Ally and PID ~= Soviet then
            --if OnlyTec == 1 then
            Actor.Create("powerproxy.paradome", true, {Location = AlliedSpawn.Location, Owner = PID})
            Actor.Create("powerproxy.parafix", true, {Location = AlliedSpawn.Location, Owner = PID})
            Actor.Create("powerproxy.pararef", true, {Location = AlliedSpawn.Location, Owner = PID})
            Actor.Create("powerproxy.paratek", true, {Location = AlliedSpawn.Location, Owner = PID})
			--Wallbuilder = Actor.Create("WallBuilder", true, {Location = AlliedSpawn.Location, Owner = PID})
			--table.insert(AllWallBuilders, Wallbuilder)
        --end
        end
    end
     --
    --[[
	for i,Rides in pairs (PlayableRides) do
	DebugUnit = Actor.Create (Rides, true, { Location = AlliedSpawn.Location, Owner = Ally })
	if DebugUnit.HasProperty("Scatter") == true then
	DebugUnit.Scatter()
	end
	end
	]] ListAllPlayables(

    )
    StartRenegade = true
end
