function addTriggers()
	for i, passenger in pairs(Map.NamedActors) do
		if (passenger.HasProperty("HasPassengers")) then
			Trigger.OnPassengerEntered(passenger, function(transport, passenger)
				transport.Owner = passenger.Owner
			end)
			Trigger.OnPassengerExited(passenger, function(transport, passenger)
				if (not transport.HasPassengers) then
					transport.Owner = neutral
				end
			end)
		end
	end
end

function WorldLoaded()
	neutral = Player.GetPlayer("Neutral")
	addTriggers()
end