--local trees = {"tgd2",  "tgb", "tgc2", "tgc1",  "tg2",  "tg1",  "cypr1", "cypr2"}
local trees = { "tg2",  "tg1",  "cypr1"}
local map = {}
local mapEmpty = 0
local mapTree = 1
local mapOreMine = 2
local mapGemMine = 3
local mapRock = 4
local mapOil = 5
local mapFCom = 6
local mapHopsital = 7
local mapComCenter = 8
-- mp0 is top-left
-- mp1 is down-left
-- mp2 is down-right
-- mp3 is top-right
local mpspawns = {}
mpspawns["mp0"] = {10, 10}
mpspawns["mp1"] = {10, 140}
mpspawns["mp2"] = {140, 140}
mpspawns["mp3"] = {140, 10}
local w = 148
local h = 148
local  numOfOre = 8
local numOfGems = 2
local dirVertical = 0
local dirHorizontal = 1
local dirSloped = 2
local mountMaxLength = 20
local numberOfChains = Utils.RandomInteger(0,5)
local numberOfOils = Utils.RandomInteger(0,3)
local numberOfFCom = Utils.RandomInteger(0,2)
local numberOfHospitals= Utils.RandomInteger(0,2)
local numberOfComCenters = Utils.RandomInteger(0,3)
local Neutral = Player.GetPlayer("Neutral")


-- Inspired by Dizzar map which was based on Murto's experiment with forest generation

--CPos RandomCell()

WorldLoaded = function()
  Trigger.AfterDelay(0.1, WorldGenerationSequence)
end


function WorldGenerationSequence()
	Media.Debug("Starting world generation sequence!")
  	FillMapWithForest()
  	ClearPlayerSpawns()
  	CreatePaths()
	CreateMountains()
	CreateOils()
	CreateFComs()
	CreateHospitals()
	CreateCommCenters()
  	PlaceRandomOreAndGems()
  	RenderMap()
end

function ClearArea(x, y, offset)
  for tileX = x - offset, x + offset do
    for tileY = y - offset, y + offset do
		Media.Debug(messageX)
		Media.Debug(messageY)
	  if map[tileX][tileY] == 1 then
        map[tileX][tileY] = 0
      end
    end
  end
end

function ClearArea(x, y, offset)
	for tileX = x - offset, x + offset do
		for tileY = y - offset, y + offset do
			Media.Debug(messageX)
			Media.Debug(messageY)
			if map[tileX][tileY] == mapTree then
				map[tileX][tileY] = 0
			end
		end
	end
end

function FillMapWithForest()
	Media.Debug("FillMapWithForest")
	for x= 1, w do
		map[x] = {}
		for y= 1, h do
			local randomTreeChance = Utils.RandomInteger(0, 10)
			if randomTreeChance < 8 then
				map[x][y] = mapTree
			else
				map[x][y] = 0
			end
		end
	end
end

function PlaceRandomOreAndGems()
	for ore = 1, numOfOre do
		local oreX = Utils.RandomInteger(10, (w / 2) - 20)
		local oreY = Utils.RandomInteger(10, (h / 2) - 20)
		ValueForMirrorMap(oreX, oreY, mapOreMine, true)
	end
	for gems = 1, numOfGems do
		local gemX = Utils.RandomInteger(35, w / 2)
		local gemY = Utils.RandomInteger(35, h / 2)
		ValueForMirrorMap(gemX, gemY, mapGemMine, true)
	end
end

function ValueForMirrorMap(x,y,mapValue, clearTrees)
	map[x][y] = mapValue
	map[x][h - y] = mapValue
	map[w - x][y] = mapValue
	map[w - x][h - y] = mapValue
	if(clearTrees) then
		local clearAreaSize = 2
		ClearArea(x,y,clearAreaSize)
		ClearArea(x,h-y,clearAreaSize)
		ClearArea(w - x,y,clearAreaSize)
		ClearArea(w- x,h - y,clearAreaSize)
	end
end

function CreatePaths()
	CreateVerticalPath(4,10, 30)
	CreateHorizontalPath(10,4, 30)
end

function CreateVerticalPath(startX, startY, newPathChance)
	local xModifier = 0
	local x = startX
	local randomChance = 0
	for yPos = startY + 1, h / 2 do
		xModifier = Utils.RandomInteger(-2, 3)
		x = x + xModifier
		if x < 3 then x = 3 end
		for xPos = x, x + 3 do
			ValueForMirrorMap(xPos, yPos, 0)
		end
		randomChance = Utils.RandomInteger(0, newPathChance)
		if randomChance == 1 then CreateHorizontalPath(x, yPos, newPathChance * 2) end
	end
end

function CreateHorizontalPath(startX, startY, newPathChance)
	local xModifier = 0
	local y = startY
	local randomChance = 0
	for xPos = startX + 1, w / 2 do
		yModifier = Utils.RandomInteger(-2, 3)
		y = y + yModifier
		if y < 3 then y = 3 end
		for yPos = y, y + 3 do
			ValueForMirrorMap(xPos, yPos, 0)
		end
		randomChance = Utils.RandomInteger(0, newPathChance)
		if randomChance == 1 then CreateVerticalPath(xPos, y, newPathChance * 2) end
	end
end



function ClearPlayerSpawns()
	Media.Debug("Clearing spawns.")
  	ClearArea(mpspawns["mp0"][1], mpspawns["mp0"][2], 4)
  	ClearArea(mpspawns["mp1"][1], mpspawns["mp1"][2], 4)
  	ClearArea(mpspawns["mp2"][1], mpspawns["mp2"][2], 4)
  	ClearArea(mpspawns["mp3"][1], mpspawns["mp3"][2], 4)
end

function CreateMountains()
	local mountXminStart = 10
	local mountYminStart = 10
	local mountXmaxStart = (w / 2) - mountMaxLength
	local mountYMaxStart = (h / 2) - mountMaxLength
	local direction = 0
	Media.Debug("Num of mountain chains: " .. numberOfChains)
	for mountNum = 1, numberOfChains do
		local xStart = Utils.RandomInteger(mountXminStart, mountXmaxStart)
		local yStart = Utils.RandomInteger(mountYminStart, mountYMaxStart)
		local xPos = xStart
		local yPos = yStart
		local mountainLen = Utils.RandomInteger(1, mountMaxLength)
		for len = 0, mountainLen do
			direction = Utils.RandomInteger(0, 3)
			if direction == dirHorizontal then
				xPos = xPos + 2
			elseif direction == dirVertical then
				yPos = yPos + 2
			elseif direction == dirSloped then
				xPos = xPos + 2
				yPos = yPos + 2
			end
			ValueForMirrorMap(xPos, yPos, mapRock, true)

		end
	end
end

function CreateOils()
	for item = 1, numberOfOils do
		local xPos = Utils.RandomInteger(10, (w / 2))
		local yPos = Utils.RandomInteger(10, (h / 2))
		ValueForMirrorMap(xPos, yPos, mapOil, true)
	end
end

function CreateFComs()
	for item = 1, numberOfFCom do
		local xPos = Utils.RandomInteger(10, (w / 2))
		local yPos = Utils.RandomInteger(10, (h / 2))
		ValueForMirrorMap(xPos, yPos, mapFCom, true)
	end
end

function CreateHospitals()
	for item = 1, numberOfHospitals do
		local xPos = Utils.RandomInteger(10, (w / 2))
		local yPos = Utils.RandomInteger(10, (h / 2))
		ValueForMirrorMap(xPos, yPos, mapHopsital, true)
	end
end

function CreateCommCenters()
	for item = 1, numberOfComCenters do
		local xPos = Utils.RandomInteger(10, (w / 2))
		local yPos = Utils.RandomInteger(10, (h / 2))
		ValueForMirrorMap(xPos, yPos, mapComCenter, true)
	end
end




function CreateVisual(x,y)
  if map[x][y] == mapTree then
    local actor = Actor.Create(Utils.Random(trees), true, {
        Owner = Neutral,
        Location = CPos.New(x, y)
      })
  elseif map[x][y] == mapOreMine then
    local actor = Actor.Create("mine", true, {
        Owner = Neutral,
        Location = CPos.New(x, y)
      })
  elseif map[x][y] == mapGemMine then
    local actor = Actor.Create("gmine", true, {
        Owner = Neutral,
        Location = CPos.New(x, y)
      })
  elseif map[x][y] == mapRock then
	  local actor = Actor.Create("rocks4", true, {
		  Owner = Neutral,
		  Location = CPos.New(x, y)
	  })
  elseif map[x][y] == mapOil then
	  local actor = Actor.Create("oilb", true, {
		  Owner = Neutral,
		  Location = CPos.New(x, y)
	  })
  elseif map[x][y] == mapHopsital then
	  local actor = Actor.Create("hosp", true, {
		  Owner = Neutral,
		  Location = CPos.New(x, y)
	  })
  elseif map[x][y] == mapFCom then
	  local actor = Actor.Create("fcom", true, {
		  Owner = Neutral,
		  Location = CPos.New(x, y)
	  })
  elseif map[x][y] == mapComCenter then
	  local actor = Actor.Create("miss", true, {
		  Owner = Neutral,
		  Location = CPos.New(x, y)
	  })
  end

end

function RenderMap()
  Media.Debug("Rendering.")
  for x=1, w do
    for y=1, h do
      if map[x][y] > 0  then
        CreateVisual(x,y)
      end
    end
  end
end