--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

RifleReinforcments = { "e1", "e1", "e1", "bike" }
BazookaReinforcments = { "e3", "e3", "e3", "bike" }
BikeReinforcments = { "bike" }

BadGuySpread = function()
	P1Units = BadGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end

PlayOpening = function()
Media.PlayMovieInRadar("dino.vqa")
end

WorldLoaded = function()
	Nod = Player.GetPlayer("Nod")
	Dinosaur = Player.GetPlayer("Dinosaur")
	Civilian = Player.GetPlayer("Civilian")
	BadGuy = Player.GetPlayer("BadGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	CoopPlayers = {};
	table.insert(CoopPlayers, Nod)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end
	
	Media.PlayMovieFullscreen("generic.vqa",PlayOpening)
	
	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end

	EnemyUnits = Dinosaur.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	CoopCurrent = 1
	
	EnemyUnits = Dinosaur.GetGroundAttackers()
	for i,EID in pairs (EnemyUnits) do
	EID.Stance = "AttackAnything"
	end
	
	Fences = Neutral.GetActorsByType("wood")
	for _, UID in ipairs(Fences) do
	UID.Owner = Nod
	end
	
	for i, PID in pairs (CoopPlayers) do
	InvestigateObj = AddPrimaryObjective(PID, "investigate-village")
	end
	
	InitObjectives(Nod)
	
	for i, PID in pairs (CoopPlayers) do
	ReachVillageObj = AddPrimaryObjective(PID, "reach-village")
	end
	
	Trigger.OnPlayerDiscovered(Civilian, function(_, discoverer)
		if discoverer.Team == 1 and not Nod.IsObjectiveCompleted(ReachVillageObj) then
			Utils.Do(Dinosaur.GetGroundAttackers(), IdleHunt)
			if not Dinosaur.HasNoRequiredUnits() then
				for i, PID in pairs (CoopPlayers) do
				KillDinos = AddPrimaryObjective(PID, "kill-creatures")
				end
			end

			for i, PID in pairs (CoopPlayers) do
			PID.MarkCompletedObjective(ReachVillageObj)
			end
		end
	end)

	DinoTric.Patrol({ WP0.Location, WP1.Location }, true, 3)
	Trigger.OnDamaged(DinoTric, function()
		DinoTric.Stop()
		IdleHunt(DinoTric)
	end)

	DinoTrex.AttackMove(WP2.Location)
	DinoTrex.AttackMove(WP3.Location)
	IdleHunt(DinoTrex)

	ReinforceWithLandingCraft(BadGuy, RifleReinforcments, SeaEntryA.Location, BeachReinforceA.Location, BeachReinforceA.Location)
	Trigger.AfterDelay(DateTime.Seconds(3), function() InitialUnitsArrived = true end)

	Trigger.AfterDelay(DateTime.Seconds(15), function() ReinforceWithLandingCraft(BadGuy, BazookaReinforcments, SeaEntryB.Location, BeachReinforceB.Location, BeachReinforceB.Location) end)
	if Difficulty == "easy" then
		Trigger.AfterDelay(DateTime.Seconds(25), function() ReinforceWithLandingCraft(BadGuy, BikeReinforcments, SeaEntryA.Location, BeachReinforceA.Location, BeachReinforceA.Location) end)
		Trigger.AfterDelay(DateTime.Seconds(30), function() ReinforceWithLandingCraft(BadGuy, BikeReinforcments, SeaEntryB.Location, BeachReinforceB.Location, BeachReinforceB.Location) end)
	end

	Camera.Position = CameraStart.CenterPosition
end

Tick = function()
	BadGuySpread()
	if InitialUnitsArrived then
		LostCounter = 0
		for i,PID in pairs (CoopPlayers) do
			if DateTime.GameTime > DateTime.Seconds(20) and PID.HasNoRequiredUnits() then
				LostCounter = LostCounter+1
			end
		end
		if LostCounter == #CoopPlayers then
			for i,PID in pairs (CoopPlayers) do
			PID.MarkFailedObjective(InvestigateObj)
			end
		end

		if Dinosaur.HasNoRequiredUnits() then
			if KillDinos then Nod.MarkCompletedObjective(KillDinos) end
			for i, PID in pairs (CoopPlayers) do
			PID.MarkCompletedObjective(InvestigateObj)
			end
		end
	end
end
