--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

WelcomeTeam = { Wel1, Wel2, Wel3, Wel4, Wel5 }

Civilians = { Actor111, Actor112, Actor113, Actor114, Actor115, Actor116, Actor117, Actor118, Actor119, Actor120, Actor121 }
RunForHelpCivs = { Actor109, Actor110 }
CiviliansBuildings = { Actor35, Actor36, Actor37, Actor38, Actor39, Actor40, Actor41, Actor42, Actor43, Actor44, Actor45, Actor54, Actor55, Actor56, Actor57, Actor58 }
OilDerricks = { Actor49, Actor50, Actor51, Actor52 }
CivsMoneyBuildings = { Actor37, Actor41, Actor42, Actor44, Actor58 }

ReinforcementsMammoths = { "htnk", "htnk" }
ReinforcementsEngineers = { "e6", "e6", "e6", "e6", "e6" }
CiviliansHelpTeam = { "mtnk", "mtnk", "msam" }
BaseDefenseTeam = { Def1, Def2, Def3, Def4 }
PatrolTeam = { Actor103, Actor122, Actor123 }
PatrolPath = { waypoint2.Location, waypoint3.Location, waypoint4.Location, waypoint5.Location }

CapturableStructures = { "afld", "hand", "hq", "nuke", "silo", "proc", "sam" }
IonCannonTargets = { { "obli", "gun", "gtwr" }, { "harv" } }

WelcomeTeamCellTrigger = { CPos.New(17,59), CPos.New(18,59), CPos.New(19,59), CPos.New(17,60), CPos.New(18,60), CPos.New(19,60), CPos.New(25,53), CPos.New(25,54), CPos.New(25,55), CPos.New(26,53), CPos.New(26,54), CPos.New(26,55) }
CivsGDIHelpCellTrigger = { CPos.New(13,7) }
GDIBaseEntranceCells = { CPos.New(16,5), CPos.New(16,6), CPos.New(16,7), CPos.New(16,8), CPos.New(17,4), CPos.New(17,5), CPos.New(17,6), CPos.New(17,7), CPos.New(17,8), CPos.New(18,4), CPos.New(18,5), CPos.New(19,4), CPos.New(8,15), CPos.New(9,15), CPos.New(10,15), CPos.New(11,15), CPos.New(12,15), CPos.New(13,15), CPos.New(14,15), CPos.New(9,16), CPos.New(10,16), CPos.New(11,16), CPos.New(12,16), CPos.New(13,16), CPos.New(14,16) }
InnerGDIBaseEntranceCells = { CPos.New(7,5), CPos.New(7,6), CPos.New(7,7), CPos.New(8,6), CPos.New(8,7), CPos.New(9,6), CPos.New(9,7) }

CaptureStructures = function(actor)
	local structures = Nod.GetActorsByTypes(CapturableStructures)
	for i,PID in pairs (CoopPlayers) do
		if PID ~= Nod then
			AlsoCapture = PID.GetActorsByTypes(CapturableStructures)
			for i,CID in pairs (AlsoCapture) do
				table.insert(structures, CID)
			end
		end
	end
	local distance = 500
	local captst = nil
	Utils.Do(structures, function(st)
		if not actor.IsDead and not st.IsDead and distance > (math.abs((actor.Location - st.Location).X) + math.abs((actor.Location - st.Location).Y)) then
			distance = math.abs((actor.Location - st.Location).X) + math.abs((actor.Location - st.Location).Y)
			captst = st
		end
	end)
	if captst then
		actor.Capture(captst)
	end
end

SendGDIAirstrike = function()
	if not GDIhq.IsDead and GDIhq.Owner == GDI then
		RNG = Utils.RandomInteger(1, #CoopPlayers)
		local target = GetAirstrikeTarget(CoopPlayers[RNG])
		if target then
			GDIhq.TargetAirstrike(target, Angle.SouthEast)
		else
			Trigger.AfterDelay(DateTime.Seconds(5), SendGDIAirstrike)
		end
	end
end

OilDerricksAstkSent = false
OilDerricksAirstrike = function()
	if not OilDerricksAstkSent then
		SendGDIAirstrike()
		OilDerricksAstkSent = true
	end
end

CivsRunning = false
RunForHelp = function()
	if not CivsRunning then
		Utils.Do(RunForHelpCivs, function(actor)
			actor.Move(CPos.New(53,45))
			actor.Move(waypoint6.Location)
			actor.Move(waypoint4.Location)
			actor.Move(waypoint9.Location)
			actor.Move(waypoint2.Location)
			actor.Move(waypoint12.Location)
			actor.Move(waypoint6.Location)
		end)
		Trigger.OnEnteredFootprint(CivsGDIHelpCellTrigger, function(a, id)
			if a == RunForHelpCivs[1] or a == RunForHelpCivs[2] then
				Reinforcements.Reinforce(GDI, CiviliansHelpTeam, { CPos.New(2,9), CPos.New(3,9) }, 30, function(a)
					a.AttackMove(waypoint2.Location)
					a.AttackMove(waypoint9.Location)
					a.AttackMove(waypoint8.Location)
					IdleHunt(a)
				end)
				Trigger.RemoveFootprintTrigger(id)
			end
		end)
		CivsRunning = true
		local cam = Actor.Create("camera", true, { Owner = Nod, Location = CPos.New(53,44) })
		Trigger.AfterDelay(125, cam.Destroy)
		Media.DisplayMessage(UserInterface.Translate("civilians-runs"), UserInterface.Translate("nod-soldier"))
	end
end

CivsBuildingsToDestroy = 0
CheckVillageDestruction = function()
	CivsBuildingsToDestroy = CivsBuildingsToDestroy - 1
	if CivsBuildingsToDestroy == 2 then
		Media.DisplayMessage(UserInterface.Translate("village-destruction-warning"))
	elseif CivsBuildingsToDestroy == 0 then
		Reinforcements.Reinforce(GDI, ReinforcementsMammoths, { CPos.New(2,9), CPos.New(3,9) }, 40, function(a)
			a.AttackMove(waypoint11.Location)
			a.AttackMove(waypoint5.Location)
			a.AttackMove(waypoint4.Location)
			a.AttackMove(waypoint6.Location)
			IdleHunt(a)
		end)
	end
end

GuardBase = function()
	Utils.Do(GDIBase, function(building)
		GuardBuilding(building)
	end)
end

GuardBuilding = function(building)
	Trigger.OnDamaged(building, function(slf, atk, dmg)
		for i,PID in pairs (CoopPlayers) do
		if atk.Type ~= "player" and not atk.IsDead and atk.Owner == PID then
			Utils.Do(BaseDefenseTeam, function(guard)
				if not guard.IsDead and not building.IsDead then
					if guard.Stance == "Defend" then
						guard.Stop()
						guard.Stance = "AttackAnything"
						guard.AttackMove(atk.Location, 3)
						Trigger.OnIdle(guard, function()
							guard.AttackMove(waypoint12.Location, 3)
							guard.Stance = "Defend"
							Trigger.ClearAll(guard)
						end)
					end
				end
			end)
		end
		end
	end)
end

StartGuard = function()
	Trigger.OnAllKilled(BaseDefenseTeam, function()
		table.insert(UniqueTeamsQueue, { team = DefenseTeams, job = "defend" })
	end)
	Utils.Do(BaseDefenseTeam, function(guard)
		guard.Stance = "Defend"
	end)
end

StartPatrol = function()
	Trigger.OnAllKilled(PatrolTeam, function()
		table.insert(UniqueTeamsQueue, { team = PatrolTeams, job = "patrol" })
	end)
	Utils.Do(PatrolTeam, function(a)
		Trigger.OnKilled(a, function()
			Utils.Do(PatrolTeam, function(a)
				if not a.IsDead then
					a.Stop()
					IdleHunt(a)
				end
			end)
		end)
	end)
	MoveAsGroup(PatrolTeam, PatrolPath, 1, true)
end

MoveAsGroup = function(team, path, i, loop)
	if i == 1 and not loop then
		Utils.Do(team, function(u)
			Trigger.OnDamaged(u, function()
				Utils.Do(team, function(u)
					if not u.IsDead then
						Trigger.Clear(u, "OnDamaged")
						IdleHunt(u)
					end
				end)
			end)
		end)
	end
	Utils.Do(team, function(a)
		if not a.IsDead then
			a.Stance = "AttackAnything"
			a.AttackMove(path[i], 2)
			Trigger.OnIdle(a, function()
				Trigger.Clear(a, "OnIdle")
				a.Stance = "Defend"
				local teamNumber = 0
				local regrouped = false
				Utils.Do(team, function(a)
					if a.IsDead or a.Stance == "Defend" then
						teamNumber = teamNumber + 1
						if teamNumber == #team then
							regrouped = true
						end
					end
				end)
				if regrouped then
					if i == #path then
						if loop == true then
							i = 1
						else
							Trigger.AfterDelay(5, function()
								Utils.Do(team, function(a)
									if not a.IsDead then
										a.Stance = "AttackAnything"
										IdleHunt(a)
									end
								end)
							end)
							return
						end
					else
						i = i + 1
					end
					Trigger.AfterDelay(20, function()
						MoveAsGroup(team, path, i, loop)
					end)
				end
			end)
		end
	end)
end

IonCannonOnline = false
ICShotsCount = 0
FireIonCannon = function(timer)
	if IonCannonOnline then
		local ii = Utils.RandomInteger(1, 4)
		local targets = { }
		if ii < 3 then
			targets = Nod.GetActorsByTypes(IonCannonTargets[ii])
			for i,PID in pairs (CoopPlayers) do
				if PID ~= Nod then
					AlsoTarget = PID.GetActorsByTypes({ "nuk2", "atwr", "weap", "proc" })
					for i,CID in pairs (AlsoTarget) do
						table.insert(targets, CID)
					end
				end
			end
		else
			targets = Nod.GetGroundAttackers()
			for i,PID in pairs (CoopPlayers) do
				if PID ~= Nod then
					AlsoTarget = PID.GetGroundAttackers()
					for i,CID in pairs (AlsoTarget) do
						table.insert(targets, CID)
					end
				end
			end
		end
		if #targets > 0 then
			local rand = Utils.RandomInteger(1, #targets + 1)
			if not targets[rand].IsDead then
				GDIAdvComCenter.ActivateIonCannon(targets[rand].Location)
				if ICShotsCount < 2 then
					ICShotsCount = ICShotsCount + 1
					if ICShotsCount > 1 then
						for i,PID in pairs (CoopPlayers) do
						PID.MarkFailedObjective(DestroyIonCannon)
						end
						Trigger.ClearAll(GDIAdvComCenter)
					end
				end
				Trigger.AfterDelay(DateTime.Seconds(timer), function() FireIonCannon(timer) end)
				return
			end
		end
		Trigger.AfterDelay(DateTime.Seconds(1), function() FireIonCannon(timer) end)
	end
end

CheckObjectives = function()
	if GDI.HasNoRequiredUnits() then
		for i,PID in pairs (CoopPlayers) do
			PID.MarkCompletedObjective(EliminateAllGDI)
		end
	end
	for i,PID in pairs (CoopPlayers) do
		if PID.HasNoRequiredUnits() and DateTime.GameTime > DateTime.Seconds(10) then
			for i,PID2 in pairs (CoopPlayers) do
				PID2.MarkFailedObjective(EliminateAllGDI)
			end
		end
	end
	Trigger.AfterDelay(25, CheckObjectives)
end

BadGuySpread = function()
	P1Units = BadGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end

NodSpread = function()
	P1Units = Nod.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end


WorldLoaded = function()
	Nod = Player.GetPlayer("Nod")
	GDI = Player.GetPlayer("GDI")
	BadGuy = Player.GetPlayer("BadGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	CoopPlayers = {};
	table.insert(CoopPlayers, Nod)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end
	
	Media.PlayMovieInRadar("consyard.vqa")

	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end

	EnemyUnits = GDI.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	CoopCurrent = 1
	NodSpread()
	for i,PID in pairs (CoopPlayers) do
		if PID ~= Nod then
			CopyMCV = Actor.Create("mcv", true, { Location = Actor84.Location, Owner = PID })
			CopyMCV.Scatter()
		end
	end
	
	Camera.Position = PlayerStart.CenterPosition
	Flare = Actor.Create("flare", true, { Owner = Nod, Location = DefaultFlareLocation.Location })
	Trigger.AfterDelay(DateTime.Minutes(1), Flare.Destroy)
	InitObjectives(Nod)
	for i,PID in pairs (CoopPlayers) do
	EliminateAllGDI = AddPrimaryObjective(PID, "eliminate-gdi-forces")
	FindAllCivMoney = AddSecondaryObjective(PID, "take-civilians-money-crates")
	end
	CheckObjectives()
	InitAi()

	Trigger.OnEnteredFootprint(WelcomeTeamCellTrigger, function(a, id)
		for i,PID in pairs (CoopPlayers) do
		if a.Owner == PID then
			Utils.Do(WelcomeTeam, function(a)
				if not a.IsDead then
					a.AttackMove(PlayerStart.Location)
					IdleHunt(a)
				end
			end)
			Trigger.RemoveFootprintTrigger(id)
		end
		end
	end)

	Trigger.OnAllKilled(Civilians, function()
		local cargo = Reinforcements.ReinforceWithTransport(GDI, "tran", ReinforcementsEngineers, { CPos.New(0,32), waypoint10.Location }, { CPos.New(0,32) })[2]
		Utils.Do(cargo, function(engs)
			if engs.Type == "e6" then
				Trigger.OnIdle(engs, CaptureStructures)
			end
		end)
	end)

	Utils.Do(CiviliansBuildings, function(b)
		Trigger.OnKilled(b, CheckVillageDestruction)
	end)

	Utils.Do(OilDerricks, function(actor)
		Trigger.OnKilledOrCaptured(actor, OilDerricksAirstrike)
	end)

	Utils.Do(RunForHelpCivs, function(actor)
		Trigger.OnDiscovered(actor, RunForHelp)
	end)

	Trigger.OnEnteredFootprint(GDIBaseEntranceCells, function(a, id)
		for i,PID in pairs (CoopPlayers) do
		if a.Owner == PID and not BombTriggered then
			BombTriggered = true
			Trigger.AfterDelay(25, SendGDIAirstrike)
			Trigger.AfterDelay(150, SendGDIAirstrike)
			Trigger.AfterDelay(275, SendGDIAirstrike)
			Trigger.RemoveFootprintTrigger(id)
		end
		end
	end)

	Trigger.OnCapture(GDIhq, function()
		GDIhq.GrantCondition("captured")
	end)

	Trigger.OnEnteredFootprint(InnerGDIBaseEntranceCells, function(a, id)
		for i,PID in pairs (CoopPlayers) do
		if a.Owner == PID and not InnerBaseEntered then
			InnerBaseEntered = true
			Reinforcements.Reinforce(GDI, ReinforcementsMammoths, { CPos.New(2,9), CPos.New(3,9) }, 40, IdleHunt)
			Trigger.RemoveFootprintTrigger(id)
		end
		end
	end)

	Trigger.AfterDelay(5, function()
		StartPatrol()
		GuardBase()
		StartGuard()
	end)

	Trigger.OnAllKilled(CivsMoneyBuildings, function()
		Trigger.AfterDelay(1, function()
			Trigger.OnAllRemovedFromWorld(Utils.Where(Map.ActorsInWorld, function(a) return a.Type == "moneycrate" or a.Type == "smallmcrate" end), function()
				for i,PID in pairs (CoopPlayers) do
				PID.MarkCompletedObjective(FindAllCivMoney)
				end
			end)
		end)
	end)

	Trigger.OnKilledOrCaptured(GDIAdvComCenter, function()
		if IonCannonOnline then
			IonCannonOnline = false
		else
			for i,PID in pairs (CoopPlayers) do
			DestroyIonCannon = AddSecondaryObjective(PID, "quickly-destroy-ion-cannon")
			end
		end
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(DestroyIonCannon)
		end
		PrepareOrcas()
	end)
end
Tick = function()
	BadGuySpread()
end