--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

CommandoReinforcements = {}
MCVReinforcements = {}

AutocreateSquads =
{
	{ "stnk", "stnk" },
	{ "ftnk", "ftnk" },
	{ "ltnk", "ltnk", "bike" },
	{ "arty", "arty", "bike", "bike" },
	{ "ltnk", "ltnk" },
	{ "stnk", "stnk" },
	{ "ltnk", "ltnk" },
	{ "arty", "arty" }
}

HeliPatrolPaths =
{
	{ HeliPatrol1.Location, HeliPatrol2.Location, HeliPatrol3.Location, HeliPatrol4.Location, HeliPatrol5.Location, HeliPatrol6.Location },
	{ HeliPatrol5.Location, HeliPatrol4.Location, HeliPatrol3.Location, HeliPatrol2.Location, HeliPatrol1.Location, HeliPatrol6.Location }
}

AttackTriggers = { AttackTrigger1, AttackTrigger2, AttackTrigger3, AttackTrigger4 }

SamSites = { SAM01, SAM02 }

GoodGuySpread = function()
	P1Units = GoodGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end

P1Units = GoodGuy.GetActorsByType("mcv")
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end

end

WorldLoaded = function()
	Nod = Player.GetPlayer("Nod")
	GDI = Player.GetPlayer("GDI")
	GoodGuy = Player.GetPlayer("GoodGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	CoopPlayers = {};
	table.insert(CoopPlayers, GDI)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end
	
	Media.PlayMovieFullscreen("obel.vqa")

	if Map.LobbyOption("blossom") == "blossomon"  then
		ExtraMines = {ExtraBlossom1, ExtraBlossom2, ExtraBlossom3, ExtraBlossom4, ExtraBlossom5}
		for i,MID in pairs (ExtraMines) do
			AddMine = Actor.Create("split2", true, { Location = MID.Location, Owner = Neutral })
		end
	end
	
	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end

	EnemyUnits = Nod.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	CoopCurrent = 1

	InitObjectives(GDI)

	for i,PID in pairs (CoopPlayers) do
	DestroySAMs = AddPrimaryObjective(PID, "destroy-obelisk-sams")
	DestroyObelisk = AddPrimaryObjective(PID, "destroy-obelisk")
	DestroyBiotechCenter = AddPrimaryObjective(PID, "destroy-biotech")
	end
	
	Trigger.OnAllKilled(SamSites, function()
		AirSupport = Actor.Create("airstrike.proxy", true, { Owner = GDI })
		AirSupportEnabled = true
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(DestroySAMs)
		end
	end)

	Trigger.OnDamaged(Obelisk01, function()
		Trigger.AfterDelay(DateTime.Seconds(1), Obelisk01.Kill)
	end)

	Trigger.OnKilled(Obelisk01, function()
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(DestroyObelisk)
		end
		
		Trigger.AfterDelay(DateTime.Seconds(5), function()
			Media.PlaySpeechNotification(All, "Reinforce")
			for i,PID in pairs (CoopPlayers) do
				table.insert(MCVReinforcements, "mcv")
			end
			ReinforceWithLandingCraft(GoodGuy, MCVReinforcements, lstStart.Location, lstEnd.Location, UnitsRally.Location)
		end)

		ObeliskFlare.Destroy()
		if AirSupportEnabled then
			AirSupport.Destroy()
		end
	end)

	Trigger.OnKilled(Biolab, function()
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(DestroyBiotechCenter)
		end
	end)

	Trigger.OnCapture(Biolab, function()
		Trigger.AfterDelay(DateTime.Seconds(1), Biolab.Kill)
	end)

	Trigger.OnDamaged(Biolab, function()
		Utils.Do(Nod.GetGroundAttackers(), IdleHunt)
	end)

	RepairNamedActors(Nod, 0.9)

	Trigger.AfterDelay(0, function()
		local toBuild = function() return { "harv" } end
		Utils.Do(Nod.GetActorsByType("harv"), function(harv)
			RebuildHarvesters(harv, toBuild)
		end)
	end)

	local vehicleToBuild = function() return Utils.Random(AutocreateSquads) end
	Utils.Do(AttackTriggers, function(a)
		Trigger.OnKilledOrCaptured(a, function()
			ProduceUnits(Nod, Airfield, nil, vehicleToBuild)
		end)
	end)
	Trigger.AfterDelay(DateTime.Seconds(150), function()
		ProduceUnits(Nod, Airfield, function() return DateTime.Seconds(150) end, vehicleToBuild)
	end)

	Trigger.AfterDelay(DateTime.Minutes(5), HeliHunt)

	local toBuild = function() return { "e4" } end
	local delay = function() return DateTime.Seconds(15) end
	ProduceUnits(Nod, HandOfNod, delay, toBuild)

	Camera.Position = UnitsRally.CenterPosition
	ObeliskFlare = Actor.Create("flare", true, { Owner = GDI, Location = Flare.Location })

	Media.PlaySpeechNotification(All, "Reinforce")
	for i,PID in pairs (CoopPlayers) do
		table.insert(CommandoReinforcements, "rmbo")
	end
	ReinforceWithLandingCraft(GoodGuy, CommandoReinforcements, lstStart.Location, lstEnd.Location, UnitsRally.Location)
end

Tick = function()
	GoodGuySpread()
	for i,PID in pairs (CoopPlayers) do
	if DateTime.GameTime > DateTime.Seconds(10) and PID.HasNoRequiredUnits() then
		for i,PID2 in pairs (CoopPlayers) do
			PID2.MarkFailedObjective(DestroyBiotechCenter)
		end
	end
	end
end

-- Overwrite the default to send the units to UnitsRally first
IdleHunt = function(unit)
	if not unit.IsDead then
		Trigger.OnIdle(unit, function()
			unit.AttackMove(UnitsRally.Location, 50)
			unit.Hunt()
		end)
	end
end

HeliHunt = function()
	local patrolpath = Utils.Random(HeliPatrolPaths)
	Utils.Do(Nod.GetActorsByType("heli"), function(actor)
		Trigger.OnIdle(actor, function()
			actor.Patrol(patrolpath)
		end)
	end)
end

RebuildHarvesters = function(harv, toBuild)
	Trigger.OnRemovedFromWorld(harv, function()
		ProduceUnits(Nod, Airfield, nil, toBuild, function(units)
			RebuildHarvesters(units[1], toBuild)
		end)
	end)
end
