--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

if Difficulty == "easy" then
	Rambo = "rmbo.easy"
elseif Difficulty == "hard" then
	Rambo = "rmbo.hard"
else
	Rambo = "rmbo"
end

GDIBuildings = { ConYard, PowerPlant1, PowerPlant2, PowerPlant3, PowerPlant4, PowerPlant5, Barracks, Silo1, Silo2, WeaponsFactory, CommCenter, GuardTower1, GuardTower2 }

Mammoths = { Mammoth1, Mammoth2, Mammoth3 }
Grenadiers = { Grenadier1, Grenadier2, Grenadier3, Grenadier4 }
MediumTanks = { MediumTank1, MediumTank2 }
Riflemen = { Rifleman1, Rifleman2, Rifleman3, Rifleman4 }

MammothPatrolPath = { MammothWaypoint1.Location, MammothWaypoint2.Location }
RiflemenPatrolPath = { RiflemenWaypoint1.Location, RiflemenWaypoint2.Location }

InfantrySquad = { "e1", "e1", "e1", "e1", "e1" }

DeliverCommando = function()
	Media.PlaySpeechNotification(All, "Reinforce")
	CommandoLives = true
	CommandoTrigger = false
	CommandoTriggerSetup = false
	Commandos = {}
	LivingCommandos = {}
	for i,PID in pairs (CoopPlayers) do
		table.insert(Commandos, Rambo)
	end
	local rambo = Reinforcements.ReinforceWithTransport(BadGuy, "tran.in", Commandos, { ChinookEntry.Location, ChinookTarget.Location }, { ChinookEntry.Location })[2][1]
	
	--[[Trigger.OnAnyKilled(LivingCommandos, function()
		CommandoLives = false
		for i,PID in pairs (CoopPlayers) do
			PID.MarkFailedObjective(KeepRamboAliveObjective)
		end
	end)]]
		
	Trigger.OnPlayerWon(Nod, function(Nod)
        if CommandoLives == true then
            for i,PID in pairs (CoopPlayers) do
			PID.MarkCompletedObjective(KeepRamboAliveObjective)
			end
        end
	end)
end

BadGuySpread = function()
	P1Units = BadGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
	if UID.Type == Rambo then
		table.insert(LivingCommandos, UID)
		Trigger.AfterDelay(DateTime.Seconds(1),function()
			CommandoTrigger = true
		end)
	end
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end

NodSpread = function()
	P1Units = Nod.GetActors()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end

PlayOpening = function()
Media.PlayMovieFullscreen("nod10b.vqa")
end

WorldLoaded = function()
	Nod = Player.GetPlayer("Nod")
	GDI = Player.GetPlayer("GDI")
	BadGuy = Player.GetPlayer("BadGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	CoopPlayers = {};
	table.insert(CoopPlayers, Nod)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end
	
	Media.PlayMovieFullscreen("kanepre.vqa",PlayOpening)

	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end

	EnemyUnits = GDI.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	CoopCurrent = 1
	NodSpread()

	GDI.Cash = 10000

	Camera.Position = DefaultCameraPosition.CenterPosition

	InitObjectives(Nod)

	GDIObjective = AddPrimaryObjective(GDI, "")
	for i,PID in pairs (CoopPlayers) do
	WarFactoryObjective = AddPrimaryObjective(PID, "destroy-capture-warfactory")
	DestroyTanksObjective = AddPrimaryObjective(PID, "destroy-mammoth-tanks")
	KeepRamboAliveObjective = AddSecondaryObjective(PID, "keep-commando-alive")
	end
	
	Trigger.OnKilledOrCaptured(WeaponsFactory, function()
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(WarFactoryObjective)
		end
	end)

	Trigger.OnAllKilled(Mammoths, function()
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(DestroyTanksObjective)
		end
	end)

	Trigger.AfterDelay(DateTime.Seconds(1), DeliverCommando)

	Utils.Do(Mammoths, function(mammoth)
		mammoth.Stance = "HoldFire"
    end)

	Utils.Do(MediumTanks, function(tank)
		Trigger.OnDamaged(tank, function()
			if DamageTrigger then
				return
			end

			DamageTrigger = true
			Utils.Do(Grenadiers, function(grenadier)
				if not grenadier.IsDead then
					grenadier.AttackMove(tank.Location)
				end
			end)
		end)
    end)

	Utils.Do(Grenadiers, function(grenadier)
		Trigger.OnDamaged(grenadier, function()
			if DamageTrigger then
				return
			end

			DamageTrigger = true
			Utils.Do(MediumTanks, function(tank)
				if not tank.IsDead then
					tank.AttackMove(grenadier.Location)
				end
			end)
		end)
    end)

	Utils.Do(GDIBuildings, function(building)
		RepairBuilding(GDI, building, 0.75)
    end)

	Trigger.OnEnteredFootprint({ NorthEntrance.Location }, function(a, id)
		for i,PID in pairs (CoopPlayers) do
		if a.Owner == PID then
			Trigger.RemoveFootprintTrigger(id)

			if Barracks.IsDead or Barracks.Owner ~= GDI then
				return
			end

			Barracks.Build(InfantrySquad, function(squad)
				Utils.Do(squad, function(unit)
					if not unit.IsDead then
						unit.AttackMove(NorthEntrance.Location)
					end
				end)
			end)
		end
		end
	end)

	Utils.Do(Riflemen, function(rifleman)
		rifleman.Patrol(RiflemenPatrolPath)
    end)

	PatrollingMammoth.Patrol(MammothPatrolPath)
end

BotController = function ()
	for i,PID in pairs (CoopPlayers) do
		if PID.IsBot == true then
			local BotUnits = PID.GetGroundAttackers()
			Utils.Do(BotUnits, IdleHunt)
		end
	end
end

Tick = function()
	BadGuySpread()
	BotController()
	if CommandoTrigger == true and CommandoTriggerSetup == false then
		CommandoTriggerSetup = true
		Trigger.OnAnyKilled(LivingCommandos, function()
		CommandoLives = false
			for i,PID in pairs (CoopPlayers) do
			PID.MarkFailedObjective(KeepRamboAliveObjective)
			end
		end)
	end
	LostCounter = 0
	for i,PID in pairs (CoopPlayers) do
		if DateTime.GameTime > DateTime.Seconds(10) and PID.HasNoRequiredUnits() then
			LostCounter = LostCounter+1
		end
	end
	if LostCounter == #CoopPlayers then
		GDI.MarkCompletedObjective(GDIObjective)
	end
end