--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

if Difficulty == "easy" then
	Rambo = "rmbo.easy"
elseif Difficulty == "hard" then
	Rambo = "rmbo.hard"
else
	Rambo = "rmbo"
end

SamSiteGoal = 3

WaypointGroup1 = { waypoint0, waypoint3, waypoint2, waypoint4, waypoint5, waypoint7 }
WaypointGroup2 = { waypoint0, waypoint3, waypoint2, waypoint4, waypoint5, waypoint6 }
WaypointGroup3 = { waypoint0, waypoint8, waypoint9, waypoint10, waypoint11, waypoint12, waypoint6, waypoint13 }
Patrol1Waypoints = { waypoint0.Location, waypoint8.Location, waypoint9.Location, waypoint10.Location }
Patrol2Waypoints = { waypoint0.Location, waypoint3.Location, waypoint2.Location, waypoint4.Location }

GDI1 = { units = { ['e2'] = 3, ['e3'] = 2 }, waypoints = WaypointGroup1, delay = 40 }
GDI2 = { units = { ['e1'] = 2, ['e2'] = 4 }, waypoints = WaypointGroup2, delay = 50 }
GDI4 = { units = { ['jeep'] = 2 }, waypoints = WaypointGroup1, delay = 50 }
GDI5 = { units = { ['mtnk'] = 1 }, waypoints = WaypointGroup1, delay = 40 }
Auto1 = { units = { ['e1'] = 2, ['e3'] = 3 }, waypoints = WaypointGroup3, delay = 40 }
Auto2 = { units = { ['e2'] = 2, ['e3'] = 2 }, waypoints = WaypointGroup3, delay = 50 }
Auto3 = { units = { ['e1'] = 3, ['e2'] = 2 }, waypoints = WaypointGroup2, delay = 60 }
Auto4 = { units = { ['mtnk'] = 1 }, waypoints = WaypointGroup1, delay = 50 }
Auto5 = { units = { ['mtnk'] = 1 }, waypoints = WaypointGroup3, delay = 50 }
Auto6 = { units = { ['e1'] = 2, ['e3'] = 2 }, waypoints = WaypointGroup3, delay = 50 }
Auto7 = { units = { ['msam'] = 1 }, waypoints = WaypointGroup1, delay = 40 }
Auto8 = { units = { ['msam'] = 1 }, waypoints = WaypointGroup3, delay = 50 }

RmboReinforcements = { Rambo }
EngineerReinforcements = { "e6", "e6" }
RocketReinforcements = { "e3", "e3", "e3", "e3" }

AutoAttackWaves = { GDI1, GDI2, GDI4, GDI5, Auto1, Auto2, Auto3, Auto4, Auto5, Auto6, Auto7, Auto8 }

NodBaseTrigger = { CPos.New(9, 52), CPos.New(9, 51), CPos.New(9, 50), CPos.New(9, 49), CPos.New(9, 48), CPos.New(9, 47), CPos.New(9, 46), CPos.New(10, 46), CPos.New(11, 46), CPos.New(12, 46), CPos.New(13, 46), CPos.New(14, 46), CPos.New(15, 46), CPos.New(16, 46), CPos.New(17, 46), CPos.New(18, 46), CPos.New(19, 46), CPos.New(20, 46), CPos.New(21, 46), CPos.New(22, 46), CPos.New(23, 46), CPos.New(24, 46), CPos.New(25, 46), CPos.New(25, 47), CPos.New(25, 48), CPos.New(25, 49), CPos.New(25, 50), CPos.New(25, 51), CPos.New(25, 52) }
EngineerTrigger = { CPos.New(5, 13), CPos.New(6, 13), CPos.New(7, 13), CPos.New(8, 13), CPos.New(9, 13), CPos.New(10, 13), CPos.New(16, 7), CPos.New(16, 6), CPos.New(16, 5), CPos.New(16, 4), CPos.New(16, 3)}
RocketTrigger = { CPos.New(20, 15), CPos.New(21, 15), CPos.New(22, 15), CPos.New(23, 15), CPos.New(24, 15), CPos.New(25, 15), CPos.New(26, 15), CPos.New(32, 15), CPos.New(32, 14), CPos.New(32, 13), CPos.New(32, 12), CPos.New(32, 11)}

AirstrikeDelay = DateTime.Minutes(2) + DateTime.Seconds(30)

CheckForSams = function(PID)
	local sams = PID.GetActorsByType("sam")
	return #sams >= SamSiteGoal
end

SendGDIAirstrike = function(hq, delay)
	if not hq.IsDead and hq.Owner == GDI then
		RNG = Utils.RandomInteger(1, #CoopPlayers)
		local target = GetAirstrikeTarget(CoopPlayers[RNG])

		if target then
			hq.TargetAirstrike(target, Angle.NorthEast + Angle.New(16))
			Trigger.AfterDelay(delay/#CoopPlayers, function() SendGDIAirstrike(hq, delay) end)
		else
			Trigger.AfterDelay((delay/#CoopPlayers)/4, function() SendGDIAirstrike(hq, delay) end)
		end
	end
end

SendWaves = function(counter, Waves)
	if counter <= #Waves then
		local team = Waves[counter]

		for type, amount in pairs(team.units) do
			MoveAndHunt(Utils.Take(amount, GDI.GetActorsByType(type)), team.waypoints)
		end

		Trigger.AfterDelay(DateTime.Seconds(team.delay), function() SendWaves(counter + 1, Waves) end)
	end
end

StartPatrols = function()
	local mtnks = GDI.GetActorsByType("mtnk")
	local msams = GDI.GetActorsByType("msam")

	if #mtnks >= 1 then
		mtnks[1].Patrol(Patrol1Waypoints, true, 20)
	end

	if #msams >= 1 then
		msams[1].Patrol(Patrol2Waypoints, true, 20)
	end
end

Trigger.OnEnteredFootprint(NodBaseTrigger, function(a, id)
	for i,PID in pairs (CoopPlayers) do
	if not Nod.IsObjectiveCompleted(LocateNodBase) and a.Owner == PID then
		Trigger.RemoveFootprintTrigger(id)

		for i,PID2 in pairs (CoopPlayers) do
			PID2.MarkCompletedObjective(LocateNodBase)
			if PID2 ~= Nod then
				ExtraMCV = Actor.Create("mcv", true,{ Owner = PID2, Location = NodCYard.Location} )
				ExtraMCV.Scatter()
			end
		end
		NodCYard.Owner = Nod

		local walls = NodBase.GetActorsByType("brik")
		Utils.Do(walls, function(actor)
			actor.Owner = Nod
		end)

		Trigger.AfterDelay(DateTime.Seconds(2), function()
			Media.PlaySpeechNotification(All, "NewOptions")
		end)
	end
	end
end)

Trigger.OnEnteredFootprint(RocketTrigger, function(a, id)
	for i,PID in pairs (CoopPlayers) do
	if not Nod.IsObjectiveCompleted(SecureFirstLanding) and a.Owner == PID then
		Trigger.RemoveFootprintTrigger(id)
		
		for i,PID2 in pairs (CoopPlayers) do
		PID2.MarkCompletedObjective(SecureFirstLanding)
		end
		
		Trigger.AfterDelay(DateTime.Seconds(5), function()
			Media.PlaySpeechNotification(All, "Reinforce")
			Reinforcements.ReinforceWithTransport(BadGuy, "tran.in", RocketReinforcements, { HelicopterEntryRocket.Location, HelicopterGoalRocket.Location }, { HelicopterEntryRocket.Location }, nil, nil)
		end)

		Trigger.AfterDelay(DateTime.Seconds(10), function()
			EngineerFlareCamera1 = Actor.Create("camera", true, { Owner = Nod, Location = FlareEngineer.Location })
			EngineerFlareCamera2 = Actor.Create("camera", true, { Owner = Nod, Location = CameraEngineerPath.Location })
			EngineerFlare = Actor.Create("flare", true, { Owner = Nod, Location = FlareEngineer.Location })
		end)

		Trigger.AfterDelay(DateTime.Minutes(1), function()
			RocketFlareCamera.Destroy()
			RocketFlare.Destroy()
		end)
	end
	end
end)

Trigger.OnEnteredFootprint(EngineerTrigger, function(a, id)
	for i,PID in pairs (CoopPlayers) do
	if not Nod.IsObjectiveCompleted(SecureSecondLanding) and a.Owner == PID then
		Trigger.RemoveFootprintTrigger(id)
		
		for i,PID2 in pairs (CoopPlayers) do
		PID2.MarkCompletedObjective(SecureSecondLanding)
		end
		
		Trigger.AfterDelay(DateTime.Seconds(5), function()
			Media.PlaySpeechNotification(All, "Reinforce")
			Reinforcements.ReinforceWithTransport(Nod, "tran.in", EngineerReinforcements, { HelicopterEntryEngineer.Location, HelicopterGoalEngineer.Location }, { HelicopterEntryEngineer.Location }, nil, nil)
		end)

		Trigger.AfterDelay(DateTime.Minutes(1), function()
			if EngineerFlareCamera1 then
				EngineerFlareCamera1.Destroy()
				EngineerFlareCamera2.Destroy()
				EngineerFlare.Destroy()
			end
		end)
	end
	end
end)

Trigger.OnKilledOrCaptured(OutpostProc, function()
	if not Nod.IsObjectiveCompleted(CaptureRefinery) then

		if OutpostProc.IsDead then
			for i,PID in pairs (CoopPlayers) do
			PID.MarkFailedObjective(CaptureRefinery)
			end
		else
			for i,PID in pairs (CoopPlayers) do
			PID.MarkCompletedObjective(CaptureRefinery)
			Nod.Cash = 1000
				if PID ~= Nod then
				PID.Cash = 2500
				end
			end
		end

		StartPatrols()

		Trigger.AfterDelay(DateTime.Minutes(1), function() SendWaves(1, AutoAttackWaves) end)
		Trigger.AfterDelay(AirstrikeDelay, function() SendGDIAirstrike(GDIHQ, AirstrikeDelay) end)
		Trigger.AfterDelay(DateTime.Minutes(3), function() ProduceInfantry(GDIPyle) end)
		Trigger.AfterDelay(DateTime.Minutes(3), function() ProduceVehicle(GDIWeap) end)
	end
end)

BadGuySpread = function()
	P1Units = BadGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end

WorldLoaded = function()
	Nod = Player.GetPlayer("Nod")
	GDI = Player.GetPlayer("GDI")
	NodBase = Player.GetPlayer("NodBase")
	BadGuy = Player.GetPlayer("BadGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	CoopPlayers = {};
	table.insert(CoopPlayers, Nod)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end
	
	Media.PlayMovieFullscreen("nod9.vqa")

	if Map.LobbyOption("blossom") == "blossomon"  then
		ExtraMines = {ExtraBlossom1, ExtraBlossom2, ExtraBlossom3, ExtraBlossom4, ExtraBlossom5}
		for i,MID in pairs (ExtraMines) do
			AddMine = Actor.Create("split2", true, { Location = MID.Location, Owner = Neutral })
		end
	end

	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end

	EnemyUnits = GDI.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	CoopCurrent = 1


	Camera.Position = CameraIntro.CenterPosition

	Media.PlaySpeechNotification(All, "Reinforce")
	for i,PID in pairs (CoopPlayers) do
		if PID ~= Nod then
			table.insert(RmboReinforcements, Rambo)
		end
	end
	Reinforcements.ReinforceWithTransport(BadGuy, "tran.in", RmboReinforcements, { HelicopterEntryRmbo.Location, HelicopterGoalRmbo.Location }, { HelicopterEntryRmbo.Location })

	RocketFlareCamera = Actor.Create("camera", true, { Owner = Nod, Location = FlareRocket.Location })
	RocketFlare = Actor.Create("flare", true, { Owner = Nod, Location = FlareRocket.Location })

	StartAI()
	AutoGuard(GDI.GetGroundAttackers())

	InitObjectives(Nod)
	
	for i,PID in pairs (CoopPlayers) do
	SecureFirstLanding = AddPrimaryObjective(PID, "secure-first-landing-zone")
	SecureSecondLanding = AddPrimaryObjective(PID, "secure-second-landing-zone")
	LocateNodBase = AddPrimaryObjective(PID, "locate-nod-base")
	CaptureRefinery = AddPrimaryObjective(PID, "capture-refinery")
	EliminateGDI = AddPrimaryObjective(PID, "eliminate-gdi-forces")
	end
	local buildSAMs = UserInterface.Translate("build-sams", { ["sams"] = SamSiteGoal })
	for i,PID in pairs (CoopPlayers) do
	BuildSAMs = AddSecondaryObjective(PID, buildSAMs)
	end
	GDIObjective = AddPrimaryObjective(GDI, "")
end

Tick = function()
	BadGuySpread()
	for i,PID in pairs (CoopPlayers) do
	if DateTime.GameTime > DateTime.Seconds(10) and PID.HasNoRequiredUnits() then
		GDI.MarkCompletedObjective(GDIObjective)
	end
	end

	if DateTime.GameTime > 2 and GDI.HasNoRequiredUnits() then
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(EliminateGDI)
		end
	end
	
	for i,PID in pairs (CoopPlayers) do
	if not PID.IsObjectiveCompleted(BuildSAMs) and CheckForSams(PID) then
		PID.MarkCompletedObjective(BuildSAMs)
	end
	end
end
