--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

NodUnitsVehicles1 = { "bggy", "bggy", "bike", "bike" }
NodUnitsVehicles2 = { "ltnk", "ltnk" }
NodUnitsEngineers = { "e6", "e6", "e6", "e6" }
NodUnitsRockets = { "e3", "e3", "e3", "e3" }
NodUnitsGunners = { "e1", "e1", "e1", "e1" }
NodUnitsFlamers = { "e4", "e4", "e4", "e4" }

MainEntranceGuards = { JeepGuard1, JeepGuard2, MediumTank1, SideGuard1, SideGuard2, SideGuard6, SideGuard7, Guard1, Guard2, Guard3, Guard4, Guard5, Guard6, Guard7, Guard8, Guard9, Guard10 }
InfantryPatrol = { InfantryPatrol1, InfantryPatrol2 }

MainEntrancePatrolPath = { waypoint0.Location, waypoint1.Location, waypoint15.Location, waypoint12.Location }
InfantryPatrolPath = { waypoint0.Location, waypoint1.Location, waypoint2.Location, waypoint8.Location, waypoint2.Location, waypoint9.Location, waypoint2.Location }
JeepPatrolPath = { waypoint0.Location, waypoint1.Location, waypoint3.Location, waypoint4.Location, waypoint3.Location, waypoint2.Location, waypoint5.Location, waypoint6.Location, waypoint2.Location, waypoint7.Location }
MediumTankPatrolPath = { waypoint14.Location, waypoint5.Location }

TargetsKilled = 0

InsertNodUnits = function()
	Media.PlaySpeechNotification(All, "Reinforce")
	Reinforcements.Reinforce(BadGuyRight, { "ltnk" }, { ReinforcementsTopSpawn.Location, ReinforcementsTankRally.Location }, 1)

	local engineers = Reinforcements.Reinforce(BadGuyRight, NodUnitsEngineers, { ReinforcementsTopSpawn.Location, ReinforcementsEngineersRally.Location }, 10)
	Reinforcements.Reinforce(BadGuyRight, NodUnitsRockets, { ReinforcementsBottomSpawn.Location, ReinforcementsRocketsRally.Location }, 10)

	Trigger.AfterDelay(DateTime.Seconds(3), function()
		Reinforcements.Reinforce(BadGuyRight, NodUnitsGunners, { ReinforcementsBottomSpawn.Location, ReinforcementsGunnersRally.Location }, 10)
		Reinforcements.Reinforce(BadGuyRight, NodUnitsFlamers, { ReinforcementsTopSpawn.Location, ReinforcementsFlamersRally.Location }, 10)
	end)

	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Reinforcements.ReinforceWithTransport(BadGuyLeft, "tran.in", NodUnitsVehicles1, { GunboatRight.Location, ReinforcementsHelicopter1Rally.Location }, { GunboatRight.Location })

		Trigger.AfterDelay(DateTime.Seconds(3), function()
			Reinforcements.ReinforceWithTransport(BadGuyLeft, "tran.in", NodUnitsVehicles2, { GunboatRight.Location, ReinforcementsHelicopter2Rally.Location }, { GunboatRight.Location })
		end)
	end)

	Trigger.OnAllRemovedFromWorld(engineers, function()
		if not Nod.IsObjectiveCompleted(CaptureHelipad) then
			for i,PID in pairs (CoopPlayers) do
			PID.MarkFailedObjective(CaptureHelipad)
			end
		end
	end)
end

DiscoveredMainEntrance = function()
	if Nod.IsObjectiveCompleted(DistractGuardsObjective) then
		return
	end
	
	for i,PID in pairs (CoopPlayers) do
	PID.MarkCompletedObjective(DistractGuardsObjective)
	end
	
	Utils.Do(MainEntranceGuards, function(guard)
		if not guard.IsDead then
			guard.Patrol(MainEntrancePatrolPath)
		end
	end)
end

Trigger.OnKilled(GDIHpad, function()
	if not Nod.IsObjectiveCompleted(CaptureHelipad) then
		for i,PID in pairs (CoopPlayers) do
		PID.MarkFailedObjective(CaptureHelipad)
		end
	end
end)

Trigger.OnKilled(GDIOrca, function()
	if not Nod.IsObjectiveCompleted(UseOrcaObjective) then
		for i,PID in pairs (CoopPlayers) do
		PID.MarkFailedObjective(UseOrcaObjective)
		end
	end
end)

Trigger.OnDamaged(GuardTower3, function()
	if not MediumTank3.IsDead then
		MediumTank3.Patrol(MediumTankPatrolPath)
	end
end)

Utils.Do(Map.ActorsWithTag("Village"), function(actor)
	Trigger.OnKilled(actor, function()
		TargetsKilled = TargetsKilled + 1

		if TargetsKilled >= 15 then
			for i,PID in pairs (CoopPlayers) do
			PID.MarkCompletedObjective(NoCaptureObjective)
			PID.MarkCompletedObjective(UseOrcaObjective)
			end
		end
	end)
end)

Utils.Do(Map.ActorsWithTag("GDIBuilding"), function(actor)
	Trigger.OnKilledOrCaptured(actor, function()
		for i,PID in pairs (CoopPlayers) do
		PID.MarkFailedObjective(NoCaptureObjective)
		end
	end)
end)

Trigger.OnCapture(GDIHpad, function()
	for i,PID in pairs (CoopPlayers) do
	PID.MarkCompletedObjective(CaptureHelipad)
	end
	if not GDIOrca.IsDead then
		GDIOrca.Owner = Nod
		for i,PID in pairs (CoopPlayers) do
			if PID ~= Nod then
				Actor.Create(GDIOrca.Type, true, { Owner = PID, Location = GDIOrca.Location })
			end
		end
	end

	Actor.Create("camera", true, { Owner = Nod, Location = waypoint25.Location })
	Actor.Create("flare", true, { Owner = Nod, Location = waypoint25.Location })
end)

BadGuySpread = function()
	P1Units = BadGuyLeft.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayerL = EvenPlayers[CoopCurrentL]
    UID.Owner = CurrentPlayerL
    CoopCurrentL = CoopCurrentL + 1
    if CoopCurrentL > #EvenPlayers then
        CoopCurrentL = 1
	end
end

	P1Units = BadGuyRight.GetActors()
for _, UID in ipairs(P1Units) do
    CurrentPlayerR = UnevenPlayers[CoopCurrentR]
    UID.Owner = CurrentPlayerR
    CoopCurrentR = CoopCurrentR + 1
    if CoopCurrentR > #UnevenPlayers then
        CoopCurrentR = 1
	end
end

	P1Units = BadGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end

end


PlayOpening = function()
Media.PlayMovieInRadar("bcanyon.vqa")
end

WorldLoaded = function()
	Nod = Player.GetPlayer("Nod")
	GDI = Player.GetPlayer("GDI")
	BadGuy = Player.GetPlayer("BadGuy")
	BadGuyLeft = Player.GetPlayer("BadGuyLeft")
	BadGuyRight = Player.GetPlayer("BadGuyRight")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	CoopPlayers = {};
	table.insert(CoopPlayers, Nod)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end
	
	Media.PlayMovieFullscreen("nod7b.vqa",PlayOpening)

	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end

	EnemyUnits = GDI.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	CoopCurrent = 1
	CoopCurrentL = 1
	CoopCurrentR = 1
	
	EvenPlayers = {}
	UnevenPlayers = {}

	if #CoopPlayers == 1 then
		table.insert(UnevenPlayers, Nod)
		table.insert(EvenPlayers, Nod)
	end
	
	if #CoopPlayers > 1 then
		for index, eintrag in ipairs(CoopPlayers) do
			if index % 2 == 0 then
				table.insert(EvenPlayers, eintrag)
			else
				table.insert(UnevenPlayers, eintrag)
			end
		end
	end

	Camera.Position = waypoint26.CenterPosition

	InsertNodUnits()

	Jeep.Patrol(JeepPatrolPath)
	Utils.Do(InfantryPatrol, function(unit)
		unit.Patrol(InfantryPatrolPath)
	end)

	Utils.Do(GDI.GetGroundAttackers(), function(guard)
		Trigger.OnDamaged(guard, function()
			if not guard.IsDead then
				IdleHunt(guard)
			end
		end)
	end)

	InitObjectives(Nod)

	Trigger.OnDiscovered(GuardTower1, DiscoveredMainEntrance)
	Trigger.OnDiscovered(GuardTower2, DiscoveredMainEntrance)
	Trigger.OnDiscovered(GuardTower3, function()
		if not Nod.IsObjectiveCompleted(DistractGuardsObjective) then
			for i,PID in pairs (CoopPlayers) do
			PID.MarkFailedObjective(DistractGuardsObjective)
			end
		end
	end)
	
	for i,PID in pairs (CoopPlayers) do
	CaptureHelipad = AddPrimaryObjective(PID, "capture-gdi-helipad")
	NoCaptureObjective = AddPrimaryObjective(PID, "dont-capture-or-destroy")
	UseOrcaObjective = AddPrimaryObjective(PID, "orca-wreak-havoc")
	DistractGuardsObjective = AddSecondaryObjective(PID, "distract-guards")
	end
	GDIObjective = AddPrimaryObjective(GDI, "")
end

BotController = function ()
	for i,PID in pairs (CoopPlayers) do
		if PID.IsBot == true then
			local BotUnits = PID.GetGroundAttackers()
			Utils.Do(BotUnits, IdleHunt)
		end
	end
end

Tick = function()
	BadGuySpread()
	BotController()
	LostCounter = 0
	for i,PID in pairs (CoopPlayers) do
		if DateTime.GameTime > DateTime.Seconds(10) and PID.HasNoRequiredUnits() then
			LostCounter = LostCounter+1
		end
	end
	if LostCounter == #CoopPlayers then
		GDI.MarkCompletedObjective(GDIObjective)
	end

	if GDI.Resources >= GDI.ResourceCapacity * 0.75 then
		GDI.Resources = GDI.ResourceCapacity * 0.25
	end
end
