--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

NodUnits = { "e1", "e1", "bggy", "bike", "e1", "e1", "bike", "bggy", "e1", "e1" }
Engineers = { "e6", "e6", "e6" }
FirstAttackWaveUnits = { "e1", "e1", "e2" }
SecondAttackWaveUnits = { "e1", "e1", "e1" }
ThirdAttackWaveUnits = { "e1", "e1", "e1", "e2" }
GDIBase = { Base1, Base2, Base3, Base4, Base5, Base6, Base7 }
Humvees = { Humvee1, Humvee2 }
HumveeFootprint = { CPos.New(22,26), CPos.New(23,26), CPos.New(24,26), CPos.New(34,25), CPos.New(35,25) }

SendAttackWave = function(units, action)
	Reinforcements.Reinforce(GDI, units, { GDIBarracksSpawn.Location, WP0.Location, WP1.Location }, 15, action)
end

FirstAttackWave = function(soldier)
	soldier.AttackMove(WP2.Location)
	soldier.AttackMove(WP3.Location)
	soldier.AttackMove(WP4.Location)
	soldier.AttackMove(PlayerBase.Location)
end

SecondAttackWave = function(soldier)
	soldier.AttackMove(WP5.Location)
	soldier.AttackMove(WP6.Location)
	soldier.AttackMove(WP7.Location)
	soldier.AttackMove(WP9.Location)
	soldier.AttackMove(PlayerBase.Location)
end

BadGuySpread = function()
	P1Units = BadGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
	P1Units = BadGuy.GetActorsByType("e6")
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end

PlayOpening = function()
Media.PlayMovieInRadar("dessweep.vqa")
end

WorldLoaded = function()
	Nod = Player.GetPlayer("Nod")
	GDI = Player.GetPlayer("GDI")
	BadGuy = Player.GetPlayer("BadGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	CoopPlayers = {};
	table.insert(CoopPlayers, Nod)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end
	
	Media.PlayMovieFullscreen("nod3.vqa",PlayOpening)

	if Map.LobbyOption("blossom") == "blossomon"  then
		ExtraMines = {ExtraBlossom1, ExtraBlossom2, ExtraBlossom3, ExtraBlossom4}
		for i,MID in pairs (ExtraMines) do
			AddMine = Actor.Create("split2", true, { Location = MID.Location, Owner = Neutral })
		end
	end

	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end

	EnemyUnits = GDI.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	CoopCurrent = 1
	InitObjectives(Nod)

	for i,PID in pairs (CoopPlayers) do
	CapturePrison = AddPrimaryObjective(PID, "capture-prison")
	DestroyGDI = AddSecondaryObjective(PID, "destroy-gdi-forces")
	end
	
	Trigger.OnKilled(TechCenter, function()
		for i,PID in pairs (CoopPlayers) do
		PID.MarkFailedObjective(CapturePrison)
		end
	end)

	Trigger.OnCapture(TechCenter, function()
		Trigger.AfterDelay(DateTime.Seconds(2), function()
			for i,PID in pairs (CoopPlayers) do
			PID.MarkCompletedObjective(CapturePrison)
			end
		end)
	end)

	Media.PlaySpeechNotification(All, "Reinforce")
	for i,PID in pairs (CoopPlayers) do
	Reinforcements.Reinforce(PID, { "mcv" }, { McvEntry.Location, McvDeploy.Location })
	end
	Reinforcements.Reinforce(BadGuy, NodUnits, { NodEntry.Location, NodRallypoint.Location })
	Trigger.AfterDelay(DateTime.Seconds(15), function()
		Media.PlaySpeechNotification(All, "Reinforce")
		Reinforcements.Reinforce(BadGuy, Engineers, { McvEntry.Location, PlayerBase.Location })
	end)

	Trigger.AfterDelay(DateTime.Seconds(40), function() SendAttackWave(FirstAttackWaveUnits, FirstAttackWave) end)
	Trigger.AfterDelay(DateTime.Seconds(80), function() SendAttackWave(SecondAttackWaveUnits, SecondAttackWave) end)
	Trigger.AfterDelay(DateTime.Seconds(140), function() SendAttackWave(ThirdAttackWaveUnits, FirstAttackWave) end)

	local humveeTriggered
	Trigger.OnEnteredFootprint(HumveeFootprint, function(actor, id)
		for i,PID in pairs (CoopPlayers) do
		if actor.Owner == PID and not humveeTriggered then
			Trigger.RemoveFootprintTrigger(id)
			humveeTriggered = true

			Utils.Do(Humvees, function(a)
				if not a.IsDead then
					IdleHunt(a)
				end
			end)
		end
		end
	end)

	Trigger.OnAnyKilled(GDIBase, function()
		if not BaseAttacked then
			BaseAttacked = true
			Utils.Do(GDI.GetGroundAttackers(), function(unit)
				IdleHunt(unit)
			end)
		end
	end)
end

Tick = function()
	BadGuySpread()
	if DateTime.GameTime > DateTime.Seconds(10) then
		for i,PID in pairs (CoopPlayers) do
		if PID.HasNoRequiredUnits() then
			for i,PID2 in pairs (CoopPlayers) do
			PID2.MarkFailedObjective(CapturePrison)
			end
		end
		end

		if GDI.HasNoRequiredUnits() then
			for i,PID in pairs (CoopPlayers) do
			PID.MarkCompletedObjective(DestroyGDI)
			end
		end
	end
end
