--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

NodUnits = { "bggy", "e1", "e1", "e1", "e1", "e1", "bggy", "e1", "e1", "e1", "bggy" }
NodBaseBuildings = { "hand", "fact", "nuke" }

GDIBase = { Refinery, Yard, Barracks, Plant, Silo1, Silo2 }

GDIWaypoints1 = { waypoint0, waypoint1, waypoint2, waypoint3 }
GDIWaypoints2 = { waypoint0, waypoint1, waypoint4, waypoint5, waypoint6, waypoint7, waypoint9 }

GetAttackers = function(amount)
	local units = GDI.GetActorsByType("e1")

	if amount > #units then
		return units
	end

	return Utils.Take(amount, units)
end

BadGuySpread = function()
	P1Units = BadGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end

PlayOpening = function()
Media.PlayMovieInRadar("seige.vqa")
end

WorldLoaded = function()
	Nod = Player.GetPlayer("Nod")
	GDI = Player.GetPlayer("GDI")
	BadGuy = Player.GetPlayer("BadGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	CoopPlayers = {};
	table.insert(CoopPlayers, Nod)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end
	
	Media.PlayMovieFullscreen("nod2.vqa",PlayOpening)

	if Map.LobbyOption("blossom") == "blossomon"  then
		ExtraMines = {ExtraBlossom1, ExtraBlossom2, ExtraBlossom3}
		for i,MID in pairs (ExtraMines) do
			AddMine = Actor.Create("split2", true, { Location = MID.Location, Owner = Neutral })
		end
	end

	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end

	EnemyUnits = GDI.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	CoopCurrent = 1
	InitObjectives(Nod)

	GDIObjective = AddPrimaryObjective(GDI, "")
	for i, PID in pairs (CoopPlayers) do
	BuildBaseObjective = AddPrimaryObjective(PID, "build-base")
	DestroyGDI = AddPrimaryObjective(PID, "destroy-gdi-units")
	end
	
	Utils.Do({ Refinery, Yard }, function(actor)
		Trigger.OnDamaged(actor, function()
			if not Grd2TriggerSwitch then
				Grd2TriggerSwitch = true
				Utils.Do(GetAttackers(5), IdleHunt)
			end
		end)
	end)

	Trigger.AfterDelay(DateTime.Minutes(1) + DateTime.Seconds(25), function()
		MoveAndHunt(GetAttackers(2), GDIWaypoints1)
	end)

	Trigger.AfterDelay(DateTime.Minutes(1) + DateTime.Seconds(20), function()
		MoveAndHunt(GetAttackers(3), GDIWaypoints2)
	end)

	Trigger.OnKilled(Guard1, function()
		MoveAndHunt(GetAttackers(3), GDIWaypoints2)
	end)

	Trigger.OnKilled(Guard4, function()
		MoveAndHunt(GetAttackers(2), GDIWaypoints1)
	end)

	Trigger.OnAllKilled({ Guard2, Guard3 }, function()
		MoveAndHunt(GetAttackers(2), GDIWaypoints1)
	end)

	Trigger.OnDamaged(Harvester, function()
		if Atk5TriggerSwitch then
			return
		end

		Atk5TriggerSwitch = true
		MoveAndHunt(GetAttackers(3), GDIWaypoints2)
	end)

	Trigger.OnAllRemovedFromWorld(GDIBase, function()
		Utils.Do(GDI.GetGroundAttackers(), IdleHunt)
	end)

	Trigger.AfterDelay(0, function()
		Utils.Do(GDI.GetActorsByType("e1"), function(unit)
			RebuildUnit({ unit }, GDI, Barracks)
		end)
	end)

	Media.PlaySpeechNotification(All, "Reinforce")
	Reinforcements.Reinforce(BadGuy, NodUnits, { UnitsEntry.Location, UnitsRally.Location }, 15)
	for i, PID in pairs (CoopPlayers) do
	Reinforcements.Reinforce(PID, { "mcv" }, { McvEntry.Location, McvRally.Location })
	end
end

Tick = function()
	BadGuySpread()
	for i, PID in pairs (CoopPlayers) do
	if DateTime.GameTime > DateTime.Seconds(5) and PID.HasNoRequiredUnits() then
		GDI.MarkCompletedObjective(GDIObjective)
	end
	end

	if GDI.HasNoRequiredUnits() then
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(DestroyGDI)
		end
	end
	
	for i, PID in pairs (CoopPlayers) do
	if DateTime.GameTime % DateTime.Seconds(1) == 0 and not PID.IsObjectiveCompleted(BuildBaseObjective) and CheckForBase(PID, NodBaseBuildings) then
		PID.MarkCompletedObjective(BuildBaseObjective)
	end
	end
end
