--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

InitialForcesA = { "bggy", "e1", "e1", "e1", "e1" }
InitialForcesB = { "e1", "e1", "bggy", "e1", "e1" }

RifleInfantryReinforcements = { "e1", "e1" }
RocketInfantryReinforcements = { "e3", "e3", "e3", "e3", "e3" }

SendInitialForces = function()
	Media.PlaySpeechNotification(All, "Reinforce")
	Reinforcements.Reinforce(BadGuy, InitialForcesA, { StartSpawnPointLeft.Location, StartRallyPoint.Location }, 5)
	Reinforcements.Reinforce(BadGuy, InitialForcesB, { StartSpawnPointRight.Location, StartRallyPoint.Location }, 10)
end

SendFirstInfantryReinforcements = function()
	Media.PlaySpeechNotification(All, "Reinforce")
	Reinforcements.Reinforce(BadGuy, RifleInfantryReinforcements, { StartSpawnPointRight.Location, StartRallyPoint.Location }, 15)
end

SendSecondInfantryReinforcements = function()
	Media.PlaySpeechNotification(All, "Reinforce")
	Reinforcements.Reinforce(BadGuy, RifleInfantryReinforcements, { StartSpawnPointLeft.Location, StartRallyPoint.Location }, 15)
end

SendLastInfantryReinforcements = function()
	Media.PlaySpeechNotification(All, "Reinforce")
	Reinforcements.Reinforce(BadGuy, RocketInfantryReinforcements, { VillageSpawnPoint.Location, VillageRallyPoint.Location }, 8)
end

BadGuySpread = function()
	P1Units = BadGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end

PlayOpening = function()
Media.PlayMovieFullscreen("nod1pre.vqa",PlayOpening2)
end

PlayOpening2 = function()
Media.PlayMovieFullscreen("nod1.vqa")
end


WorldLoaded = function()
	Nod = Player.GetPlayer("Nod")
	GDI = Player.GetPlayer("GDI")
	Villagers = Player.GetPlayer("Villagers")
	BadGuy = Player.GetPlayer("BadGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	CoopPlayers = {};
	table.insert(CoopPlayers, Nod)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end
	
	Media.PlayMovieFullscreen("intro2.vqa",PlayOpening)
	
	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end

	EnemyUnits = GDI.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	CoopCurrent = 1
	InitObjectives(Nod)
	
	for i, PID in pairs (CoopPlayers) do
	KillNikoomba = AddPrimaryObjective(PID, "kill-nikoomba")
	DestroyVillage = AddPrimaryObjective(PID, "destroy-village")
	DestroyGDI = AddSecondaryObjective(PID, "destroy-gdi-troops-area")
	end
	GDIObjective = AddPrimaryObjective(GDI, "")

	Trigger.OnKilled(Nikoomba, function()
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(KillNikoomba)
		end
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			SendLastInfantryReinforcements()
		end)
	end)

	Camera.Position = StartRallyPoint.CenterPosition

	SendInitialForces()
	Trigger.AfterDelay(DateTime.Seconds(30), SendFirstInfantryReinforcements)
	Trigger.AfterDelay(DateTime.Seconds(60), SendSecondInfantryReinforcements)
end

Tick = function()
	BadGuySpread()
	if DateTime.GameTime > DateTime.Seconds(5) then
		LostCounter = 0
		for i,PID in pairs (CoopPlayers) do
			if DateTime.GameTime > DateTime.Seconds(5) and PID.HasNoRequiredUnits() then
				LostCounter = LostCounter+1
			end
		end
		if LostCounter == #CoopPlayers then
			GDI.MarkCompletedObjective(GDIObjective)
		end
		if Villagers.HasNoRequiredUnits() then
			for i, PID in pairs (CoopPlayers) do
			PID.MarkCompletedObjective(DestroyVillage)
			end
		end

		if GDI.HasNoRequiredUnits() then
			for i, PID in pairs (CoopPlayers) do
			PID.MarkCompletedObjective(DestroyGDI)
			end
		end
	end
end
