
HarkonnenReinforcements =
{
	easy =
	{
		{ "light_inf", "trooper" },
		{ "light_inf", "trooper", "sardaukar" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "trooper" }
	},

	normal =
	{
		{ "light_inf", "light_inf_level1" },
		{ "light_inf", "light_inf_level1", "trooper" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1" },
		{ "light_inf", "light_inf", "trooper", "sardaukar", "sardaukar" },
		{ "light_inf", "light_inf", "light_inf", "sardaukar", "sardaukar" },
		{ "light_inf", "light_inf_level1", "sardaukar", "sardaukar", "sardaukar" }
	},

	hard =
	{
		{ "light_inf_level1", "light_inf_level1" },
		{ "light_inf", "light_inf_level1", "light_inf_level1" },
		{ "light_inf", "light_inf_level1", "light_inf_level1", "light_inf_level1" },
		{ "light_inf", "light_inf", "light_inf", "light_inf_level1", "light_inf_level1", "light_inf_level4" },
		{ "light_inf", "light_inf", "light_inf", "light_inf_level1", "light_inf_level1", "light_inf_level4", "sardaukar" },
		{ "light_inf_level1", "light_inf_level1", "trooper_level1", "combat_tank_h", "missile_tank", "sardaukar", "sardaukar" },
		{ "light_inf", "light_inf", "light_inf_level1", "trooper_level1", "trooper", "trooper", "sardaukar", "sardaukar", "sardaukar" },
		{ "light_inf", "light_inf_level1", "light_inf", "light_inf", "light_inf_level1", "combat_tank_h", "sardaukar", "sardaukar", "sardaukar" },
		{ "light_inf_level1", "light_inf_level1", "light_inf_level1", "light_inf_level1", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar" }
	}
}

HarkonnenAttackPaths =
{
	{ HarkonnenEntry1.Location, HarkonnenRally1.Location },
	{ HarkonnenEntry2.Location, HarkonnenRally2.Location }
}

HarkonnenAttackDelay =
{
	easy = DateTime.Minutes(3) + DateTime.Seconds(20),
	normal = DateTime.Minutes(2) + DateTime.Seconds(30),
	hard = DateTime.Minutes(1) + DateTime.Seconds(10)
}

HarkonnenAttackWaves =
{
	easy = 3,
	normal = 6,
	hard = 9
}

AtreidesReinforcements =
{
	{ "trike", "quad", "trike", "combat_tank_a", "combat_tank_a" },
	{ "light_inf", "light_inf", "light_inf", "light_inf", "engineer", "trooper", "trooper", "nsfremen", "nsfremen", "nsfremen" }
}

AtreidesPath = { AtreidesEntry.Location, AtreidesRally.Location }

Tick = function()
	if Atreides.HasNoRequiredUnits() then
		Harkonnen.MarkCompletedObjective(KillAtreides)
	end

	if Harkonnen.HasNoRequiredUnits() and not Atreides.IsObjectiveCompleted(KillHarkonnen) then
		Media.DisplayMessage(UserInterface.Translate("harkonnen-annihilated"), Mentat)
		Atreides.MarkCompletedObjective(KillHarkonnen)
	end
end

WorldLoaded = function()
	Harkonnen = Player.GetPlayer("Harkonnen")
	Atreides = Player.GetPlayer("Atreides")
	Mercenaries = Player.GetPlayer("Mercenaries")
	Smuggler = Player.GetPlayer("Smuggler")
	
	InitObjectives(Atreides)
	KillAtreides = AddPrimaryObjective(Harkonnen, "")
	KillHarkonnen = AddPrimaryObjective(Atreides, "destroy-harkonnen-forces")

	Camera.Position = AOfficer.CenterPosition

	local path = function() return Utils.Random(HarkonnenAttackPaths) end
	SendCarryallReinforcements(Harkonnen, 0, HarkonnenAttackWaves[Difficulty], HarkonnenAttackDelay[Difficulty], path, HarkonnenReinforcements[Difficulty])
	
	Trigger.AfterDelay(DateTime.Minutes(6), function()
		Media.PlaySpeechNotification(Atreides, "Reinforce")
		Reinforcements.Reinforce(Atreides, AtreidesReinforcements[1], AtreidesPath)
	end)
	Trigger.AfterDelay(DateTime.Minutes(12) + DateTime.Seconds(40), function()
		Media.PlaySpeechNotification(Atreides, "Reinforce")
		Reinforcements.Reinforce(Atreides, AtreidesReinforcements[2], AtreidesPath)
	end)
end




