--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

InfantryReinforcements = { "e1", "e1", "e2" }
JeepReinforcements = { "jeep" }
TankReinforcements = { "mtnk" }
BaseReinforcements = { "mcv" }
GDIBaseBuildings = { "pyle", "fact", "nuke", "hq", "weap" }

SamSites = { sam1, sam2, sam3, sam4 }
NodBase = { handofnod, nodpower1, nodpower2, nodpower3, nodairfield, nodrefinery, nodconyard }
HiddenNodUnits = { sleeper1, sleeper2, sleeper3, sleeper4 }

SendReinforcements = function()
	Trigger.AfterDelay(DateTime.Seconds(20), function()
		ReinforceWithLandingCraft(GoodGuy, BaseReinforcements, spawnpoint3.Location - CVec.New(0, -4), spawnpoint3.Location - CVec.New(0, -1), waypoint26.Location)
	end)

	Trigger.AfterDelay(DateTime.Seconds(10), function()
		ReinforceWithLandingCraft(GoodGuy, TankReinforcements, spawnpoint2.Location - CVec.New(0, -4), spawnpoint2.Location - CVec.New(0, -1), waypoint10.Location)
		ReinforceWithLandingCraft(GoodGuy, TankReinforcements, spawnpoint3.Location - CVec.New(0, -4), spawnpoint3.Location - CVec.New(0, -1), waypoint10.Location)
	end)

	Trigger.AfterDelay(DateTime.Seconds(5), function()
		ReinforceWithLandingCraft(GoodGuy, JeepReinforcements, spawnpoint1.Location - CVec.New(0, -4), spawnpoint1.Location - CVec.New(0, -1), waypoint10.Location)
	end)

	ReinforceWithLandingCraft(GoodGuy, InfantryReinforcements, spawnpoint2.Location - CVec.New(0, -4), spawnpoint2.Location - CVec.New(0, -1), waypoint10.Location)
	ReinforceWithLandingCraft(GoodGuy, InfantryReinforcements, spawnpoint3.Location - CVec.New(0, -4), spawnpoint3.Location - CVec.New(0, -1), waypoint10.Location)
end

AttackPlayer = function()
	Trigger.AfterDelay(DateTime.Seconds(40), function()
		for type, count in pairs({ ['e3'] = 3, ['e4'] = 2 }) do
			local atk1Actors = Utils.Take(count, Nod.GetActorsByType(type))
			Utils.Do(atk1Actors, function(unit)
				unit.Move(waypoint6.Location)
				unit.Move(waypoint7.Location)
				unit.Move(waypoint8.Location)
				unit.Move(waypoint9.Location)
				unit.Move(waypoint10.Location)
				unit.AttackMove(waypoint11.Location)
			end)
		end
	end)

	Trigger.AfterDelay(DateTime.Seconds(40), function()
		for type, count in pairs({ ['e1'] = 3, ['e3'] = 2 }) do
			local atk2Actors = Utils.Take(count, Nod.GetActorsByType(type))
			Utils.Do(atk2Actors, function(unit)
				unit.Move(waypoint11.Location)
				unit.Move(waypoint12.Location)
				unit.Move(waypoint15.Location)
				unit.Move(waypoint16.Location)
				unit.Hunt()
			end)
		end
	end)

	Trigger.AfterDelay(DateTime.Seconds(80), function()
		for type, count in pairs({ ['e3'] = 3, ['e4'] = 2 }) do
			local atk3Actors = Utils.Take(count, Nod.GetActorsByType(type))
			Utils.Do(atk3Actors, function(unit)
				unit.Move(waypoint6.Location)
				unit.Move(waypoint7.Location)
				unit.Move(waypoint8.Location)
				unit.Move(waypoint9.Location)
				unit.Move(waypoint10.Location)
				unit.AttackMove(waypoint11.Location)
			end)
		end
	end)

	Trigger.AfterDelay(DateTime.Seconds(80), function()
		for type, count in pairs({ ['e1'] = 3, ['e3'] = 2 }) do
			local atk4Actors = Utils.Take(count, Nod.GetActorsByType(type))
			Utils.Do(atk4Actors, function(unit)
				unit.Move(waypoint11.Location)
				unit.Move(waypoint12.Location)
				unit.Move(waypoint15.Location)
				unit.Move(waypoint16.Location)
				unit.AttackMove(waypoint11.Location)
			end)
		end
	end)

	Trigger.AfterDelay(DateTime.Seconds(80), function()
		local atk5Actors = Utils.Take(2, Nod.GetActorsByType('bggy'))
		Utils.Do(atk5Actors, function(unit)
			unit.Move(waypoint11.Location)
			unit.Move(waypoint12.Location)
			unit.Move(waypoint15.Location)
			unit.Move(waypoint16.Location)
			unit.Hunt()
		end)
	end)

	Utils.Do(NodBase, function(actor)
		Trigger.OnRemovedFromWorld(actor, function()
			Utils.Do(Nod.GetGroundAttackers(), IdleHunt)
		end)
	end)

	Utils.Do(HiddenNodUnits, IdleHunt)
end

GoodGuySpread = function()
	P1Units = GoodGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
	if UID.Type ~= "apc" then
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
	end
end
for _, UID in ipairs(P1Units) do
	if UID.Type == "apc" then
		if UID.HasPassengers == true then
			UID.UnloadPassengers()
		end
		if UID.HasPassengers == false then
			CurrentPlayer = CoopPlayers[CoopCurrent]
			UID.Owner = CurrentPlayer
			CoopCurrent = CoopCurrent + 1
			if CoopCurrent > #CoopPlayers then
				CoopCurrent = 1
			end
		end
	end
end
	P1Units = GoodGuy.GetActorsByType("mcv")
for _, UID in ipairs(P1Units) do
	if UID.Type ~= "apc" then
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
	end
end
end

PlayOpening = function()
Media.PlayMovieInRadar("turtkill.vqa")
end

WorldLoaded = function()
	GDI = Player.GetPlayer("GDI")
	Nod = Player.GetPlayer("Nod")
	GoodGuy = Player.GetPlayer("GoodGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	CoopPlayers = {};
	table.insert(CoopPlayers, GDI)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	for i,PID in pairs (CoopPlayers) do
		if PID ~= GDI then
			table.insert(BaseReinforcements, "mcv")
		end
	end
	Media.PlayMovieFullscreen("gdi7.vqa",PlayOpening)
	
	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end

	if Map.LobbyOption("blossom") == "blossomon"  then
		ExtraMines = {ExtraBlossom1, ExtraBlossom2, ExtraBlossom3, ExtraBlossom4, ExtraBlossom5}
		for i,MID in pairs (ExtraMines) do
			AddMine = Actor.Create("split2", true, { Location = MID.Location, Owner = Neutral })
		end
	end

	EnemyUnits = Nod.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	CoopCurrent = 1

	Camera.Position = spawnpoint2.CenterPosition

	InitObjectives(GDI)
	
	for i,PID in pairs (CoopPlayers) do
	DestroyNod = AddPrimaryObjective(PID, "destroy-nod")
	ConstructBase = AddSecondaryObjective(PID, "construct-base")
	end
	
	SendReinforcements()
	
	for i,PID in pairs (CoopPlayers) do
	destroySAMs = AddSecondaryObjective(PID, "destroy-sams")
	end
	Trigger.OnAllKilled(SamSites, function()
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(destroySAMs)
		end
		Actor.Create("airstrike.proxy", true, { Owner = GDI })
	end)

	AttackPlayer()
end

Tick = function()
	GoodGuySpread()
	if DateTime.GameTime > DateTime.Seconds(25) then
		for i,PID in pairs (CoopPlayers) do
		if PID.HasNoRequiredUnits()  then
			for i,PID2 in pairs (CoopPlayers) do
			PID2.MarkFailedObjective(DestroyNod)
			end
		end
		end
		if Nod.HasNoRequiredUnits() then
			for i,PID in pairs (CoopPlayers) do
			PID.MarkCompletedObjective(DestroyNod)
			end
		end
		
		for i,PID in pairs (CoopPlayers) do
		if not PID.IsObjectiveCompleted(ConstructBase) and DateTime.GameTime % DateTime.Seconds(1) == 0 and CheckForBase(PID, GDIBaseBuildings) then
			PID.MarkCompletedObjective(ConstructBase)
		end
		end
	end
end
