--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

RepairThreshold = { easy = 0.3, normal = 0.6, hard = 0.9 }

ActorRemovals =
{
	easy = { Actor197, Actor198, Actor199, Actor162, Actor178, Actor181, Actor171, Actor163 },
	normal = { Actor197, Actor162 },
	hard = { },
}

AllToHuntTrigger = { Silo1, Proc1, Silo2, Radar1, Afld1, Hand1, Nuke1, Nuke2, Nuke3, Fact1 }

AtkRoute1 = { waypoint0, waypoint1, waypoint2, waypoint3, waypoint4 }
AtkRoute2 = { waypoint0, waypoint8, waypoint4 }
AtkRoute3 = { waypoint0, waypoint1, waypoint2, waypoint5, waypoint6, waypoint7 }
AtkRoute4 = { waypoint0, waypoint8, waypoint9, waypoint10, waypoint11 }

AutoCreateTeams =
{
	{ types = { e1 = 2, e3 = 2 }, route = AtkRoute1 },
	{ types = { e1 = 1, e3 = 2 }, route = AtkRoute2 },
	{ types = { ltnk = 1 }      , route = AtkRoute2 },
	{ types = { bggy = 1 }      , route = AtkRoute2 },
	{ types = { bggy = 1 }      , route = AtkRoute1 },
	{ types = { ltnk = 1 }      , route = AtkRoute3 },
	{ types = { bggy = 1 }      , route = AtkRoute4 }
}

Atk1Delay = { easy = DateTime.Seconds(60), normal = DateTime.Seconds(50), hard = DateTime.Seconds(40) }
Atk2Delay = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(70), hard = DateTime.Seconds(50) }
Atk3Delay = { easy = DateTime.Seconds(120), normal = DateTime.Seconds(90), hard = DateTime.Seconds(70) }
Atk4Delay = { easy = DateTime.Seconds(150), normal = DateTime.Seconds(110), hard = DateTime.Seconds(90) }
AutoAtkStartDelay = { easy = DateTime.Seconds(150), normal = DateTime.Seconds(120), hard = DateTime.Seconds(90) }
AutoAtkMinDelay = { easy = DateTime.Minutes(1), normal = DateTime.Seconds(45), hard = DateTime.Seconds(30) }
AutoAtkMaxDelay = { easy = DateTime.Minutes(2), normal = DateTime.Seconds(90), hard = DateTime.Minutes(1) }

GDIBase = { GdiNuke1, GdiProc1, GdiWeap1, GdiNuke2, GdiNuke3, GdiPyle1, GdiSilo1, GdiRadar1 }
GDIUnits = { "e2", "e2", "e2", "e2", "e1", "e1", "e1", "e1", "mtnk", "mtnk", "jeep", "apc", "apc" }
GDIHarvester = { "harv" }
NodSams = { Sam1, Sam2, Sam3 }

AutoCreateTeam = function()
	local team = Utils.Random(AutoCreateTeams)
	for type, count in pairs(team.types) do
		MoveAndHunt(Utils.Take(count, Nod.GetActorsByType(type)), team.route)
	end

	Trigger.AfterDelay(Utils.RandomInteger(AutoAtkMinDelay[Difficulty], AutoAtkMaxDelay[Difficulty]), AutoCreateTeam)
end

DiscoverGDIBase = function(actor, discoverer)
	for i, PID in pairs (CoopPlayers) do
	if BaseDiscovered or not discoverer == PID then
		return
	end
	end

	if not GdiProc1.IsDead then
		Reinforcements.Reinforce(GDI, GDIHarvester, { GdiProc1.Location + CVec.New(0, 2), GdiProc1.Location + CVec.New(-1, 3) }, 1)
	end
	
	Utils.Do(GDIBase, function(actor)
		actor.Owner = GDI
	end)

	BaseDiscovered = true
	for i=1, HarvesterMultiplier do
		GdiWeap1.Produce("harv")
	end
	if #CoopPlayers > 1 then
		GdiPyle1.Owner = CoopPlayers[2]
	end
	if #CoopPlayers > 2 then
		P3Barr = Actor.Create("pyle", true, { Location = P3Barracks.Location, Owner = CoopPlayers[3] })
		P3Barr.Health = GdiPyle1.Health
	end
	if #CoopPlayers > 3 then
		P4Fact = Actor.Create("weap", true, { Location = P4Factory.Location, Owner = CoopPlayers[4] })
		P4Fact.Health = GdiWeap1.Health
	end
	if #CoopPlayers > 4 then
		P5Barr = Actor.Create("pyle", true, { Location = P5Barracks.Location, Owner = CoopPlayers[5] })
		P5Barr.Health = GdiPyle1.Health
	end
	if #CoopPlayers > 5 then
		P6Fact = Actor.Create("weap", true, { Location = P6Factory.Location, Owner = CoopPlayers[6] })
		P6Fact.Health = GdiWeap1.Health
	end
	for i, PID in pairs (CoopPlayers) do
		if PID ~= GDI then
			ExtraPower1 = Actor.Create(GdiNuke1.Type, true, { Location = CPos.Zero, Owner = PID })
			ExtraPower2 = Actor.Create(GdiNuke2.Type, true, { Location = CPos.Zero, Owner = PID })
			ExtraPower3 = Actor.Create(GdiNuke3.Type, true, { Location = CPos.Zero, Owner = PID })
			ExtraRadar1 = Actor.Create(GdiRadar1.Type, true, { Location = CPos.Zero, Owner = PID })
			--ExtraDome = Actor.Create("dome", true, { Location = CPos.Zero, Owner = PID })
			table.insert(ExtraPowerplants1, ExtraPower1)
			table.insert(ExtraPowerplants2, ExtraPower2)
			table.insert(ExtraPowerplants3, ExtraPower3)
			table.insert(ExtraRadars, ExtraRadar1)
		end
	end
	for i,PID in pairs (CoopPlayers) do
	EliminateNod = AddPrimaryObjective(PID, "eliminate-nod")
	PID.MarkCompletedObjective(FindBase)
	end
end

Atk1TriggerFunction = function()
	MoveAndHunt(Utils.Take(2, Nod.GetActorsByType('e1')), AtkRoute1)
	MoveAndHunt(Utils.Take(2, Nod.GetActorsByType('e3')), AtkRoute1)
end

Atk2TriggerFunction = function()
	MoveAndHunt(Utils.Take(4, Nod.GetActorsByType('e3')), AtkRoute2)
end

Atk3TriggerFunction = function()
	MoveAndHunt(Utils.Take(1, Nod.GetActorsByType('bggy')), AtkRoute2)
end

Atk4TriggerFunction = function()
	MoveAndHunt(Utils.Take(2, Nod.GetActorsByType('e1')), AtkRoute1)
	MoveAndHunt(Utils.Take(1, Nod.GetActorsByType('ltnk')), AtkRoute1)
end

InsertGDIUnits = function()
	Media.PlaySpeechNotification(All, "Reinforce")
	Reinforcements.Reinforce(GoodGuy, GDIUnits, { UnitsEntry.Location, UnitsRally.Location }, 15)
end

MimicBuildings = function()
	for i, EID in pairs (ExtraPowerplants1) do
		if GdiNuke1.IsInWorld == true then
			EID.Health = GdiNuke1.Health
		else
			EID.Destroy ()
			table.remove(ExtraPowerplants1, i)
		end
	end
	for i, EID in pairs (ExtraPowerplants2) do
		if GdiNuke2.IsInWorld == true then
			EID.Health = GdiNuke2.Health
		else
			EID.Destroy ()
			table.remove(ExtraPowerplants2, i)
		end
	end
	for i, EID in pairs (ExtraPowerplants3) do
		if GdiNuke3.IsInWorld == true then
			EID.Health = GdiNuke3.Health
		else
			EID.Destroy ()
			table.remove(ExtraPowerplants3, i)
		end
	end
	for i, EID in pairs (ExtraRadars) do
		if GdiRadar1.IsInWorld == true then
			EID.Health = GdiRadar1.Health
		else
			EID.Destroy ()
			table.remove(ExtraRadars, i)
		end
	end
end

GoodGuySpread = function()
	P1Units = GoodGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
	if UID.Type ~= "apc" then
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
	end
end
for _, UID in ipairs(P1Units) do
	if UID.Type == "apc" then
		if UID.HasPassengers == true then
			UID.UnloadPassengers()
		end
		if UID.HasPassengers == false then
			CurrentPlayer = CoopPlayers[CoopCurrent]
			UID.Owner = CurrentPlayer
			CoopCurrent = CoopCurrent + 1
			if CoopCurrent > #CoopPlayers then
				CoopCurrent = 1
			end
		end
	end
end
end

PlayOpening = function()
Media.PlayMovieFullscreen("gdi5.vqa",PlayOpening2)
end

PlayOpening2 = function()
Media.PlayMovieInRadar("seige.vqa")
end

WorldLoaded = function()
	GDI = Player.GetPlayer("GDI")
	AbandonedBase = Player.GetPlayer("AbandonedBase")
	Nod = Player.GetPlayer("Nod")
	GoodGuy = Player.GetPlayer("GoodGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	CoopPlayers = {};
	table.insert(CoopPlayers, GDI)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	Media.PlayMovieFullscreen("podium.vqa",PlayOpening)
	
	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end

	if Map.LobbyOption("blossom") == "blossomon"  then
		ExtraMines = {ExtraBlossom1, ExtraBlossom2, ExtraBlossom3, ExtraBlossom4, ExtraBlossom5, ExtraBlossom6}
		for i,MID in pairs (ExtraMines) do
			AddMine = Actor.Create("split2", true, { Location = MID.Location, Owner = Neutral })
		end
	end

	EnemyUnits = Nod.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	CoopCurrent = 1
	CoopCash = GDI.Cash
	for i, PID in pairs (CoopPlayers) do
		PID.Cash = CoopCash/#CoopPlayers
	end
	ExtraPowerplants1 = {}
	ExtraPowerplants2 = {}
	ExtraPowerplants3 = {}
	ExtraRadars = {}

	HarvesterMultiplier = Map.LobbyOption("extraharvesters")
	if Map.LobbyOption("extraharvesters") == "harvpc"  then
	HarvesterMultiplier = #CoopPlayers-1
	end
	
	InitObjectives(GDI)

	RepairNamedActors(Nod, RepairThreshold[Difficulty])
	
	for i, PID in pairs (CoopPlayers) do
	FindBase = AddPrimaryObjective(PID, "find-gdi-base")
	DestroySAMs = AddSecondaryObjective(PID, "destroy-sams")
	end
	NodObjective = AddPrimaryObjective(Nod, "")

	Utils.Do(ActorRemovals[Difficulty], function(unit)
		unit.Destroy()
	end)

	Trigger.AfterDelay(Atk1Delay[Difficulty], Atk1TriggerFunction)
	Trigger.AfterDelay(Atk2Delay[Difficulty], Atk2TriggerFunction)
	Trigger.AfterDelay(Atk3Delay[Difficulty], Atk3TriggerFunction)
	Trigger.AfterDelay(Atk4Delay[Difficulty], Atk4TriggerFunction)

	Trigger.AfterDelay(AutoAtkStartDelay[Difficulty], AutoCreateTeam)

	Trigger.OnAllKilledOrCaptured(AllToHuntTrigger, function()
		Utils.Do(Nod.GetGroundAttackers(), IdleHunt)
	end)

	Trigger.AfterDelay(DateTime.Seconds(40), function()
		local delay = function() return DateTime.Seconds(30) end
		local toBuild = function() return { "e1" } end
		ProduceUnits(Nod, Hand1, delay, toBuild)
	end)

	Trigger.OnPlayerDiscovered(AbandonedBase, DiscoverGDIBase)

	Trigger.OnAllKilled(NodSams, function()
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(DestroySAMs)
		end
		Actor.Create("airstrike.proxy", true, { Owner = GDI })
	end)

	Camera.Position = UnitsRally.CenterPosition

	InsertGDIUnits()
end

ShareMoney = function()
	if GDI.Resources > #CoopPlayers then
	CashSubtract = GDI.Resources/#CoopPlayers
	for i, PID in pairs (CoopPlayers) do
	PID.Cash = PID.Cash + CashSubtract
	end
	GDI.Resources = 0
	end
end

Tick = function()
	GoodGuySpread()
	MimicBuildings()
	ShareMoney()
	for i, PID in pairs (CoopPlayers) do
	if DateTime.GameTime > DateTime.Seconds(10) and PID.HasNoRequiredUnits() then
		Nod.MarkCompletedObjective(NodObjective)
	end
	end

	if BaseDiscovered and Nod.HasNoRequiredUnits() then
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(EliminateNod)
		end
	end
end