--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

AllToHuntTrigger =
{
	Silo1, Proc1, Silo2, Silo3, Silo4, Afld1, Hand1, Nuke1, Nuke2, Nuke3, Fact1
}

AtkRoute1 = { waypoint4.Location, waypoint5.Location, waypoint6.Location, waypoint7.Location, waypoint8.Location }
AtkRoute2 = { waypoint0.Location, waypoint1.Location, waypoint2.Location, waypoint3.Location }

AutoCreateTeams =
{
	{ types = { e1 = 1, e3 = 3 }, route = AtkRoute2 },
	{ types = { e1 = 3, e3 = 1 }, route = AtkRoute2 },
	{ types = { e3 = 4 }        , route = AtkRoute1 },
	{ types = { e1 = 4 }        , route = AtkRoute1 },
	{ types = { bggy = 1 }      , route = AtkRoute1 },
	{ types = { bggy = 1 }      , route = AtkRoute2 },
	{ types = { ltnk = 1 }      , route = AtkRoute1 },
	{ types = { ltnk = 1 }      , route = AtkRoute2 }
}

RepairThreshold = 0.6

Atk1Delay = DateTime.Seconds(40)
Atk2Delay = DateTime.Seconds(60)
Atk3Delay = DateTime.Seconds(70)
Atk4Delay = DateTime.Seconds(90)
AutoAtkStartDelay = DateTime.Seconds(115)
AutoAtkMinDelay = DateTime.Seconds(45)
AutoAtkMaxDelay = DateTime.Seconds(90)

Atk5CellTriggers =
{
	CPos.New(17,55), CPos.New(16,55), CPos.New(15,55), CPos.New(50,54), CPos.New(49,54),
	CPos.New(48,54), CPos.New(16,54), CPos.New(15,54), CPos.New(14,54), CPos.New(50,53),
	CPos.New(49,53), CPos.New(48,53), CPos.New(50,52), CPos.New(49,52)
}

GDIBase = { GdiNuke1, GdiProc1, GdiWeap1, GdiNuke2, GdiPyle1, GdiSilo1, GdiSilo2, GdiHarv }
GDIUnits = { "e2", "e2", "e2", "e2", "e1", "e1", "e1", "e1", "mtnk", "mtnk", "jeep", "jeep", "apc" }
NodSams = { Sam1, Sam2, Sam3, Sam4 }

MoveThenHunt = function(actors, path)
	Utils.Do(actors, function(actor)
		actor.Patrol(path, false)
		IdleHunt(actor)
	end)
end

AutoCreateTeam = function()
	local team = Utils.Random(AutoCreateTeams)
	for type, count in pairs(team.types) do
		MoveThenHunt(Utils.Take(count, Nod.GetActorsByType(type)), team.route)
	end

	Trigger.AfterDelay(Utils.RandomInteger(AutoAtkMinDelay, AutoAtkMaxDelay), AutoCreateTeam)
end

DiscoverGDIBase = function(actor, discoverer)
	for i, PID in pairs (CoopPlayers) do
	if BaseDiscovered or not discoverer == PID then
		return
	end
	end

	Utils.Do(GDIBase, function(actor)
		actor.Owner = GDI
	end)

	BaseDiscovered = true
	for i=1, HarvesterMultiplier do
		GdiWeap1.Produce("harv")
	end
	if #CoopPlayers > 1 then
		GdiPyle1.Owner = CoopPlayers[2]
	end
	if #CoopPlayers > 2 then
		P3Barr = Actor.Create("pyle", true, { Location = P3Barracks.Location, Owner = CoopPlayers[3] })
		P3Barr.Health = GdiPyle1.Health
	end
	if #CoopPlayers > 3 then
		P4Fact = Actor.Create("weap", true, { Location = P4Factory.Location, Owner = CoopPlayers[4] })
		P4Fact.Health = GdiWeap1.Health
	end
	if #CoopPlayers > 4 then
		P5Barr = Actor.Create("pyle", true, { Location = P5Barracks.Location, Owner = CoopPlayers[5] })
		P5Barr.Health = GdiPyle1.Health
	end
	if #CoopPlayers > 5 then
		P6Fact = Actor.Create("weap", true, { Location = P6Factory.Location, Owner = CoopPlayers[6] })
		P6Fact.Health = GdiWeap1.Health
	end
	for i, PID in pairs (CoopPlayers) do
		if PID ~= GDI then
			ExtraPower1 = Actor.Create(GdiNuke1.Type, true, { Location = CPos.Zero, Owner = PID })
			ExtraPower2 = Actor.Create(GdiNuke2.Type, true, { Location = CPos.Zero, Owner = PID })
			--ExtraDome = Actor.Create("dome", true, { Location = CPos.Zero, Owner = PID })
			table.insert(ExtraPowerplants1, ExtraPower1)
			table.insert(ExtraPowerplants2, ExtraPower2)
		end
	end
	for i,PID in pairs (CoopPlayers) do
	EliminateNod = AddPrimaryObjective(PID, "eliminate-nod")
	PID.MarkCompletedObjective(FindBase)
	end
end

Atk1TriggerFunction = function()
	MoveThenHunt(Utils.Take(2, Nod.GetActorsByType('e1')), AtkRoute1)
	MoveThenHunt(Utils.Take(3, Nod.GetActorsByType('e3')), AtkRoute1)
end

Atk2TriggerFunction = function()
	MoveThenHunt(Utils.Take(3, Nod.GetActorsByType('e1')), AtkRoute2)
	MoveThenHunt(Utils.Take(3, Nod.GetActorsByType('e3')), AtkRoute2)
end

Atk3TriggerFunction = function()
	MoveThenHunt(Utils.Take(1, Nod.GetActorsByType('bggy')), AtkRoute1)
end

Atk4TriggerFunction = function()
	MoveThenHunt(Utils.Take(1, Nod.GetActorsByType('bggy')), AtkRoute2)
end

Atk5TriggerFunction = function()
	MoveThenHunt(Utils.Take(1, Nod.GetActorsByType('ltnk')), AtkRoute2)
end

InsertGDIUnits = function()
	Media.PlaySpeechNotification(All, "Reinforce")
	Reinforcements.Reinforce(GoodGuy, GDIUnits, { UnitsEntry.Location, UnitsRally.Location }, 15)
end

MimicBuildings = function()
	for i, EID in pairs (ExtraPowerplants1) do
		if GdiNuke1.IsInWorld == true then
			EID.Health = GdiNuke1.Health
		else
			EID.Destroy ()
			table.remove(ExtraPowerplants1, i)
		end
	end
	for i, EID in pairs (ExtraPowerplants2) do
		if GdiNuke2.IsInWorld == true then
			EID.Health = GdiNuke2.Health
		else
			EID.Destroy ()
			table.remove(ExtraPowerplants2, i)
		end
	end
end

GoodGuySpread = function()
	P1Units = GoodGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
	if UID.Type ~= "apc" then
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
	end
end
for _, UID in ipairs(P1Units) do
	if UID.Type == "apc" then
		if UID.HasPassengers == true then
			UID.UnloadPassengers()
		end
		if UID.HasPassengers == false then
			CurrentPlayer = CoopPlayers[CoopCurrent]
			UID.Owner = CurrentPlayer
			CoopCurrent = CoopCurrent + 1
			if CoopCurrent > #CoopPlayers then
				CoopCurrent = 1
			end
		end
	end
end
end

PlayOpening = function()
Media.PlayMovieFullscreen("gdi5.vqa",PlayOpening2)
end

PlayOpening2 = function()
Media.PlayMovieInRadar("seige.vqa")
end

WorldLoaded = function()
	GDI = Player.GetPlayer("GDI")
	AbandonedBase = Player.GetPlayer("AbandonedBase")
	Nod = Player.GetPlayer("Nod")
	GoodGuy = Player.GetPlayer("GoodGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	CoopPlayers = {};
	table.insert(CoopPlayers, GDI)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	Media.PlayMovieFullscreen("podium.vqa",PlayOpening)
	
	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end

	if Map.LobbyOption("blossom") == "blossomon"  then
		ExtraMines = {ExtraBlossom1, ExtraBlossom2, ExtraBlossom3, ExtraBlossom4, ExtraBlossom5, ExtraBlossom6}
		for i,MID in pairs (ExtraMines) do
			AddMine = Actor.Create("split2", true, { Location = MID.Location, Owner = Neutral })
		end
	end

	EnemyUnits = Nod.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	CoopCurrent = 1
	CoopCash = GDI.Cash
	for i, PID in pairs (CoopPlayers) do
		PID.Cash = CoopCash/#CoopPlayers
	end
	ExtraPowerplants1 = {}
	ExtraPowerplants2 = {}

	HarvesterMultiplier = Map.LobbyOption("extraharvesters")
	if Map.LobbyOption("extraharvesters") == "harvpc"  then
	HarvesterMultiplier = #CoopPlayers-1
	end
	
	InitObjectives(GDI)

	RepairNamedActors(Nod, RepairThreshold)
	
	for i,PID in pairs (CoopPlayers) do
	FindBase = AddPrimaryObjective(PID, "find-gdi-base")
	DestroySAMs = AddSecondaryObjective(PID, "destroy-sams")
	end
	NodObjective = AddPrimaryObjective(Nod, "")

	Trigger.AfterDelay(Atk1Delay, Atk1TriggerFunction)
	Trigger.AfterDelay(Atk2Delay, Atk2TriggerFunction)
	Trigger.AfterDelay(Atk3Delay, Atk3TriggerFunction)
	Trigger.AfterDelay(Atk4Delay, Atk4TriggerFunction)
	Trigger.OnEnteredFootprint(Atk5CellTriggers, function(a, id)
		for i,PID in pairs (CoopPlayers) do
		if a.Owner == PID then
			Atk5TriggerFunction()
			Trigger.RemoveFootprintTrigger(id)
		end
		end
	end)
	Trigger.AfterDelay(AutoAtkStartDelay, AutoCreateTeam)

	Trigger.OnAllRemovedFromWorld(AllToHuntTrigger, function()
		Utils.Do(Nod.GetGroundAttackers(), IdleHunt)
	end)

	Trigger.AfterDelay(DateTime.Seconds(40), function()
		local delay = function() return DateTime.Seconds(30) end
		local toBuild = function() return { "e1" } end
		ProduceUnits(Nod, Hand1, delay, toBuild)
	end)

	Trigger.OnPlayerDiscovered(AbandonedBase, DiscoverGDIBase)

	Trigger.OnAllKilled(NodSams, function()
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(DestroySAMs)
		end
		Actor.Create("airstrike.proxy", true, { Owner = GDI })
	end)

	Camera.Position = UnitsRally.CenterPosition

	InsertGDIUnits()
end

ShareMoney = function()
	if GDI.Resources > #CoopPlayers then
	CashSubtract = GDI.Resources/#CoopPlayers
	for i, PID in pairs (CoopPlayers) do
	PID.Cash = PID.Cash + CashSubtract
	end
	GDI.Resources = 0
	end
end

Tick = function()
	GoodGuySpread()
	MimicBuildings()
	ShareMoney()
	for i, PID in pairs (CoopPlayers) do
	if DateTime.GameTime > DateTime.Seconds(10) and PID.HasNoRequiredUnits() then
		Nod.MarkCompletedObjective(NodObjective)
	end
	end

	if BaseDiscovered and Nod.HasNoRequiredUnits() then
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(EliminateNod)
		end
	end
end
