--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

RepairThreshold = { easy = 0.3, normal = 0.6, hard = 0.9 }

ActorRemovals =
{
	easy = { Actor167, Actor168, Actor190, Actor191, Actor193, Actor194, Actor196, Actor198, Actor200 },
	normal = { Actor167, Actor194, Actor196, Actor197 },
	hard = { },
}

GdiTanks = { "mtnk", "mtnk" }
GdiApc = { "apc" }
GdiInfantry = { "e1", "e1", "e1", "e1", "e1", "e2", "e2", "e2", "e2", "e2" }
GDIBase = { GdiNuke1, GdiNuke2, GdiProc, GdiSilo1, GdiSilo2, GdiPyle, GdiWeap, GdiHarv }
NodSams = { Sam1, Sam2, Sam3, Sam4 }
CoreNodBase = { NodConYard, NodRefinery, HandOfNod, Airfield }

Guard1UnitTypes = { "bggy" }
Guard1Path = { waypoint4.Location, waypoint5.Location, waypoint10.Location }
Guard1Delay = { easy = DateTime.Minutes(2), normal = DateTime.Minutes(1), hard = DateTime.Seconds(30) }
Guard2UnitTypes = { "bggy" }
Guard2Path = { waypoint0.Location, waypoint1.Location, waypoint2.Location }
Guard3Path = { waypoint4.Location, waypoint5.Location, waypoint9.Location }

AttackDelayMin = { easy = DateTime.Minutes(1), normal = DateTime.Seconds(45), hard = DateTime.Seconds(30) }
AttackDelayMax = { easy = DateTime.Minutes(2), normal = DateTime.Seconds(90), hard = DateTime.Minutes(1) }
AttackUnitTypes =
{
	easy =
	{
		{ factory = HandOfNod, types = { "e1", "e1" } },
		{ factory = HandOfNod, types = { "e1", "e3" } },
		{ factory = HandOfNod, types = { "e1", "e1", "e3" } },
		{ factory = HandOfNod, types = { "e1", "e3", "e3" } },
	},
	normal =
	{
		{ factory = HandOfNod, types = { "e1", "e1", "e3" } },
		{ factory = HandOfNod, types = { "e1", "e3", "e3" } },
		{ factory = HandOfNod, types = { "e1", "e1", "e3", "e3" } },
		{ factory = Airfield, types = { "bggy" } },
	},
	hard =
	{
		{ factory = HandOfNod, types = { "e1", "e1", "e3", "e3" } },
		{ factory = HandOfNod, types = { "e1", "e1", "e1", "e3", "e3" } },
		{ factory = HandOfNod, types = { "e1", "e1", "e3", "e3", "e3" } },
		{ factory = Airfield, types = { "bggy" } },
		{ factory = Airfield, types = { "ltnk" } },
	}
}

AttackPaths =
{
	{ waypoint0.Location, waypoint1.Location, waypoint2.Location, waypoint3.Location },
	{ waypoint4.Location, waypoint9.Location, waypoint7.Location, waypoint8.Location },
}

Attack = function()
	local production = Utils.Random(AttackUnitTypes[Difficulty])
	local path = Utils.Random(AttackPaths)
	local toBuild = function() return production.types end
	ProduceUnits(Nod, production.factory, nil, toBuild, function(units)
		Utils.Do(units, function(unit)
			unit.Patrol(path, false)
			IdleHunt(unit)
		end)
	end)

	Trigger.AfterDelay(Utils.RandomInteger(AttackDelayMin[Difficulty], AttackDelayMax[Difficulty]), Attack)
end

Guard1Action = function()
	ProduceUnits(Nod, Airfield, nil, function() return Guard1UnitTypes end, function(units)
		Trigger.OnAllKilled(units, function()
			Trigger.AfterDelay(Guard1Delay[Difficulty], Guard1Action)
		end)

		Utils.Do(units, function(unit)
			unit.Patrol(Guard1Path, true, DateTime.Seconds(7))
		end)
	end)
end

Guard2Action = function()
	ProduceUnits(Nod, Airfield, nil, function() return Guard2UnitTypes end, function(units)
		Utils.Do(units, function(unit)
			unit.Patrol(Guard2Path, true, DateTime.Seconds(5))
		end)
	end)
end

DiscoverGDIBase = function(actor, discoverer)
	for i,PID in pairs (CoopPlayers) do
	if BaseDiscovered or not discoverer == PID then
		return
	end
	end

	Utils.Do(GDIBase, function(actor)
		actor.Owner = GDI
	end)

	BaseDiscovered = true
	for i=1, HarvesterMultiplier do
		GdiWeap.Produce("harv")
	end
	if #CoopPlayers > 1 then
		GdiPyle.Owner = CoopPlayers[2]
	end
	if #CoopPlayers > 2 then
		P3Barr = Actor.Create("pyle", true, { Location = P3Barracks.Location, Owner = CoopPlayers[3] })
		P3Barr.Health = GdiPyle.Health
	end
	if #CoopPlayers > 3 then
		P4Fact = Actor.Create("weap", true, { Location = P4Factory.Location, Owner = CoopPlayers[4] })
		P4Fact.Health = GdiWeap.Health
	end
	if #CoopPlayers > 4 then
		P5Barr = Actor.Create("pyle", true, { Location = P5Barracks.Location, Owner = CoopPlayers[5] })
		P5Barr.Health = GdiPyle.Health
	end
	if #CoopPlayers > 5 then
		P6Fact = Actor.Create("weap", true, { Location = P6Factory.Location, Owner = CoopPlayers[6] })
		P6Fact.Health = GdiWeap.Health
	end
	for i, PID in pairs (CoopPlayers) do
		if PID ~= GDI then
			ExtraPower1 = Actor.Create(GdiNuke1.Type, true, { Location = CPos.Zero, Owner = PID })
			ExtraPower2 = Actor.Create(GdiNuke2.Type, true, { Location = CPos.Zero, Owner = PID })
			--ExtraDome = Actor.Create("dome", true, { Location = CPos.Zero, Owner = PID })
			table.insert(ExtraPowerplants1, ExtraPower1)
			table.insert(ExtraPowerplants2, ExtraPower2)
		end
	end
	for i,PID in pairs (CoopPlayers) do
	EliminateNod = AddPrimaryObjective(PID, "eliminate-nod")
	PID.MarkCompletedObjective(FindBase)
	end
	
	Attack()
end

SetupWorld = function()
	Utils.Do(ActorRemovals[Difficulty], function(unit)
		unit.Destroy()
	end)

	Media.PlaySpeechNotification(All, "Reinforce")
	Reinforcements.Reinforce(GoodGuy, GdiTanks, { GdiTankEntry.Location, GdiTankRallyPoint.Location }, DateTime.Seconds(1), function(actor) actor.Stance = "Defend" end)
	Reinforcements.Reinforce(GoodGuy, GdiApc, { GdiApcEntry.Location, GdiApcRallyPoint.Location }, DateTime.Seconds(1), function(actor) actor.Stance = "Defend" end)
	Reinforcements.Reinforce(GoodGuy, GdiInfantry, { GdiInfantryEntry.Location, GdiInfantryRallyPoint.Location }, 15, function(actor) actor.Stance = "Defend" end)

	Trigger.OnPlayerDiscovered(AbandonedBase, DiscoverGDIBase)

	RepairNamedActors(Nod, RepairThreshold[Difficulty])

	Trigger.OnAllKilled(NodSams, function()
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(DestroySAMs)
		end
		Actor.Create("airstrike.proxy", true, { Owner = GDI })
	end)

	Trigger.AfterDelay(0, function()
		GdiHarv.Stop()
	end)

	if Difficulty ~= "easy" then
		Trigger.OnDamaged(NodHarv, function()
			Utils.Do(Nod.GetGroundAttackers(), function(unit)
				unit.AttackMove(NodHarv.Location)
				if Difficulty == "hard" then
					IdleHunt(unit)
				end
			end)
		end)
	end

	Trigger.AfterDelay(DateTime.Seconds(45), Guard1Action)
	Trigger.AfterDelay(DateTime.Minutes(3), Guard2Action)

	Trigger.OnKilled(GuardTank1, function()
		if not GuardTank2.IsDead then
			GuardTank2.Patrol(Guard3Path, true, DateTime.Seconds(11))
		end
	end)

	GuardTank1.Patrol(Guard3Path, true, DateTime.Seconds(11))
end

MimicBuildings = function()
	for i, EID in pairs (ExtraPowerplants1) do
		if GdiNuke1.IsInWorld == true then
			EID.Health = GdiNuke1.Health
		else
			EID.Destroy ()
			table.remove(ExtraPowerplants1, i)
		end
	end
	for i, EID in pairs (ExtraPowerplants2) do
		if GdiNuke2.IsInWorld == true then
			EID.Health = GdiNuke2.Health
		else
			EID.Destroy ()
			table.remove(ExtraPowerplants2, i)
		end
	end
end

GoodGuySpread = function()
	P1Units = GoodGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
	if UID.Type ~= "apc" then
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
	end
end
for _, UID in ipairs(P1Units) do
	if UID.Type == "apc" then
		if UID.HasPassengers == true then
			UID.UnloadPassengers()
		end
		if UID.HasPassengers == false then
			CurrentPlayer = CoopPlayers[CoopCurrent]
			UID.Owner = CurrentPlayer
			CoopCurrent = CoopCurrent + 1
			if CoopCurrent > #CoopPlayers then
				CoopCurrent = 1
			end
		end
	end
end
end

PlayOpening = function()
Media.PlayMovieFullscreen("gdi5.vqa",PlayOpening2)
end

PlayOpening2 = function()
Media.PlayMovieInRadar("seige.vqa")
end

WorldLoaded = function()
	AbandonedBase = Player.GetPlayer("AbandonedBase")
	GDI = Player.GetPlayer("GDI")
	Nod = Player.GetPlayer("Nod")
	GoodGuy = Player.GetPlayer("GoodGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	CoopPlayers = {};
	table.insert(CoopPlayers, GDI)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	Media.PlayMovieFullscreen("podium.vqa",PlayOpening)
	
	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end

	if Map.LobbyOption("blossom") == "blossomon"  then
		ExtraMines = {ExtraBlossom1, ExtraBlossom2, ExtraBlossom3, ExtraBlossom4, ExtraBlossom5}
		for i,MID in pairs (ExtraMines) do
			AddMine = Actor.Create("split2", true, { Location = MID.Location, Owner = Neutral })
		end
	end

	EnemyUnits = Nod.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	CoopCurrent = 1
	CoopCash = GDI.Cash
	for i, PID in pairs (CoopPlayers) do
		PID.Cash = CoopCash/#CoopPlayers
	end
	ExtraPowerplants1 = {}
	ExtraPowerplants2 = {}

	HarvesterMultiplier = Map.LobbyOption("extraharvesters")
	if Map.LobbyOption("extraharvesters") == "harvpc"  then
	HarvesterMultiplier = #CoopPlayers-1
	end
	
	InitObjectives(GDI)

	NodObjective = AddPrimaryObjective(Nod, "")
	for i,PID in pairs (CoopPlayers) do
	FindBase = AddPrimaryObjective(PID, "find-gdi-base")
	DestroySAMs = AddSecondaryObjective(PID, "destroy-sams")
	end
	
	SetupWorld()

	Camera.Position = GdiTankRallyPoint.CenterPosition
end

ShareMoney = function()
	if GDI.Resources > #CoopPlayers then
	CashSubtract = GDI.Resources/#CoopPlayers
	for i, PID in pairs (CoopPlayers) do
	PID.Cash = PID.Cash + CashSubtract
	end
	GDI.Resources = 0
	end
end

GiveHarvesters = function()
	for i, PID in pairs (CoopPlayers) do
		if PID ~= GDI then
			Harvesters = PID.GetActorsByType("harv")
			for i, HID in pairs (Harvesters) do
				HID.Owner = GDI
			end
		end
	end
end

Tick = function()
	GoodGuySpread()
	MimicBuildings()
	ShareMoney()
--	GiveHarvesters()
	for i,PID in pairs (CoopPlayers) do
	if DateTime.GameTime > DateTime.Seconds(10) and PID.HasNoRequiredUnits() then
		Nod.MarkCompletedObjective(NodObjective)
	end
	end

	if BaseDiscovered and Nod.HasNoRequiredUnits() then
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(EliminateNod)
		end
	end
end
