--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

LoseTriggerHouses = { TrigLos2Farm1, TrigLos2Farm2, TrigLos2Farm3, TrigLos2Farm4 }
TownAttackTrigger = { CPos.New(54, 38), CPos.New(55, 38), CPos.New(56, 38), CPos.New(57, 38) }
GDIReinforcementsTrigger = { CPos.New(32, 51), CPos.New(32, 52), CPos.New(33, 52) }

GDIReinforcementsPart1 = { "jeep", "jeep" }
GDIReinforcementsPart2 = { "e2", "e2", "e2", "e2", "e2" }
TownAttackWave1 = { "bggy", "bggy" }
TownAttackWave2 = { "ltnk", "ltnk" }
TownAttackWave3 = { "e1", "e1", "e1", "e3", "e3", "e3" }

Civvie1Wpts = { CivvieWpts1, CivvieWpts2 }
Civvie2Wpts = { CivvieWpts3, CivvieWpts1, CivvieWpts4, CivvieWpts5, CivvieWpts6, CivvieWpts7, CivvieWpts8, CivvieWpts9, CivvieWpts10, CivvieWpts11 }

FollowCivvieWpts = function(actor, wpts)
	Utils.Do(wpts, function(wpt)
		actor.Move(wpt.Location, 2)
		actor.Wait(DateTime.Seconds(2))
	end)
end

FollowWaypoints = function(actor, wpts)
	Utils.Do(wpts, function(wpt)
		actor.AttackMove(wpt.Location, 2)
	end)
end

TownAttackersIdleAction = function(actor)
	actor.AttackMove(TownAttackWpt.Location, 2)
	actor.Hunt()
end

TownAttackAction = function(actor)
	Trigger.OnIdle(actor, TownAttackersIdleAction)
end

AttackTown = function()
	Reinforcements.Reinforce(Nod, TownAttackWave1, { NodReinfEntry.Location, NodReinfRally.Location }, DateTime.Seconds(0.25), TownAttackAction)
	Trigger.AfterDelay(DateTime.Seconds(2), function()
		Reinforcements.Reinforce(Nod, TownAttackWave2, { NodReinfEntry.Location, NodReinfRally.Location }, DateTime.Seconds(1), TownAttackAction)
	end)
	Trigger.AfterDelay(DateTime.Seconds(4), function()
		Reinforcements.Reinforce(Nod, TownAttackWave3, { NodReinfEntry.Location, NodReinfRally.Location }, DateTime.Seconds(1), TownAttackAction)
	end)
end

SendGDIReinforcements = function()
	Media.PlaySpeechNotification(All, "Reinforce")
	Reinforcements.Reinforce(GoodGuy, GDIReinforcementsPart1, { GDIReinfEntry1.Location, GDIReinfRally1.Location, GDIReinfRally3.Location }, DateTime.Seconds(1))

	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.PlaySpeechNotification(All, "Reinforce")
		local apc = Reinforcements.ReinforceWithTransport(GoodGuy, "apc", GDIReinforcementsPart2, { GDIReinfEntry2.Location, GDIReinfRally2.Location, GDIUnloadWpt.Location })[1]
		apc.UnloadPassengers()
	end)
end

GoodGuySpread = function()
	P1Units = GoodGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
	if UID.Type ~= "apc" then
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
	end
end
for _, UID in ipairs(P1Units) do
	if UID.Type == "apc" then
		if UID.HasPassengers == true then
			UID.UnloadPassengers()
		end
		if UID.HasPassengers == false then
			CurrentPlayer = CoopPlayers[CoopCurrent]
			UID.Owner = CurrentPlayer
			CoopCurrent = CoopCurrent + 1
			if CoopCurrent > #CoopPlayers then
				CoopCurrent = 1
			end
		end
	end
end
end

PlayOpening = function()
Media.PlayMovieFullscreen("gdi4a.vqa",PlayOpening2)
end

PlayOpening2 = function()
Media.PlayMovieInRadar("nodsweep.vqa")
end

WorldLoaded = function()
	GDI = Player.GetPlayer("GDI")
	Nod = Player.GetPlayer("Nod")
	GoodGuy = Player.GetPlayer("GoodGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	CoopPlayers = {};
	table.insert(CoopPlayers, GDI)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	Media.PlayMovieFullscreen("bkground.vqa",PlayOpening)
	
	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end


	EnemyUnits = Nod.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	CoopCurrent = 1
	InitObjectives(GDI)

	Trigger.OnAllKilled(LoseTriggerHouses, function()
		for i,PID in pairs (CoopPlayers) do
		PID.MarkFailedObjective(DefendTown)
		end
	end)

	NodObjective = AddPrimaryObjective(Nod, "")
	for i,PID in pairs (CoopPlayers) do
	DefendTown = AddPrimaryObjective(PID, "defend-bialystok")
	EliminateNod = AddPrimaryObjective(PID, "eliminate-nod")
	end

	Trigger.OnExitedFootprint(TownAttackTrigger, function(a, id)
		for i,PID in pairs (CoopPlayers) do
		if not TownAttackTriggered and a.Owner == PID then
			TownAttackTriggered = true
			Trigger.RemoveFootprintTrigger(id)
			AttackTown()
		end
		end
	end)

	Trigger.OnEnteredFootprint(GDIReinforcementsTrigger, function(a, id)
		for i,PID in pairs (CoopPlayers) do
		if not GDIReinforcementsTriggered and a.Owner == PID then
			GDIReinforcementsTriggered = true
			Trigger.RemoveFootprintTrigger(id)
			SendGDIReinforcements()
		end
		end
	end)

	Trigger.AfterDelay(1, function()
		FollowCivvieWpts(civvie1, Civvie1Wpts)
		FollowCivvieWpts(civvie2, Civvie2Wpts)
	end)

	Camera.Position = Actor141.CenterPosition
end

Tick = function()
	GoodGuySpread()
	LostCounter = 0
	for i,PID in pairs (CoopPlayers) do
		if PID.HasNoRequiredUnits() and DateTime.GameTime > DateTime.Seconds(5) then
			LostCounter = LostCounter+1
		end
	end
	
	if LostCounter == #CoopPlayers then
		Nod.MarkCompletedObjective(NodObjective)
	end

	if Nod.HasNoRequiredUnits() then
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(DefendTown)
		PID.MarkCompletedObjective(EliminateNod)
		end
	end
end
