--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

AutoTrigger = { CPos.New(51, 47), CPos.New(52, 47), CPos.New(53, 47), CPos.New(54, 47) }
GDIHeliTrigger = { CPos.New(27, 55), CPos.New(27, 56), CPos.New(28, 56), CPos.New(28, 57), CPos.New(28, 58), CPos.New(28, 59)}

NodUnits = { "e1", "e1", "e3", "e3" }
AutoUnits = { "e1", "e1", "e3" }

KillsUntilReinforcements = 12
HeliDelay = { 83, 137, 211 }

GDIReinforcements = { "e2", "e2", "e2", "e2", "e2" }
GDIReinforcementsWaypoints = { GDIReinforcementsEntry.Location, GDIReinforcementsWP1.Location }
GDIReinforcementsLeft = 3

NodHelis =
{
	{ delay = DateTime.Seconds(HeliDelay[1]), entry = { NodHeliEntry.Location, NodHeliLZ1.Location }, types = { "e1", "e1", "e3" } },
	{ delay = DateTime.Seconds(HeliDelay[2]), entry = { NodHeliEntry.Location, NodHeliLZ2.Location }, types = { "e1", "e1", "e1", "e1" } },
	{ delay = DateTime.Seconds(HeliDelay[3]), entry = { NodHeliEntry.Location, NodHeliLZ3.Location }, types = { "e1", "e1", "e3" } }
}

Kills = 0
NodUnitKilled = function()
	Kills = Kills + 1

	if Kills == KillsUntilReinforcements then
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(ReinforcementsObjective)
		end
		SendGDIReinforcements()
	end
end

SendHeli = function(heli)
	local units = Reinforcements.ReinforceWithTransport(Nod, "tran", heli.types, heli.entry, { heli.entry[1] })
	Utils.Do(units[2], function(actor)
		IdleHunt(actor)
		Trigger.OnKilled(actor, NodUnitKilled)
	end)
	Trigger.AfterDelay(heli.delay, function() SendHeli(heli) end)
end

SendGDIReinforcements = function()
	Media.PlaySpeechNotification(All, "Reinforce")
	Reinforcements.ReinforceWithTransport(GoodGuy, "apc", GDIReinforcements, GDIReinforcementsWaypoints, nil, function(apc, team)
		table.insert(team, apc)
		Trigger.OnAllKilled(team, function()
			if GDIReinforcementsLeft > 0 then
				GDIReinforcementsLeft = GDIReinforcementsLeft - 1
				Trigger.AfterDelay(DateTime.Seconds(5), function()
					Media.DisplayMessage(UserInterface.Translate("apcs-left", { ["apcs"] = GDIReinforcementsLeft }), UserInterface.Translate("battlefield-control"))
					SendGDIReinforcements()
				end)
			end
		end)
	end)
end

BuildNod = function()
	local after = function(team)
		Utils.Do(team, function(actor)
			Trigger.OnIdle(actor, actor.Hunt)
			Trigger.OnKilled(actor, NodUnitKilled)
		end)
		Trigger.OnAllKilled(team, BuildNod)
	end

	ProduceUnits(Nod, HandOfNod, nil, function() return NodUnits end, after)
end

BuildAuto = function()
	local after = function(team)
		Utils.Do(team, function(actor)
			Trigger.OnIdle(actor, actor.Hunt)
			Trigger.OnKilled(actor, NodUnitKilled)
		end)
	end

	local delay = function() return DateTime.Seconds(5) end
	ProduceUnits(Nod, HandOfNod, delay, function() return AutoUnits end, after)
end

Tick = function()
	GoodGuySpread()
	Nod.Cash = 1000
	
	LostCounter = 0
	for i,PID in pairs (CoopPlayers) do
		if (GDIReinforcementsLeft == 0 or not GDI.IsObjectiveCompleted(ReinforcementsObjective)) and PID.HasNoRequiredUnits() and DateTime.GameTime > DateTime.Seconds(5) then
			LostCounter = LostCounter+1
		end
	end
	
	if LostCounter == #CoopPlayers then
		for i,PID in pairs (CoopPlayers) do
		PID.MarkFailedObjective(GDIObjective)
		end
	end
end

SetupWorld = function()
	Utils.Do(Nod.GetGroundAttackers(), function(unit)
		Trigger.OnKilled(unit, NodUnitKilled)
	end)

	Hunter1.Hunt()
	Hunter2.Hunt()

	Trigger.OnRemovedFromWorld(crate, function()
	for i,PID in pairs (CoopPlayers) do
	PID.MarkCompletedObjective(GDIObjective)
	end
	end)
end

GoodGuySpread = function()
	P1Units = GoodGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
	if UID.Type ~= "apc" then
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
	end
end
for _, UID in ipairs(P1Units) do
	if UID.Type == "apc" then
		if UID.HasPassengers == true then
			UID.UnloadPassengers()
		end
		if UID.HasPassengers == false then
			CurrentPlayer = CoopPlayers[CoopCurrent]
			UID.Owner = CurrentPlayer
			CoopCurrent = CoopCurrent + 1
			if CoopCurrent > #CoopPlayers then
				CoopCurrent = 1
			end
		end
	end
end
end

PlayOpening = function()
Media.PlayMovieFullscreen("gdi4b.vqa",PlayOpening2)
end

PlayOpening2 = function()
Media.PlayMovieInRadar("nitejump.vqa")
end

WorldLoaded = function()
	GDI = Player.GetPlayer("GDI")
	Nod = Player.GetPlayer("Nod")
	GoodGuy = Player.GetPlayer("GoodGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	CoopPlayers = {};
	table.insert(CoopPlayers, GDI)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	Media.PlayMovieFullscreen("bkground.vqa",PlayOpening)
	
	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end


	EnemyUnits = Nod.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	CoopCurrent = 1
	SetupWorld()

	InitObjectives(GDI)
	
	local eliminateReinforcements = UserInterface.Translate("eliminate-reinforcements", { ["kills"] = KillsUntilReinforcements })
	for i,PID in pairs (CoopPlayers) do
	GDIObjective = AddPrimaryObjective(PID, "retrieve-rods")
	ReinforcementsObjective = AddSecondaryObjective(PID, eliminateReinforcements)
	end

	BuildNod()
	Utils.Do(NodHelis, function(heli)
		Trigger.AfterDelay(heli.delay, function() SendHeli(heli) end)
	end)

	Trigger.OnEnteredFootprint(AutoTrigger, function(a, id)
		for i,PID in pairs (CoopPlayers) do
		if not AutoTriggered and a.Owner == PID then
			AutoTriggered = true
			Trigger.RemoveFootprintTrigger(id)
			BuildAuto()
		end
		end
	end)

	Trigger.OnEnteredFootprint(GDIHeliTrigger, function(a, id)
		for i,PID in pairs (CoopPlayers) do
		if not GDIHeliTriggered and a.Owner == PID then
			GDIHeliTriggered = true
			Trigger.RemoveFootprintTrigger(id)
			Reinforcements.ReinforceWithTransport(GDI, "tran", nil, { GDIHeliEntry.Location, GDIHeliLZ.Location })
		end
		end
	end)

	Camera.Position = Actor56.CenterPosition
end
