--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

NodInBaseTeam = { RushBuggy, RushRifle1, RushRifle2, RushRifle3 }
MobileConstructionVehicle = { "mcv" }
EngineerReinforcements = { "e6", "e6", "e6" }
VehicleReinforcements = { "jeep" }

AttackerSquadSize = 3

Reinforce = function(units)
	Media.PlaySpeechNotification(All, "Reinforce")
	ReinforceWithLandingCraft(GoodGuy, units, lstStart.Location, lstEnd.Location)
end

BridgeheadSecured = function()
	Reinforce(MobileConstructionVehicle)
	Trigger.AfterDelay(DateTime.Seconds(15), NodAttack)
	Trigger.AfterDelay(DateTime.Seconds(30), function() Reinforce(EngineerReinforcements) end)
	Trigger.AfterDelay(DateTime.Seconds(120), function() Reinforce(VehicleReinforcements) end)
end

NodAttack = function()
	local nodUnits = Nod.GetGroundAttackers()
	if #nodUnits > AttackerSquadSize * 2 then
		local attackers = Utils.Skip(nodUnits, #nodUnits - AttackerSquadSize)
		Utils.Do(attackers, function(unit)
			unit.AttackMove(NodAttackWaypoint.Location)
			IdleHunt(unit)
		end)
		Trigger.OnAllKilled(attackers, function() Trigger.AfterDelay(DateTime.Seconds(15), NodAttack) end)
	end
end

GoodGuySpread = function()
	P1Units = GoodGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
	P1Units = GoodGuy.GetActorsByTypes({"e6","mcv"})
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end

WorldLoaded = function()
	GDI = Player.GetPlayer("GDI")
	Nod = Player.GetPlayer("Nod")
	GoodGuy = Player.GetPlayer("GoodGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	CoopPlayers = {};
	table.insert(CoopPlayers, GDI)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	Media.PlayMovieFullscreen("gdi2.vqa")

	for i,PID in pairs (CoopPlayers) do
		if PID ~= GDI then
			table.insert(MobileConstructionVehicle, "mcv")
		end
	end

	if Map.LobbyOption("blossom") == "blossomon"  then
		ExtraMines = {ExtraBlossom1, ExtraBlossom2}
		for i,MID in pairs (ExtraMines) do
			AddMine = Actor.Create("split2", true, { Location = MID.Location, Owner = Neutral })
		end
	end
	
	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end


	EnemyUnits = Nod.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	CoopCurrent = 1
	InitObjectives(GDI)

	NodObjective = AddPrimaryObjective(Nod, "")
	for i,PID in pairs (CoopPlayers) do
	GDIObjective1 = AddPrimaryObjective(PID, "eliminate-nod")
	GDIObjective2 = AddSecondaryObjective(PID, "capture-refinery")
	end
	
	Trigger.OnCapture(NodRefinery, function()
		for i,PID in pairs (CoopPlayers) do
			PID.MarkCompletedObjective(GDIObjective2)
		end
	end)
	Trigger.OnKilled(NodRefinery, function()
		for i,PID in pairs (CoopPlayers) do
			PID.MarkFailedObjective(GDIObjective2)
		end
	end)

	Trigger.OnAllKilled(NodInBaseTeam, BridgeheadSecured)
end

Tick = function()
	GoodGuySpread()
	LostCounter = 0
	for i,PID in pairs (CoopPlayers) do
	if DateTime.GameTime > DateTime.Seconds(5) and PID.HasNoRequiredUnits() then
		LostCounter = LostCounter+1
	end
	end
	if LostCounter == #CoopPlayers then
		Nod.MarkCompletedObjective(NodObjective)
	end

	if Nod.HasNoRequiredUnits() then
	for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(GDIObjective1)
	end
	end
end
