--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

MCVReinforcements = { "mcv" }
InfantryReinforcements = { "e1", "e1", "e1" }
VehicleReinforcements = { "jeep" }
NodPatrol = { "e1", "e1" }
GDIBaseBuildings = { "pyle", "fact", "nuke" }

SendNodPatrol = function()
	Reinforcements.Reinforce(Nod, NodPatrol, { nod0.Location, nod1.Location }, 15, function(soldier)
		soldier.AttackMove(nod2.Location)
		soldier.AttackMove(nod3.Location)
		IdleHunt(soldier)
	end)
end

Reinforce = function(units)
	Media.PlaySpeechNotification(All, "Reinforce")
	ReinforceWithLandingCraft(GoodGuy, units, lstStart.Location, lstEnd.Location, reinforcementsTarget.Location)
end

PlayOpening = function()
Media.PlayMovieFullscreen("gdi1.vqa", PlayOpening2)
end

PlayOpening2 = function()
Media.PlayMovieInRadar("landing.vqa")
end

GoodGuySpread = function()
	P1Units = GoodGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
	P1Units = GoodGuy.GetActorsByType("mcv")
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end

WorldLoaded = function()
	GDI = Player.GetPlayer("GDI")
	Nod = Player.GetPlayer("Nod")
	GoodGuy = Player.GetPlayer("GoodGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	CoopPlayers = {};
	table.insert(CoopPlayers, GDI)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	Media.PlayMovieFullscreen("intro2.vqa", PlayOpening)

	for i,PID in pairs (CoopPlayers) do
		if PID ~= GDI then
			table.insert(MCVReinforcements, "mcv")
		end
	end

	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end


	EnemyUnits = Nod.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	CoopCurrent = 1

	InitObjectives(GDI)
	
	for i,PID in pairs (CoopPlayers) do
	SecureAreaObjective = AddPrimaryObjective(PID, "eliminate-nod")
	BeachheadObjective = AddSecondaryObjective(PID, "establish-beachhead")
	end
	
	ReinforceWithLandingCraft(GoodGuy, MCVReinforcements, lstStart.Location + CVec.New(2, 0), lstEnd.Location + CVec.New(2, 0), mcvTarget.Location)
	Reinforce(InfantryReinforcements)

	SendNodPatrol()

	Trigger.AfterDelay(DateTime.Seconds(10), function() Reinforce(InfantryReinforcements) end)
	Trigger.AfterDelay(DateTime.Seconds(60), function() Reinforce(VehicleReinforcements) end)
end

Tick = function()
	GoodGuySpread()
	if Nod.HasNoRequiredUnits() then
		for i,PID in pairs (CoopPlayers) do
			PID.MarkCompletedObjective(SecureAreaObjective)
		end
	end
	
	for i,PID in pairs (CoopPlayers) do
		if DateTime.GameTime > DateTime.Seconds(5) and PID.HasNoRequiredUnits() then
			for i,PID2 in pairs (CoopPlayers) do
				PID2.MarkFailedObjective(BeachheadObjective)
				PID2.MarkFailedObjective(SecureAreaObjective)
			end
		end
	end
	for i,PID in pairs (CoopPlayers) do
	if DateTime.GameTime % DateTime.Seconds(1) == 0 and not PID.IsObjectiveCompleted(BeachheadObjective) and CheckForBase(PID, GDIBaseBuildings) then
			PID.MarkCompletedObjective(BeachheadObjective)
	end
	end
end
