
CorrinoBase = { CT1, CT2, CStarport }

CorrinoReinforcements =
{
	easy =
	{
		{ "sardaukar", "trooper" },
		{ "sardaukar", "sardaukar", "trooper" },
		{ "light_inf", "raider", "light_inf" },
		{ "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "combat_tank_h", "sardaukar", "sardaukar", "trooper", "saboteur" },
		{ "sardaukar", "sardaukar", "trooper" },
		{ "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper" },
		{ "combat_tank_h", "combat_tank_h", "missile_tank", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "combat_tank_h"  },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper" },
		{ "combat_tank_h", "combat_tank_h" },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "saboteur" },
		{ "devastator", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "trooper", "trooper", "light_inf", "raider", "combat_tank_o" },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper", "sardaukar", "trooper" },
		{ "light_inf", "light_inf", "sardaukar", "sardaukar", "trooper", "trooper", "combat_tank_h" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "combat_tank_h", "missile_tank"  },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "mpsardaukar_level1" },
		{ "light_inf", "raider", "light_inf", "trooper", "trooper", "combat_tank_h" },
		{ "siege_tank", "sardaukar", "sardaukar", "combat_tank_h", "missile_tank", "combat_tank_h"  },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "mpsardaukar_level1", "sardaukar", "sardaukar" },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper" },
		{ "devastator", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "sardaukar", "sardaukar", "trooper", "trooper", "light_inf", "raider", "combat_tank_h" },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper", "sardaukar", "trooper" },
		{ "light_inf", "light_inf", "sardaukar", "sardaukar", "trooper", "trooper", "combat_tank_h" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "combat_tank_h", "missile_tank"  },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "mpsardaukar_level1" },
		{ "light_inf", "raider", "light_inf", "trooper", "trooper", "combat_tank_o" },
		{ "saboteur", "sardaukar", "sardaukar", "combat_tank_h", "sardaukar", "combat_tank_h"  },
		{ "missile_tank", "quad", "siege_tank", "sardaukar", "sardaukar" },
		{ "missile_tank", "saboteur", "saboteur" }
	},

	normal =
	{
		{ "sardaukar", "trooper", "saboteur", },
		{ "sardaukar", "sardaukar", "trooper" },
		{ "light_inf", "raider", "light_inf", "saboteur", "light_inf", "saboteur" },
		{ "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "combat_tank_h", "combat_tank_h", "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "sardaukar", "sardaukar", "trooper", "sardaukar", "trooper", "mpsardaukar_level1", "mpsardaukar_level1", "light_inf_level4", },
		{ "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "combat_tank_h", "combat_tank_h", "missile_tank", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "combat_tank_h"  },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper" },
		{ "combat_tank_h", "combat_tank_h", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "saboteur" },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "saboteur" },
		{ "devastator", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "trooper", "trooper", "light_inf", "raider", "combat_tank_o" },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper", "sardaukar", "trooper" },
		{ "light_inf", "light_inf", "sardaukar", "sardaukar", "trooper", "trooper", "combat_tank_h" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "combat_tank_h", "missile_tank"  },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "mpsardaukar_level1" },
		{ "light_inf", "raider", "light_inf", "trooper", "trooper", "combat_tank_h" },
		{ "siege_tank", "sardaukar", "sardaukar", "combat_tank_h", "missile_tank", "combat_tank_h"  },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "mpsardaukar_level1", "sardaukar", "sardaukar" },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper" },
		{ "devastator", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "sardaukar", "sardaukar", "trooper", "trooper", "light_inf", "raider", "combat_tank_h" },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper", "sardaukar", "trooper" },
		{ "light_inf", "light_inf", "sardaukar", "sardaukar", "trooper", "trooper", "combat_tank_h" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "combat_tank_h", "missile_tank"  },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "mpsardaukar_level1" },
		{ "light_inf", "raider", "light_inf", "trooper", "trooper", "combat_tank_o" },
		{ "saboteur", "sardaukar", "sardaukar", "combat_tank_h", "sardaukar", "combat_tank_h"  },
		{ "missile_tank", "quad", "siege_tank", "sardaukar", "sardaukar" },
		{ "missile_tank", "saboteur", "saboteur", "saboteur" }
	},

	hard =
	{
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "saboteur" },
		{ "devastator", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "trooper", "trooper", "light_inf", "raider", "combat_tank_h", "sardaukar", "sardaukar", "trooper", "saboteur" },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper", "sardaukar", "trooper" },
		{ "light_inf", "light_inf", "sardaukar", "sardaukar", "trooper", "trooper", "combat_tank_h" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "combat_tank_h", "missile_tank"  },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "mpsardaukar_level1" },
		{ "light_inf", "raider", "light_inf", "trooper", "trooper", "combat_tank_h", "sardaukar", "sardaukar", "trooper", "saboteur" },
		{ "siege_tank", "sardaukar", "sardaukar", "combat_tank_h", "missile_tank", "combat_tank_h"  },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "mpsardaukar_level1", "sardaukar", "sardaukar" },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper" },
		{ "devastator", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "sardaukar", "sardaukar", "trooper", "trooper", "light_inf", "raider", "combat_tank_h" },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper", "sardaukar", "trooper" },
		{ "light_inf", "light_inf", "sardaukar", "sardaukar", "trooper", "trooper", "combat_tank_h" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "combat_tank_h", "missile_tank"  },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "mpsardaukar_level1" },
		{ "light_inf", "raider", "light_inf", "trooper", "trooper", "combat_tank_o" },
		{ "saboteur", "sardaukar", "sardaukar", "combat_tank_h", "sardaukar", "combat_tank_h"  },
		{ "missile_tank", "quad", "siege_tank", "sardaukar", "sardaukar" },
		{ "sardaukar", "trooper", "sardaukar", "sardaukar", "trooper", "saboteur" },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "saboteur", "trooper" },
		{ "light_inf", "raider", "light_inf", "sardaukar", "sardaukar", "trooper", "saboteur" },
		{ "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "combat_tank_h", "sardaukar", "sardaukar", "trooper", "saboteur" },
		{ "sardaukar", "sardaukar", "trooper", "sardaukar", "sardaukar", "trooper", "saboteur" },
		{ "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper" },
		{ "combat_tank_h", "combat_tank_h", "missile_tank", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "combat_tank_h"  },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper" },
		{ "combat_tank_h", "combat_tank_h", "sardaukar", "sardaukar", "trooper", "saboteur" },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "saboteur" },
		{ "devastator", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "trooper", "trooper", "light_inf", "raider", "combat_tank_h", "sardaukar", "sardaukar", "trooper", "saboteur" },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper", "sardaukar", "trooper" },
		{ "light_inf", "light_inf", "sardaukar", "sardaukar", "trooper", "trooper", "combat_tank_h" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "combat_tank_h", "missile_tank"  },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "mpsardaukar_level1" },
		{ "light_inf", "raider", "light_inf", "trooper", "trooper", "combat_tank_h" },
		{ "siege_tank", "sardaukar", "sardaukar", "combat_tank_h", "missile_tank", "combat_tank_h"  },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "mpsardaukar_level1", "sardaukar", "sardaukar" },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper" },
		{ "devastator", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "light_inf", "saboteur" },
		{ "sardaukar", "sardaukar", "trooper", "trooper", "light_inf", "raider", "combat_tank_h", "light_inf", "saboteur" },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper", "sardaukar", "trooper", "light_inf", "saboteur" },
		{ "light_inf", "light_inf", "sardaukar", "sardaukar", "trooper", "trooper", "combat_tank_h", "light_inf", "saboteur" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "combat_tank_h", "missile_tank", "light_inf", "saboteur"  },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "mpsardaukar_level1" },
		{ "light_inf", "raider", "light_inf", "trooper", "trooper", "combat_tank_o" },
		{ "saboteur", "sardaukar", "sardaukar", "combat_tank_h", "sardaukar", "combat_tank_h"  },
		{ "missile_tank", "quad", "siege_tank", "sardaukar", "sardaukar", "saboteur" },
		{ "missile_tank", "sardaukar", "sardaukar", "trooper", "saboteur", "saboteur" },
		{ "devastator", "sardaukar", "sardaukar", "sardaukar" }
	}
}

CorrinoAttackDelay =
{
	easy = DateTime.Minutes(5) + DateTime.Minutes(2),
	normal = DateTime.Minutes(4) + DateTime.Minutes(1),
	hard = DateTime.Minutes(3) + DateTime.Seconds(30)
}

CorrinoAttackWaves =
{
	easy = 15,
	normal = 25,
	hard = 50
}

CorrinoPaths =
{
	{ CorrinoEntry1.Location, CorrinoRally2.Location },
	{ CorrinoEntry2.Location, CorrinoRally1.Location },
	{ CorrinoEntry4.Location, CorrinoRally3.Location },
	{ CorrinoEntry3.Location, CorrinoRally4.Location },
	{ CorrinoEntry6.Location, CorrinoRally5.Location },
	{ CorrinoEntry5.Location, CorrinoRally6.Location },
	{ CorrinoEntry8.Location, CorrinoRally7.Location },
	{ CorrinoEntry7.Location, CorrinoRally8.Location },
}

AtreidesReinforcements = { "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen" }

AtreidesPath = { AtreidesEntry.Location, AtreidesRally.Location }

Tick = function()
	if Atreides.HasNoRequiredUnits() then
		Harkonnen.MarkCompletedObjective(KillAtreides)
	end

	if Harkonnen.HasNoRequiredUnits() and not Atreides.IsObjectiveCompleted(KillHarkonnen) then
		Media.DisplayMessage(UserInterface.Translate("harkonnen-annihilated"), Mentat)
		Atreides.MarkCompletedObjective(KillHarkonnen)
	end
end

WorldLoaded = function()
	Corrino = Player.GetPlayer("Corrino")
	Atreides = Player.GetPlayer("Atreides")
	Harkonnen = Player.GetPlayer("Harkonnen")
	Mercenaries = Player.GetPlayer("Mercenaries")
	Ordos = Player.GetPlayer("Ordos")
	Smugglers = Player.GetPlayer("Smugglers")
	
	InitObjectives(Atreides)
	KillAtreides = AddPrimaryObjective(Harkonnen, "")
	KillHarkonnen = AddPrimaryObjective(Atreides, "destroy-imperial-forces")
		
	Camera.Position = AConyard.CenterPosition

	Trigger.OnAllKilled(CorrinoBase, function()
		Utils.Do(Corrino.GetGroundAttackers(), IdleHunt)
	end)
	
	local path = function() return CorrinoPaths[1] end
	SendCarryallReinforcements(Corrino, 8, CorrinoAttackWaves[Difficulty], CorrinoAttackDelay[Difficulty], path, CorrinoReinforcements[Difficulty], waveCondition)

	local path = function() return CorrinoPaths[2] end
	SendCarryallReinforcements(Corrino, 8, CorrinoAttackWaves[Difficulty], CorrinoAttackDelay[Difficulty], path, CorrinoReinforcements[Difficulty], waveCondition)
	
	local path = function() return CorrinoPaths[3] end
	SendCarryallReinforcements(Corrino, 8, CorrinoAttackWaves[Difficulty], CorrinoAttackDelay[Difficulty], path, CorrinoReinforcements[Difficulty], waveCondition)
	
	local path = function() return CorrinoPaths[4] end
	SendCarryallReinforcements(Corrino, 8, CorrinoAttackWaves[Difficulty], CorrinoAttackDelay[Difficulty], path, CorrinoReinforcements[Difficulty], waveCondition)
	
	local path = function() return CorrinoPaths[5] end
	SendCarryallReinforcements(Corrino, 8, CorrinoAttackWaves[Difficulty], CorrinoAttackDelay[Difficulty], path, CorrinoReinforcements[Difficulty], waveCondition)

	local path = function() return CorrinoPaths[6] end
	SendCarryallReinforcements(Corrino, 8, CorrinoAttackWaves[Difficulty], CorrinoAttackDelay[Difficulty], path, CorrinoReinforcements[Difficulty], waveCondition)
	
	local path = function() return CorrinoPaths[7] end
	SendCarryallReinforcements(Corrino, 8, CorrinoAttackWaves[Difficulty], CorrinoAttackDelay[Difficulty], path, CorrinoReinforcements[Difficulty], waveCondition)
	
	local path = function() return CorrinoPaths[8] end
	SendCarryallReinforcements(Corrino, 0, CorrinoAttackWaves[Difficulty], CorrinoAttackDelay[Difficulty], path, CorrinoReinforcements[Difficulty], waveCondition)
	
	Actor.Create("upgrade.barracks", true, { Owner = Corrino })
	
	Trigger.AfterDelay(DateTime.Minutes(2) + DateTime.Seconds(120), function()
		Media.PlaySpeechNotification(Atreides, "Reinforce")
		Reinforcements.Reinforce(Atreides, AtreidesReinforcements, AtreidesPath)
	end)
end
