--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

--Boolean Vars
baseDiscovered = false
AtEndGame = false

--Basic Vars
TimerColor = Player.GetPlayer("Spain").Color
InsertionHelicopterType = "tran.insertion"
TimerTicks = DateTime.Minutes(18) -- 18 minutes is roughly 30 mins in the original game
Ticks = TimerTicks

--Table Vars
TankPath = { waypoint12.Location, waypoint13.Location }
InsertionPath = { waypoint12.Location, waypoint0.Location }
AlliedBase = { WarFactory, PillBox1, PillBox2, Refinery, PowerPlant1, PowerPlant2, RepairPad, OreSilo, Barracks, RadarDome }
AlliedForces = { "2tnk" , "2tnk", "mcv" }
ChopperTeam = { "e1r1", "e1r1", "e2", "e2", "e1r1" }

SendTanks = function()
	Media.PlaySpeechNotification(All, "ReinforcementsArrived")
	Reinforcements.Reinforce(GoodGuy, AlliedForces, TankPath, DateTime.Seconds(1))
end

SendInsertionHelicopter = function()
	Media.PlaySpeechNotification(All, "AlliedReinforcementsSouth")
	Reinforcements.ReinforceWithTransport(GoodGuy, InsertionHelicopterType, ChopperTeam, InsertionPath, { waypoint4.Location })
end

AlliedForcesHaveArrived = UserInterface.Translate("allied-forces-have-arrived")
FinishTimer = function()
	for i = 0, 9, 1 do
		local c = TimerColor
		if i % 2 == 0 then
			c = HSLColor.White
		end
		Trigger.AfterDelay(DateTime.Seconds(i), function() UserInterface.SetMissionText(AlliedForcesHaveArrived, c) end)
	end
	Trigger.AfterDelay(DateTime.Seconds(10), function() UserInterface.SetMissionText("") end)
end

TimerExpired = function()
	for i, PID in pairs (CoopPlayers) do
	PID.MarkCompletedObjective(SurviveObjective)
	end
end

CoopBase = function()
	for i=1, HarvesterMultiplier do
		WarFactory.Produce("harv")
	end
	if #CoopPlayers > 1 then
	Barracks.Owner = CoopPlayers[2]
	end
	if #CoopPlayers > 2 then
	P3Tent = Actor.Create("tent", true, { Owner = CoopPlayers[3], Location = P3Barracks.Location})
	P3Tent.Health = Barracks.Health
	table.insert(AlliedBase, P3Tent)
	end
	if #CoopPlayers > 3 then
	P4Warfact = Actor.Create("weap", true, { Owner = CoopPlayers[4], Location = P4Factory.Location})
	P4Warfact.Health = WarFactory.Health
	table.insert(AlliedBase, P4Warfact)
	end
	if #CoopPlayers > 4 then
	P5Tent = Actor.Create("tent", true, { Owner = CoopPlayers[5], Location = P5Barracks.Location})
	P5Tent.Health = Barracks.Health
	table.insert(AlliedBase, P5Tent)
	end
	if #CoopPlayers > 5 then
	P6Warfact = Actor.Create("weap", true, { Owner = CoopPlayers[6], Location = P6Factory.Location})
	P6Warfact.Health = WarFactory.Health
	table.insert(AlliedBase, P6Warfact)
	end
	for i, PID in pairs (CoopPlayers) do
		if PID ~= Allies then
			ExtraPower1 = Actor.Create("powr", true, { Location = CPos.Zero, Owner = PID })
			ExtraPower2 = Actor.Create("powr", true, { Location = CPos.Zero, Owner = PID })
			ExtraDome = Actor.Create("dome", true, { Location = CPos.Zero, Owner = PID })
			ExtraFix = Actor.Create("fix", true, { Location = CPos.Zero, Owner = PID })
			table.insert(ExtraPowerplants1, ExtraPower1)
			table.insert(ExtraPowerplants2, ExtraPower2)
			table.insert(ExtraDomes, ExtraDome)
			table.insert(ExtraFixes, ExtraFix)
		end
	end
end

DiscoveredAlliedBase = function(actor, discoverer)
	for i, PID in pairs (CoopPlayers) do
	if (not baseDiscovered and discoverer.Owner == PID) then
		Media.PlayMovieInRadar("antintro.vqa")
		baseDiscovered = true
		Media.PlaySpeechNotification(All, "ObjectiveReached")
		Utils.Do(AlliedBase, function(building)
			building.Owner = Allies
		end)
		
		CoopBase()
		
		--Need to delay this so we don't fail mission before obj added
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			for i, PID2 in pairs (CoopPlayers) do
			SurviveObjective = AddPrimaryObjective(PID2, "defend-outpost-until-reinforcements-arrive")
			end
			SetupTimeNotifications()
			Trigger.OnAllRemovedFromWorld(AlliedBase, function()
				for i, PID2 in pairs (CoopPlayers) do
				PID2.MarkFailedObjective(SurviveObjective)
				end
			end)
			Media.PlaySpeechNotification(All, "TimerStarted")
			Trigger.AfterDelay(DateTime.Seconds(2), function()
				for i, PID in pairs (CoopPlayers) do
					PID.MarkCompletedObjective(DiscoverObjective)
				end
			end)
			Creeps.GetActorsByType("harv")[1].FindResources()
			Creeps.GetActorsByType("harv")[1].Owner = Allies
		end)
	end
	end
end

SetupTimeNotifications = function()
	Trigger.AfterDelay(DateTime.Minutes(8), function()
		Media.PlaySpeechNotification(All, "TenMinutesRemaining")
	end)

	Trigger.AfterDelay(DateTime.Minutes(13), function()
		Media.PlaySpeechNotification(All, "WarningFiveMinutesRemaining")
	end)

	Trigger.AfterDelay(DateTime.Minutes(14), function()
		Media.PlaySpeechNotification(All, "WarningFourMinutesRemaining")
	end)

	Trigger.AfterDelay(DateTime.Minutes(15), function()
		Media.PlaySpeechNotification(All, "WarningThreeMinutesRemaining")
	end)

	Trigger.AfterDelay(DateTime.Minutes(16), function()
		Media.PlaySpeechNotification(All, "WarningTwoMinutesRemaining")
	end)

	Trigger.AfterDelay(DateTime.Minutes(17), function()
		Media.PlaySpeechNotification(All, "WarningOneMinuteRemaining")
	end)

	Trigger.AfterDelay(DateTime.Minutes(17) + DateTime.Seconds(40), function()
		Media.PlaySpeechNotification(All, "AlliedForcesApproaching")
	end)
end

GetTicks = function()
	return Ticks
end

GoodGuySpread  = function()
	P1Units = GoodGuy.GetActors()
	for _, UID in ipairs(P1Units) do
		if UID.Type ~= "tran.insertion" then
			CurrentPlayer = CoopPlayers[CoopCurrent]
			UID.Owner = CurrentPlayer
			CoopCurrent = CoopCurrent + 1
			if CoopCurrent > #CoopPlayers then
				CoopCurrent = 1
			end
		end
	end
end

GiveHarvesters = function()
	for i, PID in pairs (CoopPlayers) do
		if PID ~= Allies then
			Harvesters = PID.GetActorsByType("harv")
			for i, HID in pairs (Harvesters) do
				HID.Owner = Allies
			end
		end
	end
end

ShareMoney = function()
	if Allies.Resources > #CoopPlayers then
	CashSubtract = Allies.Resources/#CoopPlayers
	for i, PID in pairs (CoopPlayers) do
	PID.Cash = PID.Cash + CashSubtract
	end
	Allies.Resources = 0
	end
end

MimicBuildings = function()
	for i, EID in pairs (ExtraPowerplants1) do
		if PowerPlant1.IsInWorld == true then
			EID.Health = PowerPlant1.Health
		else
			EID.Destroy ()
			table.remove(ExtraPowerplants1, i)
		end
	end
	for i, EID in pairs (ExtraPowerplants2) do
		if PowerPlant2.IsInWorld == true then
			EID.Health = PowerPlant2.Health
		else
			EID.Destroy ()
			table.remove(ExtraPowerplants2, i)
		end
	end
	for i, EID in pairs (ExtraDomes) do
		if RadarDome.IsInWorld == true then
			EID.Health = RadarDome.Health
		else
			EID.Destroy ()
			table.remove(ExtraDomes, i)
		end
	end
	for i, EID in pairs (ExtraFixes) do
		if RepairPad.IsInWorld == true then
			EID.Health = RepairPad.Health
		else
			EID.Destroy ()
			table.remove(ExtraFixes, i)
		end
	end
end

Tick = function()
	GoodGuySpread()
	ShareMoney()
	MimicBuildings()
	GiveHarvesters()
	if SurviveObjective ~= nil then
		if Ticks > 0 then
			if Ticks == DateTime.Minutes(17) then
				StartAntAttack()
			elseif Ticks == DateTime.Minutes(15) then
				SendInsertionHelicopter()
			elseif Ticks == DateTime.Minutes(12) then
				StartAntAttack()
			elseif Ticks == DateTime.Minutes(6) then
				StartAntAttack()
			elseif Ticks == DateTime.Minutes(1) then
				EndAntAttack()
			end

			Ticks = Ticks - 1;
			if (Ticks % DateTime.Seconds(1)) == 0 then
				Timer = UserInterface.Translate("reinforcements-arrive-in", { ["time"] = Utils.FormatTime(Ticks) })
				UserInterface.SetMissionText(Timer, TimerColor)
			end
		else
			if not AtEndGame then
				Media.PlaySpeechNotification(All, "SecondObjectiveMet")
				AtEndGame = true
				FinishTimer()
				Camera.Position = waypoint13.CenterPosition
				SendTanks()
				Trigger.AfterDelay(DateTime.Seconds(2), function() TimerExpired() end)
			end
			Ticks = Ticks - 1
		end
	end
end

AddObjectives = function()
	InitObjectives(Allies)
	
	for i, PID in pairs (CoopPlayers) do
	DiscoverObjective = AddPrimaryObjective(PID, "find-outpost")
	end
	Utils.Do(AlliedBase, function(actor)
		Trigger.OnEnteredProximityTrigger(actor.CenterPosition, WDist.FromCells(8), function(discoverer, id)
			DiscoveredAlliedBase(actor, discoverer)
		end)
	end)

	Trigger.AfterDelay(DateTime.Seconds(1), function()
		Creeps.GetActorsByType("harv")[1].Stop()
	end)

	Camera.Position = Ranger.CenterPosition
end

WorldLoaded = function()
	Allies = Player.GetPlayer("Spain")
	AntMan = Player.GetPlayer("AntMan")
	Creeps = Player.GetPlayer("Creeps")
	GoodGuy = Player.GetPlayer("GoodGuy")
	Neutral = Player.GetPlayer("Neutral")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")

	CoopPlayers = {};
	table.insert(CoopPlayers, Allies)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end
	
	ExtraPowerplants1 = {}
	ExtraPowerplants2 = {}
	ExtraDomes = {}
	ExtraFixes = {}
	
	
	if #CoopPlayers == 6 then
		Actor.Create("e1", true, { Owner = GoodGuy, Location = Ranger.Location + CVec.New(-1,-1)})
	end
	for i, PID in pairs (CoopPlayers) do
	PID.Cash = Allies.Cash/#CoopPlayers
	end
	CoopCurrent = 1
	
	if Map.LobbyOption("oremines") == "oreon"  then
	ExtraMines = {ExtraMine1, ExtraMine2, ExtraMine3, ExtraMine4}
	for i,MID in pairs (ExtraMines) do
	AddMine = Actor.Create("mine", true, { Location = MID.Location, Owner = Neutral })
	end
	end
	
	HarvesterMultiplier = Map.LobbyOption("extraharvesters")
	if Map.LobbyOption("extraharvesters") == "harvpc"  then
	HarvesterMultiplier = #CoopPlayers-1
	end
	
	AddObjectives()
	Trigger.OnKilled(MoneyDerrick, function()
		Actor.Create("moneycrate", true, { Owner = Allies, Location = MoneyDerrick.Location + CVec.New(1,0) })
	end)
	Trigger.OnKilled(MoneyBarrel, function()
		Actor.Create("moneycrate", true, { Owner = Allies, Location = MoneyBarrel.Location})
	end)
end
