--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]
MissleSubs = { MSub1, MSub2, MSub3, MSub4 }
VolkovEntryPath = { LSTEntry.Location, LZ.Location }
VolkovandFriend = { "volk", "delphi" }
InsertionTransport = "lst.reinforcement"
SamSites = { Sam1, Sam2, Sam3, Sam4, Sam5, Sam6, Sam7, Sam8, Sam9, Sam10, Sam11, Sam12 }
PrimaryTargets = { BioLab, Silo1, Silo2 }
TimerTicks = DateTime.Minutes(8)

Shocktroopers = { Shok1, Shok2, Shok3, Shok4 }

InnerPatrolPaths =
{
	{ InnerPatrol2.Location, InnerPatrol3.Location, InnerPatrol4.Location, InnerPatrol1.Location },
	{ InnerPatrol3.Location, InnerPatrol2.Location, InnerPatrol1.Location, InnerPatrol4.Location },
	{ InnerPatrol4.Location, InnerPatrol1.Location, InnerPatrol2.Location, InnerPatrol3.Location },
	{ InnerPatrol1.Location, InnerPatrol4.Location, InnerPatrol3.Location, InnerPatrol2.Location }
}

OuterPatrols =
{
	{ TeamOne1, TeamOne2, TeamOne3 },
	{ TeamTwo1, TeamTwo2, TeamTwo3 },
	{ TeamThree1, TeamThree2, TeamThree3 },
	{ TeamFour1, TeamFour2, TeamFour3 },
	{ TeamFive1, TeamFive2, TeamFive3 }
}

OuterPatrolPaths =
{
	{ OuterPatrol1.Location, OuterPatrol2.Location, OuterPatrol3.Location, OuterPatrol4.Location, OuterPatrol5.Location, OuterPatrol6.Location, OuterPatrol7.Location },
	{ OuterPatrol5.Location, OuterPatrol4.Location, OuterPatrol3.Location, OuterPatrol2.Location, OuterPatrol1.Location, OuterPatrol7.Location, OuterPatrol6.Location },
	{ OuterPatrol6.Location, OuterPatrol7.Location, OuterPatrol1.Location, OuterPatrol2.Location, OuterPatrol3.Location, OuterPatrol4.Location, OuterPatrol5.Location },
	{ OuterPatrol3.Location, OuterPatrol4.Location, OuterPatrol5.Location, OuterPatrol6.Location, OuterPatrol7.Location, OuterPatrol1.Location, OuterPatrol2.Location },
	{ OuterPatrol3.Location, OuterPatrol2.Location, OuterPatrol1.Location, OuterPatrol7.Location, OuterPatrol6.Location, OuterPatrol5.Location, OuterPatrol4.Location }
}

GroupPatrol = function(units, waypoints, delay)
	local i = 1
	local stop = false

	Utils.Do(units, function(unit)
		Trigger.OnIdle(unit, function()
			if stop then
				return
			end
			if unit.Location == waypoints[i] then
				local bool = Utils.All(units, function(actor) return actor.IsIdle end)
				if bool then
					stop = true
					i = i + 1
					if i > #waypoints then
						i = 1
					end
					Trigger.AfterDelay(delay, function() stop = false end)
				end
			else
				unit.AttackMove(waypoints[i])
			end
		end)
	end)
end

StartPatrols = function()
	for i = 1, 5 do
		GroupPatrol(OuterPatrols[i], OuterPatrolPaths[i], DateTime.Seconds(3))
	end

	for i = 1, 4 do
		Trigger.AfterDelay(DateTime.Seconds(3* (i - 1)), function()
			Trigger.OnIdle(Shocktroopers[i], function()
				Shocktroopers[i].Patrol(InnerPatrolPaths[i])
			end)
		end)
	end
end

LabInfiltrated = false
SetupTriggers = function()
	Trigger.OnAllKilled(SamSites, function()
		USSR.MarkCompletedObjective(KillSams)
		SendInBombers()
	end)

	Trigger.OnInfiltrated(BioLab, function()
		Media.DisplayMessage("plans-stolen-erase-data", "scientist")
		Trigger.AfterDelay(DateTime.Seconds(5), function()
			USSR.MarkCompletedObjective(InfiltrateLab)
			LabInfiltrated = true
			SendInBombers()
		end)
	end)

	Trigger.OnKilled(BioLab, function()
		if not LabInfiltrated then
			USSR.MarkFailedObjective(InfiltrateLab)
		end
	end)

	Trigger.OnAllKilled(PrimaryTargets, function()
		USSR.MarkCompletedObjective(DestroyFacility)
		USSR.MarkCompletedObjective(VolkovSurvive)
	end)

	Trigger.OnAllKilled(MissleSubs, function()
		if not VolkovArrived then
			USSR.MarkFailedObjective(KillPower)
		end
	end)
end

SendInBombers = function()
	if LabInfiltrated and USSR.IsObjectiveCompleted(KillSams) then
		local proxy = Actor.Create("powerproxy.parabombs", false, { Owner = USSR })
		proxy.TargetAirstrike(TacticalNuke1.CenterPosition, Angle.SouthWest)
		proxy.TargetAirstrike(TacticalNuke2.CenterPosition, Angle.SouthWest)
		proxy.TargetAirstrike(TacticalNuke3.CenterPosition, Angle.SouthWest)
		proxy.Destroy()
	end
end


SendInVolkov = function()
	if not VolkovArrived then
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(KillPower)
		end
		Media.PlaySpeechNotification(PID, "ReinforcementsArrived")
		local teamVolkov = Reinforcements.ReinforceWithTransport(BadGuy, InsertionTransport, VolkovandFriend, VolkovEntryPath, { VolkovEntryPath[1] })[2]
		VolkovArrived = true
		teamVolkov[1].Owner = USSR
		teamVolkov[2].Owner = USSR
		if #CoopPlayers > 1 and MissionVariant == "AVCT" then
			Trigger.AfterDelay(DateTime.Seconds(0.5), function()
				Lander = BadGuy.GetActorsByType(InsertionTransport)
				for i, PID in pairs (CoopPlayers) do
					if PID ~= USSR then
						ExtraVolkov = Actor.Create("volk", false, { Owner = PID })
						--Trigger.AfterDelay(DateTime.Seconds(0.5), function()
							Lander[1].LoadPassenger(ExtraVolkov)
							Trigger.OnKilled(ExtraVolkov, function()
								for i, PID2 in pairs (CoopPlayers) do
									PID2.MarkFailedObjective(VolkovSurvive)
								end
							end)
						--end)
					end
				end
			end)
		end
		Trigger.OnKilled(teamVolkov[1], function()
			for i, PID in pairs (CoopPlayers) do
			PID.MarkFailedObjective(VolkovSurvive)
			end
		end)
		Trigger.OnAddedToWorld(teamVolkov[1], function(a)
			Media.DisplayMessage(UserInterface.Translate("software-update-failed-manual-targets"), UserInterface.Translate("volkov"))
		end)

		Trigger.OnAddedToWorld(teamVolkov[2], function(b)
			Trigger.OnKilled(b, function()
				if not LabInfiltrated then
					for i, PID in pairs (CoopPlayers) do
					PID.MarkFailedObjective(InfiltrateLab)
					end
				end
			end)
		end)
	end
end

BadGuySpreadRest  = function()
	P1Units = BadGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
	CurrentPlayer = CoopPlayers[CoopCurrent]
    if CoopCurrent > 1 then
	UID.Owner = CurrentPlayer
	end
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end

BadGuySpreadSecond  = function()
	P1Units = BadGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
	CurrentPlayer = CoopPlayers[CoopCurrent]
    if CoopCurrent > 1 then
	UID.Owner = CurrentPlayer
	end
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end

BadGuySpreadAll  = function()
	P1Units = BadGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end

Ticked = TimerTicks
Tick = function()
	if MissionVariant == "1V2CRT" and #CoopPlayers > 1 then
	BadGuySpreadRest()
	end
	if MissionVariant == "1V2CRT" and #CoopPlayers < 2 then
	BadGuySpreadAll()
	end
	if MissionVariant == "1VCRT" and #CoopPlayers > 1  then
	BadGuySpreadSecond()
	end
	if MissionVariant == "AVCT" then
	BadGuySpreadAll()
	end
	if MissionVariant == "EVOCAT" then
	BadGuySpreadAll()
	end
	if #CoopPlayers == 1  then
	BadGuySpreadAll()
	end

	if Turkey.PowerState ~= "Normal" then
		SendInVolkov()
	end

	if Ticked > 0 then
		if (Ticked % DateTime.Seconds(1)) == 0 then
			Timer = UserInterface.Translate("missiles-launch-in", { ["time"] = Utils.FormatTime(Ticked) })
			UserInterface.SetMissionText(Timer, TimerColor)
		end
		Ticked = Ticked - 1
	elseif Ticked == 0 then
		UserInterface.SetMissionText(UserInterface.Translate("too-late"), USSR.Color)
		Turkey.MarkCompletedObjective(LaunchMissles)
	end
end

WorldLoaded = function()
	USSR = Player.GetPlayer("USSR")
	Turkey = Player.GetPlayer("Turkey")
	Neutral = Player.GetPlayer("Neutral")
	BadGuy = Player.GetPlayer("BadGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")


	CoopPlayers = {};
	table.insert(CoopPlayers, USSR)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	CoopCurrent = 1

	MissionVariant = Map.LobbyOption("variant")
	
	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end


	EnemyUnits = Turkey.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end
	
	InitObjectives(USSR)

	LaunchMissles = AddPrimaryObjective(Turkey, "")
	for i, PID in pairs (CoopPlayers) do
	KillPower = AddPrimaryObjective(PID, "kill-power")
	InfiltrateLab = AddPrimaryObjective(PID, "infiltrate-bio-weapons-lab-scientist")
	DestroyFacility = AddPrimaryObjective(PID, "destroy-bio-weapons-lab-missile-silos")
	KillSams = AddSecondaryObjective(PID, "destroy-all-sam-sites-strategic-bombers")
	VolkovSurvive = AddPrimaryObjective(PID, "volkov-survive")
	end
	
	Trigger.AfterDelay(DateTime.Minutes(3), function()
		Media.PlaySpeechNotification(All, "WarningFiveMinutesRemaining")
	end)
	Trigger.AfterDelay(DateTime.Minutes(5), function()
		Media.PlaySpeechNotification(All, "WarningThreeMinutesRemaining")
	end)
	Trigger.AfterDelay(DateTime.Minutes(7), function()
		Media.PlaySpeechNotification(All, "WarningOneMinuteRemaining")
	end)

	StartPatrols()
	SetupTriggers()
	Camera.Position = DefaultCameraPosition.CenterPosition
	TimerColor = Turkey.Color
end
