--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]
StartUnits = { APC, StartSpy, Rifle1, Rifle2, Rifle3, Rifle4, Rocket1, Rocket2, Rocket3, Rocket4, Rocket5 }
SarinPlants = { SarinLab1, SarinLab2, SarinLab3, SarinLab4, SarinLab5 }
MammothStart = { CPos.New(37, 46), CPos.New(37, 47), CPos.New(37, 48), CPos.New(37, 49), CPos.New(37,50) }
NorthPatrol = { NorthPatrol1.Location, NorthPatrol2.Location, NorthPatrol3.Location, NorthPatrol4.Location, NorthPatrol5.Location }
BarrerlInvestigators = { Alert1, Alert2, Alert3, Alert4, Alert5 }
RaxTeam = { "e1", "e2", "e2", "e4", "e4", "shok" }
SouthPatrol = { SouthPatrol1.Location, SouthPatrol2.Location, SouthPatrol3.Location }
MCVReinforcements =
{
	easy = { "1tnk", "1tnk", "2tnk", "2tnk", "2tnk", "2tnk", "arty" },
	normal = { "1tnk", "1tnk", "2tnk", "2tnk" },
	hard = { "1tnk", "1tnk" }
}

SetupTriggers = function()
	Trigger.OnEnteredFootprint(MammothStart, function(actor, mammothcam)
		for i, PID in pairs (CoopPlayers) do
		if actor.Owner == PID then
			Trigger.RemoveFootprintTrigger(mammothcam)
			NorthMammoth.Patrol(NorthPatrol, true, 20)
			local mammothCamera = Actor.Create("camera", true, { Owner = Greece, Location = NorthPatrol1.Location })
			Trigger.AfterDelay(DateTime.Seconds(10), function()
				mammothCamera.Destroy()
			end)
		end
		end
	end)

	Trigger.OnEnteredProximityTrigger(NorthPatrol3.CenterPosition, WDist.FromCells(8), function(actor, trigger1)
		for i, PID in pairs (CoopPlayers) do
		if actor.Owner == PID then
			Trigger.RemoveProximityTrigger(trigger1)
			local baseCamera = Actor.Create("camera", true, { Owner = Greece, Location = BaseCam.Location })
			if Difficulty == "hard" then
				Reinforcements.Reinforce(BadGuy, RaxTeam, { BadGuyRaxSpawn.Location, BaseCam.Location }, 0)
			end
			Trigger.AfterDelay(DateTime.Seconds(10), function()
				baseCamera.Destroy()
			end)
		end
		end
	end)

	Trigger.OnAllRemovedFromWorld(StartUnits, function()
		if not MCVArrived then
			USSR.MarkCompletedObjective(SovietObj)
		end
	end)

	Trigger.OnKilled(VeryImportantBarrel, function()
		Utils.Do(BarrerlInvestigators, function(actor)
			if not actor.IsDead then
				actor.AttackMove(AlertGo.Location)
			end
		end)
	end)

	Trigger.OnAnyKilled(SarinPlants, function()
		for i, PID in pairs (CoopPlayers) do
		PID.MarkFailedObjective(CaptureSarin)
		end
	end)

	Trigger.OnAllKilledOrCaptured(SarinPlants, function()
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(CaptureSarin)
		end
	end)

	Trigger.OnEnteredProximityTrigger(AlliesMove.CenterPosition, WDist.FromCells(3), function(actor, id)
		for i, PID in pairs (CoopPlayers) do
		if actor.Owner == PID then
			Trigger.RemoveProximityTrigger(id)
			Media.PlaySpeechNotification(All, "SignalFlareSouth")
		end
		end
	end)
end

MCVArrived = false
MCVArrivedTick = false
PowerDownTeslas = function()
	if not MCVArrived then
		for i, PID in pairs (CoopPlayers) do
		CaptureSarin = AddPrimaryObjective(PID, "capture-sarin-plants-intact")
		KillBase = AddPrimaryObjective(PID, "destroy-enemy-compound")
		PID.MarkCompletedObjective(TakeOutPower)
		Media.PlaySpeechNotification(All, "ReinforcementsArrived")
		end
		Reinforcements.Reinforce(GoodGuy, MCVReinforcements[Difficulty], { AlliesSpawn.Location, AlliesMove.Location })
		for i, PID in pairs (CoopPlayers) do
		Reinforcements.Reinforce(PID, {"mcv"}, { AlliesSpawn.Location, AlliesMove.Location })
		end
		local baseFlare = Actor.Create("flare", true, { Owner = Greece, Location = AlliedBase.Location })
		Actor.Create("proc", true, { Owner = USSR, Location = Proc1.Location })
		Actor.Create("proc", true, { Owner = USSR, Location = Proc2.Location })
		SouthMammoth.Patrol(SouthPatrol, true, 20)
		MCVArrived = true

		Trigger.AfterDelay(DateTime.Seconds(1), function()
			MCVArrivedTick = true
			PrepareFinishingHunt(USSR)
		end)

		Trigger.AfterDelay(DateTime.Seconds(60), function()
			local attackers = Reinforcements.Reinforce(USSR, { "e1", "e1", "e1", "e2", "e4" }, { SovietGroundEntry3.Location }, 5)
			Utils.Do(attackers, IdleHunt)
		end)

		Trigger.AfterDelay(DateTime.Seconds(100), function()
			baseFlare.Destroy()
			ActivateAI()
		end)
	end
end

PrepareFinishingHunt = function(player)
	local buildings = GetBaseBuildings(player)

	Trigger.OnAllKilledOrCaptured(buildings, function()
		Utils.Do(player.GetGroundAttackers(), function(actor)
			actor.Stop()
			IdleHunt(actor)
		end)
	end)
end

GetBaseBuildings = function(player)
	-- Excludes the unrepairable sarin plants, which is desired anyway.
	local buildings = Utils.Where(player.GetActors(), function(actor)
		return actor.HasProperty("StartBuildingRepairs")
	end)
	return buildings
end

GoodGuySpread  = function()
	P1Units = GoodGuy.GetActors()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end

Tick = function()
	GoodGuySpread()
	USSR.Cash = 10000
	BadGuy.Cash = 10000

	if BadGuy.PowerState ~= "Normal" then
		PowerDownTeslas()
	end
	
	for i, PID in pairs (CoopPlayers) do
	if PID.HasNoRequiredUnits() and MCVArrivedTick then
		USSR.MarkCompletedObjective(SovietObj)
	end
	end

	if USSR.HasNoRequiredUnits() then
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(KillBase)
		end
	end
end

WorldLoaded = function()
	Greece = Player.GetPlayer("Greece")
	USSR = Player.GetPlayer("USSR")
	BadGuy = Player.GetPlayer("BadGuy")
	GoodGuy = Player.GetPlayer("GoodGuy")
	Neutral = Player.GetPlayer("Neutral")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")


	CoopPlayers = {};
	table.insert(CoopPlayers, Greece)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	CoopCurrent = 1
	
	if Map.LobbyOption("oremines") == "oreon"  then
	ExtraMines = {ExtraMine1, ExtraMine2}
	for i,MID in pairs (ExtraMines) do
	AddMine = Actor.Create("mine", true, { Location = MID.Location, Owner = Neutral })
	end
	ExtraGemMines = {ExtraGemMine1, ExtraGemMine2}
	for i,MID in pairs (ExtraGemMines) do
	AddMine = Actor.Create("gmine", true, { Location = MID.Location, Owner = Neutral })
	end
	end
	
	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end
	
	EProMultiplier = Map.LobbyOption("prmp")
	if Map.LobbyOption("prmp") == "prmppc"  then
	EProMultiplier = #CoopPlayers-1
	end


	EnemyUnits = USSR.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end
	
	EnemyUnits = BadGuy.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	SovietObj = AddPrimaryObjective(USSR, "")
	for i, PID in pairs (CoopPlayers) do
	TakeOutPower = AddPrimaryObjective(PID, "cut-power-east")
	end
	
	InitObjectives(Greece)

	StartSpy.DisguiseAsType("e1", BadGuy)
	Camera.Position = DefaultCameraPosition.CenterPosition
	SetupTriggers()
end
