
ShipWayPoints =
{
	{ LstEntry1.Location, LstUnload1.Location },
	{ LstEntry2.Location, LstUnload2.Location },
	{ LstEntry3.Location, LstUnload3.Location },
	{ LstEntry4.Location, LstUnload4.Location },
	{ LstEntry5.Location, LstUnload5.Location },
	{ LstEntry6.Location, LstUnload6.Location }
}

UnitTypes = { "3tnk", "ftrk", "ttnk", "apc" }
RearUnitTypes = { "3tnk", "3tnk", "ftrk", "apc" }
BeachUnitTypes = { "e1", "e2", "e3", "e4", "e1", "e2", "e3", "e4", "e1", "e2", "e3", "e4", "e1", "e2", "e3", "e4" }
ProxyType = "powerproxy.paratroopers"
ProducedUnitTypes =
{
	{ factory = AlliedBarracks1, types = { "e1", "e3" } },
	{ factory = AlliedBarracks2, types = { "e1", "e3" } },
	{ factory = SovietBarracks1, types = { "dog", "e1", "e2", "e3", "e4", "shok" } },
	{ factory = SovietBarracks2, types = { "dog", "e1", "e2", "e3", "e4", "shok" } },
	{ factory = SovietBarracks3, types = { "dog", "e1", "e2", "e3", "e4", "shok" } },
	{ factory = AlliedWarFactory1, types = { "jeep", "1tnk", "2tnk", "arty", "1tnk" } },
	{ factory = AlliedWarFactory2, types = { "jeep", "1tnk", "2tnk", "arty", "jeep" } },
	{ factory = SovietWarFactory1, types = { "3tnk", "4tnk", "v2rl", "ttnk", "apc" } },
	{ factory = SovietWarFactory2, types = { "ftrk", "3tnk", "ttnk", "3tnk", "v2rl" } }
}

ShipUnitTypes = { { "ftrk", "ftrk" }, { "3tnk", "ftrk" }, { "ttnk", "ftrk" }, { "ttnk", "3tnk" }, { "3tnk", "3tnk" }  }
HelicopterUnitTypes = { "e1", "e1", "e1", "e3", "e3" };
ParadropWaypoints = { Paradrop1, Paradrop2, Paradrop3, Paradrop4, Paradrop5, Paradrop6, Paradrop7, Paradrop8 }

BindActorTriggers = function(a)
	if a.HasProperty("Hunt") then
		if a.Owner == Allies then
			Trigger.OnIdle(a, function(a)
				if a.IsInWorld then
					a.Hunt()
				end
			end)
		else
			Trigger.OnIdle(a, function(a)
				if a.IsInWorld then
					a.AttackMove(AlliedTechnologyCenter.Location)
				end
			end)
		end
	end

	if a.HasProperty("HasPassengers") then
		Trigger.OnPassengerExited(a, function(t, p)
			BindActorTriggers(p)
		end)

		Trigger.OnDamaged(a, function()
			if a.HasPassengers then
				a.Stop()
				a.UnloadPassengers()
			end
		end)
	end
end

SendSovietUnits = function(entryCell, unitTypes, interval)
	local units = Reinforcements.Reinforce(Soviets, unitTypes, { entryCell }, interval)
	Utils.Do(units, function(unit)
		BindActorTriggers(unit)
	end)
	Trigger.OnAllKilled(units, function() SendSovietUnits(entryCell, unitTypes, interval) end)
end

ParadropSovietUnits = function()
	local lz = Utils.Random(ParadropWaypoints)
	local aircraft = PowerProxy.TargetParatroopers(lz.CenterPosition)

	Utils.Do(aircraft, function(a)
		Trigger.OnPassengerExited(a, function(t, p)
			BindActorTriggers(p)
		end)
	end)

	Trigger.AfterDelay(DateTime.Seconds(35), ParadropSovietUnits)
end

ProduceUnits = function(t)
	local factory = t.factory
	if not factory.IsDead then
		local unitType = t.types[Utils.RandomInteger(1, #t.types + 1)]
		factory.Wait(Actor.BuildTime(unitType))
		factory.Produce(unitType)
		factory.CallFunc(function() ProduceUnits(t) end)
	end
end

SetupAlliedUnits = function()
	Utils.Do(Map.NamedActors, function(a)
		if a.Owner == Allies and a.HasProperty("AcceptsCondition") and a.AcceptsCondition("unkillable") then
			a.GrantCondition("unkillable")
			a.Stance = "Defend"
		end
	end)
end

SetupFactories = function()
	Utils.Do(ProducedUnitTypes, function(production)
		Trigger.OnProduction(production.factory, function(_, a) BindActorTriggers(a) end)
	end)
end

ShipSovietUnits = function()
	local way = Utils.Random(ShipWayPoints)
	local units = Utils.Random(ShipUnitTypes)
	local attackUnits = Reinforcements.ReinforceWithTransport(Soviets, "lst", units , way, { way[2], way[1] })[2]

	Utils.Do(attackUnits, function(unit)
		BindActorTriggers(unit)
	end)

	Trigger.AfterDelay(DateTime.Seconds(25), ShipSovietUnits)
end

InsertAlliedChinookReinforcements = function(entry, hpad)
	local units = Reinforcements.ReinforceWithTransport(Allies, "tran",
		HelicopterUnitTypes, { entry.Location, hpad.Location + CVec.New(1, 2) }, { entry.Location })[2]

	Utils.Do(units, function(unit)
		BindActorTriggers(unit)
	end)

	Trigger.AfterDelay(DateTime.Seconds(90), function() InsertAlliedChinookReinforcements(entry, hpad) end)
end

ChronoshiftAlliedUnits = function()
	local cells = Utils.ExpandFootprint({ ChronoshiftLocation.Location }, false)
	local units = { }
	for i = 1, #cells do
		local unit = Actor.Create("ctnk", true, { Owner = Allies, Facing = Angle.West })
		BindActorTriggers(unit)
		units[unit] = cells[i]
	end
	Chronosphere.Chronoshift(units)
	Trigger.AfterDelay(DateTime.Seconds(50), ChronoshiftAlliedUnits)
end

Ticks = 0
Speed = 5

Tick = function()
	Ticks = Ticks + 1

	local t = (Ticks + 45) % (360 * Speed) * (math.pi / 180) / Speed;
	Camera.Position = ViewportOrigin + WVec.New(19200 * math.sin(t), 20480 * math.cos(t), 0)
end

WorldLoaded = function()
	Allies = Player.GetPlayer("Allies")
	Soviets = Player.GetPlayer("Soviets")
	ViewportOrigin = Camera.Position

	SetupAlliedUnits()
	SetupFactories()
	Trigger.AfterDelay(DateTime.Seconds(5), ShipSovietUnits)
	PowerProxy = Actor.Create(ProxyType, false, { Owner = Soviets })
	ParadropSovietUnits()
	Trigger.AfterDelay(DateTime.Seconds(15), ChronoshiftAlliedUnits)
	Utils.Do(ProducedUnitTypes, ProduceUnits)
	InsertAlliedChinookReinforcements(ChinookEntry1, HeliPad1)
	InsertAlliedChinookReinforcements(ChinookEntry2, HeliPad2)
	SendSovietUnits(Entry1.Location, UnitTypes, 50)
	SendSovietUnits(Entry2.Location, UnitTypes, 50)
	SendSovietUnits(Entry3.Location, UnitTypes, 50)
	SendSovietUnits(Entry4.Location, UnitTypes, 50)
	SendSovietUnits(Entry5.Location, UnitTypes, 50)
	SendSovietUnits(Entry6.Location, UnitTypes, 50)
	SendSovietUnits(Entry7.Location, BeachUnitTypes, 15)
	SendSovietUnits(Entry8.Location, RearUnitTypes, 80)
end
