--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]
Jeeps = { Jeep1, Jeep2 }
JeepWaypoints = { JeepWaypoint1.Location, JeepWaypoint2.Location }
OreAttackers = { OreAttack1, OreAttack2, OreAttack3, OreAttack4, OreAttack5, OreAttack6 }
RadarSites = { Radar1, Radar2, Radar3, Radar4 }
StartAttack = { StartAttack1, StartAttack2, StartAttack3, StartAttack4, StartAttack5 }
ChronoDemolitionTrigger = { CPos.New(36,96), CPos.New(37,96), CPos.New(37,97), CPos.New(38,97), CPos.New(38,98), CPos.New(39,98) }
OreAttackFootprintTrigger = { CPos.New(57,20), CPos.New(57,19), CPos.New(57,18), CPos.New(57,17), CPos.New(57,16), CPos.New(57,15), CPos.New(57,14) }

Start = function()
	for i, PID in pairs (CoopPlayers) do
	Reinforcements.Reinforce(PID, { "mcv" }, { MCVEntry.Location, DefaultCameraPosition.Location }, 5)
	end

	Utils.Do(Jeeps, function(jeep)
		jeep.Patrol(JeepWaypoints, true, 125)
	end)

	Utils.Do(StartAttack, function(a)
		IdleHunt(a)
	end)

	ChronoCam = Actor.Create("camera", true, { Owner = USSR, Location = Chronosphere.Location})
end

MissionTriggers = function()
	Trigger.OnAllKilled(RadarSites, function()
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(TakeDownRadar)
		end
		ChronoshiftAlliedUnits()
	end)

	Trigger.OnCapture(Chronosphere, function()
		if not USSR.IsObjectiveCompleted(TakeDownRadar) then
			Media.DisplayMessage(UserInterface.Translate("chrono-trap-triggered"), UserInterface.Translate("headquarters"))
			Chronosphere.Kill()
		else
			for i, PID in pairs (CoopPlayers) do
			PID.MarkCompletedObjective(CaptureChronosphere)
			end
		end
	end)

	Trigger.OnKilled(Chronosphere, function()
		for i, PID in pairs (CoopPlayers) do
		PID.MarkFailedObjective(CaptureChronosphere)
		end
	end)

	local chronoTriggered
	Trigger.OnEnteredFootprint(ChronoDemolitionTrigger, function(actor, id)
		for i, PID in pairs (CoopPlayers) do
		if actor.Owner == PID and not chronoTriggered and not USSR.IsObjectiveCompleted(TakeDownRadar) then
			Trigger.RemoveFootprintTrigger(id)
			Media.DisplayMessage(UserInterface.Translate("chrono-trap-triggered"), UserInterface.Translate("headquarters"))
			chronoTriggered = true
			Chronosphere.Kill()
		end
		end
	end)

	Trigger.OnEnteredProximityTrigger(ChinookLZ.CenterPosition, WDist.FromCells(5), function(actor, id)
		for i, PID in pairs (CoopPlayers) do
		if actor.Owner == PID and actor.Type == "harv" then
			Trigger.RemoveProximityTrigger(id)
			SendChinook()
		end
		end
	end)

	local oreAttackTriggered
	Trigger.OnEnteredFootprint(OreAttackFootprintTrigger, function(actor, id)
		for i, PID in pairs (CoopPlayers) do
		if actor.Owner == PID and not oreAttackTriggered then
			Trigger.RemoveProximityTrigger(id)
			oreAttackTrigger = true

			Utils.Do(OreAttackers, function(a)
				if not a.IsDead then
					IdleHunt(a)
				end
			end)
		end
		end
	end)
end

ChronoshiftAlliedUnits = function()
	if Chronosphere.IsDead then
		return
	end

	local cells = Utils.ExpandFootprint({ ChronoshiftPoint.Location }, false)
	local units = { }
	for i = 1, #cells do
		local unit = Actor.Create("2tnk", true, { Owner = Greece, Facing = Angle.North })
		units[unit] = cells[i]
		IdleHunt(unit)
	end
	Chronosphere.Chronoshift(units)
end

Tick = function()
	Greece.Cash = 20000
	for i, PID in pairs (CoopPlayers) do
	if PID.HasNoRequiredUnits() and DateTime.GameTime > DateTime.Seconds(10) then
		Greece.MarkCompletedObjective(AlliesObjective)
	end
	end
end

USSRSpread  = function()
	P1Units = USSR.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end

PlayOpening = function()
Media.PlayMovieInRadar("mtnkfact.vqa")
end

WorldLoaded = function()
	USSR = Player.GetPlayer("USSR")
	Greece = Player.GetPlayer("Greece")
	GoodGuy = Player.GetPlayer("GoodGuy")
	Neutral = Player.GetPlayer("Neutral")
	BadGuy = Player.GetPlayer("BadGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")

	Media.PlayMovieFullscreen("soviet13.vqa", PlayOpening)

	CoopPlayers = {};
	table.insert(CoopPlayers, USSR)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	CoopCurrent = 1
	USSRSpread()

	if Map.LobbyOption("oremines") == "oreon"  then
	ExtraMines = {ExtraMine1, ExtraMine2, ExtraMine3, ExtraMine4, ExtraMine5}
	for i,MID in pairs (ExtraMines) do
	AddMine = Actor.Create("mine", true, { Location = MID.Location, Owner = Neutral })
	end
	ExtraGemMines = {ExtraGemMine1, ExtraGemMine2, ExtraGemMine3}
	for i,MID in pairs (ExtraGemMines) do
	AddMine = Actor.Create("gmine", true, { Location = MID.Location, Owner = Neutral })
	end
	end

	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end
	
	EProMultiplier = Map.LobbyOption("prmp")
	if Map.LobbyOption("prmp") == "prmppc"  then
	EProMultiplier = #CoopPlayers-1
	end

	EnemyUnits = Greece.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	EnemyUnits = GoodGuy.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	InitObjectives(USSR)

	AlliesObjective = AddPrimaryObjective(Greece, "")
	for i, PID in pairs (CoopPlayers) do
	TakeDownRadar = AddPrimaryObjective(PID, "destroy-allied-radar-sites")
	CaptureChronosphere = AddPrimaryObjective(PID, "capture-the-chronosphere")
	end
	
	Camera.Position = DefaultCameraPosition.CenterPosition
	Start()
	MissionTriggers()
	ActivateAI()
	GreeceWarFactory.RallyPoint = WarFactoryRally.Location
	if Difficulty == "hard" then
		V2A.Destroy()
		V2B.Destroy()
	end
end
