--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]
StartingUnits = { }
StartingUnits2 = { "e4", "e4", "e2", "e2" }
SovietTransportWay = { TransportEntry.Location, TransportStop.Location }
SpreadBaddies = true

InitialSovietReinforcements = function()
	Trigger.AfterDelay(DateTime.Seconds(2), function()
		Media.PlaySpeechNotification(All, "ReinforcementsArrived")
		Reinforcements.ReinforceWithTransport(BadGuy, "lst", StartingUnits, SovietTransportWay)
		FillLander()
	end)
end

FillLander = function()
	Trigger.AfterDelay(DateTime.Seconds(0.5), function()
		Lander = BadGuy.GetActorsByType("lst")
		Lander[1].Owner = USSR
		Trigger.AfterDelay(DateTime.Seconds(0.5), function()
		for i, PID in pairs (CoopPlayers) do
			ExtraMCV = Actor.Create("mcv", false, { Owner = PID })    
			Lander[1].LoadPassenger(ExtraMCV)
		end
		for i, UID in pairs (StartingUnits2) do
		Starters = Actor.Create(UID, false, { Owner = BadGuy })
		Lander[1].LoadPassenger(Starters)
		end
		end)
	end)
end

Tick = function()
	if SpreadBaddies == true then
	BadGuySpread()
	end
	Greece.Cash = 10000

	if Greece.HasNoRequiredUnits() then
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(DestroyNavalBase)
		end
	end

	DefeatedPlayers = 0
	for i, PID in pairs (CoopPlayers) do
	if PID.HasNoRequiredUnits() and DateTime.GameTime > DateTime.Seconds(5) then
		DefeatedPlayers = DefeatedPlayers + 1
		if DefeatedPlayers == #CoopPlayers then
		Greece.MarkCompletedObjective(BeatSoviets)
		end
	end
	end
end

BadGuySpread  = function()
	P1Units = BadGuy.GetGroundAttackers()
	for _, UID in ipairs(P1Units) do
		if UID.Type ~= lst then
			CurrentPlayer = CoopPlayers[CoopCurrent]
			UID.Owner = CurrentPlayer
			CoopCurrent = CoopCurrent + 1
			if CoopCurrent > #CoopPlayers then
				CoopCurrent = 1
			end
		end
	end
end

PlayOpening = function()
Media.PlayMovieInRadar("periscop.vqa")
end

WorldLoaded = function()
	USSR = Player.GetPlayer("USSR")
	Greece = Player.GetPlayer("Greece")
	Neutral = Player.GetPlayer("Neutral")
	BadGuy = Player.GetPlayer("BadGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")

	Media.PlayMovieFullscreen("soviet11.vqa", PlayOpening)

	CoopPlayers = {};
	table.insert(CoopPlayers, USSR)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	CoopCurrent = 1

	if Map.LobbyOption("oremines") == "oreon"  then
	ExtraMines = {ExtraMine1}
	for i,MID in pairs (ExtraMines) do
	AddMine = Actor.Create("mine", true, { Location = MID.Location, Owner = Neutral })
	end
	ExtraGemMines = {ExtraGemMine1, ExtraGemMine2}
	for i,MID in pairs (ExtraGemMines) do
	AddMine = Actor.Create("gmine", true, { Location = MID.Location, Owner = Neutral })
	end
	end

	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end
	
	EProMultiplier = Map.LobbyOption("prmp")
	if Map.LobbyOption("prmp") == "prmppc"  then
	EProMultiplier = #CoopPlayers-1
	end

	EnemyUnits = Greece.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end

	InitObjectives(USSR)

	for i, PID in pairs (CoopPlayers) do
	DestroyNavalBase = AddPrimaryObjective(PID, "destroy-allied-units-structures")
	end
	BeatSoviets = AddPrimaryObjective(Greece, "")

	Camera.Position = DefaultCameraPosition.CenterPosition
	InitialSovietReinforcements()
	Trigger.AfterDelay(DateTime.Seconds(5), ActivateAI)
end
