--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

TruckStops = { TruckStop1, TruckStop2, TruckStop3, TruckStop4, TruckStop5, TruckStop6, TruckStop7, TruckStop8 }
MissionStartAttackUnits = { StartAttack1tnk1, StartAttack1tnk2, StartAttackArty1, StartAttackArty2, StartAttackArty3 }
TruckEscape = { TruckEscape1, TruckEscape2, TruckEscape3, TruckEscape4, TruckEscape5, TruckEscapeWest }
BackupRoute = { TruckEscape2, TruckEscape1, TruckEscapeEast }

MissionStart = function()
	Utils.Do(TruckStops, function(waypoint)
		StolenTruck.Move(waypoint.Location)
	end)

	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Utils.Do(MissionStartAttackUnits, function(actor)
			actor.AttackMove(DefaultCameraPosition.Location)
		end)
	end)

	Trigger.AfterDelay(DateTime.Seconds(45), function()
		Media.DisplayMessage(UserInterface.Translate("trucks-stopped-near-allied-base"))
	end)

	Trigger.OnKilled(StolenTruck, function()
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(DestroyTruck)
		PID.MarkCompletedObjective(DefendCommand)
		end
	end)

	Trigger.OnKilled(CommandCenter, function()
		for i, PID in pairs (CoopPlayers) do
		PID.MarkFailedObjective(DefendCommand)
		end
	end)
end

Trigger.OnEnteredProximityTrigger(TruckAlarm.CenterPosition, WDist.FromCells(11), function(actor, triggerflee)
	for i, PID in pairs (CoopPlayers) do
	if actor.Owner == PID and actor.Type ~= "badr" and actor.Type ~= "u2" and actor.Type ~= "camera.spyplane" then
		Trigger.RemoveProximityTrigger(triggerflee)
		Media.DisplayMessage(UserInterface.Translate("convoy-truck-escaping"))
		EscapeCamera = Actor.Create("camera", true, { Owner = USSR, Location = TruckAlarm.Location })
		Media.PlaySoundNotification(All, "AlertBleep")
		Utils.Do(TruckEscape, function(waypoint)
			StolenTruck.Move(waypoint.Location)
		end)

		Trigger.AfterDelay(DateTime.Seconds(5), function()
			EscapeCamera.Destroy()
		end)

		Trigger.OnIdle(StolenTruck, function()
			Utils.Do(BackupRoute, function(waypoint)
				StolenTruck.Move(waypoint.Location)
			end)
		end)
	end
	end
end)

Trigger.OnEnteredFootprint(({ TruckEscapeWest.Location } or { TruckEscapeEast.Location }), function(actor, triggerlose)
	if actor.Owner == Greece and actor.Type == "truk" then
		Trigger.RemoveFootprintTrigger(triggerlose)
		actor.Destroy()
		for i, PID in pairs (CoopPlayers) do
		PID.MarkFailedObjective(DestroyTruck)
		end
	end
end)

Tick = function()
	Greece.Cash = 50000
	Germany.Cash = 50000
end

USSRSpread  = function()
	P1Units = USSR.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
	if #CoopPlayers > 1 and CurrentPlayer == USSR then
	CoopCurrent = CoopCurrent + 1
	CurrentPlayer = CoopPlayers[CoopCurrent]
	end
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end

PlayOpening = function()
Media.PlayMovieInRadar("movingin.vqa")
end

WorldLoaded = function()
	USSR = Player.GetPlayer("USSR")
	Germany = Player.GetPlayer("Germany")
	Greece = Player.GetPlayer("Greece")
	Neutral = Player.GetPlayer("Neutral")
	BadGuy = Player.GetPlayer("BadGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")

	Media.PlayMovieFullscreen("soviet9.vqa", PlayOpening)

	CoopPlayers = {};
	table.insert(CoopPlayers, USSR)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	CoopCurrent = 1
	USSRSpread()

	SovietStartToBasePath = { MCVentry.Location, MCVtarget.Location }
	SovietMCV = {"mcv"}
	for i, PID in pairs (CoopPlayers) do
	if PID ~= USSR then
	Reinforcements.Reinforce(PID, SovietMCV, SovietStartToBasePath)
	end
	end

	if Map.LobbyOption("oremines") == "oreon"  then
	ExtraMines = {ExtraMine1, ExtraMine2, ExtraMine3}
	for i,MID in pairs (ExtraMines) do
	AddMine = Actor.Create("mine", true, { Location = MID.Location, Owner = Neutral })
	end
	ExtraGemMines = {ExtraGemMine1, ExtraGemMine2, ExtraGemMine3, ExtraGemMine4}
	for i,MID in pairs (ExtraGemMines) do
	AddMine = Actor.Create("gmine", true, { Location = MID.Location, Owner = Neutral })
	end
	end

	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end
	
	EProMultiplier = Map.LobbyOption("prmp")
	if Map.LobbyOption("prmp") == "prmppc"  then
	EProMultiplier = #CoopPlayers-1
	end

	EnemyUnits = Greece.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end
	
	EnemyUnits = Germany.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = EID.Owner })
	CopyUnit.Scatter()
	end
	end	

	InitObjectives(USSR)

	for i, PID in pairs (CoopPlayers) do
	DestroyTruck = AddPrimaryObjective(PID, "destroy-stolen-convoy-truck")
	DefendCommand = AddPrimaryObjective(PID, "defend-forward-command-center")
	end
	Camera.Position = DefaultCameraPosition.CenterPosition

	MissionStart()
	ActivateAI()
end
